"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerBanSynchronisationProtection = void 0;
const Action_1 = require("../../Interface/Action");
const Task_1 = require("../../Interface/Task");
const PolicyEvents_1 = require("../../MatrixTypes/PolicyEvents");
const Protection_1 = require("../Protection");
require("../Capability/StandardCapability/ServerConsequences");
require("../Capability/StandardCapability/ServerACLConsequences");
class ServerBanSynchronisationProtection extends Protection_1.AbstractProtection {
    constructor(description, capabilities, protectedRoomsSet) {
        super(description, capabilities, protectedRoomsSet, {});
        this.serverConsequences = capabilities.serverConsequences;
    }
    async handleStateChange(revision, changes) {
        const serverACLEventChanges = changes.filter((change) => change.eventType === 'm.room.server_acl');
        if (serverACLEventChanges.length === 0) {
            return (0, Action_1.Ok)(undefined);
        }
        if (serverACLEventChanges.length !== 1) {
            throw new TypeError(`How is it possible for there to be more than one server_acl event change in the same revision?`);
        }
        return (await this.serverConsequences.consequenceForServersInRoom(revision.room.toRoomIDOrAlias(), this.protectedRoomsSet.watchedPolicyRooms.revisionIssuer));
    }
    async handlePolicyChange(_revision, changes) {
        const serverPolicyChanges = changes.filter((change) => change.rule.kind === PolicyEvents_1.PolicyRuleType.Server);
        if (serverPolicyChanges.length === 0) {
            return (0, Action_1.Ok)(undefined);
        }
        const result = await this.serverConsequences.consequenceForServersInRoomSet(this.protectedRoomsSet.watchedPolicyRooms.revisionIssuer);
        if ((0, Action_1.isError)(result)) {
            return result;
        }
        else {
            return (0, Action_1.Ok)(undefined);
        }
    }
    handlePermissionRequirementsMet(room) {
        void (0, Task_1.Task)((async () => {
            await this.serverConsequences.consequenceForServersInRoom(room.toRoomIDOrAlias(), this.protectedRoomsSet.watchedPolicyRooms.revisionIssuer);
        })());
    }
}
exports.ServerBanSynchronisationProtection = ServerBanSynchronisationProtection;
(0, Protection_1.describeProtection)({
    name: 'ServerBanSynchronisationProtection',
    description: 'Synchronise server bans from watched policy lists across the protected rooms set by producing ServerACL events',
    capabilityInterfaces: {
        serverConsequences: 'ServerConsequences',
    },
    defaultCapabilities: {
        serverConsequences: 'ServerACLConsequences',
    },
    factory: async (description, protectedRoomsSet, _settings, capabilities) => (0, Action_1.Ok)(new ServerBanSynchronisationProtection(description, capabilities, protectedRoomsSet)),
});
//# sourceMappingURL=ServerBanSynchronisation.js.map