import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { ActionResult } from '../Interface/Action';
import { StateEvent } from '../MatrixTypes/Events';
import { DescribeRoomOptions } from './DeclareRoomState';
import { FakeRoomStateRevisionIssuer } from './FakeRoomStateRevisionIssuer';
import { RoomStateManager, RoomStateRevisionIssuer } from './StateRevisionIssuer';
export declare class FakeRoomStateManager implements RoomStateManager {
    private readonly roomStateRevisionIssuers;
    constructor(roomStateRevisionIssuers?: FakeRoomStateRevisionIssuer[]);
    getRoomStateRevisionIssuer(room: MatrixRoomID): Promise<ActionResult<RoomStateRevisionIssuer>>;
    getRoomState(_room: MatrixRoomID): Promise<ActionResult<StateEvent[]>>;
    appendState({ stateDescriptions, membershipDescriptions, policyDescriptions, room, }: Omit<DescribeRoomOptions, 'room'> & {
        room: MatrixRoomID;
    }): void;
    appendStateEvents(room: MatrixRoomID, stateEvents: StateEvent[]): void;
    addIssuer(issuer: FakeRoomStateRevisionIssuer): void;
}
//# sourceMappingURL=FakeRoomStateManager.d.ts.map