import type ts from 'typescript';
export interface TransformerLogger {
    circularGenericNotSupported(nodeName: string): void;
    unexpectedCreateMock(mockFileName: string, expectedFileName: string): void;
    typeNotSupported(type: string, currentNode?: ts.Node): void;
    typeOfFunctionCallNotFound(node: string): void;
    typeOfPropertyNotFound(node: ts.Node): void;
    missingTypeDefinition(node: ts.Node): void;
    missingReturnFromFunctionLike(node: ts.Node): void;
    typeCannotBeChecked(node: ts.Node): void;
    indexedAccessTypeFailed(propertyName: string, nodeText: string, currentNode: ts.Node): void;
}
export declare const getNodeFileUrl: (node: ts.Node) => string;
export declare function TransformerLogger(): TransformerLogger;
