"use strict";
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerAdminProtections = void 0;
exports.runProtectionConfigHooks = runProtectionConfigHooks;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const RoomTakedownProtection_1 = require("./RoomTakedown/RoomTakedownProtection");
const BlockInvitationsOnServerProtection_1 = require("./BlockInvitationsOnServerProtection");
exports.ServerAdminProtections = [
    RoomTakedownProtection_1.RoomTakedownProtection,
    BlockInvitationsOnServerProtection_1.BlockInvitationsOnServerProtection,
];
const hooks = [
    async function disableServerACL(config, protectionsConfig) {
        if (config.disableServerACL) {
            return await protectionsConfig.disableProtection(matrix_protection_suite_1.ServerBanSynchronisationProtection.name);
        }
        else {
            return (0, matrix_protection_suite_1.Ok)(undefined);
        }
    },
];
/**
 * Introduced to allow the legacy option `config.disableServerACL` to map onto
 * MPS's ServerBanSynchronisationProtection. I think we need to deprecate the
 * option and offer something else.
 */
async function runProtectionConfigHooks(config, protectionsConfig) {
    for (const hook of hooks) {
        const result = await hook(config, protectionsConfig);
        if ((0, matrix_protection_suite_1.isError)(result)) {
            return result;
        }
    }
    return (0, matrix_protection_suite_1.Ok)(undefined);
}
//# sourceMappingURL=ConfigHooks.js.map