"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.HomeserverUserPolicyProtection = void 0;
const typebox_1 = require("@sinclair/typebox");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const HomeserverUserPolicyApplication_1 = require("./HomeserverUserPolicyApplication");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const matrix_bot_sdk_1 = require("matrix-bot-sdk");
const typescript_result_1 = require("@gnuxie/typescript-result");
const UserSuspensionCapability_1 = require("./UserSuspensionCapability");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const HomeserverUserPolicyProtectionSettings = typebox_1.Type.Object({}, { title: "HomeserverUserPolicyProtectionSettings" });
class HomeserverUserPolicyProtection extends matrix_protection_suite_1.AbstractProtection {
    constructor(description, capabilities, protectedRoomsSet, auditLog, automaticallyRedactForReasons, managementRoomID, confirmationPromptSender) {
        super(description, capabilities, protectedRoomsSet, {});
        this.policyApplication = new HomeserverUserPolicyApplication_1.HomeserverUserPolicyApplication(managementRoomID, capabilities.userRestrictionCapability, confirmationPromptSender, auditLog, protectedRoomsSet.watchedPolicyRooms, (0, matrix_basic_types_1.userServerName)(protectedRoomsSet.userID), automaticallyRedactForReasons);
        this.policyApplication.handleProtectionEnable();
    }
    handlePolicyChange(revision, changes) {
        this.policyApplication.handlePolicyChange(changes);
        return Promise.resolve((0, typescript_result_1.Ok)(undefined));
    }
}
exports.HomeserverUserPolicyProtection = HomeserverUserPolicyProtection;
(0, matrix_protection_suite_1.describeProtection)({
    name: HomeserverUserPolicyProtection.name,
    description: `A protection to suspend resident users matching policies from watched lists`,
    capabilityInterfaces: {
        userRestrictionCapability: "UserRestrictionCapability",
    },
    defaultCapabilities: {
        userRestrictionCapability: UserSuspensionCapability_1.SynapseAdminUserSuspensionCapability.name,
    },
    configSchema: HomeserverUserPolicyProtectionSettings,
    async factory(description, protectedRoomsSet, draupnir, capabilitySet, _settings) {
        if (draupnir.stores.userRestrictionAuditLog === undefined) {
            return typescript_result_1.ResultError.Result("This protection requires the user audit log to be available to draupnir, and they are not in your configuration.");
        }
        return (0, typescript_result_1.Ok)(new HomeserverUserPolicyProtection(description, capabilitySet, protectedRoomsSet, draupnir.stores.userRestrictionAuditLog, draupnir.config.automaticallyRedactForReasons.map((reason) => new matrix_bot_sdk_1.MatrixGlob(reason)), draupnir.managementRoomID, (0, mps_interface_adaptor_1.makeconfirmationPromptSender)(draupnir)));
    },
});
//# sourceMappingURL=HomeserverUserPolicyProtection.js.map