"use strict";
// Copyright 2022 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2020 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraupnirSetPowerLevelCommand = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const typescript_result_1 = require("@gnuxie/typescript-result");
const DraupnirCommandPrerequisites_1 = require("./DraupnirCommandPrerequisites");
exports.DraupnirSetPowerLevelCommand = (0, interface_manager_1.describeCommand)({
    summary: "Set the power level of a user across the protected rooms set, or within the provided rooms",
    parameters: (0, interface_manager_1.tuple)({
        name: "user",
        acceptor: interface_manager_1.MatrixUserIDPresentationType,
    }, {
        name: "power level",
        acceptor: interface_manager_1.StringPresentationType,
    }),
    rest: {
        name: "rooms",
        acceptor: interface_manager_1.MatrixRoomReferencePresentationSchema,
    },
    async executor(draupnir, _info, _keywords, roomRefs, user, rawPowerLevel) {
        const powerLevel = Number.parseInt(rawPowerLevel, 10);
        const resolvedGivenRooms = [];
        for (const room of roomRefs) {
            const resolvedResult = await draupnir.clientPlatform
                .toRoomResolver()
                .resolveRoom(room);
            if ((0, typescript_result_1.isError)(resolvedResult)) {
                return resolvedResult;
            }
            else {
                resolvedGivenRooms.push(resolvedResult.ok);
            }
        }
        const rooms = roomRefs.length === 0
            ? draupnir.protectedRoomsSet.allProtectedRooms
            : resolvedGivenRooms;
        for (const room of rooms) {
            await draupnir.client.setUserPowerLevel(user.toString(), room.toRoomIDOrAlias(), powerLevel);
        }
        return (0, typescript_result_1.Ok)(undefined);
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.DraupnirSetPowerLevelCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=SetPowerLevelCommand.js.map