"use strict";
// Copyright 2022 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2021, 2022 Marco Cirillo
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynapseAdminHijackRoomCommand = void 0;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const matrix_protection_suite_for_matrix_bot_sdk_1 = require("matrix-protection-suite-for-matrix-bot-sdk");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const DraupnirCommandPrerequisites_1 = require("../DraupnirCommandPrerequisites");
exports.SynapseAdminHijackRoomCommand = (0, interface_manager_1.describeCommand)({
    summary: "Make the specified user the admin of a room via the synapse admin API",
    parameters: (0, interface_manager_1.tuple)({
        name: "room",
        acceptor: interface_manager_1.MatrixRoomReferencePresentationSchema,
    }, {
        name: "user",
        acceptor: interface_manager_1.MatrixUserIDPresentationType,
    }),
    async executor(draupnir, _info, _keywords, _rest, room, user) {
        const isAdmin = await draupnir.synapseAdminClient?.isSynapseAdmin();
        if (!draupnir.config.admin?.enableMakeRoomAdminCommand ||
            isAdmin === undefined ||
            (0, matrix_protection_suite_1.isError)(isAdmin) ||
            !isAdmin.ok) {
            return matrix_protection_suite_1.ActionError.Result("Either the command is disabled or Draupnir is not running as homeserver administrator.");
        }
        if (draupnir.synapseAdminClient === undefined) {
            throw new TypeError("Should be impossible at this point");
        }
        const resolvedRoom = await (0, matrix_protection_suite_for_matrix_bot_sdk_1.resolveRoomReferenceSafe)(draupnir.client, room);
        if ((0, matrix_protection_suite_1.isError)(resolvedRoom)) {
            return resolvedRoom;
        }
        await draupnir.synapseAdminClient.makeUserRoomAdmin(resolvedRoom.ok.toRoomIDOrAlias(), user.toString());
        return (0, matrix_protection_suite_1.Ok)(undefined);
    },
});
DraupnirCommandPrerequisites_1.DraupnirInterfaceAdaptor.describeRenderer(exports.SynapseAdminHijackRoomCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=HijackRoomCommand.js.map