"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardAdaptorContextToCommandContextTranslator = void 0;
class StandardAdaptorContextToCommandContextTranslator {
    constructor() {
        this.translators = new Map();
    }
    translateContext(commandDescription, adaptorContext) {
        const entry = this.translators.get(
        // i really don't care.
        commandDescription);
        if (entry === undefined) {
            return adaptorContext;
        }
        else {
            return entry(adaptorContext);
        }
    }
    registerTranslation(commandDescription, translationFunction) {
        if (this.translators.has(commandDescription)) {
            throw new TypeError(`There is already a translation function registered for the command ${commandDescription.summary}`);
        }
        this.translators.set(commandDescription, translationFunction);
        return this;
    }
}
exports.StandardAdaptorContextToCommandContextTranslator = StandardAdaptorContextToCommandContextTranslator;
//# sourceMappingURL=AdaptorContextToCommandContextTranslator.js.map