"use strict";
// Copyright 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromptRequiredError = exports.UnexpectedArgumentError = exports.ArgumentParseError = exports.AbstractArgumentParseError = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
class AbstractArgumentParseError extends typescript_result_1.ResultError {
    constructor(partialCommand, message) {
        super(message);
        this.partialCommand = partialCommand;
    }
    static Result(message, options) {
        return (0, typescript_result_1.Err)(new AbstractArgumentParseError(options.partialCommand, message));
    }
}
exports.AbstractArgumentParseError = AbstractArgumentParseError;
class ArgumentParseError extends AbstractArgumentParseError {
    constructor(parameter, partialCommand, message) {
        super(partialCommand, message);
        this.parameter = parameter;
    }
    static Result(message, options) {
        return (0, typescript_result_1.Err)(new ArgumentParseError(options.parameter, options.partialCommand, message));
    }
}
exports.ArgumentParseError = ArgumentParseError;
class UnexpectedArgumentError extends AbstractArgumentParseError {
    static Result(message, options) {
        return (0, typescript_result_1.Err)(new UnexpectedArgumentError(options.partialCommand, message));
    }
}
exports.UnexpectedArgumentError = UnexpectedArgumentError;
class PromptRequiredError extends typescript_result_1.ResultError {
    constructor(message, context, parameterRequiringPrompt, partialCommand) {
        super(message, context);
        this.parameterRequiringPrompt = parameterRequiringPrompt;
        this.partialCommand = partialCommand;
    }
    static Result(message, { promptParameter, partialCommand, }) {
        return (0, typescript_result_1.Err)(new PromptRequiredError(message, [], promptParameter, partialCommand));
    }
}
exports.PromptRequiredError = PromptRequiredError;
//# sourceMappingURL=ParseErrors.js.map