"use strict";
// Copyright 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from @the-draupnir-project/interface-manager
// https://github.com/the-draupnir-project/interface-manager
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopPresentationSchema = exports.PresentationSchemaType = void 0;
exports.checkPresentationSchema = checkPresentationSchema;
exports.acceptPresentation = acceptPresentation;
exports.printPresentationSchema = printPresentationSchema;
exports.union = union;
var PresentationSchemaType;
(function (PresentationSchemaType) {
    PresentationSchemaType["Single"] = "Single";
    PresentationSchemaType["Union"] = "Union";
    PresentationSchemaType["Top"] = "Top";
})(PresentationSchemaType || (exports.PresentationSchemaType = PresentationSchemaType = {}));
exports.TopPresentationSchema = Object.freeze({
    schemaType: PresentationSchemaType.Top,
});
function checkPresentationSchema(schema, presentation) {
    switch (schema.schemaType) {
        case PresentationSchemaType.Single:
            return presentation.presentationType === schema.presentationType;
        case PresentationSchemaType.Union:
            return Boolean(schema.variants.find((presentationType) => presentation.presentationType === presentationType));
        case PresentationSchemaType.Top:
            return true;
    }
}
function acceptPresentation(schema, commandTable, presentation) {
    if (checkPresentationSchema(schema, presentation)) {
        return presentation;
    }
    else if (schema.schemaType === PresentationSchemaType.Single) {
        const translator = commandTable.findPresentationTypeTranslator(schema.presentationType, presentation.presentationType);
        if (translator) {
            return translator.translate(presentation);
        }
        else {
            return undefined;
        }
    }
    else if (schema.schemaType === PresentationSchemaType.Union) {
        for (const variant of schema.variants) {
            const result = acceptPresentation({
                schemaType: PresentationSchemaType.Single,
                presentationType: variant,
            }, commandTable, presentation);
            if (result !== undefined) {
                return result;
            }
        }
        return undefined;
    }
    throw new TypeError(`The code is wrong`);
}
function printPresentationSchema(schema) {
    switch (schema.schemaType) {
        case PresentationSchemaType.Single:
            return schema.presentationType.name;
        case PresentationSchemaType.Union:
            return schema.variants.map((type) => type.name).join(" | ");
        case PresentationSchemaType.Top:
            return `TopPresentationSchema`;
    }
}
function union(...acceptors) {
    const presentationTypes = acceptors.reduce((acc, acceptor) => {
        if ("schemaType" in acceptor) {
            acc.push(...acceptor.variants);
        }
        else {
            acc.push(acceptor);
        }
        return acc;
    }, []);
    return {
        schemaType: PresentationSchemaType.Union,
        variants: presentationTypes,
    };
}
//# sourceMappingURL=PresentationSchema.js.map