import { CommandDescription, CommandExecutorFunction } from "./CommandDescription";
import { CommandMeta, KeywordsMeta } from "./CommandMeta";
import { DescribeCommandParametersOptions } from "./ParameterParsing";
export type DescribeCommandOptions<TCommandMeta extends CommandMeta> = {
    /** A short one line summary of what the command does to display alongside it's help */
    readonly summary: string;
    /** A longer description that goes into detail. */
    readonly description?: string;
    readonly executor: CommandExecutorFunction<TCommandMeta>;
} & DescribeCommandParametersOptions<TCommandMeta["TImmediateArgumentsObjectTypes"], TCommandMeta["TRestArgumentObjectType"], TCommandMeta["TKeywordsMeta"]>;
export declare function describeCommand<Context = unknown, InvocationInformation = unknown, CommandResult = unknown, TImmediateArgumentsObjectTypes extends unknown[] = unknown[], TRestArgumentObjectType = unknown, TKeywordsMeta extends KeywordsMeta = KeywordsMeta>(options: DescribeCommandOptions<CommandMeta<Context, InvocationInformation, CommandResult, TImmediateArgumentsObjectTypes, TRestArgumentObjectType, TKeywordsMeta>>): CommandDescription<CommandMeta<Context, InvocationInformation, CommandResult, TImmediateArgumentsObjectTypes, TRestArgumentObjectType, TKeywordsMeta>>;
//# sourceMappingURL=describeCommand.d.ts.map