import { Result } from "@gnuxie/typescript-result";
import { DocumentNode } from "./DeadDocument";
export type SendMatrixEventCB<EventID> = (text: string, html: string) => Promise<Result<EventID>>;
/**
 * Render the `DocumentNode` to Matrix (in both HTML + Markdown) using the
 * callback provided to send each event. Should serialized content span
 * more than one event, then the callback will be called for each event.
 * @param node A document node to render to Matrix.
 * @param cb A callback that will send the text+html for a single event
 * to a Matrix room.
 */
export declare function renderMatrix<EventID>(node: DocumentNode, cb: SendMatrixEventCB<EventID>): Promise<Result<EventID[]>>;
//# sourceMappingURL=DeadDocumentMatrix.d.ts.map