"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientCapabilityFactory = void 0;
const BotSDKClientPlatform_1 = require("../Client/BotSDKClientPlatform");
const BotSDKAllClient_1 = require("../Client/BotSDKAllClient");
/**
 * Creates client capabilities that reference a ClientsInRoomMap so that
 * the joined rooms can be preempted consistently.
 */
class ClientCapabilityFactory {
    constructor(clientsInRoomMap, eventDecoder) {
        this.clientsInRoomMap = clientsInRoomMap;
        this.eventDecoder = eventDecoder;
        // nothing to do.
    }
    makeClientPlatform(clientUserID, client) {
        const clientRooms = this.clientsInRoomMap.getClientRooms(clientUserID);
        if (clientRooms === undefined) {
            throw new TypeError(`Cannot create a client for an untracked user ${clientUserID}`);
        }
        return new BotSDKClientPlatform_1.BotSDKClientPlatform(new BotSDKAllClient_1.BotSDKAllClient(client, clientRooms, this.eventDecoder));
    }
}
exports.ClientCapabilityFactory = ClientCapabilityFactory;
//# sourceMappingURL=ClientCapabilityFactory.js.map