"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomDetailsResponse = exports.BrokenRoomCreatorTransform = void 0;
const typebox_1 = require("@sinclair/typebox");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const matrix_protection_suite_1 = require("matrix-protection-suite");
// There is a bug in Synapse at the moment where the creator can be blank.
// https://github.com/element-hq/synapse/issues/18563
exports.BrokenRoomCreatorTransform = typebox_1.Type.Transform(typebox_1.Type.Union([typebox_1.Type.Null(), typebox_1.Type.String()]))
    .Decode((value) => {
    if (value === '' || value === null) {
        return null;
    }
    else if ((0, matrix_basic_types_1.isStringUserID)(value)) {
        return value;
    }
    else {
        throw new TypeError('Invalid creator user ID format.');
    }
})
    .Encode((value) => (value === null ? '' : (0, matrix_basic_types_1.StringUserID)(value)));
exports.RoomDetailsResponse = typebox_1.Type.Object({
    room_id: matrix_protection_suite_1.StringRoomIDSchema,
    name: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: 'The name of the room.',
    })),
    topic: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: 'The topic of the room.',
    })),
    avatar: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: 'The mxc URI to the avatar of the room.',
    })),
    canonical_alias: typebox_1.Type.Optional(typebox_1.Type.Union([matrix_protection_suite_1.StringRoomAliasSchema, typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: 'The canonical (main) alias address of the room.',
    })),
    joined_members: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({
            description: 'How many users are currently in the room.',
        }),
        typebox_1.Type.Null(),
    ])),
    joined_local_members: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({
            description: 'How many local users are currently in the room.',
        }),
        typebox_1.Type.Null(),
    ])),
    joined_local_devices: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({
            description: 'How many local devices are currently in the room.',
        }),
        typebox_1.Type.Null(),
    ])),
    version: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.String({ description: 'The version of the room as a string.' }),
        typebox_1.Type.Null(),
    ])),
    creator: typebox_1.Type.Union([exports.BrokenRoomCreatorTransform], {
        description: 'The user_id of the room creator.',
    }),
    encryption: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: 'Algorithm of end-to-end encryption of messages. Null if encryption is not active.',
    })),
    federatable: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Boolean({
            description: 'Whether users on other servers can join this room.',
        }),
        typebox_1.Type.Null(),
    ])),
    public: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Boolean({
            description: 'Whether the room is visible in the room directory.',
        }),
        typebox_1.Type.Null(),
    ])),
    join_rules: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Literal('public'),
        typebox_1.Type.Literal('knock'),
        typebox_1.Type.Literal('knock_restricted'),
        typebox_1.Type.Literal('invite'),
        typebox_1.Type.Literal('private'),
        typebox_1.Type.Literal('restricted'),
        typebox_1.Type.String(),
        typebox_1.Type.Null(),
    ], {
        description: 'The type of rules used for users wishing to join this room.',
    })),
    guest_access: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.Literal('can_join'), typebox_1.Type.Literal('forbidden'), typebox_1.Type.Null()], { description: 'Whether guests can join the room.' })),
    history_visibility: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Literal('invited'),
        typebox_1.Type.Literal('joined'),
        typebox_1.Type.Literal('shared'),
        typebox_1.Type.Literal('world_readable'),
        typebox_1.Type.Null(),
    ], { description: 'Who can see the room history.' })),
    state_events: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Number({
            description: 'Total number of state events in the room. Represents the complexity of the room.',
        }),
        typebox_1.Type.Null(),
    ])),
    room_type: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.String(), typebox_1.Type.Null()], {
        description: "The type of the room from the room's creation event, e.g., 'm.space'. Null if not defined.",
    })),
    forgotten: typebox_1.Type.Optional(typebox_1.Type.Union([
        typebox_1.Type.Boolean({
            description: 'Whether all local users have forgotten the room.',
        }),
        typebox_1.Type.Null(),
    ])),
});
//# sourceMappingURL=RoomDetailsEndpoint.js.map