/**
 * Copyright (C) 2022-2023 Gnuxie <Gnuxie@protonmail.com>
 * All rights reserved.
 *
 * This file is modified and is NOT licensed under the Apache License.
 * This modified file incorperates work from mjolnir
 * https://github.com/matrix-org/mjolnir
 * which included the following license notice:

Copyright 2019-2021 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 *
 * However, this file is modified and the modifications in this file
 * are NOT distributed, contributed, committed, or licensed under the Apache License.
 */
import { ActionResult, EDStatic, SynapseAdminDeleteRoomRequest, SynapseAdminPostUserDeactivateRequest } from 'matrix-protection-suite';
import { MatrixSendClient } from '../MatrixEmitter';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { SynapseRoomShutdownV2RequestBody } from './ShutdownV2Endpoint';
import { BlockStatusResponse } from './BlockStatusEndpoint';
import { RoomDetailsResponse } from './RoomDetailsEndpoint';
import { UserDetailsResponse } from './UserDetailsEndpoint';
import { UserRedactionResponse, UserRedactionStatusResponse } from './UserRedactionEndpoint';
import { Result } from '@gnuxie/typescript-result';
import { RoomListQueryParams, RoomListResponse } from './RoomListEndpoint';
declare const ReportPollResponse: import("@sinclair/typebox").TObject<{
    event_reports: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TObject<{
        id: import("@sinclair/typebox").TInteger;
        room_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringRoomID>;
        name: import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TString, import("@sinclair/typebox").TNull]>;
        event_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringEventID>;
        sender: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
        user_id: import("@sinclair/typebox").TUnsafe<import("@the-draupnir-project/matrix-basic-types").StringUserID>;
        reason: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TNull, import("@sinclair/typebox").TString]>>;
    }>>;
    next_token: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TInteger, import("@sinclair/typebox").TNull]>>;
    total: import("@sinclair/typebox").TOptional<import("@sinclair/typebox").TUnion<[import("@sinclair/typebox").TInteger, import("@sinclair/typebox").TNull]>>;
}>;
type ReportPollResponse = EDStatic<typeof ReportPollResponse>;
/**
 * An account restriction at the minimum stops the user from sending
 * messages.
 */
export declare enum AccountRestriction {
    Suspended = "suspended",
    Deactivated = "deactivated",
    ShadowBanned = "shadow_banned"
}
export declare class SynapseAdminClient {
    private readonly client;
    private readonly clientUserID;
    constructor(client: MatrixSendClient, clientUserID: StringUserID);
    isSynapseAdmin(): Promise<ActionResult<boolean>>;
    deactivateUser(targetUserID: StringUserID, { erase }?: SynapseAdminPostUserDeactivateRequest): Promise<ActionResult<void>>;
    deleteRoom(roomID: StringRoomID, { block, ...otherOptions }?: SynapseAdminDeleteRoomRequest): Promise<ActionResult<void>>;
    /**
     * Make a user administrator via the Synapse Admin API
     * @param roomId the room where the user (or the bot) shall be made administrator.
     * @param userId optionally specify the user mxID to be made administrator.
     */
    makeUserRoomAdmin(roomID: StringRoomID, userID: StringUserID): Promise<ActionResult<void>>;
    getAbuseReports({ from, direction, limit, }?: {
        from?: number;
        direction?: 'f' | 'b';
        limit?: number;
    }): Promise<ActionResult<ReportPollResponse>>;
    listRooms(options: RoomListQueryParams): Promise<Result<RoomListResponse>>;
    shutdownRoomV2(roomID: StringRoomID, options: SynapseRoomShutdownV2RequestBody): Promise<ActionResult<void>>;
    getBlockStatus(roomID: StringRoomID): Promise<ActionResult<BlockStatusResponse>>;
    getRoomDetails(roomID: StringRoomID): Promise<ActionResult<RoomDetailsResponse | undefined>>;
    suspendUser(userID: StringUserID): Promise<ActionResult<void>>;
    unsuspendUser(userID: StringUserID): Promise<ActionResult<void>>;
    getUserDetails(userID: StringUserID): Promise<ActionResult<UserDetailsResponse | undefined>>;
    redactUser(userID: StringUserID): Promise<ActionResult<UserRedactionResponse>>;
    getUserRedactionStatus(redactionID: string): Promise<ActionResult<UserRedactionStatusResponse | undefined>>;
    shadowBanUser(userID: StringUserID): Promise<ActionResult<void>>;
    unshadowBanUser(userID: StringUserID): Promise<ActionResult<void>>;
    unrestrictUser(userID: StringUserID): Promise<ActionResult<AccountRestriction>>;
}
export {};
//# sourceMappingURL=SynapseAdminClient.d.ts.map