"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringPaginationTokenSchema = void 0;
exports.StringPaginationToken = StringPaginationToken;
// SPDX-FileCopyrightText: 2024 - 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typebox_1 = require("@sinclair/typebox");
typebox_1.FormatRegistry.Set('StringPaginationToken', (thing) => typeof thing === 'string');
exports.StringPaginationTokenSchema = typebox_1.Type.Unsafe(typebox_1.Type.String({ format: 'StringPaginationToken' }));
function StringPaginationToken(token) {
    if (typeof token !== 'string') {
        throw new TypeError(`StringPaginationToken must be a string, got ${typeof token}`);
    }
    return token;
}
//# sourceMappingURL=PaginationToken.js.map