import { ClientRooms } from './ClientRooms';
import { RoomEvent } from '../MatrixTypes/Events';
import { JoinedRoomsSafe } from './StandardClientRooms';
import { ActionResult } from '../Interface/Action';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
export interface ClientsInRoomMap {
    isClientInRoom(userID: StringUserID, roomID: StringRoomID): boolean;
    isClientPreemptivelyInRoom(userID: StringUserID, roomID: StringRoomID): boolean;
    getManagedUsersInRoom(roomID: StringRoomID): StringUserID[];
    getClientRooms(userID: StringUserID): ClientRooms | undefined;
    makeClientRooms(userID: StringUserID, joinedRoomsThunk: JoinedRoomsSafe): Promise<ActionResult<ClientRooms>>;
    removeClient(clientUserID: StringUserID): void;
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
    preemptTimelineJoin(userID: StringUserID, roomID: StringRoomID): void;
}
export declare class StandardClientsInRoomMap implements ClientsInRoomMap {
    private readonly userIDByRoom;
    private readonly clientRoomsByUserID;
    private readonly userRevisionListener;
    constructor();
    private addUserToRoom;
    private removeUserFromRoom;
    private userRevisionListenerMethod;
    private addClientRooms;
    makeClientRooms(userID: StringUserID, joinedRoomsThunk: JoinedRoomsSafe): Promise<ActionResult<ClientRooms>>;
    private removeClientRooms;
    removeClient(clientUserID: StringUserID): void;
    isClientInRoom(userID: StringUserID, roomID: StringRoomID): boolean;
    isClientPreemptivelyInRoom(userID: StringUserID, roomID: StringRoomID): boolean;
    preemptTimelineJoin(userID: StringUserID, roomID: StringRoomID): void;
    getClientRooms(userID: StringUserID): ClientRooms | undefined;
    getManagedUsersInRoom(roomID: StringRoomID): StringUserID[];
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
}
//# sourceMappingURL=ClientsInRoomMap.d.ts.map