"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OnEventToOnRoomEventActivityConverter = void 0;
const ConstantPeriodBatch_1 = require("./ConstantPeriodBatch");
/**
 * This is a helper to turn clients that give us a per event handler back into
 * something that bundles events together.
 * If you can avoid doing this by writing your own sync loop or `/transactions`
 * handler, then do so because this is going to suck a little.
 * https://github.com/Gnuxie/matrix-protection-suite/issues/14
 */
class OnEventToOnRoomEventActivityConverter {
    constructor(cb) {
        this.cb = cb;
        this.eventsByRoom = new Map();
        this.batcher = new ConstantPeriodBatch_1.ConstantPeriodBatch(() => undefined);
        this.batchHandler = this.handleBatch.bind(this);
        // nothing to do.
    }
    internRoomEvent(event) {
        const entry = this.eventsByRoom.get(event.room_id);
        if (entry === undefined) {
            this.eventsByRoom.set(event.room_id, [event]);
        }
        else {
            entry.push(event);
        }
    }
    handleTimelineEvent(roomID, event) {
        if (this.batcher.isFinished()) {
            this.batcher = new ConstantPeriodBatch_1.ConstantPeriodBatch(this.batchHandler);
        }
        this.internRoomEvent(event);
    }
    handleBatch() {
        for (const [roomID, events] of this.eventsByRoom.entries()) {
            this.cb(roomID, events);
        }
        this.eventsByRoom.clear();
    }
}
exports.OnEventToOnRoomEventActivityConverter = OnEventToOnRoomEventActivityConverter;
//# sourceMappingURL=RoomEventAcivity.js.map