import { ActionResult } from './Action';
export declare const DRAUPNIR_SCHEMA_VERSION_KEY = "ge.applied-langua.ge.draupnir.schema_version";
export type SchemedData<VersionKey extends string = typeof DRAUPNIR_SCHEMA_VERSION_KEY, Version extends number = number> = {
    [P in VersionKey]?: Version;
};
export type SchemaMigration<TSchema extends SchemedData = SchemedData> = (input: TSchema, toVersion: number) => Promise<ActionResult<TSchema>>;
export declare class SchemedDataManager<TSchema extends SchemedData = SchemedData> {
    private migrationSchema;
    readonly versionKey: keyof TSchema;
    constructor(migrationSchema: SchemaMigration<TSchema>[], versionKey?: keyof TSchema);
    migrateData(rawData: TSchema): Promise<ActionResult<TSchema>>;
    get latestVersion(): number;
}
//# sourceMappingURL=SchemedMatrixData.d.ts.map