"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const PermalinkSchema_1 = require("./PermalinkSchema");
const Value_1 = require("../Interface/Value");
function testLink(aClass, link) {
    const reference = Value_1.Value.Decode(PermalinkSchema_1.PermalinkSchema, link).expect('Should be able to decode all these links');
    expect(reference instanceof aClass).toBe(true);
}
test('PermalinkSchema works', function () {
    testLink(matrix_basic_types_1.MatrixEventViaRoomID, 'https://matrix.to/#/!yvVjpvDizjZrURyvZH:matrix.org/%2431MnLVoP_HR8muVkdEYsdd8Jc44X221nHpnHRqBOIeY?via=matrix.org&via=sosnowkadub.de&via=neko.dev');
    testLink(matrix_basic_types_1.MatrixEventViaRoomID, 'https://matrix.to/#/!yvVjpvDizjZrURyvZH:matrix.org/$31MnLVoP_HR8muVkdEYsdd8Jc44X221nHpnHRqBOIeY?via=matrix.org&via=sosnowkadub.de&via=neko.dev');
    testLink(matrix_basic_types_1.MatrixRoomID, 'https://matrix.to/#/!yvVjpvDizjZrURyvZH:matrix.org');
    testLink(matrix_basic_types_1.MatrixRoomID, 'https://matrix.to/#/!yvVjpvDizjZrURyvZH:matrix.org?via=matrix.org&via=sosnowkadub.de&via=neko.dev');
    testLink(matrix_basic_types_1.MatrixRoomAlias, 'https://matrix.to/#/#foo:localhhost:9999');
    testLink(matrix_basic_types_1.MatrixRoomAlias, 'https://matrix.to/#/%23foo:localhhost:9999');
    testLink(matrix_basic_types_1.MatrixEventViaAlias, 'https://matrix.to/#/#yvVjpvDizjZrURyvZH:matrix.org/$31MnLVoP_HR8muVkdEYsdd8Jc44X221nHpnHRqBOIeY');
});
//# sourceMappingURL=PermalinkSchema.test.js.map