"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynapseReport = void 0;
// Copyright 2023 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from synapse
// https://github.com/matrix-org/synapse
// </text>
const typebox_1 = require("@sinclair/typebox");
const StringlyTypedMatrix_1 = require("./StringlyTypedMatrix");
exports.SynapseReport = typebox_1.Type.Object({
    id: typebox_1.Type.Integer({
        description: 'ID of event report.',
    }),
    room_id: StringlyTypedMatrix_1.StringRoomIDSchema,
    name: typebox_1.Type.Union([
        typebox_1.Type.String({
            description: 'The ID of the room in which the event being reported is located.',
        }),
        typebox_1.Type.Null(),
    ]),
    event_id: StringlyTypedMatrix_1.StringEventIDSchema,
    sender: StringlyTypedMatrix_1.StringUserIDSchema,
    user_id: StringlyTypedMatrix_1.StringUserIDSchema,
    reason: typebox_1.Type.Optional(typebox_1.Type.Union([typebox_1.Type.Null(), typebox_1.Type.String()], {
        description: 'Comment made by the user_id in this report. May be blank or null.',
    })),
});
//# sourceMappingURL=SynapseReport.js.map