import { StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { PolicyRuleType } from '../MatrixTypes/PolicyEvents';
import { SetMembershipDelta, SetMembershipRevision } from '../Membership/SetMembershipRevision';
import { PolicyListRevision } from '../PolicyList/PolicyListRevision';
import { Recommendation, PolicyRule } from '../PolicyList/PolicyRule';
import { PolicyRuleChange } from '../PolicyList/PolicyRuleChange';
import { MemberPolicyMatches, MembershipPolicyRevisionDelta, SetMembershipPolicyRevision } from './MembershipPolicyRevision';
import { Revision } from '../PolicyList/Revision';
export declare class StandardSetMembershipPolicyRevision implements SetMembershipPolicyRevision {
    private readonly memberPolicies;
    private readonly policyMembers;
    readonly revision: Revision;
    private constructor();
    changesFromMembershipChanges(delta: SetMembershipDelta, policyRevision: PolicyListRevision): MembershipPolicyRevisionDelta;
    changesFromPolicyChanges(changes: PolicyRuleChange[], setMembershipRevision: SetMembershipRevision): MembershipPolicyRevisionDelta;
    changesFromInitialRevisions(policyRevision: PolicyListRevision, setMembershipRevision: SetMembershipRevision): MembershipPolicyRevisionDelta;
    reviseFromChanges(delta: MembershipPolicyRevisionDelta): SetMembershipPolicyRevision;
    isBlankRevision(): boolean;
    allMembersWithRules(): MemberPolicyMatches[];
    allRulesMatchingMember(member: StringUserID, options: {
        type?: PolicyRuleType;
        recommendation?: Recommendation;
    }): PolicyRule[];
    static blankRevision(): StandardSetMembershipPolicyRevision;
}
//# sourceMappingURL=StandardSetMembershipPolicyRevision.d.ts.map