import EventEmitter from 'events';
import { RoomStateRevisionIssuer } from '../StateTracking//StateRevisionIssuer';
import { PolicyRoomRevisionIssuer } from './PolicyListRevisionIssuer';
import { PolicyRoomRevision } from './PolicyListRevision';
import { StateEvent } from '../MatrixTypes/Events';
import { Redaction } from '../MatrixTypes/Redaction';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { LiteralPolicyRule } from './PolicyRule';
/**
 * An implementation of the {@link RoomMembershipRevisionIssuer} that
 * uses the {@link RoomStateRevisionIssuer}.
 */
export declare class RoomStatePolicyRoomRevisionIssuer extends EventEmitter implements PolicyRoomRevisionIssuer {
    readonly room: MatrixRoomID;
    currentRevision: PolicyRoomRevision;
    private readonly roomStateRevisionIssuer;
    private readonly stateRevisionListener;
    constructor(room: MatrixRoomID, currentRevision: PolicyRoomRevision, roomStateRevisionIssuer: RoomStateRevisionIssuer);
    updateForStateEvent(event: StateEvent): void;
    updateForRedactionEvent(event: Redaction): void;
    private listener;
    updateForRevealedPolicies(policies: LiteralPolicyRule[]): void;
    unregisterListeners(): void;
}
//# sourceMappingURL=RoomStatePolicyListRevisionIssuer.d.ts.map