import { Map as PersistentMap, List } from 'immutable';
export type ListMultiMap<Key, Value> = PersistentMap<Key, List<Value>>;
type GetKeyFromValue<Key, Value> = (value: Value) => Key;
export declare const ListMultiMap: Readonly<{
    add<Key, Value>(map: ListMultiMap<Key, Value>, key: Key, value: Value): ListMultiMap<Key, Value>;
    remove<Key, Value>(map: ListMultiMap<Key, Value>, key: Key, value: Value): ListMultiMap<Key, Value>;
    removeValues<Key, Value>(map: ListMultiMap<Key, Value>, remove: Value[], getKeyFromValue: GetKeyFromValue<Key, Value>): ListMultiMap<Key, Value>;
    addValues<Key, Value>(map: ListMultiMap<Key, Value>, add: Value[], getKeyFromValue: GetKeyFromValue<Key, Value>): ListMultiMap<Key, Value>;
    deriveIntents<Key, Value>(map: ListMultiMap<Key, Value>, add: Value[], remove: Value[], getKeyFromValue: GetKeyFromValue<Key, Value>): {
        intend: Key[];
        recall: Key[];
    };
    empty<Key, Value>(): ListMultiMap<Key, Value>;
}>;
export {};
//# sourceMappingURL=ListMultiMap.d.ts.map