import { AnyProjectionNode, ExtractDeltaShape, ExtractInputDeltaShapes, ExtractInputProjectionNodes, ExtractProjectionInputs, ProjectionNode } from './ProjectionNode';
export type ProjectionNodeListener<TProjectionNode extends ProjectionNode = ProjectionNode> = (currentNode: TProjectionNode, delta: ExtractDeltaShape<TProjectionNode>, previousNode: TProjectionNode) => void;
export interface Projection<TProjectionNode extends AnyProjectionNode = AnyProjectionNode> {
    readonly currentNode: TProjectionNode;
    addOutput(projection: Projection): this;
    removeOutput(projection: Projection): this;
    applyInput(input: ExtractProjectionInputs<TProjectionNode>): void;
    addNodeListener(listener: ProjectionNodeListener<TProjectionNode>): this;
    removeNodeListener(listener: ProjectionNodeListener<TProjectionNode>): this;
}
export declare class ProjectionOutputHelper<TProjectionNode extends ProjectionNode = ProjectionNode> {
    currentNode: TProjectionNode;
    private readonly outputs;
    private readonly emitter;
    constructor(currentNode: TProjectionNode);
    applyInput(input: ExtractInputDeltaShapes<ExtractInputProjectionNodes<TProjectionNode>>): void;
    addOutput(projection: Projection): this;
    removeOutput(projection: Projection): this;
    addNodeListener(listener: ProjectionNodeListener<TProjectionNode>): this;
    removeNodeListener(listener: ProjectionNodeListener<TProjectionNode>): this;
    [Symbol.dispose](): void;
}
//# sourceMappingURL=Projection.d.ts.map