import { Result } from '@gnuxie/typescript-result';
import { Capability } from '../CapabilityProvider';
import { ServerConsequences } from './ServerConsequences';
import { ProtectedRoomsSet } from '../../ProtectedRoomsSet';
import { StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { RoomSetResult } from './RoomSetResult';
import { PolicyListRevisionIssuer } from '../../../PolicyList/PolicyListRevisionIssuer';
export declare class SimulatedServerConsequences implements ServerConsequences, Capability {
    private readonly protectedRoomsSet;
    readonly requiredPermissions: never[];
    readonly requiredEventPermissions: never[];
    readonly requiredStatePermissions: never[];
    readonly isSimulated = true;
    private readonly simulatedCapability;
    constructor(protectedRoomsSet: ProtectedRoomsSet);
    consequenceForServersInRoom(roomID: StringRoomID, issuer: PolicyListRevisionIssuer): Promise<Result<boolean>>;
    consequenceForServersInRoomSet(issuer: PolicyListRevisionIssuer): Promise<Result<RoomSetResult>>;
    unbanServerFromRoomSet(serverName: string, reason: string): Promise<Result<RoomSetResult>>;
}
//# sourceMappingURL=SimulatedServerConsequences.d.ts.map