"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardProtectionCapabilityProviderSetConfig = void 0;
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
const typescript_result_1 = require("@gnuxie/typescript-result");
const PersistentConfigData_1 = require("../../../Config/PersistentConfigData");
const describeConfig_1 = require("../../../Config/describeConfig");
const typebox_1 = require("@sinclair/typebox");
const CapabilityProvider_1 = require("../../Capability/CapabilityProvider");
const Logger_1 = require("../../../Logging/Logger");
const log = new Logger_1.Logger('StandardProtectionCapabilityProviderSetConfig');
const CapabilityProviderConfig = typebox_1.Type.Object({
    capability_provider_name: typebox_1.Type.String(),
});
const CapabilityProviderSetConfigDescription = (0, describeConfig_1.describeConfig)({
    schema: typebox_1.Type.Object({}, { additionalProperties: CapabilityProviderConfig }),
});
class StandardProtectionCapabilityProviderSetConfig {
    constructor(makePersistentConfigBackend) {
        this.makePersistentConfigBackend = makePersistentConfigBackend;
        // nothing to do mare.
    }
    async storeActivateCapabilityProviderSet(protectionDescription, capabilityproviderSet) {
        const persistentConfigBackend = this.makePersistentConfigBackend(protectionDescription);
        if ((0, typescript_result_1.isError)(persistentConfigBackend)) {
            return persistentConfigBackend;
        }
        const persistentConfigData = new PersistentConfigData_1.StandardPersistentConfigData(CapabilityProviderSetConfigDescription, persistentConfigBackend.ok);
        let config = {};
        for (const [capabilityName, capabilityProvider] of Object.entries(capabilityproviderSet)) {
            config = {
                ...config,
                [capabilityName]: { capability_provider_name: capabilityProvider.name },
            };
        }
        return await persistentConfigData.saveConfig(config);
    }
    async getCapabilityProviderSet(protectionDescription) {
        const persistentConfigData = this.makePersistentConfigBackend(protectionDescription);
        if ((0, typescript_result_1.isError)(persistentConfigData)) {
            return persistentConfigData;
        }
        const result = await persistentConfigData.ok.requestUnparsedConfig();
        if ((0, typescript_result_1.isError)(result)) {
            return result;
        }
        if (result.ok === undefined) {
            return (0, typescript_result_1.Ok)(protectionDescription.defaultCapabilities);
        }
        const capabilityProviderSet = {
            ...protectionDescription.defaultCapabilities,
        };
        for (const [capabilityName, capabilityProviderConfig] of Object.entries(result.ok)) {
            const providerDescription = (0, CapabilityProvider_1.findCapabilityProvider)(capabilityProviderConfig.capability_provider_name);
            // drats, this should really be a config use error but it's a bitch because
            // we don't eagerly load all the capability configs to create this config,
            // so it is failing late and bad if we use it here.
            if (providerDescription === undefined) {
                log.error(`Unable to find a capability provider for ${capabilityProviderConfig.capability_provider_name} in the protection ${protectionDescription.name}, so using the default for the ${capabilityName}`);
                continue;
            }
            capabilityProviderSet[capabilityName] = providerDescription;
        }
        return (0, typescript_result_1.Ok)(capabilityProviderSet);
    }
}
exports.StandardProtectionCapabilityProviderSetConfig = StandardProtectionCapabilityProviderSetConfig;
//# sourceMappingURL=StandardProtectionCapabilityProviderSetConfig.js.map