import { ULID, ULIDFactory } from 'ulidx';
import { ExtractInputDeltaShapes, ProjectionNode } from '../../../Projection/ProjectionNode';
import { MemberPolicyMatch, MemberPolicyMatches, MembershipPolicyRevision, MembershipPolicyRevisionDelta } from '../../../MembershipPolicies/MembershipPolicyRevision';
import { StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { List, Map as PersistentMap } from 'immutable';
import { GlobPolicyRule, LiteralPolicyRule } from '../../../PolicyList/PolicyRule';
/**
 * This is just a stand in while we wait to convert the upstream MembershipPolicyRevision
 * to a projection.
 */
export type MemberBanInputProjectionNode = ProjectionNode<never[], MembershipPolicyRevisionDelta> & MembershipPolicyRevision;
export interface MemberBanIntentProjectionDelta {
    add: MemberPolicyMatch[];
    remove: MemberPolicyMatch[];
    ban: StringUserID[];
    recall: StringUserID[];
}
export type MemberBanIntentProjectionNode = ProjectionNode<[
    MemberBanInputProjectionNode
], MemberBanIntentProjectionDelta, {
    allMembersWithRules(): MemberPolicyMatches[];
    allRulesMatchingMember(member: StringUserID): (LiteralPolicyRule | GlobPolicyRule)[];
}>;
export declare const MemberBanIntentProjectionNodeHelper: Readonly<{
    reduceMembershipPolicyDelta(input: MembershipPolicyRevisionDelta): Pick<MemberBanIntentProjectionDelta, "add" | "remove">;
    reduceIntentDelta(input: Pick<MemberBanIntentProjectionDelta, "add" | "remove">, policies: PersistentMap<StringUserID, List<LiteralPolicyRule | GlobPolicyRule>>): MemberBanIntentProjectionDelta;
}>;
export declare class StandardMemberBanIntentProjectionNode implements MemberBanIntentProjectionNode {
    private readonly ulidFactory;
    private readonly intents;
    readonly ulid: ULID;
    constructor(ulidFactory: ULIDFactory, intents: PersistentMap<StringUserID, List<LiteralPolicyRule | GlobPolicyRule>>);
    static create(ulidFactory: ULIDFactory): MemberBanIntentProjectionNode;
    isEmpty(): boolean;
    reduceInput(input: ExtractInputDeltaShapes<[MemberBanInputProjectionNode]>): MemberBanIntentProjectionDelta;
    reduceDelta(input: MemberBanIntentProjectionDelta): StandardMemberBanIntentProjectionNode;
    reduceInitialInputs([membershipPolicyRevision]: [
        MemberBanInputProjectionNode
    ]): MemberBanIntentProjectionDelta;
    allMembersWithRules(): MemberPolicyMatches[];
    allRulesMatchingMember(member: StringUserID): (LiteralPolicyRule | GlobPolicyRule)[];
}
//# sourceMappingURL=MemberBanIntentProjectionNode.d.ts.map