import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { ActionResult } from '../../../Interface/Action';
import { PolicyListRevision } from '../../../PolicyList/PolicyListRevision';
import { PolicyRuleChange } from '../../../PolicyList/PolicyRuleChange';
import { RoomStateRevision, StateChange } from '../../../StateTracking/StateRevisionIssuer';
import { ServerConsequences } from '../../Capability/StandardCapability/ServerConsequences';
import { ProtectedRoomsSet } from '../../ProtectedRoomsSet';
import { AbstractProtection, Protection, ProtectionDescription } from '../../Protection';
import { UnknownConfig } from '../../../Config/ConfigDescription';
import '../../Capability/StandardCapability/ServerConsequences';
import '../../Capability/StandardCapability/ServerACLConsequences';
import { OwnLifetime } from '../../../Interface/Lifetime';
import { ServerBanIntentProjection } from './ServerBanIntentProjection';
export declare class ServerBanSynchronisationProtection extends AbstractProtection<ProtectionDescription<unknown, UnknownConfig, Capabilities>> implements Protection<ProtectionDescription<unknown, UnknownConfig, Capabilities>, ServerBanIntentProjection> {
    readonly intentProjection: ServerBanIntentProjection;
    private readonly serverConsequences;
    constructor(description: ProtectionDescription<unknown, UnknownConfig, Capabilities>, lifetime: OwnLifetime<Protection<ProtectionDescription<unknown, UnknownConfig, Capabilities>>>, capabilities: Capabilities, protectedRoomsSet: ProtectedRoomsSet, intentProjection: ServerBanIntentProjection);
    handleStateChange(revision: RoomStateRevision, changes: StateChange[]): Promise<ActionResult<void>>;
    handlePolicyChange(_revision: PolicyListRevision, changes: PolicyRuleChange[]): Promise<ActionResult<void>>;
    handlePermissionRequirementsMet(room: MatrixRoomID): void;
}
type Capabilities = {
    serverConsequences: ServerConsequences;
};
export {};
//# sourceMappingURL=ServerBanSynchronisation.d.ts.map