import { RoomEvent } from '../../MatrixTypes/Events';
import { ErroneousEventMixin, EventMixin, EventMixinDescription, ExtractEerrorMixinFromDescription, ExtractOkMixinFromDescription, OkEventMixin } from './EventMixinDescription';
export type ContentMixins = Readonly<{
    readonly mixins: EventMixin[];
    readonly additionalProperties: Record<string, unknown>;
    findMixin<TDescription extends EventMixinDescription<OkEventMixin, ErroneousEventMixin>>(description: TDescription): undefined | ExtractOkMixinFromDescription<TDescription> | ExtractEerrorMixinFromDescription<TDescription>;
}>;
export type EventWithMixins = Readonly<{
    sourceEvent: RoomEvent;
    eventType: string;
}> & ContentMixins;
export interface MixinExtractor {
    parseContent(content: Record<string, unknown>): ContentMixins;
    parseEvent(event: RoomEvent): EventWithMixins;
}
//# sourceMappingURL=EventMixinExtraction.d.ts.map