"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SafeModeHelpCommand = void 0;
const SafeModeCommands_1 = require("./SafeModeCommands");
const SafeModeAdaptor_1 = require("./SafeModeAdaptor");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const StatusCommand_1 = require("./StatusCommand");
const config_1 = require("../../config");
exports.SafeModeHelpCommand = (0, interface_manager_1.describeCommand)({
    rest: {
        name: "command parts",
        acceptor: interface_manager_1.TopPresentationSchema,
    },
    summary: "Display this message",
    executor: async function (_context, _keywords) {
        return (0, matrix_protection_suite_1.Ok)(SafeModeCommands_1.SafeModeCommands);
    },
    parameters: [],
});
SafeModeAdaptor_1.SafeModeInterfaceAdaptor.describeRenderer(exports.SafeModeHelpCommand, {
    JSXRenderer() {
        return (0, matrix_protection_suite_1.Ok)(interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
            (0, StatusCommand_1.safeModeHeader)(),
            (0, mps_interface_adaptor_1.renderTableHelp)(SafeModeCommands_1.SafeModeCommands, config_1.DOCUMENTATION_URL)));
    },
});
//# sourceMappingURL=HelpCommand.js.map