"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SafeModeCommands = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const HelpCommand_1 = require("./HelpCommand");
const StatusCommand_1 = require("./StatusCommand");
const RestartDraupnirCommand_1 = require("./RestartDraupnirCommand");
const RecoverCommand_1 = require("./RecoverCommand");
exports.SafeModeCommands = new interface_manager_1.StandardCommandTable("safe mode")
    .internPresentationTypeTranslator(interface_manager_1.StringFromNumberTranslator)
    .internPresentationTypeTranslator(interface_manager_1.StringfromBooleanTranslator)
    .internPresentationTypeTranslator(interface_manager_1.StringFromMatrixRoomIDTranslator)
    .internPresentationTypeTranslator(interface_manager_1.StringFromMatrixRoomAliasTranslator)
    .internPresentationTypeTranslator(interface_manager_1.StringFromMatrixUserIDTranslator)
    .internPresentationTypeTranslator(interface_manager_1.StringFromMatrixEventReferenceTranslator)
    .internCommand(HelpCommand_1.SafeModeHelpCommand, ["draupnir", "help"])
    .internCommand(StatusCommand_1.SafeModeStatusCommand, ["draupnir", "status"])
    .internCommand(RecoverCommand_1.SafeModeRecoverCommand, ["draupnir", "recover"])
    .internCommand(RestartDraupnirCommand_1.SafeModeRestartCommand, ["draupnir", "restart"]);
//# sourceMappingURL=SafeModeCommands.js.map