# Contributing

AdonisJs is a community driven project. You are free to contribute in any of the following ways.

- [Coding style](coding-style)
- [Fix bugs by creating PR's](fix-bugs-by-creating-prs)
- [Share an RFC for new features or big changes](share-an-rfc-for-new-features-or-big-changes)
- [Report security issues](report-security-issues)
- [Be a part of the community](be-a-part-of-community)

## Coding style

Majority of AdonisJs core packages are written in Typescript. Having a brief knowledge of Typescript is required to contribute to the core. [Learn more](https://adonisjs.com/coding-style) about the same.

## Fix bugs by creating PR's

We appreciate every time you report a bug in the framework or related libraries. However, taking time to submit a PR can help us in fixing bugs quickly and ensure a healthy and stable eco-system.

Go through the following points, before creating a new PR.

1. Create an issue discussing the bug or short-coming in the framework.
2. Once approved, go ahead and fork the REPO.
3. Make sure to start from the `develop`, since this is the upto date branch.
4. Make sure to keep commits small and relevant.
5. We follow [conventional-commits](https://github.com/conventional-changelog/conventional-changelog) to structure our commit messages. Instead of running `git commit`, you must run `npm commit`, which will show you prompts to create a valid commit message.
6. Once done with all the changes, create a PR against the `develop` branch.

## Share an RFC for new features or big changes

Sharing PR's for small changes works great. However, when contributing big features to the framework, it is required to go through the RFC process.

### What is an RFC?

RFC stands for **Request for Commits**, a standard process followed by many other frameworks including [Ember](https://github.com/emberjs/rfcs), [yarn](https://github.com/yarnpkg/rfcs) and [rust](https://github.com/rust-lang/rfcs). 

In brief, RFC process allows you to talk about the changes with everyone in the community and get a view of the core team before dedicating your time to work on the feature.

The RFC proposals are created as issues on [adonisjs/rfcs](https://github.com/adonisjs/rfcs) repo. Make sure to read the README to learn about the process in depth.

## Report security issues

All of the security issues, must be reported via [email](mailto:virk@adonisjs.com) and not using any of the public channels. [Learn more](https://adonisjs.com/security) about the security policy

## Be a part of community

We welcome you to participate in the [forum](https://forum.adonisjs.com/) and the AdonisJs [discord server](https://discord.me/adonisjs). You are free to ask your questions and share your work or contributions made to AdonisJs eco-system. 

We follow a strict [Code of Conduct](https://adonisjs.com/community-guidelines) to make sure everyone is respectful to each other.
