import { getCurrentHub } from '@sentry/core';
import { normalize } from '@sentry/utils';
import { getIPC } from '../ipc.js';

/**
 * Passes scope changes to the main process.
 */
class ScopeToMain {
    constructor() {
        this.name = ScopeToMain.id;
    }
    /** @inheritDoc */
    setupOnce() {
        this._setupScopeListener();
    }
    /**
     * Sends the scope to the main process when it updates.
     */
    _setupScopeListener() {
        const scope = getCurrentHub().getScope();
        if (scope) {
            const ipc = getIPC();
            scope.addScopeListener((updatedScope) => {
                ipc.sendScope(JSON.stringify(normalize(updatedScope, 20, 2000)));
                scope.clearBreadcrumbs();
                scope.clearAttachments();
            });
        }
    }
}
/** @inheritDoc */
ScopeToMain.id = 'ScopeToMain';

export { ScopeToMain };
//# sourceMappingURL=scope-to-main.js.map
