const node = require('@sentry/node');
const index = require('./integrations/index.js');
const core = require('@sentry/core');
const electronNet = require('./transports/electron-net.js');
const electronOfflineNet = require('./transports/electron-offline-net.js');
const sdk = require('./sdk.js');
const anr = require('./anr.js');
const process = require('../common/process.js');
const mode = require('../common/mode.js');

process.ensureProcess('main');
const Integrations = Object.assign(Object.assign({}, index), node.Integrations);

exports.NodeClient = node.NodeClient;
exports.close = node.close;
exports.flush = node.flush;
exports.lastEventId = node.lastEventId;
exports.FunctionToString = core.FunctionToString;
exports.Hub = core.Hub;
exports.InboundFilters = core.InboundFilters;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addGlobalEventProcessor = core.addGlobalEventProcessor;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureMessage = core.captureMessage;
exports.configureScope = core.configureScope;
exports.createTransport = core.createTransport;
exports.getCurrentHub = core.getCurrentHub;
exports.getHubFromCarrier = core.getHubFromCarrier;
exports.makeMain = core.makeMain;
exports.setContext = core.setContext;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.startTransaction = core.startTransaction;
exports.withScope = core.withScope;
exports.makeElectronTransport = electronNet.makeElectronTransport;
exports.makeElectronOfflineTransport = electronOfflineNet.makeElectronOfflineTransport;
exports.defaultIntegrations = sdk.defaultIntegrations;
exports.init = sdk.init;
exports.enableMainProcessAnrDetection = anr.enableMainProcessAnrDetection;
Object.defineProperty(exports, 'IPCMode', {
	enumerable: true,
	get: () => mode.IPCMode
});
exports.Integrations = Integrations;
//# sourceMappingURL=index.js.map
