Object.defineProperty(exports, '__esModule', { value: true });

const core = require('@sentry/core');
const index = require('./tracing/index.js');
const client = require('./client.js');
const http = require('./transports/http.js');
const sdk = require('./sdk.js');
const requestdata = require('./requestdata.js');
const utils = require('./utils.js');
const module$1 = require('./module.js');
const index$1 = require('./anr/index.js');
const handlers = require('./handlers.js');
const index$2 = require('./integrations/index.js');
const integrations = require('./tracing/integrations.js');

const INTEGRATIONS = {
  ...core.Integrations,
  ...index$2,
  ...integrations,
};

exports.Hub = core.Hub;
exports.SDK_VERSION = core.SDK_VERSION;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addGlobalEventProcessor = core.addGlobalEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureMessage = core.captureMessage;
exports.close = core.close;
exports.configureScope = core.configureScope;
exports.continueTrace = core.continueTrace;
exports.createTransport = core.createTransport;
exports.extractTraceparentData = core.extractTraceparentData;
exports.flush = core.flush;
exports.getActiveSpan = core.getActiveSpan;
exports.getActiveTransaction = core.getActiveTransaction;
exports.getCurrentHub = core.getCurrentHub;
exports.getHubFromCarrier = core.getHubFromCarrier;
exports.lastEventId = core.lastEventId;
exports.makeMain = core.makeMain;
exports.runWithAsyncContext = core.runWithAsyncContext;
exports.setContext = core.setContext;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanStatusfromHttpCode = core.spanStatusfromHttpCode;
exports.startActiveSpan = core.startActiveSpan;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.startTransaction = core.startTransaction;
exports.trace = core.trace;
exports.withScope = core.withScope;
exports.autoDiscoverNodePerformanceMonitoringIntegrations = index.autoDiscoverNodePerformanceMonitoringIntegrations;
exports.NodeClient = client.NodeClient;
exports.makeNodeTransport = http.makeNodeTransport;
exports.defaultIntegrations = sdk.defaultIntegrations;
exports.defaultStackParser = sdk.defaultStackParser;
exports.getSentryRelease = sdk.getSentryRelease;
exports.init = sdk.init;
exports.DEFAULT_USER_INCLUDES = requestdata.DEFAULT_USER_INCLUDES;
exports.addRequestDataToEvent = requestdata.addRequestDataToEvent;
exports.extractRequestData = requestdata.extractRequestData;
exports.deepReadDirSync = utils.deepReadDirSync;
exports.getModuleFromFilename = module$1.getModuleFromFilename;
exports.enableAnrDetection = index$1.enableAnrDetection;
exports.Handlers = handlers;
exports.Integrations = INTEGRATIONS;
//# sourceMappingURL=index.js.map
