'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = require('react');
var React__default = _interopDefault(React);
var warning = _interopDefault(require('tiny-warning'));
var PropTypes = _interopDefault(require('prop-types'));
var hoist = _interopDefault(require('hoist-non-react-statics'));
var getDisplayName = _interopDefault(require('react-display-name'));

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function isObject(obj) {
  return obj !== null && typeof obj === 'object' && !Array.isArray(obj);
}

function createThemeProvider(context) {
  var ThemeProvider =
  /*#__PURE__*/
  function (_React$Component) {
    _inheritsLoose(ThemeProvider, _React$Component);

    function ThemeProvider() {
      var _this;

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _React$Component.call.apply(_React$Component, [this].concat(args)) || this;

      _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "cachedTheme", void 0);

      _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "lastOuterTheme", void 0);

      _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "lastTheme", void 0);

      _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "renderProvider", function (outerTheme) {
        var children = _this.props.children;
        return React__default.createElement(context.Provider, {
          value: _this.getTheme(outerTheme)
        }, children);
      });

      return _this;
    }

    var _proto = ThemeProvider.prototype;

    // Get the theme from the props, supporting both (outerTheme) => {} as well as object notation
    _proto.getTheme = function getTheme(outerTheme) {
      if (this.props.theme !== this.lastTheme || outerTheme !== this.lastOuterTheme || !this.cachedTheme) {
        this.lastOuterTheme = outerTheme;
        this.lastTheme = this.props.theme;

        if (typeof this.lastTheme === 'function') {
          var theme = this.props.theme;
          this.cachedTheme = theme(outerTheme);
          process.env.NODE_ENV !== "production" ? warning(isObject(this.cachedTheme), '[ThemeProvider] Please return an object from your theme function') : void 0;
        } else {
          var _theme = this.props.theme;
          process.env.NODE_ENV !== "production" ? warning(isObject(_theme), '[ThemeProvider] Please make your theme prop a plain object') : void 0;
          this.cachedTheme = outerTheme ? _extends({}, outerTheme, _theme) : _theme;
        }
      }

      return this.cachedTheme;
    };

    _proto.render = function render() {
      var children = this.props.children;

      if (!children) {
        return null;
      }

      return React__default.createElement(context.Consumer, null, this.renderProvider);
    };

    return ThemeProvider;
  }(React__default.Component);

  if (process.env.NODE_ENV !== 'production') {
    ThemeProvider.propTypes = {
      // eslint-disable-next-line react/require-default-props
      children: PropTypes.node,
      theme: PropTypes.oneOfType([PropTypes.shape({}), PropTypes.func]).isRequired
    };
  }

  return ThemeProvider;
}

function createWithTheme(context) {
  return function hoc(Component) {
    var withTheme = React__default.forwardRef(function (props, ref) {
      return React__default.createElement(context.Consumer, null, function (theme) {
        process.env.NODE_ENV !== "production" ? warning(isObject(theme), '[theming] Please use withTheme only with the ThemeProvider') : void 0;
        return React__default.createElement(Component, _extends({
          theme: theme,
          ref: ref
        }, props));
      });
    });

    if (process.env.NODE_ENV !== 'production') {
      withTheme.displayName = "WithTheme(" + getDisplayName(Component) + ")";
    }

    hoist(withTheme, Component);
    return withTheme;
  };
}

function createUseTheme(context) {
  var useTheme = function useTheme() {
    var theme = React__default.useContext(context);
    process.env.NODE_ENV !== "production" ? warning(isObject(theme), '[theming] Please use useTheme only with the ThemeProvider') : void 0;
    return theme;
  };

  return useTheme;
}

function createTheming(context) {
  return {
    context: context,
    withTheme: createWithTheme(context),
    useTheme: createUseTheme(context),
    ThemeProvider: createThemeProvider(context)
  };
}

var ThemeContext = React.createContext();

var _createTheming = createTheming(ThemeContext),
    withTheme = _createTheming.withTheme,
    ThemeProvider = _createTheming.ThemeProvider,
    useTheme = _createTheming.useTheme;

exports.useTheme = useTheme;
exports.ThemeContext = ThemeContext;
exports.withTheme = withTheme;
exports.createTheming = createTheming;
exports.ThemeProvider = ThemeProvider;
