/* leaflet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from leaflet.vala, do not modify */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <adwaita.h>
#include <stdlib.h>
#include <string.h>
#include <graphene-gobject.h>
#include <gdk/gdk.h>
#include <gsk/gsk.h>
#include <gio/gio.h>

#define G4_CONTENT_WIDTH_MIN 340
#define G4_CONTENT_WIDTH_MAX 480
#define G4_LEAFLET_MODE_SIDEBAR 1
#define G4_LEAFLET_MODE_CONTENT 2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_SIZE_WATCHER (g4_size_watcher_get_type ())
#define G4_SIZE_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_SIZE_WATCHER, G4SizeWatcher))
#define G4_IS_SIZE_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_SIZE_WATCHER))
#define G4_SIZE_WATCHER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), G4_TYPE_SIZE_WATCHER, G4SizeWatcherIface))

typedef struct _G4SizeWatcher G4SizeWatcher;
typedef struct _G4SizeWatcherIface G4SizeWatcherIface;

#define G4_TYPE_LEAFLET (g4_leaflet_get_type ())
#define G4_LEAFLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_LEAFLET, G4Leaflet))
#define G4_LEAFLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_LEAFLET, G4LeafletClass))
#define G4_IS_LEAFLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_LEAFLET))
#define G4_IS_LEAFLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_LEAFLET))
#define G4_LEAFLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_LEAFLET, G4LeafletClass))

typedef struct _G4Leaflet G4Leaflet;
typedef struct _G4LeafletClass G4LeafletClass;
typedef struct _G4LeafletPrivate G4LeafletPrivate;

#define G4_TYPE_STACK (g4_stack_get_type ())
#define G4_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_STACK, G4Stack))
#define G4_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_STACK, G4StackClass))
#define G4_IS_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_STACK))
#define G4_IS_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_STACK))
#define G4_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_STACK, G4StackClass))

typedef struct _G4Stack G4Stack;
typedef struct _G4StackClass G4StackClass;
enum  {
	G4_LEAFLET_0_PROPERTY,
	G4_LEAFLET_FOLDED_PROPERTY,
	G4_LEAFLET_CONTENT_PROPERTY,
	G4_LEAFLET_SIDEBAR_PROPERTY,
	G4_LEAFLET_VISIBLE_MODE_PROPERTY,
	G4_LEAFLET_NUM_PROPERTIES
};
static GParamSpec* g4_leaflet_properties[G4_LEAFLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*G4VoidFunc) (gpointer user_data);
typedef struct _G4StackPrivate G4StackPrivate;
enum  {
	G4_STACK_0_PROPERTY,
	G4_STACK_ANIMATE_TRANSITIONS_PROPERTY,
	G4_STACK_PARENT_PROPERTY,
	G4_STACK_VISIBLE_CHILD_PROPERTY,
	G4_STACK_WIDGET_PROPERTY,
	G4_STACK_NUM_PROPERTIES
};
static GParamSpec* g4_stack_properties[G4_STACK_NUM_PROPERTIES];

struct _G4SizeWatcherIface {
	GTypeInterface parent_iface;
	void (*first_allocated) (G4SizeWatcher* self);
	void (*size_to_change) (G4SizeWatcher* self, gint width, gint height);
};

struct _G4Leaflet {
	GtkWidget parent_instance;
	G4LeafletPrivate * priv;
};

struct _G4LeafletClass {
	GtkWidgetClass parent_class;
};

struct _G4LeafletPrivate {
	GtkWidget* _content_box;
	GtkWidget* _sidebar_box;
	GtkWidget* _content;
	GtkWidget* _sidebar;
	G4Stack* _widget;
	gboolean _folded;
	gfloat _content_fraction;
	gint _content_min_width;
	gint _content_max_width;
	gint _view_width;
	gint _view_height;
	gint _visible_mode;
};

struct _G4Stack {
	GObject parent_instance;
	G4StackPrivate * priv;
};

struct _G4StackClass {
	GObjectClass parent_class;
};

struct _G4StackPrivate {
	gboolean _retain_last_popped;
	AdwNavigationPage* _last_page;
	AdwNavigationView* _widget;
};

static gint G4Leaflet_private_offset;
static gpointer g4_leaflet_parent_class = NULL;
static gint G4Stack_private_offset;
static gpointer g4_stack_parent_class = NULL;

VALA_EXTERN GType g4_size_watcher_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void g4_size_watcher_first_allocated (G4SizeWatcher* self);
VALA_EXTERN void g4_size_watcher_size_to_change (G4SizeWatcher* self,
                                     gint width,
                                     gint height);
static GType g4_size_watcher_get_type_once (void);
VALA_EXTERN GType g4_leaflet_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Leaflet, g_object_unref)
VALA_EXTERN GType g4_stack_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Stack, g_object_unref)
VALA_EXTERN GtkWidget* g4_stack_get_widget (G4Stack* self);
VALA_EXTERN G4Stack* g4_stack_new (gboolean retain_last_popped);
VALA_EXTERN G4Stack* g4_stack_construct (GType object_type,
                             gboolean retain_last_popped);
VALA_EXTERN G4Leaflet* g4_leaflet_new (void);
VALA_EXTERN G4Leaflet* g4_leaflet_construct (GType object_type);
VALA_EXTERN GtkWidget* g4_stack_add (G4Stack* self,
                         GtkWidget* child,
                         const gchar* tag);
static void __lambda52_ (G4Leaflet* self);
VALA_EXTERN GtkWidget* g4_stack_get_visible_child (G4Stack* self);
static void ___lambda52__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void g4_leaflet_pop (G4Leaflet* self);
VALA_EXTERN void g4_leaflet_set_visible_mode (G4Leaflet* self,
                                  gint value);
VALA_EXTERN void g4_leaflet_push (G4Leaflet* self);
static void g4_leaflet_real_measure (GtkWidget* base,
                              GtkOrientation orientation,
                              gint for_size,
                              gint* minimum,
                              gint* natural,
                              gint* minimum_baseline,
                              gint* natural_baseline);
static void g4_leaflet_real_size_allocate (GtkWidget* base,
                                    gint width,
                                    gint height,
                                    gint baseline);
VALA_EXTERN guint g4_run_idle_once (G4VoidFunc func,
                        gpointer func_target,
                        GDestroyNotify func_target_destroy_notify,
                        gint priority);
static void ___lambda53_ (G4Leaflet* self);
static void ____lambda53__g4_void_func (gpointer self);
VALA_EXTERN void g4_stack_set_child (G4Stack* self,
                         GtkWidget* page,
                         GtkWidget* child);
VALA_EXTERN gboolean g4_stack_get_animate_transitions (G4Stack* self);
VALA_EXTERN void g4_stack_set_animate_transitions (G4Stack* self,
                                       gboolean value);
static void g4_leaflet_update_visible_child (G4Leaflet* self);
static void g4_leaflet_real_snapshot (GtkWidget* base,
                               GtkSnapshot* snapshot);
VALA_EXTERN void g4_stack_set_visible_child (G4Stack* self,
                                 GtkWidget* value);
VALA_EXTERN gboolean g4_leaflet_get_folded (G4Leaflet* self);
VALA_EXTERN GtkWidget* g4_leaflet_get_content (G4Leaflet* self);
VALA_EXTERN void g4_leaflet_set_content (G4Leaflet* self,
                             GtkWidget* value);
VALA_EXTERN GtkWidget* g4_leaflet_get_sidebar (G4Leaflet* self);
VALA_EXTERN void g4_leaflet_set_sidebar (G4Leaflet* self,
                             GtkWidget* value);
VALA_EXTERN gint g4_leaflet_get_visible_mode (G4Leaflet* self);
static void g4_leaflet_finalize (GObject * obj);
static GType g4_leaflet_get_type_once (void);
static void _vala_g4_leaflet_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_g4_leaflet_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static AdwNavigationPage* __lambda49_ (G4Stack* self);
static AdwNavigationPage* ___lambda49__adw_navigation_view_get_next_page (AdwNavigationView* _sender,
                                                                   gpointer self);
static void __lambda50_ (G4Stack* self);
static void ___lambda50__adw_navigation_view_pushed (AdwNavigationView* _sender,
                                              gpointer self);
static void __lambda51_ (G4Stack* self,
                  AdwNavigationPage* page);
static void ___lambda51__adw_navigation_view_popped (AdwNavigationView* _sender,
                                              AdwNavigationPage* page,
                                              gpointer self);
VALA_EXTERN void g4_stack_pop (G4Stack* self);
VALA_EXTERN GtkWidget* g4_stack_get_child_by_name (G4Stack* self,
                                       const gchar* name);
VALA_EXTERN GPtrArray* g4_stack_get_children (G4Stack* self);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void g4_stack_get_visible_names (G4Stack* self,
                                 GPtrArray* names);
static AdwNavigationPage* g4_stack_find_page (G4Stack* self,
                                       GtkWidget* child);
VALA_EXTERN GtkWidget* g4_stack_get_parent (G4Stack* self);
static void g4_stack_finalize (GObject * obj);
static GType g4_stack_get_type_once (void);
static void _vala_g4_stack_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_g4_stack_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
g4_size_watcher_first_allocated (G4SizeWatcher* self)
{
	G4SizeWatcherIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = G4_SIZE_WATCHER_GET_INTERFACE (self);
	if (_iface_->first_allocated) {
		_iface_->first_allocated (self);
	}
}

void
g4_size_watcher_size_to_change (G4SizeWatcher* self,
                                gint width,
                                gint height)
{
	G4SizeWatcherIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = G4_SIZE_WATCHER_GET_INTERFACE (self);
	if (_iface_->size_to_change) {
		_iface_->size_to_change (self, width, height);
	}
}

static void
g4_size_watcher_default_init (G4SizeWatcherIface * iface,
                              gpointer iface_data)
{
}

static GType
g4_size_watcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4SizeWatcherIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_size_watcher_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType g4_size_watcher_type_id;
	g4_size_watcher_type_id = g_type_register_static (G_TYPE_INTERFACE, "G4SizeWatcher", &g_define_type_info, 0);
	return g4_size_watcher_type_id;
}

GType
g4_size_watcher_get_type (void)
{
	static volatile gsize g4_size_watcher_type_id__once = 0;
	if (g_once_init_enter (&g4_size_watcher_type_id__once)) {
		GType g4_size_watcher_type_id;
		g4_size_watcher_type_id = g4_size_watcher_get_type_once ();
		g_once_init_leave (&g4_size_watcher_type_id__once, g4_size_watcher_type_id);
	}
	return g4_size_watcher_type_id__once;
}

static inline gpointer
g4_leaflet_get_instance_private (G4Leaflet* self)
{
	return G_STRUCT_MEMBER_P (self, G4Leaflet_private_offset);
}

static void
__lambda52_ (G4Leaflet* self)
{
	gint _tmp0_ = 0;
	G4Stack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	gint mode = 0;
	gboolean _tmp5_ = FALSE;
	_tmp1_ = self->priv->_widget;
	_tmp2_ = g4_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_sidebar;
	if (_tmp3_ == _tmp4_) {
		_tmp0_ = G4_LEAFLET_MODE_SIDEBAR;
	} else {
		_tmp0_ = G4_LEAFLET_MODE_CONTENT;
	}
	mode = _tmp0_;
	if (self->priv->_folded) {
		_tmp5_ = self->priv->_visible_mode != mode;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		self->priv->_visible_mode = mode;
		g_object_notify ((GObject*) self, "visible-mode");
	}
}

static void
___lambda52__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda52_ ((G4Leaflet*) self);
}

G4Leaflet*
g4_leaflet_construct (GType object_type)
{
	G4Leaflet * self = NULL;
	G4Stack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	G4Stack* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	G4Stack* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	G4Stack* _tmp9_;
	self = (G4Leaflet*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = self->priv->_sidebar;
	_tmp2_ = g4_stack_add (_tmp0_, _tmp1_, "sidebar");
	_g_object_unref0 (self->priv->_sidebar_box);
	self->priv->_sidebar_box = _tmp2_;
	_tmp3_ = self->priv->_widget;
	_tmp4_ = self->priv->_content;
	_tmp5_ = g4_stack_add (_tmp3_, _tmp4_, "content");
	_g_object_unref0 (self->priv->_content_box);
	self->priv->_content_box = _tmp5_;
	_tmp6_ = self->priv->_widget;
	_tmp7_ = g4_stack_get_widget (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_widget_set_parent (_tmp8_, (GtkWidget*) self);
	_tmp9_ = self->priv->_widget;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::visible-child", (GCallback) ___lambda52__g_object_notify, self, 0);
	return self;
}

G4Leaflet*
g4_leaflet_new (void)
{
	return g4_leaflet_construct (G4_TYPE_LEAFLET);
}

void
g4_leaflet_pop (G4Leaflet* self)
{
	g_return_if_fail (self != NULL);
	g4_leaflet_set_visible_mode (self, G4_LEAFLET_MODE_SIDEBAR);
}

void
g4_leaflet_push (G4Leaflet* self)
{
	g_return_if_fail (self != NULL);
	g4_leaflet_set_visible_mode (self, G4_LEAFLET_MODE_CONTENT);
}

static void
g4_leaflet_real_measure (GtkWidget* base,
                         GtkOrientation orientation,
                         gint for_size,
                         gint* minimum,
                         gint* natural,
                         gint* minimum_baseline,
                         gint* natural_baseline)
{
	G4Leaflet * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	gint minimum1 = 0;
	gint minimum2 = 0;
	gint natural1 = 0;
	gint natural2 = 0;
	GtkWidget* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkWidget* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	self = (G4Leaflet*) base;
	minimum1 = 0;
	minimum2 = 0;
	natural1 = 0;
	natural2 = 0;
	_tmp0_ = self->priv->_content;
	gtk_widget_measure (_tmp0_, orientation, for_size, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	minimum1 = _tmp1_;
	natural1 = _tmp2_;
	_vala_minimum_baseline = _tmp3_;
	_vala_natural_baseline = _tmp4_;
	_tmp5_ = self->priv->_sidebar;
	gtk_widget_measure (_tmp5_, orientation, for_size, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	minimum2 = _tmp6_;
	natural2 = _tmp7_;
	_vala_minimum_baseline = _tmp8_;
	_vala_natural_baseline = _tmp9_;
	if (orientation == GTK_ORIENTATION_HORIZONTAL) {
		_vala_minimum = MAX (MIN (minimum1, minimum2), self->priv->_content_min_width);
	} else {
		_vala_minimum = MAX (minimum1, minimum2);
	}
	_vala_natural = MAX (natural1, natural2);
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static void
___lambda53_ (G4Leaflet* self)
{
	G4SizeWatcher* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	G4SizeWatcher* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	_tmp1_ = self->priv->_content;
	_tmp0_ = G4_IS_SIZE_WATCHER (_tmp1_) ? ((G4SizeWatcher*) _tmp1_) : NULL;
	if (_tmp0_ != NULL) {
		g4_size_watcher_first_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G4_TYPE_SIZE_WATCHER, G4SizeWatcher));
	}
	_tmp3_ = self->priv->_sidebar;
	_tmp2_ = G4_IS_SIZE_WATCHER (_tmp3_) ? ((G4SizeWatcher*) _tmp3_) : NULL;
	if (_tmp2_ != NULL) {
		g4_size_watcher_first_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G4_TYPE_SIZE_WATCHER, G4SizeWatcher));
	}
}

static void
____lambda53__g4_void_func (gpointer self)
{
	___lambda53_ ((G4Leaflet*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
g4_leaflet_real_size_allocate (GtkWidget* base,
                               gint width,
                               gint height,
                               gint baseline)
{
	G4Leaflet * self;
	gboolean _tmp0_ = FALSE;
	gboolean first = FALSE;
	GtkWidget* stack = NULL;
	G4Stack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	gboolean folded = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkAllocation allocation = {0};
	self = (G4Leaflet*) base;
	if (self->priv->_view_width == 0) {
		_tmp0_ = width > 0;
	} else {
		_tmp0_ = FALSE;
	}
	first = _tmp0_;
	if (first) {
		g4_run_idle_once (____lambda53__g4_void_func, g_object_ref (self), g_object_unref, G_PRIORITY_DEFAULT_IDLE);
	}
	self->priv->_view_width = width;
	self->priv->_view_height = height;
	_tmp1_ = self->priv->_widget;
	_tmp2_ = g4_stack_get_widget (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	stack = _tmp4_;
	folded = width < (self->priv->_content_min_width * 2);
	if (self->priv->_folded != folded) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = first;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		gboolean animate = FALSE;
		G4Stack* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		G4Stack* _tmp25_;
		G4Stack* _tmp26_;
		self->priv->_folded = folded;
		if (folded) {
			GtkWidget* _tmp7_;
			GtkWidget* _tmp8_;
			_tmp7_ = self->priv->_content;
			_tmp8_ = self->priv->_content_box;
			_tmp6_ = !gtk_widget_is_ancestor (_tmp7_, _tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkWidget* _tmp9_;
			G4Stack* _tmp10_;
			GtkWidget* _tmp11_;
			GtkWidget* _tmp12_;
			_tmp9_ = self->priv->_content;
			gtk_widget_unparent (_tmp9_);
			_tmp10_ = self->priv->_widget;
			_tmp11_ = self->priv->_content_box;
			_tmp12_ = self->priv->_content;
			g4_stack_set_child (_tmp10_, _tmp11_, _tmp12_);
		} else {
			gboolean _tmp13_ = FALSE;
			if (!folded) {
				GtkWidget* _tmp14_;
				GtkWidget* _tmp15_;
				_tmp14_ = self->priv->_content;
				_tmp15_ = self->priv->_content_box;
				_tmp13_ = gtk_widget_is_ancestor (_tmp14_, _tmp15_);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				G4Stack* _tmp16_;
				GtkWidget* _tmp17_;
				GtkWidget* _tmp18_;
				G4Stack* _tmp19_;
				GtkWidget* _tmp20_;
				GtkWidget* _tmp21_;
				_tmp16_ = self->priv->_widget;
				_tmp17_ = self->priv->_content_box;
				g4_stack_set_child (_tmp16_, _tmp17_, NULL);
				_tmp18_ = self->priv->_content;
				_tmp19_ = self->priv->_widget;
				_tmp20_ = g4_stack_get_widget (_tmp19_);
				_tmp21_ = _tmp20_;
				gtk_widget_insert_after (_tmp18_, (GtkWidget*) self, _tmp21_);
			}
		}
		_tmp22_ = self->priv->_widget;
		_tmp23_ = g4_stack_get_animate_transitions (_tmp22_);
		_tmp24_ = _tmp23_;
		animate = _tmp24_;
		_tmp25_ = self->priv->_widget;
		g4_stack_set_animate_transitions (_tmp25_, FALSE);
		g4_leaflet_update_visible_child (self);
		_tmp26_ = self->priv->_widget;
		g4_stack_set_animate_transitions (_tmp26_, animate);
		g_object_notify ((GObject*) self, "folded");
	}
	memset (&allocation, 0, sizeof (GtkAllocation));
	allocation.x = 0;
	allocation.y = 0;
	allocation.width = width;
	allocation.height = height;
	if (folded) {
		G4SizeWatcher* _tmp27_ = NULL;
		GtkWidget* _tmp28_;
		G4SizeWatcher* _tmp29_ = NULL;
		GtkWidget* _tmp30_;
		GtkWidget* _tmp31_;
		GtkAllocation _tmp32_;
		GtkWidget* _tmp33_;
		GtkAllocation _tmp34_;
		GtkWidget* _tmp35_;
		GtkAllocation _tmp36_;
		_tmp28_ = self->priv->_content;
		_tmp27_ = G4_IS_SIZE_WATCHER (_tmp28_) ? ((G4SizeWatcher*) _tmp28_) : NULL;
		if (_tmp27_ != NULL) {
			g4_size_watcher_size_to_change (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, G4_TYPE_SIZE_WATCHER, G4SizeWatcher), width, height);
		}
		_tmp30_ = self->priv->_sidebar;
		_tmp29_ = G4_IS_SIZE_WATCHER (_tmp30_) ? ((G4SizeWatcher*) _tmp30_) : NULL;
		if (_tmp29_ != NULL) {
			g4_size_watcher_size_to_change (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, G4_TYPE_SIZE_WATCHER, G4SizeWatcher), width, height);
		}
		_tmp31_ = self->priv->_content;
		_tmp32_ = allocation;
		gtk_widget_size_allocate (_tmp31_, &_tmp32_, baseline);
		_tmp33_ = self->priv->_sidebar;
		_tmp34_ = allocation;
		gtk_widget_size_allocate (_tmp33_, &_tmp34_, baseline);
		_tmp35_ = stack;
		_tmp36_ = allocation;
		gtk_widget_size_allocate (_tmp35_, &_tmp36_, baseline);
	} else {
		gboolean rtl = FALSE;
		gint content_width = 0;
		gint side_width = 0;
		gint _tmp37_ = 0;
		G4SizeWatcher* _tmp38_ = NULL;
		GtkWidget* _tmp39_;
		GtkWidget* _tmp40_;
		GtkAllocation _tmp41_;
		GtkWidget* _tmp42_;
		GtkAllocation _tmp43_;
		gint _tmp44_ = 0;
		G4SizeWatcher* _tmp45_ = NULL;
		GtkWidget* _tmp46_;
		GtkWidget* _tmp47_;
		GtkAllocation _tmp48_;
		rtl = gtk_widget_get_direction ((GtkWidget*) self) == GTK_TEXT_DIR_RTL;
		content_width = (gint) CLAMP (width * self->priv->_content_fraction, (gfloat) self->priv->_content_min_width, (gfloat) self->priv->_content_max_width);
		side_width = width - content_width;
		if (rtl) {
			_tmp37_ = content_width;
		} else {
			_tmp37_ = 0;
		}
		allocation.x = _tmp37_;
		allocation.width = side_width;
		_tmp39_ = self->priv->_sidebar;
		_tmp38_ = G4_IS_SIZE_WATCHER (_tmp39_) ? ((G4SizeWatcher*) _tmp39_) : NULL;
		if (_tmp38_ != NULL) {
			g4_size_watcher_size_to_change (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, G4_TYPE_SIZE_WATCHER, G4SizeWatcher), side_width, height);
		}
		_tmp40_ = self->priv->_sidebar;
		_tmp41_ = allocation;
		gtk_widget_size_allocate (_tmp40_, &_tmp41_, baseline);
		_tmp42_ = stack;
		_tmp43_ = allocation;
		gtk_widget_size_allocate (_tmp42_, &_tmp43_, baseline);
		if (rtl) {
			_tmp44_ = 0;
		} else {
			_tmp44_ = side_width;
		}
		allocation.x = _tmp44_;
		allocation.width = content_width;
		_tmp46_ = self->priv->_content;
		_tmp45_ = G4_IS_SIZE_WATCHER (_tmp46_) ? ((G4SizeWatcher*) _tmp46_) : NULL;
		if (_tmp45_ != NULL) {
			g4_size_watcher_size_to_change (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, G4_TYPE_SIZE_WATCHER, G4SizeWatcher), content_width, height);
		}
		_tmp47_ = self->priv->_content;
		_tmp48_ = allocation;
		gtk_widget_size_allocate (_tmp47_, &_tmp48_, baseline);
	}
	_g_object_unref0 (stack);
}

static void
g4_leaflet_real_snapshot (GtkWidget* base,
                          GtkSnapshot* snapshot)
{
	G4Leaflet * self;
	self = (G4Leaflet*) base;
	g_return_if_fail (snapshot != NULL);
	if (!self->priv->_folded) {
		gint size = 0;
		GtkWidget* _tmp0_;
		gboolean rtl = FALSE;
		graphene_rect_t rect = {0};
		gint _tmp1_ = 0;
		GdkRGBA color = {0};
		GdkRGBA color2 = {0};
		GdkRGBA _tmp2_ = {0};
		GskColorStop* stops = NULL;
		GdkRGBA _tmp3_;
		GskColorStop _tmp4_ = {0};
		GdkRGBA _tmp5_;
		GskColorStop _tmp6_ = {0};
		GdkRGBA _tmp7_;
		GskColorStop _tmp8_ = {0};
		GskColorStop* _tmp9_;
		gint stops_length1;
		gint _stops_size_;
		graphene_rect_t _tmp10_;
		graphene_point_t _tmp11_ = {0};
		graphene_point_t _tmp12_ = {0};
		GskColorStop* _tmp13_;
		gint _tmp13__length1;
		_tmp0_ = self->priv->_sidebar;
		size = gtk_widget_get_width (_tmp0_);
		rtl = gtk_widget_get_direction ((GtkWidget*) self) == GTK_TEXT_DIR_RTL;
		memset (&rect, 0, sizeof (graphene_rect_t));
		if (rtl) {
			_tmp1_ = self->priv->_view_width - size;
		} else {
			_tmp1_ = size;
		}
		graphene_rect_init (&rect, (gfloat) _tmp1_, (gfloat) 0, 0.5f, (gfloat) self->priv->_view_height);
		memset (&color, 0, sizeof (GdkRGBA));
		color.alpha = (gfloat) 0;
		color.blue = color.alpha;
		color.green = color.blue;
		color.red = color.green;
		gtk_widget_get_color ((GtkWidget*) self, &_tmp2_);
		color2 = _tmp2_;
		color2.alpha = 0.25f;
		_tmp3_ = color;
		memset (&_tmp4_, 0, sizeof (GskColorStop));
		_tmp4_.offset = (gfloat) 0;
		_tmp4_.color = _tmp3_;
		_tmp5_ = color2;
		memset (&_tmp6_, 0, sizeof (GskColorStop));
		_tmp6_.offset = 0.5f;
		_tmp6_.color = _tmp5_;
		_tmp7_ = color;
		memset (&_tmp8_, 0, sizeof (GskColorStop));
		_tmp8_.offset = (gfloat) 1;
		_tmp8_.color = _tmp7_;
		_tmp9_ = g_new0 (GskColorStop, 3);
		_tmp9_[0] = _tmp4_;
		_tmp9_[1] = _tmp6_;
		_tmp9_[2] = _tmp8_;
		stops = _tmp9_;
		stops_length1 = 3;
		_stops_size_ = stops_length1;
		_tmp10_ = rect;
		graphene_rect_get_top_left (&rect, &_tmp11_);
		graphene_rect_get_bottom_right (&rect, &_tmp12_);
		_tmp13_ = stops;
		_tmp13__length1 = stops_length1;
		gtk_snapshot_append_linear_gradient (snapshot, &_tmp10_, &_tmp11_, &_tmp12_, _tmp13_, (gsize) _tmp13__length1);
		stops = (g_free (stops), NULL);
	}
	GTK_WIDGET_CLASS (g4_leaflet_parent_class)->snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), snapshot);
}

static void
g4_leaflet_update_visible_child (G4Leaflet* self)
{
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	G4Stack* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->_folded) {
		_tmp1_ = self->priv->_visible_mode == G4_LEAFLET_MODE_CONTENT;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkWidget* _tmp2_;
		_tmp2_ = self->priv->_content;
		_tmp0_ = _tmp2_;
	} else {
		GtkWidget* _tmp3_;
		_tmp3_ = self->priv->_sidebar;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = self->priv->_widget;
	g4_stack_set_visible_child (_tmp4_, _tmp0_);
}

gboolean
g4_leaflet_get_folded (G4Leaflet* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_folded;
	return result;
}

GtkWidget*
g4_leaflet_get_content (G4Leaflet* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}

void
g4_leaflet_set_content (G4Leaflet* self,
                        GtkWidget* value)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_content);
	self->priv->_content = _tmp0_;
	if (self->priv->_folded) {
		G4Stack* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp1_ = self->priv->_widget;
		_tmp2_ = self->priv->_content_box;
		g4_stack_set_child (_tmp1_, _tmp2_, value);
	} else {
		G4Stack* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp3_ = self->priv->_widget;
		_tmp4_ = self->priv->_content_box;
		g4_stack_set_child (_tmp3_, _tmp4_, NULL);
		_tmp5_ = self->priv->_content;
		gtk_widget_set_parent (_tmp5_, (GtkWidget*) self);
	}
	gtk_widget_queue_allocate ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, g4_leaflet_properties[G4_LEAFLET_CONTENT_PROPERTY]);
}

GtkWidget*
g4_leaflet_get_sidebar (G4Leaflet* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sidebar;
	result = _tmp0_;
	return result;
}

void
g4_leaflet_set_sidebar (G4Leaflet* self,
                        GtkWidget* value)
{
	GtkWidget* _tmp0_;
	G4Stack* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_sidebar);
	self->priv->_sidebar = _tmp0_;
	_tmp1_ = self->priv->_widget;
	_tmp2_ = self->priv->_sidebar_box;
	g4_stack_set_child (_tmp1_, _tmp2_, value);
	gtk_widget_queue_allocate ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, g4_leaflet_properties[G4_LEAFLET_SIDEBAR_PROPERTY]);
}

gint
g4_leaflet_get_visible_mode (G4Leaflet* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_visible_mode;
	return result;
}

void
g4_leaflet_set_visible_mode (G4Leaflet* self,
                             gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_visible_mode = value;
	g4_leaflet_update_visible_child (self);
	g_object_notify_by_pspec ((GObject *) self, g4_leaflet_properties[G4_LEAFLET_VISIBLE_MODE_PROPERTY]);
}

static void
g4_leaflet_class_init (G4LeafletClass * klass,
                       gpointer klass_data)
{
	g4_leaflet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4Leaflet_private_offset);
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) g4_leaflet_real_measure;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) g4_leaflet_real_size_allocate;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) g4_leaflet_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_leaflet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_g4_leaflet_set_property;
	G_OBJECT_CLASS (klass)->finalize = g4_leaflet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_LEAFLET_FOLDED_PROPERTY, g4_leaflet_properties[G4_LEAFLET_FOLDED_PROPERTY] = g_param_spec_boolean ("folded", "folded", "folded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_LEAFLET_CONTENT_PROPERTY, g4_leaflet_properties[G4_LEAFLET_CONTENT_PROPERTY] = g_param_spec_object ("content", "content", "content", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_LEAFLET_SIDEBAR_PROPERTY, g4_leaflet_properties[G4_LEAFLET_SIDEBAR_PROPERTY] = g_param_spec_object ("sidebar", "sidebar", "sidebar", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_LEAFLET_VISIBLE_MODE_PROPERTY, g4_leaflet_properties[G4_LEAFLET_VISIBLE_MODE_PROPERTY] = g_param_spec_int ("visible-mode", "visible-mode", "visible-mode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
g4_leaflet_instance_init (G4Leaflet * self,
                          gpointer klass)
{
	AdwBin* _tmp0_;
	AdwBin* _tmp1_;
	G4Stack* _tmp2_;
	self->priv = g4_leaflet_get_instance_private (self);
	_tmp0_ = (AdwBin*) adw_bin_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->_content = (GtkWidget*) _tmp0_;
	_tmp1_ = (AdwBin*) adw_bin_new ();
	g_object_ref_sink (_tmp1_);
	self->priv->_sidebar = (GtkWidget*) _tmp1_;
	_tmp2_ = g4_stack_new (TRUE);
	self->priv->_widget = _tmp2_;
	self->priv->_folded = FALSE;
	self->priv->_content_fraction = 3 / 8.f;
	self->priv->_content_min_width = G4_CONTENT_WIDTH_MIN;
	self->priv->_content_max_width = G4_CONTENT_WIDTH_MAX;
	self->priv->_view_width = 0;
	self->priv->_view_height = 0;
	self->priv->_visible_mode = G4_LEAFLET_MODE_SIDEBAR;
}

static void
g4_leaflet_finalize (GObject * obj)
{
	G4Leaflet * self;
	GtkWidget* _tmp0_;
	G4Stack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_LEAFLET, G4Leaflet);
	_tmp0_ = self->priv->_content;
	gtk_widget_unparent (_tmp0_);
	_tmp1_ = self->priv->_widget;
	_tmp2_ = g4_stack_get_widget (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_unparent (_tmp3_);
	_g_object_unref0 (self->priv->_content_box);
	_g_object_unref0 (self->priv->_sidebar_box);
	_g_object_unref0 (self->priv->_content);
	_g_object_unref0 (self->priv->_sidebar);
	_g_object_unref0 (self->priv->_widget);
	G_OBJECT_CLASS (g4_leaflet_parent_class)->finalize (obj);
}

static GType
g4_leaflet_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4LeafletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_leaflet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4Leaflet), 0, (GInstanceInitFunc) g4_leaflet_instance_init, NULL };
	GType g4_leaflet_type_id;
	g4_leaflet_type_id = g_type_register_static (gtk_widget_get_type (), "G4Leaflet", &g_define_type_info, 0);
	G4Leaflet_private_offset = g_type_add_instance_private (g4_leaflet_type_id, sizeof (G4LeafletPrivate));
	return g4_leaflet_type_id;
}

GType
g4_leaflet_get_type (void)
{
	static volatile gsize g4_leaflet_type_id__once = 0;
	if (g_once_init_enter (&g4_leaflet_type_id__once)) {
		GType g4_leaflet_type_id;
		g4_leaflet_type_id = g4_leaflet_get_type_once ();
		g_once_init_leave (&g4_leaflet_type_id__once, g4_leaflet_type_id);
	}
	return g4_leaflet_type_id__once;
}

static void
_vala_g4_leaflet_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	G4Leaflet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_LEAFLET, G4Leaflet);
	switch (property_id) {
		case G4_LEAFLET_FOLDED_PROPERTY:
		g_value_set_boolean (value, g4_leaflet_get_folded (self));
		break;
		case G4_LEAFLET_CONTENT_PROPERTY:
		g_value_set_object (value, g4_leaflet_get_content (self));
		break;
		case G4_LEAFLET_SIDEBAR_PROPERTY:
		g_value_set_object (value, g4_leaflet_get_sidebar (self));
		break;
		case G4_LEAFLET_VISIBLE_MODE_PROPERTY:
		g_value_set_int (value, g4_leaflet_get_visible_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_g4_leaflet_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	G4Leaflet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_LEAFLET, G4Leaflet);
	switch (property_id) {
		case G4_LEAFLET_CONTENT_PROPERTY:
		g4_leaflet_set_content (self, g_value_get_object (value));
		break;
		case G4_LEAFLET_SIDEBAR_PROPERTY:
		g4_leaflet_set_sidebar (self, g_value_get_object (value));
		break;
		case G4_LEAFLET_VISIBLE_MODE_PROPERTY:
		g4_leaflet_set_visible_mode (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
g4_stack_get_instance_private (G4Stack* self)
{
	return G_STRUCT_MEMBER_P (self, G4Stack_private_offset);
}

static AdwNavigationPage*
__lambda49_ (G4Stack* self)
{
	AdwNavigationPage* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	AdwNavigationView* _tmp2_;
	AdwNavigationPage* _tmp3_;
	AdwNavigationPage* _tmp4_;
	AdwNavigationPage* _tmp5_;
	AdwNavigationPage* _tmp11_;
	AdwNavigationPage* result;
	_tmp2_ = self->priv->_widget;
	_tmp3_ = adw_navigation_view_get_visible_page (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_last_page;
	if (_tmp4_ != _tmp5_) {
		AdwNavigationPage* _tmp6_ = NULL;
		AdwNavigationPage* _tmp7_;
		GtkWidget* _tmp8_ = NULL;
		_tmp7_ = self->priv->_last_page;
		_tmp6_ = _tmp7_;
		_tmp8_ = NULL;
		if (_tmp6_ != NULL) {
			GtkWidget* _tmp9_;
			_tmp9_ = adw_navigation_page_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, adw_navigation_page_get_type (), AdwNavigationPage));
			_tmp8_ = _tmp9_;
		}
		_tmp1_ = _tmp8_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		AdwNavigationPage* _tmp10_;
		_tmp10_ = self->priv->_last_page;
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp11_ = _g_object_ref0 (_tmp0_);
	result = _tmp11_;
	return result;
}

static AdwNavigationPage*
___lambda49__adw_navigation_view_get_next_page (AdwNavigationView* _sender,
                                                gpointer self)
{
	AdwNavigationPage* result;
	result = __lambda49_ ((G4Stack*) self);
	return result;
}

static void
__lambda50_ (G4Stack* self)
{
	g_object_notify ((GObject*) self, "visible-child");
}

static void
___lambda50__adw_navigation_view_pushed (AdwNavigationView* _sender,
                                         gpointer self)
{
	__lambda50_ ((G4Stack*) self);
}

static void
__lambda51_ (G4Stack* self,
             AdwNavigationPage* page)
{
	g_return_if_fail (page != NULL);
	g_object_notify ((GObject*) self, "visible-child");
	if (self->priv->_retain_last_popped) {
		AdwNavigationPage* _tmp0_;
		_tmp0_ = _g_object_ref0 (page);
		_g_object_unref0 (self->priv->_last_page);
		self->priv->_last_page = _tmp0_;
	}
}

static void
___lambda51__adw_navigation_view_popped (AdwNavigationView* _sender,
                                         AdwNavigationPage* page,
                                         gpointer self)
{
	__lambda51_ ((G4Stack*) self, page);
}

G4Stack*
g4_stack_construct (GType object_type,
                    gboolean retain_last_popped)
{
	G4Stack * self = NULL;
	AdwNavigationView* _tmp0_;
	AdwNavigationView* _tmp1_;
	AdwNavigationView* _tmp2_;
	AdwNavigationView* _tmp3_;
	self = (G4Stack*) g_object_new (object_type, NULL);
	self->priv->_retain_last_popped = retain_last_popped;
	_tmp0_ = (AdwNavigationView*) adw_navigation_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_widget);
	self->priv->_widget = _tmp0_;
	_tmp1_ = self->priv->_widget;
	g_signal_connect_object (_tmp1_, "get-next-page", (GCallback) ___lambda49__adw_navigation_view_get_next_page, self, 0);
	_tmp2_ = self->priv->_widget;
	g_signal_connect_object (_tmp2_, "pushed", (GCallback) ___lambda50__adw_navigation_view_pushed, self, 0);
	_tmp3_ = self->priv->_widget;
	g_signal_connect_object (_tmp3_, "popped", (GCallback) ___lambda51__adw_navigation_view_popped, self, 0);
	return self;
}

G4Stack*
g4_stack_new (gboolean retain_last_popped)
{
	return g4_stack_construct (G4_TYPE_STACK, retain_last_popped);
}

GtkWidget*
g4_stack_add (G4Stack* self,
              GtkWidget* child,
              const gchar* tag)
{
	const gchar* _tmp0_ = NULL;
	AdwNavigationPage* page = NULL;
	AdwNavigationPage* _tmp1_;
	AdwNavigationPage* _tmp2_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = tag;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp1_ = adw_navigation_page_new (child, (const gchar*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	page = _tmp1_;
	_tmp2_ = page;
	adw_navigation_page_set_tag (_tmp2_, tag);
	if (self->priv->_retain_last_popped) {
		AdwNavigationPage* _tmp3_;
		AdwNavigationPage* _tmp4_;
		AdwNavigationView* _tmp5_;
		AdwNavigationPage* _tmp6_;
		_tmp3_ = page;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->_last_page);
		self->priv->_last_page = _tmp4_;
		_tmp5_ = self->priv->_widget;
		_tmp6_ = page;
		adw_navigation_view_add (_tmp5_, _tmp6_);
	} else {
		AdwNavigationView* _tmp7_;
		AdwNavigationPage* _tmp8_;
		_tmp7_ = self->priv->_widget;
		_tmp8_ = page;
		adw_navigation_view_push (_tmp7_, _tmp8_);
	}
	result = (GtkWidget*) page;
	return result;
}

void
g4_stack_pop (G4Stack* self)
{
	AdwNavigationView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_widget;
	adw_navigation_view_pop (_tmp0_);
}

GtkWidget*
g4_stack_get_child_by_name (G4Stack* self,
                            const gchar* name)
{
	AdwNavigationPage* _tmp0_ = NULL;
	AdwNavigationView* _tmp1_;
	AdwNavigationPage* _tmp2_;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = self->priv->_widget;
	_tmp2_ = adw_navigation_view_find_page (_tmp1_, name);
	_tmp0_ = _tmp2_;
	_tmp3_ = NULL;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = adw_navigation_page_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, adw_navigation_page_get_type (), AdwNavigationPage));
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

GPtrArray*
g4_stack_get_children (G4Stack* self)
{
	GListModel* pages = NULL;
	AdwNavigationView* _tmp0_;
	GListModel* _tmp1_;
	GListModel* _tmp2_;
	guint count = 0U;
	GListModel* _tmp3_;
	GPtrArray* children = NULL;
	GPtrArray* _tmp4_;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = adw_navigation_view_get_navigation_stack (_tmp0_);
	_tmp2_ = _tmp1_;
	pages = _tmp2_;
	_tmp3_ = pages;
	count = g_list_model_get_n_items (_tmp3_);
	_tmp4_ = g_ptr_array_new_full (count, _g_object_unref0_);
	children = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				AdwNavigationPage* page = NULL;
				GListModel* _tmp7_;
				GObject* _tmp8_;
				GPtrArray* _tmp9_;
				AdwNavigationPage* _tmp10_;
				GtkWidget* _tmp11_;
				GtkWidget* _tmp12_;
				GtkWidget* _tmp13_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(((guint) i) < count)) {
					break;
				}
				_tmp7_ = pages;
				_tmp8_ = g_list_model_get_item (_tmp7_, (guint) i);
				page = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, adw_navigation_page_get_type (), AdwNavigationPage);
				_tmp9_ = children;
				_tmp10_ = page;
				_tmp11_ = adw_navigation_page_get_child (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				g_ptr_array_add (_tmp9_, _tmp13_);
				_g_object_unref0 (page);
			}
		}
	}
	result = children;
	_g_object_unref0 (pages);
	return result;
}

void
g4_stack_get_visible_names (G4Stack* self,
                            GPtrArray* names)
{
	GListModel* pages = NULL;
	AdwNavigationView* _tmp0_;
	GListModel* _tmp1_;
	GListModel* _tmp2_;
	guint count = 0U;
	GListModel* _tmp3_;
	AdwNavigationPage* visible_page = NULL;
	AdwNavigationView* _tmp4_;
	AdwNavigationPage* _tmp5_;
	AdwNavigationPage* _tmp6_;
	AdwNavigationPage* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (names != NULL);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = adw_navigation_view_get_navigation_stack (_tmp0_);
	_tmp2_ = _tmp1_;
	pages = _tmp2_;
	_tmp3_ = pages;
	count = g_list_model_get_n_items (_tmp3_);
	_tmp4_ = self->priv->_widget;
	_tmp5_ = adw_navigation_view_get_visible_page (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	visible_page = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				AdwNavigationPage* page = NULL;
				GListModel* _tmp10_;
				GObject* _tmp11_;
				AdwNavigationPage* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				AdwNavigationPage* _tmp16_;
				AdwNavigationPage* _tmp17_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(((guint) i) < count)) {
					break;
				}
				_tmp10_ = pages;
				_tmp11_ = g_list_model_get_item (_tmp10_, (guint) i);
				page = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, adw_navigation_page_get_type (), AdwNavigationPage);
				_tmp12_ = page;
				_tmp13_ = adw_navigation_page_get_tag (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup (_tmp14_);
				g_ptr_array_add (names, _tmp15_);
				_tmp16_ = page;
				_tmp17_ = visible_page;
				if (_tmp16_ == _tmp17_) {
					_g_object_unref0 (page);
					break;
				}
				_g_object_unref0 (page);
			}
		}
	}
	_g_object_unref0 (visible_page);
	_g_object_unref0 (pages);
}

void
g4_stack_set_child (G4Stack* self,
                    GtkWidget* page,
                    GtkWidget* child)
{
	AdwNavigationPage* p = NULL;
	AdwNavigationPage* _tmp0_;
	AdwNavigationPage* _tmp1_ = NULL;
	AdwNavigationPage* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (page, adw_navigation_page_get_type ()) ? ((AdwNavigationPage*) page) : NULL);
	p = _tmp0_;
	_tmp2_ = p;
	_tmp1_ = _tmp2_;
	if (_tmp1_ != NULL) {
		adw_navigation_page_set_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, adw_navigation_page_get_type (), AdwNavigationPage), child);
	}
	_g_object_unref0 (p);
}

static AdwNavigationPage*
g4_stack_find_page (G4Stack* self,
                    GtkWidget* child)
{
	GListModel* pages = NULL;
	AdwNavigationView* _tmp0_;
	GListModel* _tmp1_;
	GListModel* _tmp2_;
	guint count = 0U;
	GListModel* _tmp3_;
	AdwNavigationPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = adw_navigation_view_get_navigation_stack (_tmp0_);
	_tmp2_ = _tmp1_;
	pages = _tmp2_;
	_tmp3_ = pages;
	count = g_list_model_get_n_items (_tmp3_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				AdwNavigationPage* page = NULL;
				GListModel* _tmp6_;
				GObject* _tmp7_;
				AdwNavigationPage* _tmp8_;
				GtkWidget* _tmp9_;
				GtkWidget* _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(((guint) i) < count)) {
					break;
				}
				_tmp6_ = pages;
				_tmp7_ = g_list_model_get_item (_tmp6_, (guint) i);
				page = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, adw_navigation_page_get_type (), AdwNavigationPage);
				_tmp8_ = page;
				_tmp9_ = adw_navigation_page_get_child (_tmp8_);
				_tmp10_ = _tmp9_;
				if (_tmp10_ == child) {
					result = page;
					_g_object_unref0 (pages);
					return result;
				}
				_g_object_unref0 (page);
			}
		}
	}
	result = NULL;
	_g_object_unref0 (pages);
	return result;
}

gboolean
g4_stack_get_animate_transitions (G4Stack* self)
{
	gboolean result;
	AdwNavigationView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = adw_navigation_view_get_animate_transitions (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
g4_stack_set_animate_transitions (G4Stack* self,
                                  gboolean value)
{
	AdwNavigationView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_widget;
	adw_navigation_view_set_animate_transitions (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, g4_stack_properties[G4_STACK_ANIMATE_TRANSITIONS_PROPERTY]);
}

GtkWidget*
g4_stack_get_parent (G4Stack* self)
{
	GtkWidget* result;
	AdwNavigationView* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = gtk_widget_get_parent ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GtkWidget*
g4_stack_get_visible_child (G4Stack* self)
{
	GtkWidget* result;
	AdwNavigationView* _tmp0_;
	AdwNavigationPage* _tmp1_;
	AdwNavigationPage* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = adw_navigation_view_get_visible_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = adw_navigation_page_get_child (_tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

void
g4_stack_set_visible_child (G4Stack* self,
                            GtkWidget* value)
{
	AdwNavigationView* _tmp0_;
	AdwNavigationPage* _tmp1_;
	AdwNavigationPage* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = adw_navigation_view_get_visible_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = adw_navigation_page_get_child (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != value) {
		AdwNavigationPage* _tmp5_ = NULL;
		AdwNavigationPage* _tmp6_;
		GtkWidget* _tmp7_ = NULL;
		_tmp6_ = self->priv->_last_page;
		_tmp5_ = _tmp6_;
		_tmp7_ = NULL;
		if (_tmp5_ != NULL) {
			GtkWidget* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp8_ = adw_navigation_page_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, adw_navigation_page_get_type (), AdwNavigationPage));
			_tmp9_ = _tmp8_;
			_tmp7_ = _tmp9_;
		}
		if (_tmp7_ == value) {
			AdwNavigationView* _tmp10_;
			AdwNavigationPage* _tmp11_;
			_tmp10_ = self->priv->_widget;
			_tmp11_ = self->priv->_last_page;
			adw_navigation_view_push (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, adw_navigation_page_get_type (), AdwNavigationPage));
		} else {
			AdwNavigationPage* page = NULL;
			AdwNavigationPage* _tmp12_;
			AdwNavigationPage* _tmp13_;
			_tmp12_ = g4_stack_find_page (self, value);
			page = _tmp12_;
			_tmp13_ = page;
			if (_tmp13_ != NULL) {
				AdwNavigationView* _tmp14_;
				AdwNavigationPage* _tmp15_;
				_tmp14_ = self->priv->_widget;
				_tmp15_ = page;
				adw_navigation_view_pop_to_page (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, adw_navigation_page_get_type (), AdwNavigationPage));
			}
			_g_object_unref0 (page);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, g4_stack_properties[G4_STACK_VISIBLE_CHILD_PROPERTY]);
}

GtkWidget*
g4_stack_get_widget (G4Stack* self)
{
	GtkWidget* result;
	AdwNavigationView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	result = (GtkWidget*) _tmp0_;
	return result;
}

static void
g4_stack_class_init (G4StackClass * klass,
                     gpointer klass_data)
{
	g4_stack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4Stack_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_stack_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_g4_stack_set_property;
	G_OBJECT_CLASS (klass)->finalize = g4_stack_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_STACK_ANIMATE_TRANSITIONS_PROPERTY, g4_stack_properties[G4_STACK_ANIMATE_TRANSITIONS_PROPERTY] = g_param_spec_boolean ("animate-transitions", "animate-transitions", "animate-transitions", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_STACK_PARENT_PROPERTY, g4_stack_properties[G4_STACK_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_STACK_VISIBLE_CHILD_PROPERTY, g4_stack_properties[G4_STACK_VISIBLE_CHILD_PROPERTY] = g_param_spec_object ("visible-child", "visible-child", "visible-child", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_STACK_WIDGET_PROPERTY, g4_stack_properties[G4_STACK_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
g4_stack_instance_init (G4Stack * self,
                        gpointer klass)
{
	AdwNavigationView* _tmp0_;
	self->priv = g4_stack_get_instance_private (self);
	self->priv->_retain_last_popped = FALSE;
	self->priv->_last_page = NULL;
	_tmp0_ = (AdwNavigationView*) adw_navigation_view_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->_widget = _tmp0_;
}

static void
g4_stack_finalize (GObject * obj)
{
	G4Stack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_STACK, G4Stack);
	_g_object_unref0 (self->priv->_last_page);
	_g_object_unref0 (self->priv->_widget);
	G_OBJECT_CLASS (g4_stack_parent_class)->finalize (obj);
}

static GType
g4_stack_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4StackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4Stack), 0, (GInstanceInitFunc) g4_stack_instance_init, NULL };
	GType g4_stack_type_id;
	g4_stack_type_id = g_type_register_static (G_TYPE_OBJECT, "G4Stack", &g_define_type_info, 0);
	G4Stack_private_offset = g_type_add_instance_private (g4_stack_type_id, sizeof (G4StackPrivate));
	return g4_stack_type_id;
}

GType
g4_stack_get_type (void)
{
	static volatile gsize g4_stack_type_id__once = 0;
	if (g_once_init_enter (&g4_stack_type_id__once)) {
		GType g4_stack_type_id;
		g4_stack_type_id = g4_stack_get_type_once ();
		g_once_init_leave (&g4_stack_type_id__once, g4_stack_type_id);
	}
	return g4_stack_type_id__once;
}

static void
_vala_g4_stack_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	G4Stack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_STACK, G4Stack);
	switch (property_id) {
		case G4_STACK_ANIMATE_TRANSITIONS_PROPERTY:
		g_value_set_boolean (value, g4_stack_get_animate_transitions (self));
		break;
		case G4_STACK_PARENT_PROPERTY:
		g_value_set_object (value, g4_stack_get_parent (self));
		break;
		case G4_STACK_VISIBLE_CHILD_PROPERTY:
		g_value_set_object (value, g4_stack_get_visible_child (self));
		break;
		case G4_STACK_WIDGET_PROPERTY:
		g_value_set_object (value, g4_stack_get_widget (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_g4_stack_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	G4Stack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_STACK, G4Stack);
	switch (property_id) {
		case G4_STACK_ANIMATE_TRANSITIONS_PROPERTY:
		g4_stack_set_animate_transitions (self, g_value_get_boolean (value));
		break;
		case G4_STACK_VISIBLE_CHILD_PROPERTY:
		g4_stack_set_visible_child (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

