/* music.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from music.vala, do not modify */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <errno.h>

#define G4_UNKNOWN_ALBUM _ ("Unknown Album")
#define G4_UNKNOWN_ARTIST _ ("Unknown Artist")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define G4_TYPE_MUSIC (g4_music_get_type ())
#define G4_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_MUSIC, G4Music))
#define G4_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_MUSIC, G4MusicClass))
#define G4_IS_MUSIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_MUSIC))
#define G4_IS_MUSIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_MUSIC))
#define G4_MUSIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_MUSIC, G4MusicClass))

typedef struct _G4Music G4Music;
typedef struct _G4MusicClass G4MusicClass;
typedef struct _G4MusicPrivate G4MusicPrivate;
enum  {
	G4_MUSIC_0_PROPERTY,
	G4_MUSIC_ALBUM_KEY_PROPERTY,
	G4_MUSIC_ARTIST_NAME_PROPERTY,
	G4_MUSIC_COVER_KEY_PROPERTY,
	G4_MUSIC_NUM_PROPERTIES
};
static GParamSpec* g4_music_properties[G4_MUSIC_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))

#define G4_TYPE_DATA_INPUT_BYTES (g4_data_input_bytes_get_type ())
#define G4_DATA_INPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_DATA_INPUT_BYTES, G4DataInputBytes))
#define G4_DATA_INPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_DATA_INPUT_BYTES, G4DataInputBytesClass))
#define G4_IS_DATA_INPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_DATA_INPUT_BYTES))
#define G4_IS_DATA_INPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_DATA_INPUT_BYTES))
#define G4_DATA_INPUT_BYTES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_DATA_INPUT_BYTES, G4DataInputBytesClass))

typedef struct _G4DataInputBytes G4DataInputBytes;
typedef struct _G4DataInputBytesClass G4DataInputBytesClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define G4_TYPE_DATA_OUTPUT_BYTES (g4_data_output_bytes_get_type ())
#define G4_DATA_OUTPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G4_TYPE_DATA_OUTPUT_BYTES, G4DataOutputBytes))
#define G4_DATA_OUTPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G4_TYPE_DATA_OUTPUT_BYTES, G4DataOutputBytesClass))
#define G4_IS_DATA_OUTPUT_BYTES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G4_TYPE_DATA_OUTPUT_BYTES))
#define G4_IS_DATA_OUTPUT_BYTES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G4_TYPE_DATA_OUTPUT_BYTES))
#define G4_DATA_OUTPUT_BYTES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G4_TYPE_DATA_OUTPUT_BYTES, G4DataOutputBytesClass))

typedef struct _G4DataOutputBytes G4DataOutputBytes;
typedef struct _G4DataOutputBytesClass G4DataOutputBytesClass;
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _G4Music {
	GObject parent_instance;
	G4MusicPrivate * priv;
	gchar* album;
	gchar* artist;
	gchar* title;
	gchar* album_artist;
	guint32 date;
	gchar* genre;
	gint track;
	gint disc;
	gboolean has_cover;
	gint64 modified_time;
	gchar* uri;
	gchar* cover_uri;
	gchar* _album_key;
	gchar* _artist_key;
	gchar* _title_key;
	gint _order;
};

struct _G4MusicClass {
	GObjectClass parent_class;
	gchar* (*get_abbreviation) (G4Music* self);
};

struct _G4MusicPrivate {
	gchar* _cover_key;
};

static gint G4Music_private_offset;
static gpointer g4_music_parent_class = NULL;

VALA_EXTERN GType g4_music_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4Music, g_object_unref)
VALA_EXTERN gchar* g4_music_get_abbreviation (G4Music* self);
VALA_EXTERN G4Music* g4_music_new (const gchar* uri,
                       const gchar* title,
                       gint64 time);
VALA_EXTERN G4Music* g4_music_construct (GType object_type,
                             const gchar* uri,
                             const gchar* title,
                             gint64 time);
VALA_EXTERN G4Music* g4_music_new_empty (void);
VALA_EXTERN G4Music* g4_music_construct_empty (GType object_type);
VALA_EXTERN G4Music* g4_music_new_titled (const gchar* title,
                              const gchar* uri);
VALA_EXTERN G4Music* g4_music_construct_titled (GType object_type,
                                    const gchar* title,
                                    const gchar* uri);
VALA_EXTERN gchar* g4_music_get_artist_and_title (G4Music* self);
static gchar* g4_music_real_get_abbreviation (G4Music* self);
VALA_EXTERN gchar* g4_parse_abbreviation (const gchar* text);
VALA_EXTERN gchar* g4_music_get_date_string (G4Music* self);
VALA_EXTERN gboolean g4_music_from_gst_tags (G4Music* self,
                                 GstTagList* tags);
VALA_EXTERN guint32 g4_music_gst_date_time_to_uint (GstDateTime* dt);
VALA_EXTERN GstDateTime* g4_music_parse_gst_original_date (GstTagList* tags);
static void g4_music_update_album_key (G4Music* self);
VALA_EXTERN gboolean g4_music_has_unknown (G4Music* self);
VALA_EXTERN GType g4_data_input_bytes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DataInputBytes, g_object_unref)
VALA_EXTERN G4Music* g4_music_new_deserialize (G4DataInputBytes* dis,
                                   GError** error);
VALA_EXTERN G4Music* g4_music_construct_deserialize (GType object_type,
                                         G4DataInputBytes* dis,
                                         GError** error);
VALA_EXTERN gchar* g4_data_input_bytes_read_string (G4DataInputBytes* self,
                                        GError** error);
VALA_EXTERN guint8 g4_data_input_bytes_read_byte (G4DataInputBytes* self,
                                      GError** error);
VALA_EXTERN guint64 g4_data_input_bytes_read_uint64 (G4DataInputBytes* self,
                                         GError** error);
VALA_EXTERN guint32 g4_data_input_bytes_read_uint32 (G4DataInputBytes* self,
                                         GError** error);
VALA_EXTERN gsize g4_data_input_bytes_read_size (G4DataInputBytes* self,
                                     GError** error);
VALA_EXTERN GType g4_data_output_bytes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (G4DataOutputBytes, g_object_unref)
VALA_EXTERN void g4_music_serialize (G4Music* self,
                         G4DataOutputBytes* dos,
                         GError** error);
VALA_EXTERN void g4_data_output_bytes_write_string (G4DataOutputBytes* self,
                                        const gchar* str);
VALA_EXTERN void g4_data_output_bytes_write_byte (G4DataOutputBytes* self,
                                      guint8 n);
VALA_EXTERN void g4_data_output_bytes_write_uint64 (G4DataOutputBytes* self,
                                        guint64 n);
VALA_EXTERN void g4_data_output_bytes_write_uint32 (G4DataOutputBytes* self,
                                        guint32 n);
VALA_EXTERN void g4_data_output_bytes_write_size (G4DataOutputBytes* self,
                                      gsize n);
VALA_EXTERN void g4_music_parse_tags (G4Music* self);
VALA_EXTERN GstTagList* g4_parse_gst_tags (GFile* file);
VALA_EXTERN gint g4_music_compare_by_album (G4Music* s1,
                                G4Music* s2);
VALA_EXTERN gint g4_music_compare_by_artist (G4Music* s1,
                                 G4Music* s2);
VALA_EXTERN gint g4_music_compare_by_artist_album (G4Music* s1,
                                       G4Music* s2);
VALA_EXTERN gint g4_music_compare_by_title (G4Music* s1,
                                G4Music* s2);
VALA_EXTERN gint g4_music_compare_by_order (G4Music* s1,
                                G4Music* s2);
VALA_EXTERN gint g4_music_compare_by_recent (G4Music* s1,
                                 G4Music* s2);
VALA_EXTERN void g4_music_original_order (GPtrArray* arr);
VALA_EXTERN void g4_music_shuffle_order (GPtrArray* arr);
VALA_EXTERN const gchar* g4_music_get_album_key (G4Music* self);
VALA_EXTERN const gchar* g4_music_get_artist_name (G4Music* self);
VALA_EXTERN const gchar* g4_music_get_cover_key (G4Music* self);
VALA_EXTERN void g4_music_set_cover_key (G4Music* self,
                             const gchar* value);
static void g4_music_finalize (GObject * obj);
static GType g4_music_get_type_once (void);
static void _vala_g4_music_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_g4_music_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
VALA_EXTERN gboolean g4_is_music_type (const gchar* content_type);
VALA_EXTERN gunichar g4_find_first_letter (const gchar* text);
VALA_EXTERN gchar* g4_get_display_name (const gchar* uri);
VALA_EXTERN gchar* g4_get_file_display_name (GFile* file);
VALA_EXTERN gchar* g4_get_uri_with_end_sep (GFile* file);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
g4_music_get_instance_private (G4Music* self)
{
	return G_STRUCT_MEMBER_P (self, G4Music_private_offset);
}

G4Music*
g4_music_construct (GType object_type,
                    const gchar* uri,
                    const gchar* title,
                    gint64 time)
{
	G4Music * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (G4Music*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (title);
	_g_free0 (self->title);
	self->title = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (self->uri);
	self->uri = _tmp1_;
	self->modified_time = time;
	return self;
}

G4Music*
g4_music_new (const gchar* uri,
              const gchar* title,
              gint64 time)
{
	return g4_music_construct (G4_TYPE_MUSIC, uri, title, time);
}

G4Music*
g4_music_construct_empty (GType object_type)
{
	G4Music * self = NULL;
	self = (G4Music*) g_object_new (object_type, NULL);
	return self;
}

G4Music*
g4_music_new_empty (void)
{
	return g4_music_construct_empty (G4_TYPE_MUSIC);
}

G4Music*
g4_music_construct_titled (GType object_type,
                           const gchar* title,
                           const gchar* uri)
{
	G4Music * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (G4Music*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (title);
	_g_free0 (self->title);
	self->title = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (self->uri);
	self->uri = _tmp1_;
	_tmp2_ = g_utf8_collate_key_for_filename (title, (gssize) -1);
	_g_free0 (self->_title_key);
	self->_title_key = _tmp2_;
	return self;
}

G4Music*
g4_music_new_titled (const gchar* title,
                     const gchar* uri)
{
	return g4_music_construct_titled (G4_TYPE_MUSIC, title, uri);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

inline gchar*
g4_music_get_artist_and_title (G4Music* self)
{
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->artist;
	if (g_strcmp0 (_tmp1_, G4_UNKNOWN_ARTIST) == 0) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->title;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = self->artist;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = self->title;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat (_tmp5_, " - ", _tmp7_, NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	result = _tmp0_;
	return result;
}

static gchar*
g4_music_real_get_abbreviation (G4Music* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = self->album;
	_tmp1_ = g4_parse_abbreviation (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
g4_music_get_abbreviation (G4Music* self)
{
	G4MusicClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = G4_MUSIC_GET_CLASS (self);
	if (_klass_->get_abbreviation) {
		return _klass_->get_abbreviation (self);
	}
	return NULL;
}

inline gchar*
g4_music_get_date_string (G4Music* self)
{
	guint32 year = 0U;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	year = self->date / 400;
	if (year > ((guint32) 0)) {
		guint32 month = 0U;
		gchar* _tmp13_;
		month = (self->date - (year * 400)) / 32;
		if (month > ((guint32) 0)) {
			guint32 d = 0U;
			gchar* _tmp0_ = NULL;
			d = self->date % 32;
			if (d > ((guint32) 0)) {
				gchar* _tmp1_;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp1_ = g_strdup_printf ("%u", year);
				_tmp2_ = _tmp1_;
				_tmp3_ = g_strdup_printf ("%u", month);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strdup_printf ("%u", d);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strconcat (_tmp2_, "-", _tmp4_, "-", _tmp6_, NULL);
				_g_free0 (_tmp0_);
				_tmp0_ = _tmp7_;
				_g_free0 (_tmp6_);
				_g_free0 (_tmp4_);
				_g_free0 (_tmp2_);
			} else {
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = g_strdup_printf ("%u", year);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup_printf ("%u", month);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp9_, "-", _tmp11_, NULL);
				_g_free0 (_tmp0_);
				_tmp0_ = _tmp12_;
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
			}
			result = _tmp0_;
			return result;
		}
		_tmp13_ = g_strdup_printf ("%u", year);
		result = _tmp13_;
		return result;
	}
	_tmp14_ = g_strdup ("");
	result = _tmp14_;
	return result;
}

gboolean
g4_music_from_gst_tags (G4Music* self,
                        GstTagList* tags)
{
	gboolean changed = FALSE;
	const gchar* al = NULL;
	const gchar* ar = NULL;
	const gchar* ti = NULL;
	const gchar* aa = NULL;
	const gchar* ge = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp25_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_ = NULL;
	gboolean _tmp37_;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	const gchar* _tmp46_ = NULL;
	gboolean _tmp47_;
	GstDateTime* dt = NULL;
	guint dtu = 0U;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	GstDateTime* _tmp56_ = NULL;
	gboolean _tmp57_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GstDateTime* _tmp62_;
	GstDateTime* _tmp63_;
	guint tn = 0U;
	guint avn = 0U;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	guint _tmp68_ = 0U;
	gboolean _tmp69_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	guint _tmp72_ = 0U;
	gboolean _tmp73_;
	GstSample* sample = NULL;
	gboolean _tmp74_ = FALSE;
	GstSample* _tmp75_ = NULL;
	gboolean _tmp76_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tags != NULL, FALSE);
	changed = FALSE;
	al = NULL;
	ar = NULL;
	ti = NULL;
	aa = NULL;
	ge = NULL;
	_tmp3_ = gst_tag_list_peek_string_index (tags, GST_TAG_ALBUM, (guint) 0, &_tmp2_);
	al = _tmp2_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		_tmp4_ = al;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GCompareFunc _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = ((GCompareFunc) g_strcmp0);
		_tmp6_ = self->album;
		_tmp7_ = al;
		_tmp0_ = _tmp5_ (_tmp6_, _tmp7_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = al;
		_tmp9_ = g_strdup ((const gchar*) _tmp8_);
		_g_free0 (self->album);
		self->album = _tmp9_;
		changed = TRUE;
	}
	_tmp13_ = gst_tag_list_peek_string_index (tags, GST_TAG_ARTIST, (guint) 0, &_tmp12_);
	ar = _tmp12_;
	if (_tmp13_) {
		const gchar* _tmp14_;
		_tmp14_ = ar;
		_tmp11_ = _tmp14_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GCompareFunc _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = ((GCompareFunc) g_strcmp0);
		_tmp16_ = self->artist;
		_tmp17_ = ar;
		_tmp10_ = _tmp15_ (_tmp16_, _tmp17_) != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = ar;
		_tmp19_ = g_strdup ((const gchar*) _tmp18_);
		_g_free0 (self->artist);
		self->artist = _tmp19_;
		_tmp20_ = self->artist;
		_tmp21_ = g_utf8_collate_key_for_filename (_tmp20_, (gssize) -1);
		_g_free0 (self->_artist_key);
		self->_artist_key = _tmp21_;
		changed = TRUE;
	}
	_tmp25_ = gst_tag_list_peek_string_index (tags, GST_TAG_TITLE, (guint) 0, &_tmp24_);
	ti = _tmp24_;
	if (_tmp25_) {
		const gchar* _tmp26_;
		_tmp26_ = ti;
		_tmp23_ = _tmp26_ != NULL;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GCompareFunc _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = ((GCompareFunc) g_strcmp0);
		_tmp28_ = self->title;
		_tmp29_ = ti;
		_tmp22_ = _tmp27_ (_tmp28_, _tmp29_) != 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp30_ = ti;
		_tmp31_ = g_strdup ((const gchar*) _tmp30_);
		_g_free0 (self->title);
		self->title = _tmp31_;
		_tmp32_ = self->title;
		_tmp33_ = g_utf8_collate_key_for_filename (_tmp32_, (gssize) -1);
		_g_free0 (self->_title_key);
		self->_title_key = _tmp33_;
		changed = TRUE;
	}
	_tmp37_ = gst_tag_list_peek_string_index (tags, GST_TAG_ALBUM_ARTIST, (guint) 0, &_tmp36_);
	aa = _tmp36_;
	if (_tmp37_) {
		const gchar* _tmp38_;
		_tmp38_ = aa;
		_tmp35_ = _tmp38_ != NULL;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GCompareFunc _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp39_ = ((GCompareFunc) g_strcmp0);
		_tmp40_ = self->album_artist;
		_tmp41_ = aa;
		_tmp34_ = _tmp39_ (_tmp40_, _tmp41_) != 0;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		const gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp42_ = aa;
		_tmp43_ = g_strdup ((const gchar*) _tmp42_);
		_g_free0 (self->album_artist);
		self->album_artist = _tmp43_;
		changed = TRUE;
	}
	_tmp47_ = gst_tag_list_peek_string_index (tags, GST_TAG_GENRE, (guint) 0, &_tmp46_);
	ge = _tmp46_;
	if (_tmp47_) {
		const gchar* _tmp48_;
		_tmp48_ = ge;
		_tmp45_ = _tmp48_ != NULL;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		GCompareFunc _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		_tmp49_ = ((GCompareFunc) g_strcmp0);
		_tmp50_ = self->genre;
		_tmp51_ = ge;
		_tmp44_ = _tmp49_ (_tmp50_, _tmp51_) != 0;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		const gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp52_ = ge;
		_tmp53_ = g_strdup ((const gchar*) _tmp52_);
		_g_free0 (self->genre);
		self->genre = _tmp53_;
		changed = TRUE;
	}
	dt = NULL;
	dtu = (guint) 0;
	_tmp57_ = gst_tag_list_get_date_time (tags, GST_TAG_DATE_TIME, &_tmp56_);
	_gst_date_time_unref0 (dt);
	dt = _tmp56_;
	if (_tmp57_) {
		GstDateTime* _tmp58_;
		_tmp58_ = dt;
		_tmp55_ = _tmp58_ != NULL;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		GstDateTime* _tmp59_;
		_tmp59_ = dt;
		dtu = (guint) g4_music_gst_date_time_to_uint (_tmp59_);
		_tmp54_ = dtu != ((guint) self->date);
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		self->date = (guint32) dtu;
		changed = TRUE;
	}
	_tmp62_ = g4_music_parse_gst_original_date (tags);
	_gst_date_time_unref0 (dt);
	dt = _tmp62_;
	_tmp63_ = dt;
	if (_tmp63_ != NULL) {
		GstDateTime* _tmp64_;
		_tmp64_ = dt;
		_tmp61_ = _tmp64_ != NULL;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		GstDateTime* _tmp65_;
		_tmp65_ = dt;
		dtu = (guint) g4_music_gst_date_time_to_uint (_tmp65_);
		_tmp60_ = dtu != ((guint) self->date);
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		self->date = (guint32) dtu;
		changed = TRUE;
	}
	tn = (guint) 0;
	avn = (guint) 0;
	_tmp69_ = gst_tag_list_get_uint (tags, GST_TAG_TRACK_NUMBER, &_tmp68_);
	tn = _tmp68_;
	if (_tmp69_) {
		_tmp67_ = ((gint) tn) > 0;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		_tmp66_ = ((guint) self->track) != tn;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		self->track = (gint) tn;
		changed = TRUE;
	}
	_tmp73_ = gst_tag_list_get_uint (tags, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp72_);
	avn = _tmp72_;
	if (_tmp73_) {
		_tmp71_ = ((gint) avn) > 0;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		_tmp70_ = ((guint) self->disc) != avn;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		self->disc = (gint) avn;
		changed = TRUE;
	}
	sample = NULL;
	_tmp76_ = gst_tag_list_get_sample (tags, GST_TAG_IMAGE, &_tmp75_);
	_gst_sample_unref0 (sample);
	sample = _tmp75_;
	if (_tmp76_) {
		GstSample* _tmp77_;
		_tmp77_ = sample;
		_tmp74_ = self->has_cover != (_tmp77_ != NULL);
	} else {
		_tmp74_ = FALSE;
	}
	if (_tmp74_) {
		GstSample* _tmp78_;
		_tmp78_ = sample;
		self->has_cover = _tmp78_ != NULL;
		changed = TRUE;
	}
	if (changed) {
		g4_music_update_album_key (self);
	}
	result = changed;
	_gst_sample_unref0 (sample);
	_gst_date_time_unref0 (dt);
	return result;
}

gboolean
g4_music_has_unknown (G4Music* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->title;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = self->artist;
		_tmp1_ = g_strcmp0 (_tmp5_, G4_UNKNOWN_ARTIST) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = self->album;
		_tmp0_ = g_strcmp0 (_tmp6_, G4_UNKNOWN_ALBUM) == 0;
	}
	result = _tmp0_;
	return result;
}

G4Music*
g4_music_construct_deserialize (GType object_type,
                                G4DataInputBytes* dis,
                                GError** error)
{
	G4Music * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint8 _tmp9_ = 0U;
	guint64 _tmp10_ = 0ULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	guint32 _tmp17_ = 0U;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gsize _tmp21_ = 0UL;
	gsize _tmp22_ = 0UL;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (dis != NULL, NULL);
	self = (G4Music*) g_object_new (object_type, NULL);
	_tmp1_ = g4_data_input_bytes_read_string (dis, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_free0 (self->album);
	self->album = _tmp2_;
	_tmp4_ = g4_data_input_bytes_read_string (dis, &_inner_error0_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	_g_free0 (self->artist);
	self->artist = _tmp5_;
	_tmp7_ = g4_data_input_bytes_read_string (dis, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = _tmp6_;
	_tmp6_ = NULL;
	_g_free0 (self->title);
	self->title = _tmp8_;
	_tmp9_ = g4_data_input_bytes_read_byte (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->has_cover = ((gint) _tmp9_) == 1;
	_tmp10_ = g4_data_input_bytes_read_uint64 (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->modified_time = (gint64) _tmp10_;
	_tmp12_ = g4_data_input_bytes_read_string (dis, &_inner_error0_);
	_tmp11_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp13_ = _tmp11_;
	_tmp11_ = NULL;
	_g_free0 (self->uri);
	self->uri = _tmp13_;
	_tmp15_ = g4_data_input_bytes_read_string (dis, &_inner_error0_);
	_tmp14_ = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp16_ = _tmp14_;
	_tmp14_ = NULL;
	_g_free0 (self->album_artist);
	self->album_artist = _tmp16_;
	_tmp17_ = g4_data_input_bytes_read_uint32 (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->date = _tmp17_;
	_tmp19_ = g4_data_input_bytes_read_string (dis, &_inner_error0_);
	_tmp18_ = _tmp19_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = _tmp18_;
	_tmp18_ = NULL;
	_g_free0 (self->genre);
	self->genre = _tmp20_;
	_tmp21_ = g4_data_input_bytes_read_size (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp18_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->track = (gint) _tmp21_;
	_tmp22_ = g4_data_input_bytes_read_size (dis, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (_tmp18_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	self->disc = (gint) _tmp22_;
	g4_music_update_album_key (self);
	_tmp23_ = self->artist;
	_tmp24_ = g_utf8_collate_key_for_filename (_tmp23_, (gssize) -1);
	_g_free0 (self->_artist_key);
	self->_artist_key = _tmp24_;
	_tmp25_ = self->title;
	_tmp26_ = g_utf8_collate_key_for_filename (_tmp25_, (gssize) -1);
	_g_free0 (self->_title_key);
	self->_title_key = _tmp26_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp0_);
	return self;
}

G4Music*
g4_music_new_deserialize (G4DataInputBytes* dis,
                          GError** error)
{
	return g4_music_construct_deserialize (G4_TYPE_MUSIC, dis, error);
}

void
g4_music_serialize (G4Music* self,
                    G4DataOutputBytes* dos,
                    GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dos != NULL);
	_tmp0_ = self->album;
	g4_data_output_bytes_write_string (dos, _tmp0_);
	_tmp1_ = self->artist;
	g4_data_output_bytes_write_string (dos, _tmp1_);
	_tmp2_ = self->title;
	g4_data_output_bytes_write_string (dos, _tmp2_);
	if (self->has_cover) {
		_tmp3_ = 1;
	} else {
		_tmp3_ = 0;
	}
	g4_data_output_bytes_write_byte (dos, (guint8) _tmp3_);
	g4_data_output_bytes_write_uint64 (dos, (guint64) self->modified_time);
	_tmp4_ = self->uri;
	g4_data_output_bytes_write_string (dos, _tmp4_);
	_tmp5_ = self->album_artist;
	g4_data_output_bytes_write_string (dos, _tmp5_);
	g4_data_output_bytes_write_uint32 (dos, self->date);
	_tmp6_ = self->genre;
	g4_data_output_bytes_write_string (dos, _tmp6_);
	g4_data_output_bytes_write_size (dos, (gsize) self->track);
	g4_data_output_bytes_write_size (dos, (gsize) self->disc);
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
g4_music_parse_tags (G4Music* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	const gchar* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = self->title;
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->title);
	self->title = _tmp4_;
	_tmp5_ = file;
	if (g_file_is_native (_tmp5_)) {
		GstTagList* tags = NULL;
		GFile* _tmp6_;
		GstTagList* _tmp7_;
		GstTagList* _tmp8_;
		_tmp6_ = file;
		_tmp7_ = g4_parse_gst_tags (_tmp6_);
		tags = _tmp7_;
		_tmp8_ = tags;
		if (_tmp8_ != NULL) {
			GstTagList* _tmp9_;
			_tmp9_ = tags;
			g4_music_from_gst_tags (self, (GstTagList*) _tmp9_);
		}
		_gst_tag_list_unref0 (tags);
	}
	_tmp11_ = self->title;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == 0) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = self->artist;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp10_ = _tmp16_ == 0;
	}
	if (_tmp10_) {
		gint end = 0;
		const gchar* _tmp17_;
		gint track_index = 0;
		gint pos = 0;
		const gchar* _tmp20_;
		gboolean _tmp21_ = FALSE;
		gchar** sa = NULL;
		const gchar* _tmp33_;
		gchar** _tmp34_;
		gchar** _tmp35_;
		gint sa_length1;
		gint _sa_size_;
		gint len = 0;
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		_tmp17_ = name;
		end = string_last_index_of_char (_tmp17_, (gunichar) '.', 0);
		if (end > 0) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = name;
			_tmp19_ = string_substring (_tmp18_, (glong) 0, (glong) end);
			_g_free0 (name);
			name = _tmp19_;
		}
		track_index = 0;
		_tmp20_ = name;
		pos = string_index_of_char (_tmp20_, (gunichar) '.', 0);
		if (pos > 0) {
			const gchar* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			_tmp22_ = name;
			_tmp23_ = strlen (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp21_ = pos < (_tmp24_ - 1);
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gint _tmp28_ = 0;
			gboolean _tmp29_;
			gboolean _tmp30_;
			_tmp25_ = name;
			_tmp26_ = string_substring (_tmp25_, (glong) 0, (glong) pos);
			_tmp27_ = _tmp26_;
			_tmp29_ = int_try_parse (_tmp27_, &_tmp28_, NULL, (guint) 10);
			track_index = _tmp28_;
			_tmp30_ = _tmp29_;
			_g_free0 (_tmp27_);
			if (_tmp30_) {
				const gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp31_ = name;
				_tmp32_ = string_substring (_tmp31_, (glong) (pos + 1), (glong) -1);
				_g_free0 (name);
				name = _tmp32_;
			}
		}
		_tmp33_ = name;
		_tmp35_ = _tmp34_ = g_strsplit (_tmp33_, "-", 0);
		sa = _tmp35_;
		sa_length1 = _vala_array_length (_tmp34_);
		_sa_size_ = sa_length1;
		_tmp36_ = sa;
		_tmp36__length1 = sa_length1;
		len = _tmp36__length1;
		_tmp37_ = self->title;
		_tmp38_ = strlen (_tmp37_);
		_tmp39_ = _tmp38_;
		if (_tmp39_ == 0) {
			gchar* _tmp40_ = NULL;
			gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			if (len >= 1) {
				gchar** _tmp41_;
				gint _tmp41__length1;
				const gchar* _tmp42_;
				gchar* _tmp43_;
				_tmp41_ = sa;
				_tmp41__length1 = sa_length1;
				_tmp42_ = _tmp41_[len - 1];
				_tmp43_ = string_strip (_tmp42_);
				_g_free0 (_tmp40_);
				_tmp40_ = _tmp43_;
			} else {
				const gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp44_ = name;
				_tmp45_ = g_strdup (_tmp44_);
				_g_free0 (_tmp40_);
				_tmp40_ = _tmp45_;
			}
			_tmp46_ = g_strdup (_tmp40_);
			_g_free0 (self->title);
			self->title = _tmp46_;
			_tmp47_ = self->title;
			_tmp48_ = g_utf8_collate_key_for_filename (_tmp47_, (gssize) -1);
			_g_free0 (self->_title_key);
			self->_title_key = _tmp48_;
			_g_free0 (_tmp40_);
		}
		_tmp49_ = self->artist;
		_tmp50_ = strlen (_tmp49_);
		_tmp51_ = _tmp50_;
		if (_tmp51_ == 0) {
			gchar* _tmp52_ = NULL;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			if (len >= 2) {
				gchar** _tmp53_;
				gint _tmp53__length1;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				_tmp53_ = sa;
				_tmp53__length1 = sa_length1;
				_tmp54_ = _tmp53_[len - 2];
				_tmp55_ = string_strip (_tmp54_);
				_g_free0 (_tmp52_);
				_tmp52_ = _tmp55_;
			} else {
				gchar* _tmp56_;
				_tmp56_ = g_strdup (G4_UNKNOWN_ARTIST);
				_g_free0 (_tmp52_);
				_tmp52_ = _tmp56_;
			}
			_tmp57_ = g_strdup (_tmp52_);
			_g_free0 (self->artist);
			self->artist = _tmp57_;
			_tmp58_ = self->artist;
			_tmp59_ = g_utf8_collate_key_for_filename (_tmp58_, (gssize) -1);
			_g_free0 (self->_artist_key);
			self->_artist_key = _tmp59_;
			_g_free0 (_tmp52_);
		}
		if (track_index == 0) {
			gboolean _tmp60_ = FALSE;
			if (track_index == 0) {
				_tmp60_ = len >= 3;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				gchar** _tmp61_;
				gint _tmp61__length1;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gint _tmp65_ = 0;
				_tmp61_ = sa;
				_tmp61__length1 = sa_length1;
				_tmp62_ = _tmp61_[0];
				_tmp63_ = string_strip (_tmp62_);
				_tmp64_ = _tmp63_;
				int_try_parse (_tmp64_, &_tmp65_, NULL, (guint) 10);
				track_index = _tmp65_;
				_g_free0 (_tmp64_);
			}
			if (track_index > 0) {
				self->track = track_index;
			}
		}
		sa = (_vala_array_free (sa, sa_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp66_ = self->album;
	_tmp67_ = strlen (_tmp66_);
	_tmp68_ = _tmp67_;
	if (_tmp68_ == 0) {
		GFile* _tmp69_ = NULL;
		GFile* _tmp70_;
		GFile* _tmp71_;
		gchar* _tmp72_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp70_ = file;
		_tmp71_ = g_file_get_parent (_tmp70_);
		_tmp69_ = _tmp71_;
		_tmp72_ = NULL;
		if (_tmp69_ != NULL) {
			gchar* _tmp73_;
			_tmp73_ = g_file_get_basename (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, g_file_get_type (), GFile));
			_g_free0 (_tmp72_);
			_tmp72_ = _tmp73_;
		}
		_tmp75_ = _tmp72_;
		_tmp72_ = NULL;
		_tmp74_ = _tmp75_;
		if (_tmp74_ == NULL) {
			gchar* _tmp76_;
			_tmp76_ = g_strdup (G4_UNKNOWN_ALBUM);
			_g_free0 (_tmp74_);
			_tmp74_ = _tmp76_;
		}
		_tmp77_ = _tmp74_;
		_tmp74_ = NULL;
		_g_free0 (self->album);
		self->album = (gchar*) _tmp77_;
		_tmp78_ = self->album;
		_tmp79_ = g_utf8_collate_key_for_filename (_tmp78_, (gssize) -1);
		_g_free0 (self->_album_key);
		self->_album_key = _tmp79_;
		_g_free0 (_tmp74_);
		_g_free0 (_tmp72_);
		_g_object_unref0 (_tmp69_);
	}
	_g_free0 (name);
	_g_object_unref0 (file);
}

static void
g4_music_update_album_key (G4Music* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->album;
	_tmp1_ = g_strdup_printf ("%u", self->date);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp0_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->album_artist;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate_key_for_filename (_tmp7_, (gssize) -1);
	_g_free0 (self->_album_key);
	self->_album_key = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

gint
g4_music_compare_by_album (G4Music* s1,
                           G4Music* s2)
{
	gint ret = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCompareFunc _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GCompareFunc _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = s1->_album_key;
	_tmp2_ = s2->_album_key;
	ret = _tmp0_ (_tmp1_, _tmp2_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	ret = s1->disc - s2->disc;
	if (ret != 0) {
		result = ret;
		return result;
	}
	ret = s1->track - s2->track;
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp3_ = ((GCompareFunc) g_strcmp0);
	_tmp4_ = s1->_title_key;
	_tmp5_ = s2->_title_key;
	ret = _tmp3_ (_tmp4_, _tmp5_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp6_ = ((GCompareFunc) g_strcmp0);
	_tmp7_ = s1->uri;
	_tmp8_ = s2->uri;
	result = _tmp6_ (_tmp7_, _tmp8_);
	return result;
}

gint
g4_music_compare_by_artist (G4Music* s1,
                            G4Music* s2)
{
	gint ret = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCompareFunc _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GCompareFunc _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = s1->_artist_key;
	_tmp2_ = s2->_artist_key;
	ret = _tmp0_ (_tmp1_, _tmp2_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp3_ = ((GCompareFunc) g_strcmp0);
	_tmp4_ = s1->_title_key;
	_tmp5_ = s2->_title_key;
	ret = _tmp3_ (_tmp4_, _tmp5_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp6_ = ((GCompareFunc) g_strcmp0);
	_tmp7_ = s1->uri;
	_tmp8_ = s2->uri;
	result = _tmp6_ (_tmp7_, _tmp8_);
	return result;
}

gint
g4_music_compare_by_artist_album (G4Music* s1,
                                  G4Music* s2)
{
	gint ret = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = s1->_artist_key;
	_tmp2_ = s2->_artist_key;
	ret = _tmp0_ (_tmp1_, _tmp2_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	result = g4_music_compare_by_album (s1, s2);
	return result;
}

gint
g4_music_compare_by_title (G4Music* s1,
                           G4Music* s2)
{
	gint ret = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GCompareFunc _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GCompareFunc _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = s1->_title_key;
	_tmp2_ = s2->_title_key;
	ret = _tmp0_ (_tmp1_, _tmp2_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp3_ = ((GCompareFunc) g_strcmp0);
	_tmp4_ = s1->_artist_key;
	_tmp5_ = s2->_artist_key;
	ret = _tmp3_ (_tmp4_, _tmp5_);
	if (ret != 0) {
		result = ret;
		return result;
	}
	_tmp6_ = ((GCompareFunc) g_strcmp0);
	_tmp7_ = s1->uri;
	_tmp8_ = s2->uri;
	result = _tmp6_ (_tmp7_, _tmp8_);
	return result;
}

gint
g4_music_compare_by_order (G4Music* s1,
                           G4Music* s2)
{
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	result = s1->_order - s2->_order;
	return result;
}

gint
g4_music_compare_by_recent (G4Music* s1,
                            G4Music* s2)
{
	gint64 diff = 0LL;
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	diff = s2->modified_time - s1->modified_time;
	result = (gint) CLAMP (diff, (gint64) -1, (gint64) 1);
	return result;
}

static gpointer
_gst_date_time_ref0 (gpointer self)
{
	return self ? gst_date_time_ref (self) : NULL;
}

inline guint32
g4_music_gst_date_time_to_uint (GstDateTime* dt)
{
	guint32 result;
	if (dt != NULL) {
		GstDateTime* d = NULL;
		GstDateTime* _tmp0_;
		gint _tmp1_ = 0;
		GstDateTime* _tmp2_;
		gint _tmp4_ = 0;
		GstDateTime* _tmp5_;
		gint _tmp7_ = 0;
		GstDateTime* _tmp8_;
		_tmp0_ = _gst_date_time_ref0 ((GstDateTime*) dt);
		d = _tmp0_;
		_tmp2_ = d;
		if (gst_date_time_has_year (_tmp2_)) {
			GstDateTime* _tmp3_;
			_tmp3_ = d;
			_tmp1_ = gst_date_time_get_year (_tmp3_);
		} else {
			_tmp1_ = 0;
		}
		_tmp5_ = d;
		if (gst_date_time_has_month (_tmp5_)) {
			GstDateTime* _tmp6_;
			_tmp6_ = d;
			_tmp4_ = gst_date_time_get_month (_tmp6_);
		} else {
			_tmp4_ = 0;
		}
		_tmp8_ = d;
		if (gst_date_time_has_day (_tmp8_)) {
			GstDateTime* _tmp9_;
			_tmp9_ = d;
			_tmp7_ = gst_date_time_get_day (_tmp9_);
		} else {
			_tmp7_ = 0;
		}
		result = (guint32) (((_tmp1_ * 400) + (_tmp4_ * 32)) + _tmp7_);
		_gst_date_time_unref0 (d);
		return result;
	}
	result = (guint32) 0;
	return result;
}

GstDateTime*
g4_music_parse_gst_original_date (GstTagList* tags)
{
	GstDateTime* date = NULL;
	GstDateTime* year = NULL;
	guint ec_size = 0U;
	GstDateTime* _tmp22_ = NULL;
	GstDateTime* _tmp23_;
	GstDateTime* _tmp25_;
	GstDateTime* result;
	g_return_val_if_fail (tags != NULL, NULL);
	date = NULL;
	year = NULL;
	ec_size = gst_tag_list_get_tag_size (tags, GST_TAG_EXTENDED_COMMENT);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* s = NULL;
				gboolean _tmp2_ = FALSE;
				const gchar* _tmp3_ = NULL;
				gboolean _tmp4_;
				gchar* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < ec_size)) {
					break;
				}
				s = NULL;
				_tmp4_ = gst_tag_list_peek_string_index (tags, GST_TAG_EXTENDED_COMMENT, (guint) i, &_tmp3_);
				_g_free0 (s);
				_tmp5_ = g_strdup (_tmp3_);
				s = _tmp5_;
				if (_tmp4_) {
					const gchar* _tmp6_;
					_tmp6_ = s;
					_tmp2_ = _tmp6_ != NULL;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gchar* str = NULL;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					const gchar* _tmp9_;
					gboolean _tmp19_ = FALSE;
					GstDateTime* _tmp20_;
					_tmp7_ = s;
					_tmp8_ = g_strdup ((const gchar*) _tmp7_);
					str = _tmp8_;
					_tmp9_ = str;
					if (g_str_has_prefix (_tmp9_, "ORIGINALDATE=")) {
						const gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						GstDateTime* _tmp13_;
						_tmp10_ = str;
						_tmp11_ = string_substring (_tmp10_, (glong) 13, (glong) -1);
						_tmp12_ = _tmp11_;
						_tmp13_ = gst_date_time_new_from_iso8601_string (_tmp12_);
						_gst_date_time_unref0 (date);
						date = _tmp13_;
						_g_free0 (_tmp12_);
					} else {
						const gchar* _tmp14_;
						_tmp14_ = str;
						if (g_str_has_prefix (_tmp14_, "ORIGINALYEAR=")) {
							const gchar* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							GstDateTime* _tmp18_;
							_tmp15_ = str;
							_tmp16_ = string_substring (_tmp15_, (glong) 13, (glong) -1);
							_tmp17_ = _tmp16_;
							_tmp18_ = gst_date_time_new_from_iso8601_string (_tmp17_);
							_gst_date_time_unref0 (year);
							year = _tmp18_;
							_g_free0 (_tmp17_);
						}
					}
					_tmp20_ = date;
					if (_tmp20_ != NULL) {
						GstDateTime* _tmp21_;
						_tmp21_ = year;
						_tmp19_ = _tmp21_ != NULL;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						_g_free0 (str);
						_g_free0 (s);
						break;
					}
					_g_free0 (str);
				}
				_g_free0 (s);
			}
		}
	}
	_tmp23_ = date;
	_tmp22_ = _tmp23_;
	if (_tmp22_ == NULL) {
		GstDateTime* _tmp24_;
		_tmp24_ = year;
		_tmp22_ = _tmp24_;
	}
	_tmp25_ = _gst_date_time_ref0 (_tmp22_);
	result = _tmp25_;
	_gst_date_time_unref0 (year);
	_gst_date_time_unref0 (date);
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

void
g4_music_original_order (GPtrArray* arr)
{
	g_return_if_fail (arr != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_g_ptr_array_get_length (arr);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gconstpointer _tmp4_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp4_ = g_ptr_array_index (arr, (guint) i);
				((G4Music*) _tmp4_)->_order = i;
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
g_ptr_array_set (GPtrArray* self,
                 guint index,
                 gpointer data)
{
	gpointer _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	g_ptr_array_remove_index_fast (self, index);
}

void
g4_music_shuffle_order (GPtrArray* arr)
{
	g_return_if_fail (arr != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_g_ptr_array_get_length (arr);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint32 r = 0;
				G4Music* s = NULL;
				gconstpointer _tmp4_;
				G4Music* _tmp5_;
				gconstpointer _tmp6_;
				G4Music* _tmp7_;
				G4Music* _tmp8_;
				G4Music* _tmp9_;
				gconstpointer _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				if (!(i > 0)) {
					break;
				}
				r = g_random_int_range ((gint32) 0, (gint32) (i + 1));
				_tmp4_ = g_ptr_array_index (arr, (guint) i);
				_tmp5_ = _g_object_ref0 ((G4Music*) _tmp4_);
				s = _tmp5_;
				_tmp6_ = g_ptr_array_index (arr, (guint) r);
				_tmp7_ = _g_object_ref0 ((G4Music*) _tmp6_);
				g_ptr_array_set (arr, (guint) i, _tmp7_);
				_tmp8_ = s;
				_tmp9_ = _g_object_ref0 (_tmp8_);
				g_ptr_array_set (arr, (guint) r, _tmp9_);
				_tmp10_ = g_ptr_array_index (arr, (guint) i);
				((G4Music*) _tmp10_)->_order = i;
				_g_object_unref0 (s);
			}
		}
	}
}

const gchar*
g4_music_get_album_key (G4Music* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_album_key;
	result = _tmp0_;
	return result;
}

const gchar*
g4_music_get_artist_name (G4Music* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->album_artist;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		const gchar* _tmp4_;
		_tmp4_ = self->album_artist;
		_tmp0_ = _tmp4_;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = self->artist;
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

const gchar*
g4_music_get_cover_key (G4Music* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_cover_key;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->uri;
		_tmp0_ = _tmp2_;
	}
	result = (const gchar*) _tmp0_;
	return result;
}

void
g4_music_set_cover_key (G4Music* self,
                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_cover_key);
	self->priv->_cover_key = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, g4_music_properties[G4_MUSIC_COVER_KEY_PROPERTY]);
}

static void
g4_music_class_init (G4MusicClass * klass,
                     gpointer klass_data)
{
	g4_music_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &G4Music_private_offset);
	((G4MusicClass *) klass)->get_abbreviation = (gchar* (*) (G4Music*)) g4_music_real_get_abbreviation;
	G_OBJECT_CLASS (klass)->get_property = _vala_g4_music_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_g4_music_set_property;
	G_OBJECT_CLASS (klass)->finalize = g4_music_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_ALBUM_KEY_PROPERTY, g4_music_properties[G4_MUSIC_ALBUM_KEY_PROPERTY] = g_param_spec_string ("album-key", "album-key", "album-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_ARTIST_NAME_PROPERTY, g4_music_properties[G4_MUSIC_ARTIST_NAME_PROPERTY] = g_param_spec_string ("artist-name", "artist-name", "artist-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), G4_MUSIC_COVER_KEY_PROPERTY, g4_music_properties[G4_MUSIC_COVER_KEY_PROPERTY] = g_param_spec_string ("cover-key", "cover-key", "cover-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
g4_music_instance_init (G4Music * self,
                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self->priv = g4_music_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->album = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->artist = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->title = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->album_artist = _tmp3_;
	self->date = (guint32) 0;
	_tmp4_ = g_strdup ("");
	self->genre = _tmp4_;
	self->track = 0;
	self->disc = 0;
	self->has_cover = FALSE;
	self->modified_time = (gint64) 0;
	_tmp5_ = g_strdup ("");
	self->uri = _tmp5_;
	self->cover_uri = NULL;
	_tmp6_ = g_strdup ("");
	self->_album_key = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->_artist_key = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->_title_key = _tmp8_;
	self->priv->_cover_key = NULL;
	self->_order = 0;
}

static void
g4_music_finalize (GObject * obj)
{
	G4Music * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, G4_TYPE_MUSIC, G4Music);
	_g_free0 (self->album);
	_g_free0 (self->artist);
	_g_free0 (self->title);
	_g_free0 (self->album_artist);
	_g_free0 (self->genre);
	_g_free0 (self->uri);
	_g_free0 (self->cover_uri);
	_g_free0 (self->_album_key);
	_g_free0 (self->_artist_key);
	_g_free0 (self->_title_key);
	_g_free0 (self->priv->_cover_key);
	G_OBJECT_CLASS (g4_music_parent_class)->finalize (obj);
}

static GType
g4_music_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (G4MusicClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) g4_music_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (G4Music), 0, (GInstanceInitFunc) g4_music_instance_init, NULL };
	GType g4_music_type_id;
	g4_music_type_id = g_type_register_static (G_TYPE_OBJECT, "G4Music", &g_define_type_info, 0);
	G4Music_private_offset = g_type_add_instance_private (g4_music_type_id, sizeof (G4MusicPrivate));
	return g4_music_type_id;
}

GType
g4_music_get_type (void)
{
	static volatile gsize g4_music_type_id__once = 0;
	if (g_once_init_enter (&g4_music_type_id__once)) {
		GType g4_music_type_id;
		g4_music_type_id = g4_music_get_type_once ();
		g_once_init_leave (&g4_music_type_id__once, g4_music_type_id);
	}
	return g4_music_type_id__once;
}

static void
_vala_g4_music_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	G4Music * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_MUSIC, G4Music);
	switch (property_id) {
		case G4_MUSIC_ALBUM_KEY_PROPERTY:
		g_value_set_string (value, g4_music_get_album_key (self));
		break;
		case G4_MUSIC_ARTIST_NAME_PROPERTY:
		g_value_set_string (value, g4_music_get_artist_name (self));
		break;
		case G4_MUSIC_COVER_KEY_PROPERTY:
		g_value_set_string (value, g4_music_get_cover_key (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_g4_music_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	G4Music * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, G4_TYPE_MUSIC, G4Music);
	switch (property_id) {
		case G4_MUSIC_COVER_KEY_PROPERTY:
		g4_music_set_cover_key (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gboolean
g4_is_music_type (const gchar* content_type)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (content_type != NULL, FALSE);
	if (g_content_type_is_mime_type (content_type, "audio/*")) {
		_tmp1_ = !g_str_has_suffix (content_type, "pls");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !g_str_has_suffix (content_type, "url");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gunichar
g4_find_first_letter (const gchar* text)
{
	gint index = 0;
	gint next = 0;
	gunichar c = 0U;
	gunichar result;
	g_return_val_if_fail (text != NULL, 0U);
	index = 0;
	next = 0;
	c = (gunichar) 0;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = string_get_next_char (text, &next, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		if (g_unichar_isalpha (c)) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = g_unichar_iswide_cjk (c);
		}
		if (_tmp2_) {
			result = c;
			return result;
		}
		index = next;
	}
	result = (gunichar) 0;
	return result;
}

gchar*
g4_get_display_name (const gchar* uri)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	_tmp1_ = _tmp0_;
	_tmp2_ = g4_get_file_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
g4_get_file_display_name (GFile* file)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp1_ = g_file_get_basename (file);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	name = (gchar*) _tmp3_;
	_tmp5_ = name;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 0) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = name;
		_tmp4_ = g_strcmp0 (_tmp8_, "/") == 0;
	}
	if (_tmp4_) {
		gchar* _tmp9_;
		_tmp9_ = g_file_get_parse_name (file);
		_g_free0 (name);
		name = _tmp9_;
	}
	_tmp10_ = name;
	_tmp11_ = name;
	_tmp12_ = string_substring (_tmp10_, (glong) 0, (glong) string_index_of_char (_tmp11_, (gunichar) '.', 0));
	result = _tmp12_;
	_g_free0 (name);
	_g_free0 (_tmp0_);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gchar*
g4_get_uri_with_end_sep (GFile* file)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = uri;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (string_get (_tmp1_, (glong) (_tmp4_ - 1)) != '/') {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = uri;
		_tmp6_ = g_strconcat (_tmp5_, "/", NULL);
		_g_free0 (uri);
		uri = _tmp6_;
	}
	result = uri;
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gchar*
g4_parse_abbreviation (const gchar* text)
{
	GString* sb = NULL;
	GString* _tmp0_;
	gint char_count = 0;
	gchar** arr = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint arr_length1;
	gint _arr_size_;
	gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	char_count = 0;
	_tmp2_ = _tmp1_ = g_str_tokenize_and_fold (text, "", NULL);
	arr = _tmp2_;
	arr_length1 = _vala_array_length (_tmp1_);
	_arr_size_ = arr_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* s = NULL;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				gunichar c = 0U;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = arr;
				_tmp6__length1 = arr_length1;
				if (i < _tmp6__length1) {
					_tmp5_ = char_count < 2;
				} else {
					_tmp5_ = FALSE;
				}
				if (!_tmp5_) {
					break;
				}
				_tmp7_ = arr;
				_tmp7__length1 = arr_length1;
				_tmp8_ = _tmp7_[i];
				s = _tmp8_;
				c = (gunichar) 0;
				_tmp10_ = s;
				if (g_ascii_strncasecmp (_tmp10_, "feat", (gsize) 4) != 0) {
					const gchar* _tmp11_;
					_tmp11_ = s;
					c = g4_find_first_letter (_tmp11_);
					_tmp9_ = c > ((gunichar) 0);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					GString* _tmp12_;
					gint _tmp13_;
					_tmp12_ = sb;
					g_string_append_unichar (_tmp12_, c);
					_tmp13_ = char_count;
					char_count = _tmp13_ + 1;
					if (char_count >= 2) {
						break;
					}
				}
			}
		}
	}
	if (char_count >= 2) {
		GString* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = sb;
		_tmp15_ = _tmp14_->str;
		_tmp16_ = g_utf8_strup (_tmp15_, (gssize) -1);
		result = _tmp16_;
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (sb);
		return result;
	} else {
		if (g_utf8_strlen (text, (gssize) -1) > 2) {
			gint index = 0;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			index = string_index_of_nth_char (text, (glong) 2);
			_tmp17_ = string_substring (text, (glong) 0, (glong) index);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_utf8_strup (_tmp18_, (gssize) -1);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp18_);
			result = _tmp20_;
			arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
			_g_string_free0 (sb);
			return result;
		}
	}
	_tmp21_ = g_utf8_strup (text, (gssize) -1);
	result = _tmp21_;
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (sb);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

