/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp.data;

import java.util.Arrays;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ByteRangeLocation {
    public static From from(int offset) {
        return new From(offset);
    }

    public static OffsetLength from(int offset, int length) {
        return new OffsetLength(offset, length);
    }

    public static byte[] extract(byte[] bytes, ByteRangeLocation location) {
        if (location instanceof OffsetLength) {
            OffsetLength ol = (OffsetLength)location;
            return Arrays.copyOfRange(bytes, ol.offset(), ol.offset() + ol.length());
        }
        if (location instanceof From) {
            From from = (From)location;
            return Arrays.copyOfRange(bytes, from.offset(), bytes.length);
        }
        throw new IllegalArgumentException("Unknown ByteRangeLocation type");
    }

    public record From(int offset) implements ByteRangeLocation
    {
    }

    public record OffsetLength(int offset, int length) implements ByteRangeLocation
    {
    }
}

