/* actions.c generated by valac 0.56.17, the Vala compiler
 * generated from actions.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "actions.h"
#include <gio/gio.h>
#include <glib-object.h>
#include "gnome-pomodoro.h"
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

#define ACTIONS_ACTION_PATH_PREFIX "/org/gnome/pomodoro/plugins/actions/action"
#define ACTIONS_ACTION_PATH_SUFFIX "/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	ACTIONS_ACTION_MANAGER_0_PROPERTY,
	ACTIONS_ACTION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* actions_action_manager_properties[ACTIONS_ACTION_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	ACTIONS_ACTION_MANAGER_ACTIONS_CHANGED_SIGNAL,
	ACTIONS_ACTION_MANAGER_NUM_SIGNALS
};
static guint actions_action_manager_signals[ACTIONS_ACTION_MANAGER_NUM_SIGNALS] = {0};

#define ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS (actions_application_extension_internals_get_type ())
#define ACTIONS_APPLICATION_EXTENSION_INTERNALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS, ActionsApplicationExtensionInternals))
#define ACTIONS_APPLICATION_EXTENSION_INTERNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS, ActionsApplicationExtensionInternalsClass))
#define ACTIONS_IS_APPLICATION_EXTENSION_INTERNALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS))
#define ACTIONS_IS_APPLICATION_EXTENSION_INTERNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS))
#define ACTIONS_APPLICATION_EXTENSION_INTERNALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS, ActionsApplicationExtensionInternalsClass))

typedef struct _ActionsApplicationExtensionInternals ActionsApplicationExtensionInternals;
typedef struct _ActionsApplicationExtensionInternalsClass ActionsApplicationExtensionInternalsClass;
typedef struct _ActionsApplicationExtensionInternalsPrivate ActionsApplicationExtensionInternalsPrivate;
enum  {
	ACTIONS_APPLICATION_EXTENSION_INTERNALS_0_PROPERTY,
	ACTIONS_APPLICATION_EXTENSION_INTERNALS_NUM_PROPERTIES
};
static GParamSpec* actions_application_extension_internals_properties[ACTIONS_APPLICATION_EXTENSION_INTERNALS_NUM_PROPERTIES];
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _actions_context_free0(var) ((var == NULL) ? NULL : (var = (actions_context_free (var), NULL)))
enum  {
	ACTIONS_APPLICATION_EXTENSION_0_PROPERTY,
	ACTIONS_APPLICATION_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* actions_application_extension_properties[ACTIONS_APPLICATION_EXTENSION_NUM_PROPERTIES];
enum  {
	ACTIONS_PREFERENCES_DIALOG_EXTENSION_0_PROPERTY,
	ACTIONS_PREFERENCES_DIALOG_EXTENSION_NUM_PROPERTIES
};
static GParamSpec* actions_preferences_dialog_extension_properties[ACTIONS_PREFERENCES_DIALOG_EXTENSION_NUM_PROPERTIES];

struct _ActionsActionManagerPrivate {
	GList* actions;
	GHashTable* actions_hash;
	GSettings* settings;
};

struct _ActionsApplicationExtensionInternals {
	GObject parent_instance;
	ActionsApplicationExtensionInternalsPrivate * priv;
};

struct _ActionsApplicationExtensionInternalsClass {
	GObjectClass parent_class;
};

struct _ActionsApplicationExtensionInternalsPrivate {
	GAsyncQueue* jobs_queue;
	GThread* jobs_thread;
	ActionsActionManager* actions_manager;
	PomodoroTimer* timer;
};

struct _ActionsApplicationExtensionPrivate {
	GtkCssProvider* css_provider;
	ActionsApplicationExtensionInternals* internals;
};

struct _ActionsPreferencesDialogExtensionPrivate {
	PomodoroPreferencesDialog* dialog;
	GList* rows;
};

static gint ActionsActionManager_private_offset;
static gpointer actions_action_manager_parent_class = NULL;
static ActionsActionManager* actions_action_manager_instance;
static ActionsActionManager* actions_action_manager_instance = NULL;
static GType actions_action_manager_type_id = 0;
static gint ActionsApplicationExtensionInternals_private_offset;
static gpointer actions_application_extension_internals_parent_class = NULL;
static GType actions_application_extension_internals_type_id = 0;
static gint ActionsApplicationExtension_private_offset;
static gpointer actions_application_extension_parent_class = NULL;
static PomodoroApplicationExtensionIface * actions_application_extension_pomodoro_application_extension_parent_iface = NULL;
static GType actions_application_extension_type_id = 0;
static gint ActionsPreferencesDialogExtension_private_offset;
static gpointer actions_preferences_dialog_extension_parent_class = NULL;
static PomodoroPreferencesDialogExtensionIface * actions_preferences_dialog_extension_pomodoro_preferences_dialog_extension_parent_iface = NULL;
static GType actions_preferences_dialog_extension_type_id = 0;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void actions_action_manager_populate (ActionsActionManager* self);
static void _g_free0_ (gpointer var);
static void actions_action_manager_remove_internal (ActionsActionManager* self,
                                             ActionsAction* action);
static gint actions_action_manager_extract_id (const gchar* path);
static guint actions_action_manager_get_next_id (ActionsActionManager* self);
static void actions_action_manager_add_internal (ActionsActionManager* self,
                                          ActionsAction* action,
                                          gint position);
static void actions_action_manager_on_settings_changed (ActionsActionManager* self,
                                                 const gchar* key);
static void actions_action_manager_real_dispose (GObject* base);
static void actions_action_manager_real_actions_changed (ActionsActionManager* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GObject * actions_action_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _actions_action_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
static void actions_action_manager_finalize (GObject * obj);
GType actions_application_extension_internals_register_type (GTypeModule * module);
VALA_EXTERN GType actions_application_extension_internals_get_type (void) G_GNUC_CONST ;
static gboolean actions_application_extension_internals_jobs_thread_func (ActionsApplicationExtensionInternals* self);
static void actions_application_extension_internals_on_timer_is_paused_notify (ActionsApplicationExtensionInternals* self);
static void actions_application_extension_internals_on_timer_state_changed (ActionsApplicationExtensionInternals* self,
                                                                     PomodoroTimerState* state,
                                                                     PomodoroTimerState* previous_state);
static void actions_application_extension_internals_real_dispose (GObject* base);
VALA_EXTERN ActionsApplicationExtensionInternals* actions_application_extension_internals_new (void);
VALA_EXTERN ActionsApplicationExtensionInternals* actions_application_extension_internals_construct (GType object_type);
static GObject * actions_application_extension_internals_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties);
static void _actions_context_free0_ (gpointer var);
static gpointer _actions_application_extension_internals_jobs_thread_func_gthread_func (gpointer self);
static void _actions_application_extension_internals_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                                   PomodoroTimerState* state,
                                                                                                   PomodoroTimerState* previous_state,
                                                                                                   gpointer self);
static void _actions_application_extension_internals_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self);
static void actions_application_extension_internals_finalize (GObject * obj);
static void actions_application_extension_real_dispose (GObject* base);
static GObject * actions_application_extension_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void actions_application_extension_finalize (GObject * obj);
static void actions_preferences_dialog_extension_setup_main_page (ActionsPreferencesDialogExtension* self);
static void actions_preferences_dialog_extension_on_row_activated (ActionsPreferencesDialogExtension* self,
                                                            GtkListBox* listbox,
                                                            GtkListBoxRow* row);
static void _actions_preferences_dialog_extension_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                        GtkListBoxRow* row,
                                                                                        gpointer self);
static GtkListBoxRow* actions_preferences_dialog_extension_create_row (ActionsPreferencesDialogExtension* self,
                                                                const gchar* label,
                                                                const gchar* name);
static GObject * actions_preferences_dialog_extension_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static void actions_preferences_dialog_extension_finalize (GObject * obj);
GType actions_action_list_box_row_register_type (GTypeModule * module);
GType actions_action_page_register_type (GTypeModule * module);
GType actions_action_register_type (GTypeModule * module);
GType actions_preferences_page_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
actions_context_copy (const ActionsContext* self,
                      ActionsContext* dest)
{
	ActionsAction* _tmp0_;
	ActionsAction* _tmp1_;
	_tmp0_ = (*self).action;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).action);
	(*dest).action = _tmp1_;
	(*dest).triggers = (*self).triggers;
	(*dest).state = (*self).state;
	(*dest).elapsed = (*self).elapsed;
	(*dest).duration = (*self).duration;
}

void
actions_context_destroy (ActionsContext* self)
{
	_g_object_unref0 ((*self).action);
}

ActionsContext*
actions_context_dup (const ActionsContext* self)
{
	ActionsContext* dup;
	dup = g_new0 (ActionsContext, 1);
	actions_context_copy (self, dup);
	return dup;
}

void
actions_context_free (ActionsContext* self)
{
	actions_context_destroy (self);
	g_free (self);
}

static GType
actions_context_get_type_once (void)
{
	GType actions_context_type_id;
	actions_context_type_id = g_boxed_type_register_static ("ActionsContext", (GBoxedCopyFunc) actions_context_dup, (GBoxedFreeFunc) actions_context_free);
	return actions_context_type_id;
}

GType
actions_context_get_type (void)
{
	static volatile gsize actions_context_type_id__once = 0;
	if (g_once_init_enter (&actions_context_type_id__once)) {
		GType actions_context_type_id;
		actions_context_type_id = actions_context_get_type_once ();
		g_once_init_leave (&actions_context_type_id__once, actions_context_type_id);
	}
	return actions_context_type_id__once;
}

static inline gpointer
actions_action_manager_get_instance_private (ActionsActionManager* self)
{
	return G_STRUCT_MEMBER_P (self, ActionsActionManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

ActionsActionManager*
actions_action_manager_get_instance (void)
{
	ActionsActionManager* _tmp0_;
	ActionsActionManager* _tmp1_;
	ActionsActionManager* result;
	_tmp0_ = actions_action_manager_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GList*
actions_action_manager_get_actions (ActionsActionManager* self)
{
	GList* actions = NULL;
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	actions = NULL;
	_tmp0_ = self->priv->actions;
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp0_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			ActionsAction* _tmp1_;
			ActionsAction* action = NULL;
			_tmp1_ = _g_object_ref0 ((ActionsAction*) action_it->data);
			action = _tmp1_;
			{
				ActionsAction* _tmp2_;
				_tmp2_ = action;
				actions = g_list_append (actions, _tmp2_);
				_g_object_unref0 (action);
			}
		}
	}
	result = actions;
	return result;
}

/**
         * Load items from settings
         */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
actions_action_manager_populate (ActionsActionManager* self)
{
	GList* new_actions = NULL;
	GHashTable* new_paths_hash = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSettings* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	GList* _tmp25_;
	GList* _tmp34_;
	g_return_if_fail (self != NULL);
	new_actions = NULL;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	new_paths_hash = _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp5_ = _tmp4_ = g_settings_get_strv (_tmp3_, "actions-list");
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp5_;
		path_collection_length1 = _vala_array_length (_tmp4_);
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			gchar* _tmp6_;
			gchar* path = NULL;
			_tmp6_ = g_strdup (path_collection[path_it]);
			path = _tmp6_;
			{
				ActionsAction* action = NULL;
				GHashTable* _tmp7_;
				const gchar* _tmp8_;
				gconstpointer _tmp9_;
				ActionsAction* _tmp10_;
				ActionsAction* _tmp11_;
				ActionsAction* _tmp19_;
				ActionsAction* _tmp20_;
				GHashTable* _tmp21_;
				ActionsAction* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp7_ = self->priv->actions_hash;
				_tmp8_ = path;
				_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 ((ActionsAction*) _tmp9_);
				action = _tmp10_;
				_tmp11_ = action;
				if (_tmp11_ == NULL) {
					const gchar* _tmp12_;
					ActionsAction* _tmp13_;
					GHashTable* _tmp14_;
					ActionsAction* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					ActionsAction* _tmp18_;
					_tmp12_ = path;
					_tmp13_ = actions_action_new_for_path (_tmp12_);
					_g_object_unref0 (action);
					action = _tmp13_;
					_tmp14_ = self->priv->actions_hash;
					_tmp15_ = action;
					_tmp16_ = actions_action_get_path (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = action;
					g_hash_table_insert (_tmp14_, _tmp17_, _tmp18_);
				}
				_tmp19_ = action;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				new_actions = g_list_append (new_actions, _tmp20_);
				_tmp21_ = new_paths_hash;
				_tmp22_ = action;
				_tmp23_ = actions_action_get_path (_tmp22_);
				_tmp24_ = _tmp23_;
				g_hash_table_add (_tmp21_, _tmp24_);
				_g_object_unref0 (action);
				_g_free0 (path);
			}
		}
		path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp25_ = self->priv->actions;
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp25_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			ActionsAction* _tmp26_;
			ActionsAction* action = NULL;
			_tmp26_ = _g_object_ref0 ((ActionsAction*) action_it->data);
			action = _tmp26_;
			{
				GHashTable* _tmp27_;
				ActionsAction* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gboolean _tmp32_;
				_tmp27_ = new_paths_hash;
				_tmp28_ = action;
				_tmp29_ = actions_action_get_path (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = _tmp30_;
				_tmp32_ = !g_hash_table_contains (_tmp27_, _tmp31_);
				_g_free0 (_tmp31_);
				if (_tmp32_) {
					ActionsAction* _tmp33_;
					_tmp33_ = action;
					actions_action_manager_remove_internal (self, _tmp33_);
				}
				_g_object_unref0 (action);
			}
		}
	}
	_tmp34_ = new_actions;
	new_actions = NULL;
	(self->priv->actions == NULL) ? NULL : (self->priv->actions = (_g_list_free__g_object_unref0_ (self->priv->actions), NULL));
	self->priv->actions = _tmp34_;
	g_signal_emit (self, actions_action_manager_signals[ACTIONS_ACTION_MANAGER_ACTIONS_CHANGED_SIGNAL], 0);
	_g_hash_table_unref0 (new_paths_hash);
	(new_actions == NULL) ? NULL : (new_actions = (_g_list_free__g_object_unref0_ (new_actions), NULL));
}

/**
         * Extract action ID from path
         */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
actions_action_manager_extract_id (const gchar* path)
{
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (path != NULL, 0);
	if (g_str_has_prefix (path, ACTIONS_ACTION_PATH_PREFIX)) {
		_tmp0_ = g_str_has_suffix (path, ACTIONS_ACTION_PATH_SUFFIX);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* path_part = NULL;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp1_ = strlen (ACTIONS_ACTION_PATH_PREFIX);
		_tmp2_ = _tmp1_;
		_tmp3_ = strlen (path);
		_tmp4_ = _tmp3_;
		_tmp5_ = strlen (ACTIONS_ACTION_PATH_SUFFIX);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_slice (path, (glong) _tmp2_, (glong) (_tmp4_ - _tmp6_));
		path_part = _tmp7_;
		_tmp8_ = path_part;
		result = atoi (_tmp8_);
		_g_free0 (path_part);
		return result;
	}
	result = -1;
	return result;
}

static guint
actions_action_manager_get_next_id (ActionsActionManager* self)
{
	gint next_id = 0;
	GList* iter = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	next_id = 0;
	_tmp0_ = self->priv->actions;
	_tmp1_ = g_list_first (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GList* _tmp2_;
		ActionsAction* action = NULL;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		ActionsAction* _tmp5_;
		ActionsAction* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp2_ = iter;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _g_object_ref0 ((ActionsAction*) _tmp4_);
		action = _tmp5_;
		_tmp6_ = action;
		_tmp7_ = actions_action_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = actions_action_manager_extract_id (_tmp9_) == next_id;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			gint _tmp11_;
			GList* _tmp12_;
			GList* _tmp13_;
			_tmp11_ = next_id;
			next_id = _tmp11_ + 1;
			_tmp12_ = self->priv->actions;
			_tmp13_ = g_list_first (_tmp12_);
			iter = _tmp13_;
		} else {
			GList* _tmp14_;
			GList* _tmp15_;
			_tmp14_ = iter;
			_tmp15_ = _tmp14_->next;
			iter = _tmp15_;
		}
		_g_object_unref0 (action);
	}
	result = (guint) next_id;
	return result;
}

static void
actions_action_manager_add_internal (ActionsActionManager* self,
                                     ActionsAction* action,
                                     gint position)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ActionsAction* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->actions_hash;
	_tmp1_ = actions_action_get_path (action);
	_tmp2_ = _tmp1_;
	g_hash_table_insert (_tmp0_, _tmp2_, action);
	_tmp3_ = _g_object_ref0 (action);
	self->priv->actions = g_list_insert (self->priv->actions, _tmp3_, position);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
actions_action_manager_remove_internal (ActionsActionManager* self,
                                        ActionsAction* action)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->actions_hash;
	_tmp1_ = actions_action_get_path (action);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	g_hash_table_remove (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	self->priv->actions = vala_g_list_remove_full (self->priv->actions, action, _g_object_unref0_);
	actions_action_reset (action);
}

void
actions_action_manager_add (ActionsActionManager* self,
                            ActionsAction* action,
                            gint position)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = actions_action_get_path (action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup_printf ("/org/gnome/pomodoro/plugins/actions/action%u/", actions_action_manager_get_next_id (self));
		_tmp5_ = _tmp4_;
		actions_action_set_path (action, _tmp5_);
		_g_free0 (_tmp5_);
	}
	actions_action_manager_add_internal (self, action, position);
	g_signal_emit (self, actions_action_manager_signals[ACTIONS_ACTION_MANAGER_ACTIONS_CHANGED_SIGNAL], 0);
}

void
actions_action_manager_remove (ActionsActionManager* self,
                               ActionsAction* action)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	actions_action_manager_remove_internal (self, action);
	g_signal_emit (self, actions_action_manager_signals[ACTIONS_ACTION_MANAGER_ACTIONS_CHANGED_SIGNAL], 0);
}

static void
actions_action_manager_on_settings_changed (ActionsActionManager* self,
                                            const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("actions-list")))) {
		switch (0) {
			default:
			{
				actions_action_manager_populate (self);
				break;
			}
		}
	}
}

static void
actions_action_manager_real_dispose (GObject* base)
{
	ActionsActionManager * self;
	self = (ActionsActionManager*) base;
	actions_action_manager_instance = NULL;
	G_OBJECT_CLASS (actions_action_manager_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

ActionsActionManager*
actions_action_manager_construct (GType object_type)
{
	ActionsActionManager * self = NULL;
	self = (ActionsActionManager*) g_object_new (object_type, NULL);
	return self;
}

ActionsActionManager*
actions_action_manager_new (void)
{
	return actions_action_manager_construct (ACTIONS_TYPE_ACTION_MANAGER);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
actions_action_manager_real_actions_changed (ActionsActionManager* self)
{
	gchar** paths = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint paths_length1;
	gint _paths_size_;
	gchar** new_paths = NULL;
	gchar** _tmp3_;
	gint new_paths_length1;
	gint _new_paths_size_;
	gboolean has_changed = FALSE;
	GList* _tmp4_;
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "actions-list");
	paths = _tmp2_;
	paths_length1 = _vala_array_length (_tmp1_);
	_paths_size_ = paths_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	new_paths = _tmp3_;
	new_paths_length1 = 0;
	_new_paths_size_ = new_paths_length1;
	has_changed = FALSE;
	_tmp4_ = self->priv->actions;
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp4_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			ActionsAction* _tmp5_;
			ActionsAction* action = NULL;
			_tmp5_ = _g_object_ref0 ((ActionsAction*) action_it->data);
			action = _tmp5_;
			{
				ActionsAction* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp6_ = action;
				_tmp7_ = actions_action_get_path (_tmp6_);
				_tmp8_ = _tmp7_;
				_vala_array_add1 (&new_paths, &new_paths_length1, &_new_paths_size_, _tmp8_);
				_g_object_unref0 (action);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = paths;
				_tmp11__length1 = paths_length1;
				_tmp12_ = _tmp11_[i];
				_tmp13_ = new_paths;
				_tmp13__length1 = new_paths_length1;
				_tmp14_ = _tmp13_[i];
				if (g_strcmp0 (_tmp12_, _tmp14_) != 0) {
					has_changed = TRUE;
					break;
				}
				_tmp15_ = paths;
				_tmp15__length1 = paths_length1;
				_tmp16_ = _tmp15_[i];
				if (_tmp16_ == NULL) {
					break;
				}
			}
		}
	}
	if (has_changed) {
		GSettings* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp17_ = self->priv->settings;
		_tmp18_ = new_paths;
		_tmp18__length1 = new_paths_length1;
		g_settings_set_strv (_tmp17_, "actions-list", _tmp18_);
	}
	new_paths = (_vala_array_free (new_paths, new_paths_length1, (GDestroyNotify) g_free), NULL);
	paths = (_vala_array_free (paths, paths_length1, (GDestroyNotify) g_free), NULL);
}

static void
_actions_action_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	actions_action_manager_on_settings_changed ((ActionsActionManager*) self, key);
}

static GObject *
actions_action_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ActionsActionManager * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	parent_class = G_OBJECT_CLASS (actions_action_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_ACTION_MANAGER, ActionsActionManager);
	actions_action_manager_instance = self;
	_tmp0_ = g_settings_new ("org.gnome.pomodoro.plugins.actions");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _actions_action_manager_on_settings_changed_g_settings_changed, self, 0);
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->actions_hash);
	self->priv->actions_hash = _tmp4_;
	actions_action_manager_populate (self);
	return obj;
}

static void
actions_action_manager_class_init (ActionsActionManagerClass * klass,
                                   gpointer klass_data)
{
	actions_action_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ActionsActionManager_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) actions_action_manager_real_dispose;
	((ActionsActionManagerClass *) klass)->actions_changed = actions_action_manager_real_actions_changed;
	G_OBJECT_CLASS (klass)->constructor = actions_action_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = actions_action_manager_finalize;
	/**
	         * Save actions to settings
	         */
	actions_action_manager_signals[ACTIONS_ACTION_MANAGER_ACTIONS_CHANGED_SIGNAL] = g_signal_new ("actions-changed", ACTIONS_TYPE_ACTION_MANAGER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ActionsActionManagerClass, actions_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
actions_action_manager_instance_init (ActionsActionManager * self,
                                      gpointer klass)
{
	self->priv = actions_action_manager_get_instance_private (self);
}

static void
actions_action_manager_finalize (GObject * obj)
{
	ActionsActionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_ACTION_MANAGER, ActionsActionManager);
	(self->priv->actions == NULL) ? NULL : (self->priv->actions = (_g_list_free__g_object_unref0_ (self->priv->actions), NULL));
	_g_hash_table_unref0 (self->priv->actions_hash);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (actions_action_manager_parent_class)->finalize (obj);
}

GType
actions_action_manager_get_type (void)
{
	return actions_action_manager_type_id;
}

GType
actions_action_manager_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ActionsActionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) actions_action_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ActionsActionManager), 0, (GInstanceInitFunc) actions_action_manager_instance_init, NULL };
	actions_action_manager_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ActionsActionManager", &g_define_type_info, 0);
	ActionsActionManager_private_offset = sizeof (ActionsActionManagerPrivate);
	return actions_action_manager_type_id;
}

static inline gpointer
actions_application_extension_internals_get_instance_private (ActionsApplicationExtensionInternals* self)
{
	return G_STRUCT_MEMBER_P (self, ActionsApplicationExtensionInternals_private_offset);
}

static gboolean
actions_application_extension_internals_jobs_thread_func (ActionsApplicationExtensionInternals* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		ActionsContext* context = NULL;
		GAsyncQueue* _tmp0_;
		gpointer _tmp1_;
		ActionsContext* _tmp2_;
		_tmp0_ = self->priv->jobs_queue;
		_tmp1_ = g_async_queue_pop (_tmp0_);
		context = (ActionsContext*) _tmp1_;
		_tmp2_ = context;
		if ((*_tmp2_).triggers != ACTIONS_TRIGGER_NONE) {
			ActionsContext* _tmp3_;
			ActionsAction* _tmp4_;
			ActionsContext* _tmp5_;
			ActionsContext _tmp6_;
			_tmp3_ = context;
			_tmp4_ = (*_tmp3_).action;
			_tmp5_ = context;
			_tmp6_ = *_tmp5_;
			actions_action_execute (_tmp4_, &_tmp6_);
		} else {
			_actions_context_free0 (context);
			break;
		}
		_actions_context_free0 (context);
	}
	g_object_unref ((GObject*) self);
	result = TRUE;
	return result;
}

static gpointer
_actions_context_dup0 (gpointer self)
{
	return self ? actions_context_dup (self) : NULL;
}

static void
actions_application_extension_internals_on_timer_is_paused_notify (ActionsApplicationExtensionInternals* self)
{
	PomodoroTimer* timer = NULL;
	PomodoroTimer* _tmp0_;
	PomodoroTimer* _tmp1_;
	GList* actions = NULL;
	ActionsActionManager* _tmp2_;
	ActionsActionManager* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	ActionsState states = 0U;
	PomodoroTimer* _tmp6_;
	PomodoroTimerState* _tmp7_;
	PomodoroTimerState* _tmp8_;
	ActionsTrigger _tmp9_ = 0U;
	PomodoroTimer* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	ActionsTrigger triggers = 0U;
	GList* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	timer = _tmp1_;
	_tmp2_ = actions_action_manager_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = actions_action_manager_get_actions (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	actions = _tmp5_;
	_tmp6_ = timer;
	_tmp7_ = pomodoro_timer_get_state (_tmp6_);
	_tmp8_ = _tmp7_;
	states = actions_state_from_timer_state (_tmp8_);
	_tmp10_ = timer;
	_tmp11_ = pomodoro_timer_get_is_paused (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		_tmp9_ = ACTIONS_TRIGGER_PAUSE;
	} else {
		_tmp9_ = ACTIONS_TRIGGER_RESUME;
	}
	triggers = _tmp9_;
	_tmp13_ = actions;
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp13_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			ActionsAction* action = NULL;
			action = (ActionsAction*) action_it->data;
			{
				ActionsState states_match = 0U;
				ActionsAction* _tmp14_;
				ActionsState _tmp15_;
				ActionsState _tmp16_;
				ActionsTrigger triggers_match = 0U;
				ActionsAction* _tmp17_;
				ActionsTrigger _tmp18_;
				ActionsTrigger _tmp19_;
				gboolean _tmp20_ = FALSE;
				_tmp14_ = action;
				_tmp15_ = actions_action_get_states (_tmp14_);
				_tmp16_ = _tmp15_;
				states_match = _tmp16_ & states;
				_tmp17_ = action;
				_tmp18_ = actions_action_get_triggers (_tmp17_);
				_tmp19_ = _tmp18_;
				triggers_match = _tmp19_ & triggers;
				if (states_match != 0) {
					_tmp20_ = triggers_match != 0;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					GAsyncQueue* _tmp21_;
					ActionsAction* _tmp22_;
					ActionsAction* _tmp23_;
					PomodoroTimer* _tmp24_;
					PomodoroTimerState* _tmp25_;
					PomodoroTimerState* _tmp26_;
					gdouble _tmp27_;
					gdouble _tmp28_;
					PomodoroTimer* _tmp29_;
					PomodoroTimerState* _tmp30_;
					PomodoroTimerState* _tmp31_;
					gdouble _tmp32_;
					gdouble _tmp33_;
					ActionsContext _tmp34_ = {0};
					ActionsContext _tmp35_;
					ActionsContext* _tmp36_;
					_tmp21_ = self->priv->jobs_queue;
					_tmp22_ = action;
					_tmp23_ = _g_object_ref0 (_tmp22_);
					_tmp24_ = timer;
					_tmp25_ = pomodoro_timer_get_state (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = pomodoro_timer_state_get_elapsed (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = timer;
					_tmp30_ = pomodoro_timer_get_state (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = pomodoro_timer_state_get_duration (_tmp31_);
					_tmp33_ = _tmp32_;
					memset (&_tmp34_, 0, sizeof (ActionsContext));
					_g_object_unref0 (_tmp34_.action);
					_tmp34_.action = _tmp23_;
					_tmp34_.triggers = triggers_match;
					_tmp34_.state = states_match;
					_tmp34_.elapsed = _tmp28_;
					_tmp34_.duration = _tmp33_;
					_tmp35_ = _tmp34_;
					_tmp36_ = _actions_context_dup0 (&_tmp35_);
					g_async_queue_push (_tmp21_, _tmp36_);
					actions_context_destroy (&_tmp35_);
				}
			}
		}
	}
	(actions == NULL) ? NULL : (actions = (g_list_free (actions), NULL));
	_g_object_unref0 (timer);
}

static void
actions_application_extension_internals_on_timer_state_changed (ActionsApplicationExtensionInternals* self,
                                                                PomodoroTimerState* state,
                                                                PomodoroTimerState* previous_state)
{
	GList* actions = NULL;
	ActionsActionManager* _tmp0_;
	ActionsActionManager* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	ActionsState states_a = 0U;
	ActionsState states_b = 0U;
	ActionsTrigger triggers_a = 0U;
	ActionsTrigger triggers_b = 0U;
	GList* _tmp4_;
	GList* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (previous_state != NULL);
	_tmp0_ = actions_action_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = actions_action_manager_get_actions (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	actions = _tmp3_;
	states_a = actions_state_from_timer_state (previous_state);
	states_b = actions_state_from_timer_state (state);
	triggers_a = ACTIONS_TRIGGER_NONE;
	triggers_b = ACTIONS_TRIGGER_NONE;
	if (G_TYPE_CHECK_INSTANCE_TYPE (previous_state, POMODORO_TYPE_DISABLED_STATE)) {
		triggers_b |= ACTIONS_TRIGGER_ENABLE;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (state, POMODORO_TYPE_DISABLED_STATE)) {
		triggers_a |= ACTIONS_TRIGGER_DISABLE;
	} else {
		triggers_b |= ACTIONS_TRIGGER_START;
	}
	if (pomodoro_timer_state_is_completed (previous_state)) {
		triggers_a |= ACTIONS_TRIGGER_COMPLETE;
	} else {
		triggers_a |= ACTIONS_TRIGGER_SKIP;
	}
	_tmp4_ = actions;
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp4_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			ActionsAction* action = NULL;
			action = (ActionsAction*) action_it->data;
			{
				ActionsState states_match = 0U;
				ActionsAction* _tmp5_;
				ActionsState _tmp6_;
				ActionsState _tmp7_;
				ActionsTrigger triggers_match = 0U;
				ActionsAction* _tmp8_;
				ActionsTrigger _tmp9_;
				ActionsTrigger _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp5_ = action;
				_tmp6_ = actions_action_get_states (_tmp5_);
				_tmp7_ = _tmp6_;
				states_match = _tmp7_ & states_a;
				_tmp8_ = action;
				_tmp9_ = actions_action_get_triggers (_tmp8_);
				_tmp10_ = _tmp9_;
				triggers_match = _tmp10_ & triggers_a;
				if (states_match != 0) {
					_tmp11_ = triggers_match != 0;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GAsyncQueue* _tmp12_;
					ActionsAction* _tmp13_;
					ActionsAction* _tmp14_;
					gdouble _tmp15_;
					gdouble _tmp16_;
					gdouble _tmp17_;
					gdouble _tmp18_;
					ActionsContext _tmp19_ = {0};
					ActionsContext _tmp20_;
					ActionsContext* _tmp21_;
					_tmp12_ = self->priv->jobs_queue;
					_tmp13_ = action;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_tmp15_ = pomodoro_timer_state_get_elapsed (previous_state);
					_tmp16_ = _tmp15_;
					_tmp17_ = pomodoro_timer_state_get_duration (previous_state);
					_tmp18_ = _tmp17_;
					memset (&_tmp19_, 0, sizeof (ActionsContext));
					_g_object_unref0 (_tmp19_.action);
					_tmp19_.action = _tmp14_;
					_tmp19_.triggers = triggers_match;
					_tmp19_.state = states_match;
					_tmp19_.elapsed = _tmp16_;
					_tmp19_.duration = _tmp18_;
					_tmp20_ = _tmp19_;
					_tmp21_ = _actions_context_dup0 (&_tmp20_);
					g_async_queue_push (_tmp12_, _tmp21_);
					actions_context_destroy (&_tmp20_);
				}
			}
		}
	}
	_tmp22_ = actions;
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp22_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			ActionsAction* action = NULL;
			action = (ActionsAction*) action_it->data;
			{
				ActionsState states_match = 0U;
				ActionsAction* _tmp23_;
				ActionsState _tmp24_;
				ActionsState _tmp25_;
				ActionsTrigger triggers_match = 0U;
				ActionsAction* _tmp26_;
				ActionsTrigger _tmp27_;
				ActionsTrigger _tmp28_;
				gboolean _tmp29_ = FALSE;
				_tmp23_ = action;
				_tmp24_ = actions_action_get_states (_tmp23_);
				_tmp25_ = _tmp24_;
				states_match = _tmp25_ & states_b;
				_tmp26_ = action;
				_tmp27_ = actions_action_get_triggers (_tmp26_);
				_tmp28_ = _tmp27_;
				triggers_match = _tmp28_ & triggers_b;
				if (states_match != 0) {
					_tmp29_ = triggers_match != 0;
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					GAsyncQueue* _tmp30_;
					ActionsAction* _tmp31_;
					ActionsAction* _tmp32_;
					gdouble _tmp33_;
					gdouble _tmp34_;
					gdouble _tmp35_;
					gdouble _tmp36_;
					ActionsContext _tmp37_ = {0};
					ActionsContext _tmp38_;
					ActionsContext* _tmp39_;
					_tmp30_ = self->priv->jobs_queue;
					_tmp31_ = action;
					_tmp32_ = _g_object_ref0 (_tmp31_);
					_tmp33_ = pomodoro_timer_state_get_elapsed (state);
					_tmp34_ = _tmp33_;
					_tmp35_ = pomodoro_timer_state_get_duration (state);
					_tmp36_ = _tmp35_;
					memset (&_tmp37_, 0, sizeof (ActionsContext));
					_g_object_unref0 (_tmp37_.action);
					_tmp37_.action = _tmp32_;
					_tmp37_.triggers = triggers_match;
					_tmp37_.state = states_match;
					_tmp37_.elapsed = _tmp34_;
					_tmp37_.duration = _tmp36_;
					_tmp38_ = _tmp37_;
					_tmp39_ = _actions_context_dup0 (&_tmp38_);
					g_async_queue_push (_tmp30_, _tmp39_);
					actions_context_destroy (&_tmp38_);
				}
			}
		}
	}
	(actions == NULL) ? NULL : (actions = (g_list_free (actions), NULL));
}

static void
actions_application_extension_internals_real_dispose (GObject* base)
{
	ActionsApplicationExtensionInternals * self;
	PomodoroDisabledState* _tmp0_;
	PomodoroDisabledState* _tmp1_;
	PomodoroTimer* _tmp2_;
	PomodoroTimerState* _tmp3_;
	PomodoroTimerState* _tmp4_;
	GAsyncQueue* _tmp5_;
	ActionsContext _tmp6_ = {0};
	ActionsContext _tmp7_;
	ActionsContext* _tmp8_;
	self = (ActionsApplicationExtensionInternals*) base;
	_tmp0_ = pomodoro_disabled_state_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->timer;
	_tmp3_ = pomodoro_timer_get_state (_tmp2_);
	_tmp4_ = _tmp3_;
	actions_application_extension_internals_on_timer_state_changed (self, (PomodoroTimerState*) _tmp1_, _tmp4_);
	_g_object_unref0 (_tmp1_);
	_tmp5_ = self->priv->jobs_queue;
	memset (&_tmp6_, 0, sizeof (ActionsContext));
	_tmp6_.triggers = ACTIONS_TRIGGER_NONE;
	_tmp7_ = _tmp6_;
	_tmp8_ = _actions_context_dup0 (&_tmp7_);
	g_async_queue_push (_tmp5_, _tmp8_);
	actions_context_destroy (&_tmp7_);
	G_OBJECT_CLASS (actions_application_extension_internals_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

ActionsApplicationExtensionInternals*
actions_application_extension_internals_construct (GType object_type)
{
	ActionsApplicationExtensionInternals * self = NULL;
	self = (ActionsApplicationExtensionInternals*) g_object_new (object_type, NULL);
	return self;
}

ActionsApplicationExtensionInternals*
actions_application_extension_internals_new (void)
{
	return actions_application_extension_internals_construct (ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS);
}

static void
_actions_context_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (actions_context_free (var), NULL));
}

static gpointer
_actions_application_extension_internals_jobs_thread_func_gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) actions_application_extension_internals_jobs_thread_func ((ActionsApplicationExtensionInternals*) self));
	g_object_unref (self);
	return result;
}

static void
_actions_application_extension_internals_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                              PomodoroTimerState* state,
                                                                                              PomodoroTimerState* previous_state,
                                                                                              gpointer self)
{
	actions_application_extension_internals_on_timer_state_changed ((ActionsApplicationExtensionInternals*) self, state, previous_state);
}

static void
_actions_application_extension_internals_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self)
{
	actions_application_extension_internals_on_timer_is_paused_notify ((ActionsApplicationExtensionInternals*) self);
}

static GObject *
actions_application_extension_internals_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ActionsApplicationExtensionInternals * self;
	ActionsActionManager* _tmp0_;
	GAsyncQueue* _tmp1_;
	GThread* _tmp2_;
	PomodoroTimer* _tmp3_;
	PomodoroTimer* _tmp4_;
	PomodoroTimer* _tmp5_;
	PomodoroTimer* _tmp6_;
	PomodoroTimer* _tmp7_;
	PomodoroTimerState* _tmp8_;
	PomodoroTimerState* _tmp9_;
	PomodoroTimer* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	parent_class = G_OBJECT_CLASS (actions_application_extension_internals_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS, ActionsApplicationExtensionInternals);
	_tmp0_ = actions_action_manager_new ();
	_g_object_unref0 (self->priv->actions_manager);
	self->priv->actions_manager = _tmp0_;
	_tmp1_ = g_async_queue_new_full (_actions_context_free0_);
	_g_async_queue_unref0 (self->priv->jobs_queue);
	self->priv->jobs_queue = _tmp1_;
	_tmp2_ = g_thread_new ("actions-queue", _actions_application_extension_internals_jobs_thread_func_gthread_func, g_object_ref (self));
	_g_thread_unref0 (self->priv->jobs_thread);
	self->priv->jobs_thread = _tmp2_;
	_tmp3_ = pomodoro_timer_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->timer);
	self->priv->timer = _tmp4_;
	_tmp5_ = self->priv->timer;
	g_signal_connect_object (_tmp5_, "state-changed", (GCallback) _actions_application_extension_internals_on_timer_state_changed_pomodoro_timer_state_changed, self, 0);
	_tmp6_ = self->priv->timer;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::is-paused", (GCallback) _actions_application_extension_internals_on_timer_is_paused_notify_g_object_notify, self, 0);
	_tmp7_ = self->priv->timer;
	_tmp8_ = pomodoro_timer_get_state (_tmp7_);
	_tmp9_ = _tmp8_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, POMODORO_TYPE_DISABLED_STATE)) {
		PomodoroTimer* _tmp10_;
		PomodoroTimerState* _tmp11_;
		PomodoroTimerState* _tmp12_;
		PomodoroDisabledState* _tmp13_;
		PomodoroDisabledState* _tmp14_;
		_tmp10_ = self->priv->timer;
		_tmp11_ = pomodoro_timer_get_state (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = pomodoro_disabled_state_new ();
		_tmp14_ = _tmp13_;
		actions_application_extension_internals_on_timer_state_changed (self, _tmp12_, (PomodoroTimerState*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	} else {
		PomodoroTimer* _tmp15_;
		PomodoroTimerState* _tmp16_;
		PomodoroTimerState* _tmp17_;
		PomodoroTimer* _tmp18_;
		PomodoroTimerState* _tmp19_;
		PomodoroTimerState* _tmp20_;
		_tmp15_ = self->priv->timer;
		_tmp16_ = pomodoro_timer_get_state (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->timer;
		_tmp19_ = pomodoro_timer_get_state (_tmp18_);
		_tmp20_ = _tmp19_;
		actions_application_extension_internals_on_timer_state_changed (self, _tmp17_, _tmp20_);
	}
	_tmp21_ = self->priv->timer;
	_tmp22_ = pomodoro_timer_get_is_paused (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_) {
		actions_application_extension_internals_on_timer_is_paused_notify (self);
	}
	g_object_ref ((GObject*) self);
	return obj;
}

static void
actions_application_extension_internals_class_init (ActionsApplicationExtensionInternalsClass * klass,
                                                    gpointer klass_data)
{
	actions_application_extension_internals_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ActionsApplicationExtensionInternals_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) actions_application_extension_internals_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = actions_application_extension_internals_constructor;
	G_OBJECT_CLASS (klass)->finalize = actions_application_extension_internals_finalize;
}

static void
actions_application_extension_internals_instance_init (ActionsApplicationExtensionInternals * self,
                                                       gpointer klass)
{
	self->priv = actions_application_extension_internals_get_instance_private (self);
}

static void
actions_application_extension_internals_finalize (GObject * obj)
{
	ActionsApplicationExtensionInternals * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_APPLICATION_EXTENSION_INTERNALS, ActionsApplicationExtensionInternals);
	_g_async_queue_unref0 (self->priv->jobs_queue);
	_g_thread_unref0 (self->priv->jobs_thread);
	_g_object_unref0 (self->priv->actions_manager);
	_g_object_unref0 (self->priv->timer);
	G_OBJECT_CLASS (actions_application_extension_internals_parent_class)->finalize (obj);
}

GType
actions_application_extension_internals_get_type (void)
{
	return actions_application_extension_internals_type_id;
}

GType
actions_application_extension_internals_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ActionsApplicationExtensionInternalsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) actions_application_extension_internals_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ActionsApplicationExtensionInternals), 0, (GInstanceInitFunc) actions_application_extension_internals_instance_init, NULL };
	actions_application_extension_internals_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ActionsApplicationExtensionInternals", &g_define_type_info, 0);
	ActionsApplicationExtensionInternals_private_offset = sizeof (ActionsApplicationExtensionInternalsPrivate);
	return actions_application_extension_internals_type_id;
}

static inline gpointer
actions_application_extension_get_instance_private (ActionsApplicationExtension* self)
{
	return G_STRUCT_MEMBER_P (self, ActionsApplicationExtension_private_offset);
}

static void
actions_application_extension_real_dispose (GObject* base)
{
	ActionsApplicationExtension * self;
	GdkScreen* _tmp0_;
	GtkCssProvider* _tmp1_;
	ActionsApplicationExtensionInternals* _tmp2_;
	self = (ActionsApplicationExtension*) base;
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = self->priv->css_provider;
	gtk_style_context_remove_provider_for_screen (_tmp0_, (GtkStyleProvider*) _tmp1_);
	_tmp2_ = self->priv->internals;
	g_object_run_dispose ((GObject*) _tmp2_);
	G_OBJECT_CLASS (actions_application_extension_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, peas_extension_base_get_type (), PeasExtensionBase));
}

ActionsApplicationExtension*
actions_application_extension_construct (GType object_type)
{
	ActionsApplicationExtension * self = NULL;
	self = (ActionsApplicationExtension*) g_object_new (object_type, NULL);
	return self;
}

ActionsApplicationExtension*
actions_application_extension_new (void)
{
	return actions_application_extension_construct (ACTIONS_TYPE_APPLICATION_EXTENSION);
}

static GObject *
actions_application_extension_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ActionsApplicationExtension * self;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* _tmp2_;
	GtkCssProvider* _tmp3_;
	ActionsApplicationExtensionInternals* _tmp4_;
	parent_class = G_OBJECT_CLASS (actions_application_extension_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_APPLICATION_EXTENSION, ActionsApplicationExtension);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->css_provider);
	self->priv->css_provider = _tmp0_;
	_tmp1_ = self->priv->css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/pomodoro/plugins/actions/style.css");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = self->priv->css_provider;
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp4_ = actions_application_extension_internals_new ();
	_g_object_unref0 (self->priv->internals);
	self->priv->internals = _tmp4_;
	return obj;
}

static void
actions_application_extension_class_init (ActionsApplicationExtensionClass * klass,
                                          gpointer klass_data)
{
	actions_application_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ActionsApplicationExtension_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) actions_application_extension_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = actions_application_extension_constructor;
	G_OBJECT_CLASS (klass)->finalize = actions_application_extension_finalize;
}

static void
actions_application_extension_pomodoro_application_extension_interface_init (PomodoroApplicationExtensionIface * iface,
                                                                             gpointer iface_data)
{
	actions_application_extension_pomodoro_application_extension_parent_iface = g_type_interface_peek_parent (iface);
}

static void
actions_application_extension_instance_init (ActionsApplicationExtension * self,
                                             gpointer klass)
{
	self->priv = actions_application_extension_get_instance_private (self);
}

static void
actions_application_extension_finalize (GObject * obj)
{
	ActionsApplicationExtension * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_APPLICATION_EXTENSION, ActionsApplicationExtension);
	_g_object_unref0 (self->priv->css_provider);
	_g_object_unref0 (self->priv->internals);
	G_OBJECT_CLASS (actions_application_extension_parent_class)->finalize (obj);
}

GType
actions_application_extension_get_type (void)
{
	return actions_application_extension_type_id;
}

GType
actions_application_extension_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ActionsApplicationExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) actions_application_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ActionsApplicationExtension), 0, (GInstanceInitFunc) actions_application_extension_instance_init, NULL };
	static const GInterfaceInfo pomodoro_application_extension_info = { (GInterfaceInitFunc) actions_application_extension_pomodoro_application_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	actions_application_extension_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ActionsApplicationExtension", &g_define_type_info, 0);
	g_type_module_add_interface (module, actions_application_extension_type_id, POMODORO_TYPE_APPLICATION_EXTENSION, &pomodoro_application_extension_info);
	ActionsApplicationExtension_private_offset = sizeof (ActionsApplicationExtensionPrivate);
	return actions_application_extension_type_id;
}

static inline gpointer
actions_preferences_dialog_extension_get_instance_private (ActionsPreferencesDialogExtension* self)
{
	return G_STRUCT_MEMBER_P (self, ActionsPreferencesDialogExtension_private_offset);
}

static void
_actions_preferences_dialog_extension_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                   GtkListBoxRow* row,
                                                                                   gpointer self)
{
	actions_preferences_dialog_extension_on_row_activated ((ActionsPreferencesDialogExtension*) self, _sender, row);
}

static void
actions_preferences_dialog_extension_setup_main_page (ActionsPreferencesDialogExtension* self)
{
	PomodoroPreferencesMainPage* main_page = NULL;
	PomodoroPreferencesDialog* _tmp0_;
	PomodoroPreferencesPage* _tmp1_;
	PomodoroPreferencesMainPage* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp4_;
	GtkSizeGroup* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBoxRow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	_tmp1_ = pomodoro_preferences_dialog_get_page (_tmp0_, "main");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, POMODORO_TYPE_PREFERENCES_MAIN_PAGE) ? ((PomodoroPreferencesMainPage*) _tmp1_) : NULL);
	main_page = _tmp2_;
	_tmp3_ = main_page->plugins_listbox;
	g_signal_connect_object (_tmp3_, "row-activated", (GCallback) _actions_preferences_dialog_extension_on_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp4_ = actions_preferences_dialog_extension_create_row (self, _ ("Custom actions…"), "actions");
	row = _tmp4_;
	_tmp5_ = main_page->lisboxrow_sizegroup;
	gtk_size_group_add_widget (_tmp5_, (GtkWidget*) row);
	_tmp6_ = main_page->plugins_listbox;
	gtk_list_box_insert (_tmp6_, (GtkWidget*) row, 0);
	_tmp7_ = _g_object_ref0 (row);
	self->priv->rows = g_list_prepend (self->priv->rows, _tmp7_);
	_g_object_unref0 (row);
	_g_object_unref0 (main_page);
}

static GtkListBoxRow*
actions_preferences_dialog_extension_create_row (ActionsPreferencesDialogExtension* self,
                                                 const gchar* label,
                                                 const gchar* name)
{
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp0_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	g_object_ref_sink (_tmp0_);
	name_label = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) name_label, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) name_label, GTK_ALIGN_BASELINE);
	_tmp1_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp1_);
	row = _tmp1_;
	gtk_widget_set_name ((GtkWidget*) row, name);
	gtk_list_box_row_set_selectable (row, FALSE);
	gtk_container_add ((GtkContainer*) row, (GtkWidget*) name_label);
	gtk_widget_show_all ((GtkWidget*) row);
	result = row;
	_g_object_unref0 (name_label);
	return result;
}

static void
actions_preferences_dialog_extension_on_row_activated (ActionsPreferencesDialogExtension* self,
                                                       GtkListBox* listbox,
                                                       GtkListBoxRow* row)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_widget_get_name ((GtkWidget*) row);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, "actions") == 0) {
		PomodoroPreferencesDialog* _tmp2_;
		_tmp2_ = self->priv->dialog;
		pomodoro_preferences_dialog_set_page (_tmp2_, "actions");
	}
}

ActionsPreferencesDialogExtension*
actions_preferences_dialog_extension_construct (GType object_type)
{
	ActionsPreferencesDialogExtension * self = NULL;
	self = (ActionsPreferencesDialogExtension*) g_object_new (object_type, NULL);
	return self;
}

ActionsPreferencesDialogExtension*
actions_preferences_dialog_extension_new (void)
{
	return actions_preferences_dialog_extension_construct (ACTIONS_TYPE_PREFERENCES_DIALOG_EXTENSION);
}

static GObject *
actions_preferences_dialog_extension_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ActionsPreferencesDialogExtension * self;
	PomodoroPreferencesDialog* _tmp0_;
	PomodoroPreferencesDialog* _tmp1_;
	PomodoroPreferencesDialog* _tmp2_;
	parent_class = G_OBJECT_CLASS (actions_preferences_dialog_extension_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_PREFERENCES_DIALOG_EXTENSION, ActionsPreferencesDialogExtension);
	_tmp0_ = pomodoro_preferences_dialog_get_default ();
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp0_;
	_tmp1_ = self->priv->dialog;
	pomodoro_preferences_dialog_add_page (_tmp1_, "actions", _ ("Actions"), ACTIONS_TYPE_PREFERENCES_PAGE);
	_tmp2_ = self->priv->dialog;
	pomodoro_preferences_dialog_add_page (_tmp2_, "add-action", _ ("Action"), ACTIONS_TYPE_ACTION_PAGE);
	actions_preferences_dialog_extension_setup_main_page (self);
	return obj;
}

static void
actions_preferences_dialog_extension_class_init (ActionsPreferencesDialogExtensionClass * klass,
                                                 gpointer klass_data)
{
	actions_preferences_dialog_extension_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ActionsPreferencesDialogExtension_private_offset);
	G_OBJECT_CLASS (klass)->constructor = actions_preferences_dialog_extension_constructor;
	G_OBJECT_CLASS (klass)->finalize = actions_preferences_dialog_extension_finalize;
}

static void
actions_preferences_dialog_extension_pomodoro_preferences_dialog_extension_interface_init (PomodoroPreferencesDialogExtensionIface * iface,
                                                                                           gpointer iface_data)
{
	actions_preferences_dialog_extension_pomodoro_preferences_dialog_extension_parent_iface = g_type_interface_peek_parent (iface);
}

static void
actions_preferences_dialog_extension_instance_init (ActionsPreferencesDialogExtension * self,
                                                    gpointer klass)
{
	self->priv = actions_preferences_dialog_extension_get_instance_private (self);
}

static void
actions_preferences_dialog_extension_finalize (GObject * obj)
{
	ActionsPreferencesDialogExtension * self;
	PomodoroPreferencesDialog* _tmp0_;
	GList* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ACTIONS_TYPE_PREFERENCES_DIALOG_EXTENSION, ActionsPreferencesDialogExtension);
	_tmp0_ = self->priv->dialog;
	if (_tmp0_ != NULL) {
		PomodoroPreferencesDialog* _tmp1_;
		PomodoroPreferencesDialog* _tmp2_;
		_tmp1_ = self->priv->dialog;
		pomodoro_preferences_dialog_remove_page (_tmp1_, "actions");
		_tmp2_ = self->priv->dialog;
		pomodoro_preferences_dialog_remove_page (_tmp2_, "add-action");
	}
	_tmp3_ = self->priv->rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp3_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkListBoxRow* _tmp4_;
			GtkListBoxRow* row = NULL;
			_tmp4_ = _g_object_ref0 ((GtkListBoxRow*) row_it->data);
			row = _tmp4_;
			{
				GtkListBoxRow* _tmp5_;
				_tmp5_ = row;
				gtk_widget_destroy ((GtkWidget*) _tmp5_);
				_g_object_unref0 (row);
			}
		}
	}
	(self->priv->rows == NULL) ? NULL : (self->priv->rows = (_g_list_free__g_object_unref0_ (self->priv->rows), NULL));
	self->priv->rows = NULL;
	_g_object_unref0 (self->priv->dialog);
	(self->priv->rows == NULL) ? NULL : (self->priv->rows = (_g_list_free__g_object_unref0_ (self->priv->rows), NULL));
	G_OBJECT_CLASS (actions_preferences_dialog_extension_parent_class)->finalize (obj);
}

GType
actions_preferences_dialog_extension_get_type (void)
{
	return actions_preferences_dialog_extension_type_id;
}

GType
actions_preferences_dialog_extension_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ActionsPreferencesDialogExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) actions_preferences_dialog_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ActionsPreferencesDialogExtension), 0, (GInstanceInitFunc) actions_preferences_dialog_extension_instance_init, NULL };
	static const GInterfaceInfo pomodoro_preferences_dialog_extension_info = { (GInterfaceInitFunc) actions_preferences_dialog_extension_pomodoro_preferences_dialog_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	actions_preferences_dialog_extension_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ActionsPreferencesDialogExtension", &g_define_type_info, 0);
	g_type_module_add_interface (module, actions_preferences_dialog_extension_type_id, POMODORO_TYPE_PREFERENCES_DIALOG_EXTENSION, &pomodoro_preferences_dialog_extension_info);
	ActionsPreferencesDialogExtension_private_offset = sizeof (ActionsPreferencesDialogExtensionPrivate);
	return actions_preferences_dialog_extension_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* object_module = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	actions_action_list_box_row_register_type (module);
	actions_action_page_register_type (module);
	actions_action_manager_register_type (module);
	actions_application_extension_internals_register_type (module);
	actions_application_extension_register_type (module);
	actions_preferences_dialog_extension_register_type (module);
	actions_action_register_type (module);
	actions_preferences_page_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	object_module = _tmp0_;
	peas_object_module_register_extension_type (object_module, POMODORO_TYPE_APPLICATION_EXTENSION, ACTIONS_TYPE_APPLICATION_EXTENSION);
	peas_object_module_register_extension_type (object_module, POMODORO_TYPE_PREFERENCES_DIALOG_EXTENSION, ACTIONS_TYPE_PREFERENCES_DIALOG_EXTENSION);
	_g_object_unref0 (object_module);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

