/* sound-player.c generated by valac 0.56.17, the Vala compiler
 * generated from sound-player.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "sounds.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <config.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gst/gst.h>
#include "gnome-pomodoro.h"
#include <float.h>
#include <math.h>
#include <canberra.h>

#define SOUNDS_PLUGIN_GSTREAMER_PLAYER_FADE_FRAMES_PER_SECOND ((guint) 20)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SOUNDS_PLUGIN_TYPE_FADEABLE (sounds_plugin_fadeable_get_type ())
#define SOUNDS_PLUGIN_FADEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUNDS_PLUGIN_TYPE_FADEABLE, SoundsPluginFadeable))
#define SOUNDS_PLUGIN_IS_FADEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUNDS_PLUGIN_TYPE_FADEABLE))
#define SOUNDS_PLUGIN_FADEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SOUNDS_PLUGIN_TYPE_FADEABLE, SoundsPluginFadeableIface))

typedef struct _SoundsPluginFadeable SoundsPluginFadeable;
typedef struct _SoundsPluginFadeableIface SoundsPluginFadeableIface;

#define SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER (sounds_plugin_gstreamer_player_get_type ())
#define SOUNDS_PLUGIN_GSTREAMER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, SoundsPluginGStreamerPlayer))
#define SOUNDS_PLUGIN_GSTREAMER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, SoundsPluginGStreamerPlayerClass))
#define SOUNDS_PLUGIN_IS_GSTREAMER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER))
#define SOUNDS_PLUGIN_IS_GSTREAMER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER))
#define SOUNDS_PLUGIN_GSTREAMER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, SoundsPluginGStreamerPlayerClass))

typedef struct _SoundsPluginGStreamerPlayer SoundsPluginGStreamerPlayer;
typedef struct _SoundsPluginGStreamerPlayerClass SoundsPluginGStreamerPlayerClass;
typedef struct _SoundsPluginGStreamerPlayerPrivate SoundsPluginGStreamerPlayerPrivate;
enum  {
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_0_PROPERTY,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_FILE_PROPERTY,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_PROPERTY,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_FADE_PROPERTY,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_REPEAT_PROPERTY,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_NUM_PROPERTIES
};
static GParamSpec* sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_NUM_PROPERTIES];
typedef enum  {
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_VIDEO = 0x00000001,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_AUDIO = 0x00000002,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_TEXT = 0x00000004,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_VIS = 0x00000008,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_SOFT_VOLUME = 0x00000010,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_NATIVE_AUDIO = 0x00000020,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_NATIVE_VIDEO = 0x00000040,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_DOWNLOAD = 0x00000080,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_BUFFERING = 0x00000100,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_DEINTERLACE = 0x00000200,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_SOFT_COLORBALANCE = 0x00000400,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_FORCE_FILTERS = 0x00000800
} SoundsPluginGStreamerPlayerGstPlayFlags;

#define SOUNDS_PLUGIN_GSTREAMER_PLAYER_TYPE_GST_PLAY_FLAGS (sounds_plugin_gstreamer_player_gst_play_flags_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_FINISHED_SIGNAL,
	SOUNDS_PLUGIN_GSTREAMER_PLAYER_NUM_SIGNALS
};
static guint sounds_plugin_gstreamer_player_signals[SOUNDS_PLUGIN_GSTREAMER_PLAYER_NUM_SIGNALS] = {0};

#define SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER (sounds_plugin_canberra_player_get_type ())
#define SOUNDS_PLUGIN_CANBERRA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER, SoundsPluginCanberraPlayer))
#define SOUNDS_PLUGIN_CANBERRA_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER, SoundsPluginCanberraPlayerClass))
#define SOUNDS_PLUGIN_IS_CANBERRA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER))
#define SOUNDS_PLUGIN_IS_CANBERRA_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER))
#define SOUNDS_PLUGIN_CANBERRA_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER, SoundsPluginCanberraPlayerClass))

typedef struct _SoundsPluginCanberraPlayer SoundsPluginCanberraPlayer;
typedef struct _SoundsPluginCanberraPlayerClass SoundsPluginCanberraPlayerClass;
typedef struct _SoundsPluginCanberraPlayerPrivate SoundsPluginCanberraPlayerPrivate;
enum  {
	SOUNDS_PLUGIN_CANBERRA_PLAYER_0_PROPERTY,
	SOUNDS_PLUGIN_CANBERRA_PLAYER_FILE_PROPERTY,
	SOUNDS_PLUGIN_CANBERRA_PLAYER_EVENT_ID_PROPERTY,
	SOUNDS_PLUGIN_CANBERRA_PLAYER_VOLUME_PROPERTY,
	SOUNDS_PLUGIN_CANBERRA_PLAYER_NUM_PROPERTIES
};
static GParamSpec* sounds_plugin_canberra_player_properties[SOUNDS_PLUGIN_CANBERRA_PLAYER_NUM_PROPERTIES];
#define _ca_context_destroy0(var) ((var == NULL) ? NULL : (var = (ca_context_destroy (var), NULL)))
#define _ca_proplist_destroy0(var) ((var == NULL) ? NULL : (var = (ca_proplist_destroy (var), NULL)))

#define SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER (sounds_plugin_dummy_player_get_type ())
#define SOUNDS_PLUGIN_DUMMY_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER, SoundsPluginDummyPlayer))
#define SOUNDS_PLUGIN_DUMMY_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER, SoundsPluginDummyPlayerClass))
#define SOUNDS_PLUGIN_IS_DUMMY_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER))
#define SOUNDS_PLUGIN_IS_DUMMY_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER))
#define SOUNDS_PLUGIN_DUMMY_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER, SoundsPluginDummyPlayerClass))

typedef struct _SoundsPluginDummyPlayer SoundsPluginDummyPlayer;
typedef struct _SoundsPluginDummyPlayerClass SoundsPluginDummyPlayerClass;
typedef struct _SoundsPluginDummyPlayerPrivate SoundsPluginDummyPlayerPrivate;
enum  {
	SOUNDS_PLUGIN_DUMMY_PLAYER_0_PROPERTY,
	SOUNDS_PLUGIN_DUMMY_PLAYER_FILE_PROPERTY,
	SOUNDS_PLUGIN_DUMMY_PLAYER_VOLUME_PROPERTY,
	SOUNDS_PLUGIN_DUMMY_PLAYER_NUM_PROPERTIES
};
static GParamSpec* sounds_plugin_dummy_player_properties[SOUNDS_PLUGIN_DUMMY_PLAYER_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SoundsPluginFadeableIface {
	GTypeInterface parent_iface;
	void (*fade_in) (SoundsPluginFadeable* self, guint duration);
	void (*fade_out) (SoundsPluginFadeable* self, guint duration);
};

struct _SoundsPluginGStreamerPlayer {
	GObject parent_instance;
	SoundsPluginGStreamerPlayerPrivate * priv;
};

struct _SoundsPluginGStreamerPlayerClass {
	GObjectClass parent_class;
	void (*finished) (SoundsPluginGStreamerPlayer* self);
};

struct _SoundsPluginGStreamerPlayerPrivate {
	gboolean _repeat;
	GFile* _file;
	GstElement* pipeline;
	GstElement* volume_filter;
	PomodoroAnimation* volume_animation;
	gboolean is_about_to_finish;
	gboolean retry_on_error;
};

struct _SoundsPluginCanberraPlayer {
	GObject parent_instance;
	SoundsPluginCanberraPlayerPrivate * priv;
};

struct _SoundsPluginCanberraPlayerClass {
	GObjectClass parent_class;
};

struct _SoundsPluginCanberraPlayerPrivate {
	gchar* _event_id;
	gdouble _volume;
	GFile* _file;
	ca_context* context;
	gboolean is_cached;
};

struct _SoundsPluginDummyPlayer {
	GObject parent_instance;
	SoundsPluginDummyPlayerPrivate * priv;
};

struct _SoundsPluginDummyPlayerClass {
	GObjectClass parent_class;
};

struct _SoundsPluginDummyPlayerPrivate {
	gdouble _volume;
	GFile* _file;
};

static GType sounds_plugin_sound_player_type_id = 0;
static GType sounds_plugin_fadeable_type_id = 0;
static gint SoundsPluginGStreamerPlayer_private_offset;
static gpointer sounds_plugin_gstreamer_player_parent_class = NULL;
static SoundsPluginSoundPlayerIface * sounds_plugin_gstreamer_player_sounds_plugin_sound_player_parent_iface = NULL;
static SoundsPluginFadeableIface * sounds_plugin_gstreamer_player_sounds_plugin_fadeable_parent_iface = NULL;
static GType sounds_plugin_gstreamer_player_type_id = 0;
static gint SoundsPluginCanberraPlayer_private_offset;
static gpointer sounds_plugin_canberra_player_parent_class = NULL;
static SoundsPluginSoundPlayerIface * sounds_plugin_canberra_player_sounds_plugin_sound_player_parent_iface = NULL;
static GType sounds_plugin_canberra_player_type_id = 0;
static gint SoundsPluginDummyPlayer_private_offset;
static gpointer sounds_plugin_dummy_player_parent_class = NULL;
static SoundsPluginSoundPlayerIface * sounds_plugin_dummy_player_sounds_plugin_sound_player_parent_iface = NULL;
static GType sounds_plugin_dummy_player_type_id = 0;

VALA_EXTERN gchar* sounds_plugin_get_absolute_uri (const gchar* uri);
static gchar** sounds_plugin_sound_player_real_get_supported_mime_types (SoundsPluginSoundPlayer* self,
                                                                  gint* result_length1);
GType sounds_plugin_fadeable_register_type (GTypeModule * module);
VALA_EXTERN GType sounds_plugin_fadeable_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sounds_plugin_fadeable_fade_in (SoundsPluginFadeable* self,
                                     guint duration);
VALA_EXTERN void sounds_plugin_fadeable_fade_out (SoundsPluginFadeable* self,
                                      guint duration);
GType sounds_plugin_gstreamer_player_register_type (GTypeModule * module);
VALA_EXTERN GType sounds_plugin_gstreamer_player_get_type (void) G_GNUC_CONST ;
static GType sounds_plugin_gstreamer_player_gst_play_flags_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN SoundsPluginGStreamerPlayer* sounds_plugin_gstreamer_player_new (GError** error);
VALA_EXTERN SoundsPluginGStreamerPlayer* sounds_plugin_gstreamer_player_construct (GType object_type,
                                                                       GError** error);
static void sounds_plugin_gstreamer_player_on_about_to_finish (SoundsPluginGStreamerPlayer* self);
static void _sounds_plugin_gstreamer_player_on_about_to_finish_dynamic_about_to_finish0_ (GstElement* _sender,
                                                                                   gpointer self);
static gboolean sounds_plugin_gstreamer_player_on_bus_callback (SoundsPluginGStreamerPlayer* self,
                                                         GstBus* bus,
                                                         GstMessage* message);
static gboolean _sounds_plugin_gstreamer_player_on_bus_callback_gst_bus_func (GstBus* bus,
                                                                       GstMessage* message,
                                                                       gpointer self);
static void sounds_plugin_gstreamer_player_real_play (SoundsPluginSoundPlayer* base);
static void sounds_plugin_gstreamer_player_real_stop (SoundsPluginSoundPlayer* base);
static void sounds_plugin_gstreamer_player_real_fade_in (SoundsPluginFadeable* base,
                                                  guint duration);
VALA_EXTERN void sounds_plugin_gstreamer_player_set_volume_fade (SoundsPluginGStreamerPlayer* self,
                                                     gdouble value);
static void sounds_plugin_gstreamer_player_real_fade_out (SoundsPluginFadeable* base,
                                                   guint duration);
static void ___lambda4_ (SoundsPluginGStreamerPlayer* self);
static void ____lambda4__pomodoro_animation_complete (PomodoroAnimation* _sender,
                                               gpointer self);
VALA_EXTERN gdouble sounds_plugin_gstreamer_player_get_volume_fade (SoundsPluginGStreamerPlayer* self);
VALA_EXTERN gboolean sounds_plugin_gstreamer_player_get_repeat (SoundsPluginGStreamerPlayer* self);
VALA_EXTERN void sounds_plugin_gstreamer_player_set_repeat (SoundsPluginGStreamerPlayer* self,
                                                gboolean value);
static void sounds_plugin_gstreamer_player_real_finished (SoundsPluginGStreamerPlayer* self);
static void sounds_plugin_gstreamer_player_finalize (GObject * obj);
static void _vala_sounds_plugin_gstreamer_player_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_sounds_plugin_gstreamer_player_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
GType sounds_plugin_canberra_player_register_type (GTypeModule * module);
VALA_EXTERN GType sounds_plugin_canberra_player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SoundsPluginCanberraPlayer* sounds_plugin_canberra_player_new (const gchar* event_id,
                                                               GError** error);
VALA_EXTERN SoundsPluginCanberraPlayer* sounds_plugin_canberra_player_construct (GType object_type,
                                                                     const gchar* event_id,
                                                                     GError** error);
static void sounds_plugin_canberra_player_set_event_id (SoundsPluginCanberraPlayer* self,
                                                 const gchar* value);
static gdouble sounds_plugin_canberra_player_amplitude_to_decibels (gdouble amplitude);
static void sounds_plugin_canberra_player_real_play (SoundsPluginSoundPlayer* base);
VALA_EXTERN const gchar* sounds_plugin_canberra_player_get_event_id (SoundsPluginCanberraPlayer* self);
static void sounds_plugin_canberra_player_cache_file (SoundsPluginCanberraPlayer* self);
static void sounds_plugin_canberra_player_on_play_callback (SoundsPluginCanberraPlayer* self,
                                                     ca_context* context,
                                                     guint32 id,
                                                     gint code);
static void _sounds_plugin_canberra_player_on_play_callback_ca_finishcallback (ca_context* c,
                                                                        guint32 id,
                                                                        gint code,
                                                                        gpointer self);
static void sounds_plugin_canberra_player_real_stop (SoundsPluginSoundPlayer* base);
static gchar** sounds_plugin_canberra_player_real_get_supported_mime_types (SoundsPluginSoundPlayer* base,
                                                                     gint* result_length1);
static void sounds_plugin_canberra_player_finalize (GObject * obj);
static void _vala_sounds_plugin_canberra_player_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_sounds_plugin_canberra_player_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
GType sounds_plugin_dummy_player_register_type (GTypeModule * module);
VALA_EXTERN GType sounds_plugin_dummy_player_get_type (void) G_GNUC_CONST ;
static void sounds_plugin_dummy_player_real_play (SoundsPluginSoundPlayer* base);
static void sounds_plugin_dummy_player_real_stop (SoundsPluginSoundPlayer* base);
VALA_EXTERN SoundsPluginDummyPlayer* sounds_plugin_dummy_player_new (void);
VALA_EXTERN SoundsPluginDummyPlayer* sounds_plugin_dummy_player_construct (GType object_type);
static void sounds_plugin_dummy_player_finalize (GObject * obj);
static void _vala_sounds_plugin_dummy_player_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_sounds_plugin_dummy_player_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

GQuark
sounds_plugin_sound_player_error_quark (void)
{
	return g_quark_from_static_string ("sounds-plugin-sound-player-error-quark");
}

static GType
sounds_plugin_sound_player_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SOUNDS_PLUGIN_SOUND_PLAYER_ERROR_FAILED_TO_INITIALIZE, "SOUNDS_PLUGIN_SOUND_PLAYER_ERROR_FAILED_TO_INITIALIZE", "failed-to-initialize"}, {0, NULL, NULL}};
	GType sounds_plugin_sound_player_error_type_id;
	sounds_plugin_sound_player_error_type_id = g_enum_register_static ("SoundsPluginSoundPlayerError", values);
	return sounds_plugin_sound_player_error_type_id;
}

GType
sounds_plugin_sound_player_error_get_type (void)
{
	static volatile gsize sounds_plugin_sound_player_error_type_id__once = 0;
	if (g_once_init_enter (&sounds_plugin_sound_player_error_type_id__once)) {
		GType sounds_plugin_sound_player_error_type_id;
		sounds_plugin_sound_player_error_type_id = sounds_plugin_sound_player_error_get_type_once ();
		g_once_init_leave (&sounds_plugin_sound_player_error_type_id__once, sounds_plugin_sound_player_error_type_id);
	}
	return sounds_plugin_sound_player_error_type_id__once;
}

/**
     * Preset sounds are defined relative to data directory,
     * and used URIs are not particulary valid.
     */
gchar*
sounds_plugin_get_absolute_uri (const gchar* uri)
{
	gchar* scheme = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	scheme = _tmp0_;
	_tmp2_ = scheme;
	if (_tmp2_ == NULL) {
		_tmp1_ = g_strcmp0 (uri, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* path = NULL;
		gchar* _tmp3_;
		_tmp3_ = g_build_filename (PACKAGE_DATA_DIR, "sounds", uri, NULL);
		path = _tmp3_;
		{
			gchar* _tmp4_ = NULL;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = path;
			_tmp6_ = g_filename_to_uri (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				_g_free0 (path);
				_g_free0 (scheme);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			result = _tmp7_;
			_g_free0 (_tmp4_);
			_g_free0 (path);
			_g_free0 (scheme);
			return result;
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = path;
			_tmp9_ = _error_;
			_tmp10_ = _tmp9_->message;
			g_warning ("sound-player.vala:47: Failed to convert \"%s\" to uri: %s", _tmp8_, _tmp10_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_free0 (scheme);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (path);
	}
	_tmp11_ = g_strdup (uri);
	result = _tmp11_;
	_g_free0 (scheme);
	return result;
}

void
sounds_plugin_sound_player_play (SoundsPluginSoundPlayer* self)
{
	SoundsPluginSoundPlayerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SOUNDS_PLUGIN_SOUND_PLAYER_GET_INTERFACE (self);
	if (_iface_->play) {
		_iface_->play (self);
	}
}

void
sounds_plugin_sound_player_stop (SoundsPluginSoundPlayer* self)
{
	SoundsPluginSoundPlayerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SOUNDS_PLUGIN_SOUND_PLAYER_GET_INTERFACE (self);
	if (_iface_->stop) {
		_iface_->stop (self);
	}
}

static gchar**
sounds_plugin_sound_player_real_get_supported_mime_types (SoundsPluginSoundPlayer* self,
                                                          gint* result_length1)
{
	gchar** mime_types = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint mime_types_length1;
	gint _mime_types_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	_tmp0_ = g_strdup ("audio/*");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	mime_types = _tmp1_;
	mime_types_length1 = 1;
	_mime_types_size_ = mime_types_length1;
	_tmp2_ = mime_types;
	_tmp2__length1 = mime_types_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar**
sounds_plugin_sound_player_get_supported_mime_types (SoundsPluginSoundPlayer* self,
                                                     gint* result_length1)
{
	SoundsPluginSoundPlayerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SOUNDS_PLUGIN_SOUND_PLAYER_GET_INTERFACE (self);
	if (_iface_->get_supported_mime_types) {
		return _iface_->get_supported_mime_types (self, result_length1);
	}
	return NULL;
}

GFile*
sounds_plugin_sound_player_get_file (SoundsPluginSoundPlayer* self)
{
	SoundsPluginSoundPlayerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SOUNDS_PLUGIN_SOUND_PLAYER_GET_INTERFACE (self);
	if (_iface_->get_file) {
		return _iface_->get_file (self);
	}
	return NULL;
}

void
sounds_plugin_sound_player_set_file (SoundsPluginSoundPlayer* self,
                                     GFile* value)
{
	SoundsPluginSoundPlayerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SOUNDS_PLUGIN_SOUND_PLAYER_GET_INTERFACE (self);
	if (_iface_->set_file) {
		_iface_->set_file (self, value);
	}
}

gdouble
sounds_plugin_sound_player_get_volume (SoundsPluginSoundPlayer* self)
{
	SoundsPluginSoundPlayerIface* _iface_;
	g_return_val_if_fail (self != NULL, 0.0);
	_iface_ = SOUNDS_PLUGIN_SOUND_PLAYER_GET_INTERFACE (self);
	if (_iface_->get_volume) {
		return _iface_->get_volume (self);
	}
	return -1.0;
}

void
sounds_plugin_sound_player_set_volume (SoundsPluginSoundPlayer* self,
                                       gdouble value)
{
	SoundsPluginSoundPlayerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SOUNDS_PLUGIN_SOUND_PLAYER_GET_INTERFACE (self);
	if (_iface_->set_volume) {
		_iface_->set_volume (self, value);
	}
}

static void
sounds_plugin_sound_player_default_init (SoundsPluginSoundPlayerIface * iface,
                                         gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_interface_install_property (iface, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->get_supported_mime_types = sounds_plugin_sound_player_real_get_supported_mime_types;
}

GType
sounds_plugin_sound_player_get_type (void)
{
	return sounds_plugin_sound_player_type_id;
}

GType
sounds_plugin_sound_player_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundsPluginSoundPlayerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sounds_plugin_sound_player_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	sounds_plugin_sound_player_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SoundsPluginSoundPlayer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (sounds_plugin_sound_player_type_id, G_TYPE_OBJECT);
	return sounds_plugin_sound_player_type_id;
}

void
sounds_plugin_fadeable_fade_in (SoundsPluginFadeable* self,
                                guint duration)
{
	SoundsPluginFadeableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SOUNDS_PLUGIN_FADEABLE_GET_INTERFACE (self);
	if (_iface_->fade_in) {
		_iface_->fade_in (self, duration);
	}
}

void
sounds_plugin_fadeable_fade_out (SoundsPluginFadeable* self,
                                 guint duration)
{
	SoundsPluginFadeableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SOUNDS_PLUGIN_FADEABLE_GET_INTERFACE (self);
	if (_iface_->fade_out) {
		_iface_->fade_out (self, duration);
	}
}

static void
sounds_plugin_fadeable_default_init (SoundsPluginFadeableIface * iface,
                                     gpointer iface_data)
{
}

GType
sounds_plugin_fadeable_get_type (void)
{
	return sounds_plugin_fadeable_type_id;
}

GType
sounds_plugin_fadeable_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundsPluginFadeableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sounds_plugin_fadeable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	sounds_plugin_fadeable_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SoundsPluginFadeable", &g_define_type_info, 0);
	return sounds_plugin_fadeable_type_id;
}

static inline gpointer
sounds_plugin_gstreamer_player_get_instance_private (SoundsPluginGStreamerPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, SoundsPluginGStreamerPlayer_private_offset);
}

static GType
sounds_plugin_gstreamer_player_gst_play_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_VIDEO, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_VIDEO", "video"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_AUDIO, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_AUDIO", "audio"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_TEXT, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_TEXT", "text"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_VIS, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_VIS", "vis"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_SOFT_VOLUME, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_SOFT_VOLUME", "soft-volume"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_NATIVE_AUDIO, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_NATIVE_AUDIO", "native-audio"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_NATIVE_VIDEO, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_NATIVE_VIDEO", "native-video"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_DOWNLOAD, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_DOWNLOAD", "download"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_BUFFERING, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_BUFFERING", "buffering"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_DEINTERLACE, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_DEINTERLACE", "deinterlace"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_SOFT_COLORBALANCE, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_SOFT_COLORBALANCE", "soft-colorbalance"}, {SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_FORCE_FILTERS, "SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_FORCE_FILTERS", "force-filters"}, {0, NULL, NULL}};
	GType sounds_plugin_gstreamer_player_gst_play_flags_type_id;
	sounds_plugin_gstreamer_player_gst_play_flags_type_id = g_flags_register_static ("SoundsPluginGStreamerPlayerGstPlayFlags", values);
	return sounds_plugin_gstreamer_player_gst_play_flags_type_id;
}

static GType
sounds_plugin_gstreamer_player_gst_play_flags_get_type (void)
{
	static volatile gsize sounds_plugin_gstreamer_player_gst_play_flags_type_id__once = 0;
	if (g_once_init_enter (&sounds_plugin_gstreamer_player_gst_play_flags_type_id__once)) {
		GType sounds_plugin_gstreamer_player_gst_play_flags_type_id;
		sounds_plugin_gstreamer_player_gst_play_flags_type_id = sounds_plugin_gstreamer_player_gst_play_flags_get_type_once ();
		g_once_init_leave (&sounds_plugin_gstreamer_player_gst_play_flags_type_id__once, sounds_plugin_gstreamer_player_gst_play_flags_type_id);
	}
	return sounds_plugin_gstreamer_player_gst_play_flags_type_id__once;
}

static void
_sounds_plugin_gstreamer_player_on_about_to_finish_dynamic_about_to_finish0_ (GstElement* _sender,
                                                                              gpointer self)
{
	sounds_plugin_gstreamer_player_on_about_to_finish ((SoundsPluginGStreamerPlayer*) self);
}

static gboolean
_sounds_plugin_gstreamer_player_on_bus_callback_gst_bus_func (GstBus* bus,
                                                              GstMessage* message,
                                                              gpointer self)
{
	gboolean result;
	result = sounds_plugin_gstreamer_player_on_bus_callback ((SoundsPluginGStreamerPlayer*) self, bus, message);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SoundsPluginGStreamerPlayer*
sounds_plugin_gstreamer_player_construct (GType object_type,
                                          GError** error)
{
	SoundsPluginGStreamerPlayer * self = NULL;
	GstElement* pipeline = NULL;
	GstElement* _tmp0_;
	GstElement* volume_filter = NULL;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp4_;
	GstElement* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstBus* _tmp11_;
	GstBus* _tmp12_;
	GstElement* _tmp13_;
	GstElement* _tmp14_;
	GstElement* _tmp15_;
	GstElement* _tmp16_;
	GstElement* _tmp17_;
	GstElement* _tmp18_;
	GError* _inner_error0_ = NULL;
	self = (SoundsPluginGStreamerPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = gst_element_factory_make ("playbin", "player");
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	pipeline = _tmp0_;
	_tmp1_ = gst_element_factory_make ("volume", "volume");
	if (_tmp1_ != NULL) {
		g_object_ref_sink (_tmp1_);
	}
	volume_filter = _tmp1_;
	_tmp2_ = pipeline;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (SOUNDS_PLUGIN_SOUND_PLAYER_ERROR, SOUNDS_PLUGIN_SOUND_PLAYER_ERROR_FAILED_TO_INITIALIZE, "Failed to initialize \"playbin\" element");
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == SOUNDS_PLUGIN_SOUND_PLAYER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (volume_filter);
			_g_object_unref0 (pipeline);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (volume_filter);
			_g_object_unref0 (pipeline);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = volume_filter;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (SOUNDS_PLUGIN_SOUND_PLAYER_ERROR, SOUNDS_PLUGIN_SOUND_PLAYER_ERROR_FAILED_TO_INITIALIZE, "Failed to initialize \"volume\" element");
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == SOUNDS_PLUGIN_SOUND_PLAYER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (volume_filter);
			_g_object_unref0 (pipeline);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (volume_filter);
			_g_object_unref0 (pipeline);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = pipeline;
	((GstObject*) _tmp6_)->flags = (guint32) SOUNDS_PLUGIN_GSTREAMER_PLAYER_GST_PLAY_FLAGS_AUDIO;
	_tmp7_ = pipeline;
	_tmp8_ = volume_filter;
	g_object_set (_tmp7_, "audio-filter", _tmp8_, NULL);
	_tmp9_ = pipeline;
	g_signal_connect_object (_tmp9_, "about-to-finish", (GCallback) _sounds_plugin_gstreamer_player_on_about_to_finish_dynamic_about_to_finish0_, self, 0);
	_tmp10_ = pipeline;
	_tmp11_ = gst_element_get_bus (_tmp10_);
	_tmp12_ = _tmp11_;
	gst_bus_add_watch_full (_tmp12_, G_PRIORITY_DEFAULT, _sounds_plugin_gstreamer_player_on_bus_callback_gst_bus_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = pipeline;
	g_object_set (_tmp13_, "volume", 1.0, NULL);
	_tmp14_ = volume_filter;
	g_object_set (_tmp14_, "volume", 0.0, NULL);
	_tmp15_ = volume_filter;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->priv->volume_filter);
	self->priv->volume_filter = _tmp16_;
	_tmp17_ = pipeline;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp18_;
	_g_object_unref0 (volume_filter);
	_g_object_unref0 (pipeline);
	return self;
}

SoundsPluginGStreamerPlayer*
sounds_plugin_gstreamer_player_new (GError** error)
{
	return sounds_plugin_gstreamer_player_construct (SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, error);
}

static void
sounds_plugin_gstreamer_player_real_play (SoundsPluginSoundPlayer* base)
{
	SoundsPluginGStreamerPlayer * self;
	GstElement* _tmp0_;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp0_ = self->priv->pipeline;
	_vala_return_if_fail (_tmp0_ != NULL, "this.pipeline != null");
	sounds_plugin_fadeable_fade_in ((SoundsPluginFadeable*) self, (guint) 0);
}

static void
sounds_plugin_gstreamer_player_real_stop (SoundsPluginSoundPlayer* base)
{
	SoundsPluginGStreamerPlayer * self;
	GstElement* _tmp0_;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp0_ = self->priv->pipeline;
	_vala_return_if_fail (_tmp0_ != NULL, "this.pipeline != null");
	sounds_plugin_fadeable_fade_out ((SoundsPluginFadeable*) self, (guint) 0);
}

static void
sounds_plugin_gstreamer_player_real_fade_in (SoundsPluginFadeable* base,
                                             guint duration)
{
	SoundsPluginGStreamerPlayer * self;
	PomodoroAnimation* _tmp0_;
	gchar* _tmp6_ = NULL;
	GFile* _tmp7_;
	gchar* uri = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp0_ = self->priv->volume_animation;
	if (_tmp0_ != NULL) {
		PomodoroAnimation* _tmp1_;
		_tmp1_ = self->priv->volume_animation;
		pomodoro_animation_stop (_tmp1_);
		_g_object_unref0 (self->priv->volume_animation);
		self->priv->volume_animation = NULL;
	}
	if (duration > ((guint) 0)) {
		PomodoroAnimation* _tmp2_;
		PomodoroAnimation* _tmp3_;
		GValue _tmp4_ = {0};
		PomodoroAnimation* _tmp5_;
		_tmp2_ = pomodoro_animation_new (POMODORO_ANIMATION_MODE_EASE_OUT, duration, SOUNDS_PLUGIN_GSTREAMER_PLAYER_FADE_FRAMES_PER_SECOND);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->volume_animation);
		self->priv->volume_animation = _tmp2_;
		_tmp3_ = self->priv->volume_animation;
		g_value_init (&_tmp4_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp4_, 1.0);
		pomodoro_animation_add_property (_tmp3_, (GObject*) self, "volume-fade", &_tmp4_);
		G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
		_tmp5_ = self->priv->volume_animation;
		pomodoro_animation_start (_tmp5_);
	} else {
		sounds_plugin_gstreamer_player_set_volume_fade (self, 1.0);
	}
	_tmp7_ = self->priv->_file;
	if (_tmp7_ != NULL) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->_file;
		_tmp9_ = g_file_get_uri (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		_g_free0 (_tmp6_);
		_tmp6_ = _tmp10_;
	}
	_tmp11_ = sounds_plugin_get_absolute_uri (_tmp6_);
	uri = _tmp11_;
	_tmp12_ = uri;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		GstElement* _tmp13_;
		const gchar* _tmp14_;
		GstElement* _tmp15_;
		self->priv->retry_on_error = TRUE;
		_tmp13_ = self->priv->pipeline;
		_tmp14_ = uri;
		g_object_set (_tmp13_, "uri", _tmp14_, NULL);
		_tmp15_ = self->priv->pipeline;
		gst_element_set_state (_tmp15_, GST_STATE_PLAYING);
	}
	_g_free0 (uri);
	_g_free0 (_tmp6_);
}

static void
___lambda4_ (SoundsPluginGStreamerPlayer* self)
{
	sounds_plugin_sound_player_stop ((SoundsPluginSoundPlayer*) self);
}

static void
____lambda4__pomodoro_animation_complete (PomodoroAnimation* _sender,
                                          gpointer self)
{
	___lambda4_ ((SoundsPluginGStreamerPlayer*) self);
}

static void
sounds_plugin_gstreamer_player_real_fade_out (SoundsPluginFadeable* base,
                                              guint duration)
{
	SoundsPluginGStreamerPlayer * self;
	GstState state = 0;
	GstState pending_state = 0;
	PomodoroAnimation* _tmp0_;
	GstElement* _tmp2_;
	GstState _tmp3_ = 0;
	GstState _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp0_ = self->priv->volume_animation;
	if (_tmp0_ != NULL) {
		PomodoroAnimation* _tmp1_;
		_tmp1_ = self->priv->volume_animation;
		pomodoro_animation_stop (_tmp1_);
		_g_object_unref0 (self->priv->volume_animation);
		self->priv->volume_animation = NULL;
	}
	_tmp2_ = self->priv->pipeline;
	gst_element_get_state (_tmp2_, &_tmp3_, &_tmp4_, GST_CLOCK_TIME_NONE);
	state = _tmp3_;
	pending_state = _tmp4_;
	if (pending_state != GST_STATE_VOID_PENDING) {
		state = pending_state;
	}
	if (duration > ((guint) 0)) {
		_tmp5_ = state == GST_STATE_PLAYING;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		PomodoroAnimation* _tmp6_;
		PomodoroAnimation* _tmp7_;
		GValue _tmp8_ = {0};
		PomodoroAnimation* _tmp9_;
		PomodoroAnimation* _tmp10_;
		_tmp6_ = pomodoro_animation_new (POMODORO_ANIMATION_MODE_EASE_IN_OUT, duration, SOUNDS_PLUGIN_GSTREAMER_PLAYER_FADE_FRAMES_PER_SECOND);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->volume_animation);
		self->priv->volume_animation = _tmp6_;
		_tmp7_ = self->priv->volume_animation;
		g_value_init (&_tmp8_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp8_, 0.0);
		pomodoro_animation_add_property (_tmp7_, (GObject*) self, "volume-fade", &_tmp8_);
		G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
		_tmp9_ = self->priv->volume_animation;
		g_signal_connect_object (_tmp9_, "complete", (GCallback) ____lambda4__pomodoro_animation_complete, self, 0);
		_tmp10_ = self->priv->volume_animation;
		pomodoro_animation_start (_tmp10_);
	} else {
		gboolean _tmp11_ = FALSE;
		if (state != GST_STATE_NULL) {
			_tmp11_ = state != GST_STATE_READY;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GstElement* _tmp12_;
			_tmp12_ = self->priv->pipeline;
			gst_element_set_state (_tmp12_, GST_STATE_READY);
		}
		sounds_plugin_gstreamer_player_set_volume_fade (self, 0.0);
	}
}

static gboolean
sounds_plugin_gstreamer_player_on_bus_callback (SoundsPluginGStreamerPlayer* self,
                                                GstBus* bus,
                                                GstMessage* message)
{
	GError* _error_ = NULL;
	GstState state = 0;
	GstState pending_state = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = self->priv->pipeline;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, GST_CLOCK_TIME_NONE);
	state = _tmp1_;
	pending_state = _tmp2_;
	switch (message->type) {
		case GST_MESSAGE_EOS:
		{
			if (self->priv->is_about_to_finish) {
				self->priv->is_about_to_finish = FALSE;
			} else {
				g_signal_emit (self, sounds_plugin_gstreamer_player_signals[SOUNDS_PLUGIN_GSTREAMER_PLAYER_FINISHED_SIGNAL], 0);
			}
			if (pending_state != GST_STATE_PLAYING) {
				GstElement* _tmp3_;
				_tmp3_ = self->priv->pipeline;
				gst_element_set_state (_tmp3_, GST_STATE_READY);
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _tmp4_ = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			GstElement* _tmp7_;
			if (self->priv->is_about_to_finish) {
				self->priv->is_about_to_finish = FALSE;
			}
			gst_message_parse_error (message, &_tmp4_, NULL);
			_g_error_free0 (_error_);
			_error_ = _tmp4_;
			_tmp5_ = _error_;
			_tmp6_ = _tmp5_->message;
			g_critical ("sound-player.vala:321: %s", _tmp6_);
			_tmp7_ = self->priv->pipeline;
			gst_element_set_state (_tmp7_, GST_STATE_NULL);
			if (self->priv->retry_on_error) {
				GstElement* _tmp8_;
				self->priv->retry_on_error = FALSE;
				_tmp8_ = self->priv->pipeline;
				gst_element_set_state (_tmp8_, GST_STATE_PLAYING);
			} else {
				g_signal_emit (self, sounds_plugin_gstreamer_player_signals[SOUNDS_PLUGIN_GSTREAMER_PLAYER_FINISHED_SIGNAL], 0);
			}
			break;
		}
		case GST_MESSAGE_SEGMENT_DONE:
		{
			self->priv->retry_on_error = TRUE;
			break;
		}
		default:
		{
			break;
		}
	}
	result = G_SOURCE_CONTINUE;
	_g_error_free0 (_error_);
	return result;
}

/**
         * Try emit "finished" signal before the end of stream.
         * If play gets called during then 
         */
static void
sounds_plugin_gstreamer_player_on_about_to_finish (SoundsPluginGStreamerPlayer* self)
{
	g_return_if_fail (self != NULL);
	self->priv->is_about_to_finish = TRUE;
	g_signal_emit (self, sounds_plugin_gstreamer_player_signals[SOUNDS_PLUGIN_GSTREAMER_PLAYER_FINISHED_SIGNAL], 0);
}

static GFile*
sounds_plugin_gstreamer_player_real_get_file (SoundsPluginSoundPlayer* base)
{
	GFile* result;
	SoundsPluginGStreamerPlayer* self;
	GFile* _tmp0_;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
sounds_plugin_gstreamer_player_real_set_file (SoundsPluginSoundPlayer* base,
                                              GFile* value)
{
	SoundsPluginGStreamerPlayer* self;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_;
	gchar* uri = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp0_;
	_tmp2_ = self->priv->_file;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->_file;
		_tmp4_ = g_file_get_uri (_tmp3_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = sounds_plugin_get_absolute_uri (_tmp1_);
	uri = _tmp6_;
	_tmp7_ = uri;
	if (g_strcmp0 (_tmp7_, "") == 0) {
		sounds_plugin_sound_player_stop ((SoundsPluginSoundPlayer*) self);
	} else {
		GstState state = 0;
		GstState pending_state = 0;
		GstElement* _tmp8_;
		GstState _tmp9_ = 0;
		GstState _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = self->priv->pipeline;
		gst_element_get_state (_tmp8_, &_tmp9_, &_tmp10_, GST_CLOCK_TIME_NONE);
		state = _tmp9_;
		pending_state = _tmp10_;
		if (pending_state != GST_STATE_VOID_PENDING) {
			state = pending_state;
		}
		if (state == GST_STATE_PLAYING) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = state == GST_STATE_PAUSED;
		}
		if (_tmp11_) {
			GstElement* _tmp12_;
			GstElement* _tmp13_;
			const gchar* _tmp14_;
			GstElement* _tmp15_;
			self->priv->is_about_to_finish = FALSE;
			_tmp12_ = self->priv->pipeline;
			gst_element_set_state (_tmp12_, GST_STATE_READY);
			_tmp13_ = self->priv->pipeline;
			_tmp14_ = uri;
			g_object_set (_tmp13_, "uri", _tmp14_, NULL);
			_tmp15_ = self->priv->pipeline;
			gst_element_set_state (_tmp15_, state);
		}
	}
	_g_free0 (uri);
	_g_free0 (_tmp1_);
	g_object_notify_by_pspec ((GObject *) self, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_FILE_PROPERTY]);
}

static gdouble
sounds_plugin_gstreamer_player_real_get_volume (SoundsPluginSoundPlayer* base)
{
	gdouble result;
	SoundsPluginGStreamerPlayer* self;
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp1_ = self->priv->pipeline;
	if (_tmp1_ != NULL) {
		GstElement* _tmp2_;
		GstElement* _tmp3_;
		GstElement* _tmp4_;
		_tmp2_ = self->priv->pipeline;
		g_object_get (_tmp2_, "volume", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GstElement* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp5_ = self->priv->pipeline;
		g_object_get (_tmp5_, "volume", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = 1.0;
		return result;
	}
}

static void
sounds_plugin_gstreamer_player_real_set_volume (SoundsPluginSoundPlayer* base,
                                                gdouble value)
{
	SoundsPluginGStreamerPlayer* self;
	GstElement* _tmp0_;
	self = (SoundsPluginGStreamerPlayer*) base;
	_tmp0_ = self->priv->pipeline;
	g_object_set (_tmp0_, "volume", CLAMP (value, 0.0, 1.0), NULL);
	g_object_notify_by_pspec ((GObject *) self, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_PROPERTY]);
}

gdouble
sounds_plugin_gstreamer_player_get_volume_fade (SoundsPluginGStreamerPlayer* self)
{
	gdouble result;
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->volume_filter;
	if (_tmp1_ != NULL) {
		GstElement* _tmp2_;
		GstElement* _tmp3_;
		GstElement* _tmp4_;
		_tmp2_ = self->priv->volume_filter;
		g_object_get (_tmp2_, "volume", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GstElement* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp5_ = self->priv->volume_filter;
		g_object_get (_tmp5_, "volume", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = 0.0;
		return result;
	}
}

void
sounds_plugin_gstreamer_player_set_volume_fade (SoundsPluginGStreamerPlayer* self,
                                                gdouble value)
{
	GstElement* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_filter;
	g_object_set (_tmp0_, "volume", CLAMP (value, 0.0, 1.0), NULL);
	g_object_notify_by_pspec ((GObject *) self, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_FADE_PROPERTY]);
}

gboolean
sounds_plugin_gstreamer_player_get_repeat (SoundsPluginGStreamerPlayer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_repeat;
	return result;
}

void
sounds_plugin_gstreamer_player_set_repeat (SoundsPluginGStreamerPlayer* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sounds_plugin_gstreamer_player_get_repeat (self);
	if (old_value != value) {
		self->priv->_repeat = value;
		g_object_notify_by_pspec ((GObject *) self, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_REPEAT_PROPERTY]);
	}
}

static void
sounds_plugin_gstreamer_player_real_finished (SoundsPluginGStreamerPlayer* self)
{
	gchar* current_uri = NULL;
	gboolean _tmp0_;
	_tmp0_ = self->priv->_repeat;
	if (_tmp0_) {
		GstElement* _tmp1_;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->pipeline;
		g_object_get ((GObject*) _tmp1_, "current-uri", &_tmp2_, NULL);
		_g_free0 (current_uri);
		current_uri = _tmp2_;
		_tmp3_ = current_uri;
		if (g_strcmp0 (_tmp3_, "") != 0) {
			GstElement* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->pipeline;
			_tmp5_ = current_uri;
			g_object_set ((GObject*) _tmp4_, "uri", _tmp5_, NULL);
		}
	}
	_g_free0 (current_uri);
}

static void
sounds_plugin_gstreamer_player_class_init (SoundsPluginGStreamerPlayerClass * klass,
                                           gpointer klass_data)
{
	sounds_plugin_gstreamer_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundsPluginGStreamerPlayer_private_offset);
	((SoundsPluginGStreamerPlayerClass *) klass)->finished = sounds_plugin_gstreamer_player_real_finished;
	G_OBJECT_CLASS (klass)->get_property = _vala_sounds_plugin_gstreamer_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sounds_plugin_gstreamer_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = sounds_plugin_gstreamer_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_GSTREAMER_PLAYER_FILE_PROPERTY, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_PROPERTY, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_FADE_PROPERTY, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_FADE_PROPERTY] = g_param_spec_double ("volume-fade", "volume-fade", "volume-fade", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_GSTREAMER_PLAYER_REPEAT_PROPERTY, sounds_plugin_gstreamer_player_properties[SOUNDS_PLUGIN_GSTREAMER_PLAYER_REPEAT_PROPERTY] = g_param_spec_boolean ("repeat", "repeat", "repeat", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sounds_plugin_gstreamer_player_signals[SOUNDS_PLUGIN_GSTREAMER_PLAYER_FINISHED_SIGNAL] = g_signal_new ("finished", SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SoundsPluginGStreamerPlayerClass, finished), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sounds_plugin_gstreamer_player_sounds_plugin_sound_player_interface_init (SoundsPluginSoundPlayerIface * iface,
                                                                          gpointer iface_data)
{
	sounds_plugin_gstreamer_player_sounds_plugin_sound_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->play = (void (*) (SoundsPluginSoundPlayer*)) sounds_plugin_gstreamer_player_real_play;
	iface->stop = (void (*) (SoundsPluginSoundPlayer*)) sounds_plugin_gstreamer_player_real_stop;
	iface->get_file = sounds_plugin_gstreamer_player_real_get_file;
	iface->set_file = sounds_plugin_gstreamer_player_real_set_file;
	iface->get_volume = sounds_plugin_gstreamer_player_real_get_volume;
	iface->set_volume = sounds_plugin_gstreamer_player_real_set_volume;
}

static void
sounds_plugin_gstreamer_player_sounds_plugin_fadeable_interface_init (SoundsPluginFadeableIface * iface,
                                                                      gpointer iface_data)
{
	sounds_plugin_gstreamer_player_sounds_plugin_fadeable_parent_iface = g_type_interface_peek_parent (iface);
	iface->fade_in = (void (*) (SoundsPluginFadeable*, guint)) sounds_plugin_gstreamer_player_real_fade_in;
	iface->fade_out = (void (*) (SoundsPluginFadeable*, guint)) sounds_plugin_gstreamer_player_real_fade_out;
}

static void
sounds_plugin_gstreamer_player_instance_init (SoundsPluginGStreamerPlayer * self,
                                              gpointer klass)
{
	self->priv = sounds_plugin_gstreamer_player_get_instance_private (self);
	self->priv->_repeat = FALSE;
	self->priv->is_about_to_finish = FALSE;
	self->priv->retry_on_error = TRUE;
}

static void
sounds_plugin_gstreamer_player_finalize (GObject * obj)
{
	SoundsPluginGStreamerPlayer * self;
	GstElement* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, SoundsPluginGStreamerPlayer);
	_tmp0_ = self->priv->pipeline;
	if (_tmp0_ != NULL) {
		GstElement* _tmp1_;
		_tmp1_ = self->priv->pipeline;
		gst_element_set_state (_tmp1_, GST_STATE_NULL);
	}
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->volume_filter);
	_g_object_unref0 (self->priv->volume_animation);
	G_OBJECT_CLASS (sounds_plugin_gstreamer_player_parent_class)->finalize (obj);
}

GType
sounds_plugin_gstreamer_player_get_type (void)
{
	return sounds_plugin_gstreamer_player_type_id;
}

GType
sounds_plugin_gstreamer_player_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundsPluginGStreamerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sounds_plugin_gstreamer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundsPluginGStreamerPlayer), 0, (GInstanceInitFunc) sounds_plugin_gstreamer_player_instance_init, NULL };
	static const GInterfaceInfo sounds_plugin_sound_player_info = { (GInterfaceInitFunc) sounds_plugin_gstreamer_player_sounds_plugin_sound_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sounds_plugin_fadeable_info = { (GInterfaceInitFunc) sounds_plugin_gstreamer_player_sounds_plugin_fadeable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	sounds_plugin_gstreamer_player_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SoundsPluginGStreamerPlayer", &g_define_type_info, 0);
	g_type_module_add_interface (module, sounds_plugin_gstreamer_player_type_id, SOUNDS_PLUGIN_TYPE_SOUND_PLAYER, &sounds_plugin_sound_player_info);
	g_type_module_add_interface (module, sounds_plugin_gstreamer_player_type_id, SOUNDS_PLUGIN_TYPE_FADEABLE, &sounds_plugin_fadeable_info);
	SoundsPluginGStreamerPlayer_private_offset = sizeof (SoundsPluginGStreamerPlayerPrivate);
	return sounds_plugin_gstreamer_player_type_id;
}

static void
_vala_sounds_plugin_gstreamer_player_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	SoundsPluginGStreamerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, SoundsPluginGStreamerPlayer);
	switch (property_id) {
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_FILE_PROPERTY:
		g_value_set_object (value, sounds_plugin_sound_player_get_file ((SoundsPluginSoundPlayer*) self));
		break;
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_PROPERTY:
		g_value_set_double (value, sounds_plugin_sound_player_get_volume ((SoundsPluginSoundPlayer*) self));
		break;
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_FADE_PROPERTY:
		g_value_set_double (value, sounds_plugin_gstreamer_player_get_volume_fade (self));
		break;
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_REPEAT_PROPERTY:
		g_value_set_boolean (value, sounds_plugin_gstreamer_player_get_repeat (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sounds_plugin_gstreamer_player_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	SoundsPluginGStreamerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUNDS_PLUGIN_TYPE_GSTREAMER_PLAYER, SoundsPluginGStreamerPlayer);
	switch (property_id) {
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_FILE_PROPERTY:
		sounds_plugin_sound_player_set_file ((SoundsPluginSoundPlayer*) self, g_value_get_object (value));
		break;
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_PROPERTY:
		sounds_plugin_sound_player_set_volume ((SoundsPluginSoundPlayer*) self, g_value_get_double (value));
		break;
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_VOLUME_FADE_PROPERTY:
		sounds_plugin_gstreamer_player_set_volume_fade (self, g_value_get_double (value));
		break;
		case SOUNDS_PLUGIN_GSTREAMER_PLAYER_REPEAT_PROPERTY:
		sounds_plugin_gstreamer_player_set_repeat (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
sounds_plugin_canberra_player_get_instance_private (SoundsPluginCanberraPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, SoundsPluginCanberraPlayer_private_offset);
}

SoundsPluginCanberraPlayer*
sounds_plugin_canberra_player_construct (GType object_type,
                                         const gchar* event_id,
                                         GError** error)
{
	SoundsPluginCanberraPlayer * self = NULL;
	ca_context* context = NULL;
	gint status = 0;
	ca_context* _tmp0_ = NULL;
	gint _tmp1_;
	GApplication* application = NULL;
	GApplication* _tmp2_;
	GApplication* _tmp3_;
	ca_context* _tmp9_;
	GApplication* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ca_context* _tmp18_;
	ca_context* _tmp24_;
	GError* _inner_error0_ = NULL;
	self = (SoundsPluginCanberraPlayer*) g_object_new (object_type, NULL);
	_tmp1_ = ca_context_create (&_tmp0_);
	_ca_context_destroy0 (context);
	context = _tmp0_;
	status = _tmp1_;
	_tmp2_ = g_application_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	application = _tmp3_;
	if (status != CA_SUCCESS) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp4_ = ca_strerror (status);
		_tmp5_ = g_strdup_printf ("Failed to initialize canberra context - %s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new_literal (SOUNDS_PLUGIN_SOUND_PLAYER_ERROR, SOUNDS_PLUGIN_SOUND_PLAYER_ERROR_FAILED_TO_INITIALIZE, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == SOUNDS_PLUGIN_SOUND_PLAYER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (application);
			_ca_context_destroy0 (context);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (application);
			_ca_context_destroy0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = context;
	_tmp10_ = application;
	_tmp11_ = g_application_get_application_id (_tmp10_);
	_tmp12_ = _tmp11_;
	status = ca_context_change_props (_tmp9_, CA_PROP_APPLICATION_ID, _tmp12_, CA_PROP_APPLICATION_NAME, PACKAGE_NAME, CA_PROP_APPLICATION_ICON_NAME, PACKAGE_NAME, NULL);
	if (status != CA_SUCCESS) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GError* _tmp16_;
		GError* _tmp17_;
		_tmp13_ = ca_strerror (status);
		_tmp14_ = g_strdup_printf ("Failed to set context properties - %s", _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_error_new_literal (SOUNDS_PLUGIN_SOUND_PLAYER_ERROR, SOUNDS_PLUGIN_SOUND_PLAYER_ERROR_FAILED_TO_INITIALIZE, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_inner_error0_ = _tmp17_;
		if (_inner_error0_->domain == SOUNDS_PLUGIN_SOUND_PLAYER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (application);
			_ca_context_destroy0 (context);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (application);
			_ca_context_destroy0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp18_ = context;
	status = ca_context_open (_tmp18_);
	if (status != CA_SUCCESS) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		_tmp19_ = ca_strerror (status);
		_tmp20_ = g_strdup_printf ("Failed to open canberra context - %s", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (SOUNDS_PLUGIN_SOUND_PLAYER_ERROR, SOUNDS_PLUGIN_SOUND_PLAYER_ERROR_FAILED_TO_INITIALIZE, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_inner_error0_ = _tmp23_;
		if (_inner_error0_->domain == SOUNDS_PLUGIN_SOUND_PLAYER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (application);
			_ca_context_destroy0 (context);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (application);
			_ca_context_destroy0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp24_ = context;
	context = NULL;
	_ca_context_destroy0 (self->priv->context);
	self->priv->context = _tmp24_;
	sounds_plugin_canberra_player_set_event_id (self, event_id);
	_g_object_unref0 (application);
	_ca_context_destroy0 (context);
	return self;
}

SoundsPluginCanberraPlayer*
sounds_plugin_canberra_player_new (const gchar* event_id,
                                   GError** error)
{
	return sounds_plugin_canberra_player_construct (SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER, event_id, error);
}

static gdouble
sounds_plugin_canberra_player_amplitude_to_decibels (gdouble amplitude)
{
	gdouble result;
	result = 20.0 * log10 (amplitude);
	return result;
}

static void
_sounds_plugin_canberra_player_on_play_callback_ca_finishcallback (ca_context* c,
                                                                   guint32 id,
                                                                   gint code,
                                                                   gpointer self)
{
	sounds_plugin_canberra_player_on_play_callback ((SoundsPluginCanberraPlayer*) self, c, id, code);
}

static void
sounds_plugin_canberra_player_real_play (SoundsPluginSoundPlayer* base)
{
	SoundsPluginCanberraPlayer * self;
	ca_context* _tmp0_;
	GFile* _tmp1_;
	self = (SoundsPluginCanberraPlayer*) base;
	_tmp0_ = self->priv->context;
	_vala_return_if_fail (_tmp0_ != NULL, "this.context != null");
	_tmp1_ = self->priv->_file;
	if (_tmp1_ != NULL) {
		ca_context* _tmp2_;
		_tmp2_ = self->priv->context;
		if (_tmp2_ != NULL) {
			ca_proplist* properties = NULL;
			gint status = 0;
			ca_proplist* _tmp3_ = NULL;
			gint _tmp4_;
			ca_proplist* _tmp5_;
			ca_proplist* _tmp6_;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			ca_proplist* _tmp10_;
			gdouble _tmp11_;
			gdouble _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			ca_context* _tmp18_;
			ca_proplist* _tmp19_;
			properties = NULL;
			_tmp4_ = ca_proplist_create (&_tmp3_);
			_ca_proplist_destroy0 (properties);
			properties = _tmp3_;
			status = _tmp4_;
			_tmp5_ = properties;
			ca_proplist_sets (_tmp5_, CA_PROP_MEDIA_ROLE, "alert");
			_tmp6_ = properties;
			_tmp7_ = self->priv->_file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			ca_proplist_sets (_tmp6_, CA_PROP_MEDIA_FILENAME, _tmp9_);
			_g_free0 (_tmp9_);
			_tmp10_ = properties;
			_tmp11_ = sounds_plugin_sound_player_get_volume ((SoundsPluginSoundPlayer*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("%g", (gfloat) sounds_plugin_canberra_player_amplitude_to_decibels (_tmp12_));
			_tmp14_ = _tmp13_;
			ca_proplist_sets (_tmp10_, CA_PROP_CANBERRA_VOLUME, _tmp14_);
			_g_free0 (_tmp14_);
			_tmp15_ = self->priv->_event_id;
			if (_tmp15_ != NULL) {
				ca_proplist* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = properties;
				_tmp17_ = self->priv->_event_id;
				ca_proplist_sets (_tmp16_, CA_PROP_EVENT_ID, _tmp17_);
				if (!self->priv->is_cached) {
					sounds_plugin_canberra_player_cache_file (self);
				}
			}
			_tmp18_ = self->priv->context;
			_tmp19_ = properties;
			status = ca_context_play_full (_tmp18_, (guint32) 0, _tmp19_, _sounds_plugin_canberra_player_on_play_callback_ca_finishcallback, self);
			if (status != CA_SUCCESS) {
				GFile* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp20_ = self->priv->_file;
				_tmp21_ = g_file_get_uri (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = ca_strerror (status);
				g_warning ("sound-player.vala:472: Couldn't play sound '%s' - %s", _tmp22_, _tmp23_);
				_g_free0 (_tmp22_);
			}
			_ca_proplist_destroy0 (properties);
		} else {
			GFile* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = self->priv->_file;
			_tmp25_ = g_file_get_uri (_tmp24_);
			_tmp26_ = _tmp25_;
			g_warning ("sound-player.vala:478: Couldn't play sound '%s'", _tmp26_);
			_g_free0 (_tmp26_);
		}
	}
}

static void
sounds_plugin_canberra_player_real_stop (SoundsPluginSoundPlayer* base)
{
	SoundsPluginCanberraPlayer * self;
	ca_context* _tmp0_;
	self = (SoundsPluginCanberraPlayer*) base;
	_tmp0_ = self->priv->context;
	_vala_return_if_fail (_tmp0_ != NULL, "this.context != null");
}

static gchar**
sounds_plugin_canberra_player_real_get_supported_mime_types (SoundsPluginSoundPlayer* base,
                                                             gint* result_length1)
{
	SoundsPluginCanberraPlayer * self;
	gchar** mime_types = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint mime_types_length1;
	gint _mime_types_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	self = (SoundsPluginCanberraPlayer*) base;
	_tmp0_ = g_strdup ("audio/x-vorbis+ogg");
	_tmp1_ = g_strdup ("audio/x-wav");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	mime_types = _tmp2_;
	mime_types_length1 = 2;
	_mime_types_size_ = mime_types_length1;
	_tmp3_ = mime_types;
	_tmp3__length1 = mime_types_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static void
sounds_plugin_canberra_player_cache_file (SoundsPluginCanberraPlayer* self)
{
	ca_proplist* properties = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ca_context* _tmp2_;
	g_return_if_fail (self != NULL);
	properties = NULL;
	_tmp2_ = self->priv->context;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_event_id;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GFile* _tmp4_;
		_tmp4_ = self->priv->_file;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint status = 0;
		ca_proplist* _tmp5_ = NULL;
		gint _tmp6_;
		ca_proplist* _tmp7_;
		const gchar* _tmp8_;
		ca_proplist* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		ca_context* _tmp13_;
		ca_proplist* _tmp14_;
		_tmp6_ = ca_proplist_create (&_tmp5_);
		_ca_proplist_destroy0 (properties);
		properties = _tmp5_;
		status = _tmp6_;
		_tmp7_ = properties;
		_tmp8_ = self->priv->_event_id;
		ca_proplist_sets (_tmp7_, CA_PROP_EVENT_ID, _tmp8_);
		_tmp9_ = properties;
		_tmp10_ = self->priv->_file;
		_tmp11_ = g_file_get_path (_tmp10_);
		_tmp12_ = _tmp11_;
		ca_proplist_sets (_tmp9_, CA_PROP_MEDIA_FILENAME, _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = self->priv->context;
		_tmp14_ = properties;
		status = ca_context_cache_full (_tmp13_, _tmp14_);
		if (status != CA_SUCCESS) {
			const gchar* _tmp15_;
			_tmp15_ = ca_strerror (status);
			g_warning ("sound-player.vala:513: Couldn't clear libcanberra cache - %s", _tmp15_);
		} else {
			self->priv->is_cached = TRUE;
		}
	}
	_ca_proplist_destroy0 (properties);
}

static void
sounds_plugin_canberra_player_on_play_callback (SoundsPluginCanberraPlayer* self,
                                                ca_context* context,
                                                guint32 id,
                                                gint code)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
}

static GFile*
sounds_plugin_canberra_player_real_get_file (SoundsPluginSoundPlayer* base)
{
	GFile* result;
	SoundsPluginCanberraPlayer* self;
	GFile* _tmp0_;
	self = (SoundsPluginCanberraPlayer*) base;
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
sounds_plugin_canberra_player_real_set_file (SoundsPluginSoundPlayer* base,
                                             GFile* value)
{
	SoundsPluginCanberraPlayer* self;
	GFile* _tmp0_ = NULL;
	GFile* _tmp6_;
	self = (SoundsPluginCanberraPlayer*) base;
	if (value != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		_tmp1_ = g_file_get_uri (value);
		_tmp2_ = _tmp1_;
		_tmp3_ = sounds_plugin_get_absolute_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp6_;
	if (self->priv->is_cached) {
		sounds_plugin_canberra_player_cache_file (self);
	}
	_g_object_unref0 (_tmp0_);
	g_object_notify_by_pspec ((GObject *) self, sounds_plugin_canberra_player_properties[SOUNDS_PLUGIN_CANBERRA_PLAYER_FILE_PROPERTY]);
}

const gchar*
sounds_plugin_canberra_player_get_event_id (SoundsPluginCanberraPlayer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event_id;
	result = _tmp0_;
	return result;
}

static void
sounds_plugin_canberra_player_set_event_id (SoundsPluginCanberraPlayer* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sounds_plugin_canberra_player_get_event_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_event_id);
		self->priv->_event_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sounds_plugin_canberra_player_properties[SOUNDS_PLUGIN_CANBERRA_PLAYER_EVENT_ID_PROPERTY]);
	}
}

static gdouble
sounds_plugin_canberra_player_real_get_volume (SoundsPluginSoundPlayer* base)
{
	gdouble result;
	SoundsPluginCanberraPlayer* self;
	self = (SoundsPluginCanberraPlayer*) base;
	result = self->priv->_volume;
	return result;
}

static void
sounds_plugin_canberra_player_real_set_volume (SoundsPluginSoundPlayer* base,
                                               gdouble value)
{
	SoundsPluginCanberraPlayer* self;
	gdouble old_value;
	self = (SoundsPluginCanberraPlayer*) base;
	old_value = sounds_plugin_canberra_player_real_get_volume (base);
	if (old_value != value) {
		self->priv->_volume = value;
		g_object_notify_by_pspec ((GObject *) self, sounds_plugin_canberra_player_properties[SOUNDS_PLUGIN_CANBERRA_PLAYER_VOLUME_PROPERTY]);
	}
}

static void
sounds_plugin_canberra_player_class_init (SoundsPluginCanberraPlayerClass * klass,
                                          gpointer klass_data)
{
	sounds_plugin_canberra_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundsPluginCanberraPlayer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sounds_plugin_canberra_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sounds_plugin_canberra_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = sounds_plugin_canberra_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_CANBERRA_PLAYER_FILE_PROPERTY, sounds_plugin_canberra_player_properties[SOUNDS_PLUGIN_CANBERRA_PLAYER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_CANBERRA_PLAYER_EVENT_ID_PROPERTY, sounds_plugin_canberra_player_properties[SOUNDS_PLUGIN_CANBERRA_PLAYER_EVENT_ID_PROPERTY] = g_param_spec_string ("event-id", "event-id", "event-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_CANBERRA_PLAYER_VOLUME_PROPERTY, sounds_plugin_canberra_player_properties[SOUNDS_PLUGIN_CANBERRA_PLAYER_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sounds_plugin_canberra_player_sounds_plugin_sound_player_interface_init (SoundsPluginSoundPlayerIface * iface,
                                                                         gpointer iface_data)
{
	sounds_plugin_canberra_player_sounds_plugin_sound_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->play = (void (*) (SoundsPluginSoundPlayer*)) sounds_plugin_canberra_player_real_play;
	iface->stop = (void (*) (SoundsPluginSoundPlayer*)) sounds_plugin_canberra_player_real_stop;
	iface->get_supported_mime_types = (gchar** (*) (SoundsPluginSoundPlayer*, gint*)) sounds_plugin_canberra_player_real_get_supported_mime_types;
	iface->get_file = sounds_plugin_canberra_player_real_get_file;
	iface->set_file = sounds_plugin_canberra_player_real_set_file;
	iface->get_volume = sounds_plugin_canberra_player_real_get_volume;
	iface->set_volume = sounds_plugin_canberra_player_real_set_volume;
}

static void
sounds_plugin_canberra_player_instance_init (SoundsPluginCanberraPlayer * self,
                                             gpointer klass)
{
	self->priv = sounds_plugin_canberra_player_get_instance_private (self);
	self->priv->_volume = 1.0;
	self->priv->is_cached = FALSE;
}

static void
sounds_plugin_canberra_player_finalize (GObject * obj)
{
	SoundsPluginCanberraPlayer * self;
	ca_context* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER, SoundsPluginCanberraPlayer);
	_tmp0_ = self->priv->context;
	if (_tmp0_ != NULL) {
		sounds_plugin_sound_player_stop ((SoundsPluginSoundPlayer*) self);
	}
	_g_free0 (self->priv->_event_id);
	_g_object_unref0 (self->priv->_file);
	_ca_context_destroy0 (self->priv->context);
	G_OBJECT_CLASS (sounds_plugin_canberra_player_parent_class)->finalize (obj);
}

GType
sounds_plugin_canberra_player_get_type (void)
{
	return sounds_plugin_canberra_player_type_id;
}

GType
sounds_plugin_canberra_player_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundsPluginCanberraPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sounds_plugin_canberra_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundsPluginCanberraPlayer), 0, (GInstanceInitFunc) sounds_plugin_canberra_player_instance_init, NULL };
	static const GInterfaceInfo sounds_plugin_sound_player_info = { (GInterfaceInitFunc) sounds_plugin_canberra_player_sounds_plugin_sound_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	sounds_plugin_canberra_player_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SoundsPluginCanberraPlayer", &g_define_type_info, 0);
	g_type_module_add_interface (module, sounds_plugin_canberra_player_type_id, SOUNDS_PLUGIN_TYPE_SOUND_PLAYER, &sounds_plugin_sound_player_info);
	SoundsPluginCanberraPlayer_private_offset = sizeof (SoundsPluginCanberraPlayerPrivate);
	return sounds_plugin_canberra_player_type_id;
}

static void
_vala_sounds_plugin_canberra_player_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	SoundsPluginCanberraPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER, SoundsPluginCanberraPlayer);
	switch (property_id) {
		case SOUNDS_PLUGIN_CANBERRA_PLAYER_FILE_PROPERTY:
		g_value_set_object (value, sounds_plugin_sound_player_get_file ((SoundsPluginSoundPlayer*) self));
		break;
		case SOUNDS_PLUGIN_CANBERRA_PLAYER_EVENT_ID_PROPERTY:
		g_value_set_string (value, sounds_plugin_canberra_player_get_event_id (self));
		break;
		case SOUNDS_PLUGIN_CANBERRA_PLAYER_VOLUME_PROPERTY:
		g_value_set_double (value, sounds_plugin_sound_player_get_volume ((SoundsPluginSoundPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sounds_plugin_canberra_player_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	SoundsPluginCanberraPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUNDS_PLUGIN_TYPE_CANBERRA_PLAYER, SoundsPluginCanberraPlayer);
	switch (property_id) {
		case SOUNDS_PLUGIN_CANBERRA_PLAYER_FILE_PROPERTY:
		sounds_plugin_sound_player_set_file ((SoundsPluginSoundPlayer*) self, g_value_get_object (value));
		break;
		case SOUNDS_PLUGIN_CANBERRA_PLAYER_EVENT_ID_PROPERTY:
		sounds_plugin_canberra_player_set_event_id (self, g_value_get_string (value));
		break;
		case SOUNDS_PLUGIN_CANBERRA_PLAYER_VOLUME_PROPERTY:
		sounds_plugin_sound_player_set_volume ((SoundsPluginSoundPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
sounds_plugin_dummy_player_get_instance_private (SoundsPluginDummyPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, SoundsPluginDummyPlayer_private_offset);
}

static void
sounds_plugin_dummy_player_real_play (SoundsPluginSoundPlayer* base)
{
	SoundsPluginDummyPlayer * self;
	self = (SoundsPluginDummyPlayer*) base;
}

static void
sounds_plugin_dummy_player_real_stop (SoundsPluginSoundPlayer* base)
{
	SoundsPluginDummyPlayer * self;
	self = (SoundsPluginDummyPlayer*) base;
}

SoundsPluginDummyPlayer*
sounds_plugin_dummy_player_construct (GType object_type)
{
	SoundsPluginDummyPlayer * self = NULL;
	self = (SoundsPluginDummyPlayer*) g_object_new (object_type, NULL);
	return self;
}

SoundsPluginDummyPlayer*
sounds_plugin_dummy_player_new (void)
{
	return sounds_plugin_dummy_player_construct (SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER);
}

static GFile*
sounds_plugin_dummy_player_real_get_file (SoundsPluginSoundPlayer* base)
{
	GFile* result;
	SoundsPluginDummyPlayer* self;
	GFile* _tmp0_;
	self = (SoundsPluginDummyPlayer*) base;
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
sounds_plugin_dummy_player_real_set_file (SoundsPluginSoundPlayer* base,
                                          GFile* value)
{
	SoundsPluginDummyPlayer* self;
	GFile* _tmp0_ = NULL;
	GFile* _tmp6_;
	self = (SoundsPluginDummyPlayer*) base;
	if (value != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		_tmp1_ = g_file_get_uri (value);
		_tmp2_ = _tmp1_;
		_tmp3_ = sounds_plugin_get_absolute_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp6_;
	_g_object_unref0 (_tmp0_);
	g_object_notify_by_pspec ((GObject *) self, sounds_plugin_dummy_player_properties[SOUNDS_PLUGIN_DUMMY_PLAYER_FILE_PROPERTY]);
}

static gdouble
sounds_plugin_dummy_player_real_get_volume (SoundsPluginSoundPlayer* base)
{
	gdouble result;
	SoundsPluginDummyPlayer* self;
	self = (SoundsPluginDummyPlayer*) base;
	result = self->priv->_volume;
	return result;
}

static void
sounds_plugin_dummy_player_real_set_volume (SoundsPluginSoundPlayer* base,
                                            gdouble value)
{
	SoundsPluginDummyPlayer* self;
	gdouble old_value;
	self = (SoundsPluginDummyPlayer*) base;
	old_value = sounds_plugin_dummy_player_real_get_volume (base);
	if (old_value != value) {
		self->priv->_volume = value;
		g_object_notify_by_pspec ((GObject *) self, sounds_plugin_dummy_player_properties[SOUNDS_PLUGIN_DUMMY_PLAYER_VOLUME_PROPERTY]);
	}
}

static void
sounds_plugin_dummy_player_class_init (SoundsPluginDummyPlayerClass * klass,
                                       gpointer klass_data)
{
	sounds_plugin_dummy_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundsPluginDummyPlayer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sounds_plugin_dummy_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sounds_plugin_dummy_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = sounds_plugin_dummy_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_DUMMY_PLAYER_FILE_PROPERTY, sounds_plugin_dummy_player_properties[SOUNDS_PLUGIN_DUMMY_PLAYER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUNDS_PLUGIN_DUMMY_PLAYER_VOLUME_PROPERTY, sounds_plugin_dummy_player_properties[SOUNDS_PLUGIN_DUMMY_PLAYER_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sounds_plugin_dummy_player_sounds_plugin_sound_player_interface_init (SoundsPluginSoundPlayerIface * iface,
                                                                      gpointer iface_data)
{
	sounds_plugin_dummy_player_sounds_plugin_sound_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->play = (void (*) (SoundsPluginSoundPlayer*)) sounds_plugin_dummy_player_real_play;
	iface->stop = (void (*) (SoundsPluginSoundPlayer*)) sounds_plugin_dummy_player_real_stop;
	iface->get_file = sounds_plugin_dummy_player_real_get_file;
	iface->set_file = sounds_plugin_dummy_player_real_set_file;
	iface->get_volume = sounds_plugin_dummy_player_real_get_volume;
	iface->set_volume = sounds_plugin_dummy_player_real_set_volume;
}

static void
sounds_plugin_dummy_player_instance_init (SoundsPluginDummyPlayer * self,
                                          gpointer klass)
{
	self->priv = sounds_plugin_dummy_player_get_instance_private (self);
	self->priv->_volume = 1.0;
}

static void
sounds_plugin_dummy_player_finalize (GObject * obj)
{
	SoundsPluginDummyPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER, SoundsPluginDummyPlayer);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (sounds_plugin_dummy_player_parent_class)->finalize (obj);
}

GType
sounds_plugin_dummy_player_get_type (void)
{
	return sounds_plugin_dummy_player_type_id;
}

GType
sounds_plugin_dummy_player_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundsPluginDummyPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sounds_plugin_dummy_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundsPluginDummyPlayer), 0, (GInstanceInitFunc) sounds_plugin_dummy_player_instance_init, NULL };
	static const GInterfaceInfo sounds_plugin_sound_player_info = { (GInterfaceInitFunc) sounds_plugin_dummy_player_sounds_plugin_sound_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	sounds_plugin_dummy_player_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SoundsPluginDummyPlayer", &g_define_type_info, 0);
	g_type_module_add_interface (module, sounds_plugin_dummy_player_type_id, SOUNDS_PLUGIN_TYPE_SOUND_PLAYER, &sounds_plugin_sound_player_info);
	SoundsPluginDummyPlayer_private_offset = sizeof (SoundsPluginDummyPlayerPrivate);
	return sounds_plugin_dummy_player_type_id;
}

static void
_vala_sounds_plugin_dummy_player_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SoundsPluginDummyPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER, SoundsPluginDummyPlayer);
	switch (property_id) {
		case SOUNDS_PLUGIN_DUMMY_PLAYER_FILE_PROPERTY:
		g_value_set_object (value, sounds_plugin_sound_player_get_file ((SoundsPluginSoundPlayer*) self));
		break;
		case SOUNDS_PLUGIN_DUMMY_PLAYER_VOLUME_PROPERTY:
		g_value_set_double (value, sounds_plugin_sound_player_get_volume ((SoundsPluginSoundPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sounds_plugin_dummy_player_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SoundsPluginDummyPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUNDS_PLUGIN_TYPE_DUMMY_PLAYER, SoundsPluginDummyPlayer);
	switch (property_id) {
		case SOUNDS_PLUGIN_DUMMY_PLAYER_FILE_PROPERTY:
		sounds_plugin_sound_player_set_file ((SoundsPluginSoundPlayer*) self, g_value_get_object (value));
		break;
		case SOUNDS_PLUGIN_DUMMY_PLAYER_VOLUME_PROPERTY:
		sounds_plugin_sound_player_set_volume ((SoundsPluginSoundPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

