/* accelerator.c generated by valac 0.56.17, the Vala compiler
 * generated from accelerator.vala, do not modify */

/*
 * based on keyboard-shortcuts.c from gnome-control-center
 *
 * Copyright (c) 2013 gnome-pomodoro contributors
 *               2010 Intel, Inc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *          Thomas Wood <thomas.wood@intel.com>
 *          Rodrigo Moya <rodrigo@gnome.org>
 */
/* TODO:
 * Handle integration with window manager
 *  - suppress any keybings from being triggered
 *  - if keybinding is taken, notify about it
 *
 * For now gnome-shell extension is responsible for setting it.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gnome-pomodoro.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define POMODORO_TYPE_ACCELERATOR_ERROR (pomodoro_accelerator_error_get_type ())

#define POMODORO_TYPE_ACCELERATOR (pomodoro_accelerator_get_type ())
#define POMODORO_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_ACCELERATOR, PomodoroAccelerator))
#define POMODORO_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_ACCELERATOR, PomodoroAcceleratorClass))
#define POMODORO_IS_ACCELERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_ACCELERATOR))
#define POMODORO_IS_ACCELERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_ACCELERATOR))
#define POMODORO_ACCELERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_ACCELERATOR, PomodoroAcceleratorClass))

typedef struct _PomodoroAccelerator PomodoroAccelerator;
typedef struct _PomodoroAcceleratorClass PomodoroAcceleratorClass;
typedef struct _PomodoroAcceleratorPrivate PomodoroAcceleratorPrivate;
enum  {
	POMODORO_ACCELERATOR_0_PROPERTY,
	POMODORO_ACCELERATOR_NAME_PROPERTY,
	POMODORO_ACCELERATOR_DISPLAY_NAME_PROPERTY,
	POMODORO_ACCELERATOR_NUM_PROPERTIES
};
static GParamSpec* pomodoro_accelerator_properties[POMODORO_ACCELERATOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	POMODORO_ACCELERATOR_CHANGED_SIGNAL,
	POMODORO_ACCELERATOR_NUM_SIGNALS
};
static guint pomodoro_accelerator_signals[POMODORO_ACCELERATOR_NUM_SIGNALS] = {0};

typedef enum  {
	POMODORO_ACCELERATOR_ERROR_INVALID,
	POMODORO_ACCELERATOR_ERROR_FORBIDDEN,
	POMODORO_ACCELERATOR_ERROR_TYPING_COLLISION
} PomodoroAcceleratorError;
#define POMODORO_ACCELERATOR_ERROR pomodoro_accelerator_error_quark ()

struct _PomodoroAccelerator {
	GObject parent_instance;
	PomodoroAcceleratorPrivate * priv;
};

struct _PomodoroAcceleratorClass {
	GObjectClass parent_class;
	void (*changed) (PomodoroAccelerator* self);
};

struct _PomodoroAcceleratorPrivate {
	guint _key;
	GdkModifierType _modifiers;
};

static gint PomodoroAccelerator_private_offset;
static gpointer pomodoro_accelerator_parent_class = NULL;

VALA_EXTERN GQuark pomodoro_accelerator_error_quark (void);
VALA_EXTERN GType pomodoro_accelerator_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pomodoro_accelerator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PomodoroAccelerator* pomodoro_accelerator_new_from_name (const gchar* name);
VALA_EXTERN PomodoroAccelerator* pomodoro_accelerator_construct_from_name (GType object_type,
                                                               const gchar* name);
VALA_EXTERN void pomodoro_accelerator_set_name (PomodoroAccelerator* self,
                                    const gchar* value);
static void pomodoro_accelerator_parse (const gchar* name,
                                 guint* keyval,
                                 GdkModifierType* modifiers);
VALA_EXTERN void pomodoro_accelerator_unset (PomodoroAccelerator* self);
static void pomodoro_accelerator_set_key (PomodoroAccelerator* self,
                                   guint value);
static void pomodoro_accelerator_set_modifiers (PomodoroAccelerator* self,
                                         GdkModifierType value);
static void pomodoro_accelerator_normalize (guint* keyval,
                                     GdkModifierType* modifiers);
VALA_EXTERN void pomodoro_accelerator_set_keyval (PomodoroAccelerator* self,
                                      guint keyval,
                                      GdkModifierType modifiers);
static guint pomodoro_accelerator_get_key (PomodoroAccelerator* self);
static GdkModifierType pomodoro_accelerator_get_modifiers (PomodoroAccelerator* self);
VALA_EXTERN void pomodoro_accelerator_validate (PomodoroAccelerator* self,
                                    GError** error);
static gchar** pomodoro_accelerator_get_keys_internal (PomodoroAccelerator* self,
                                                gboolean escape,
                                                gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gchar** pomodoro_accelerator_get_keys (PomodoroAccelerator* self,
                                       gint* result_length1);
VALA_EXTERN PomodoroAccelerator* pomodoro_accelerator_new (void);
VALA_EXTERN PomodoroAccelerator* pomodoro_accelerator_construct (GType object_type);
VALA_EXTERN gchar* pomodoro_accelerator_get_name (PomodoroAccelerator* self);
VALA_EXTERN gchar* pomodoro_accelerator_get_display_name (PomodoroAccelerator* self);
static void pomodoro_accelerator_real_changed (PomodoroAccelerator* self);
static void pomodoro_accelerator_finalize (GObject * obj);
static GType pomodoro_accelerator_get_type_once (void);
static void _vala_pomodoro_accelerator_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_pomodoro_accelerator_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GQuark
pomodoro_accelerator_error_quark (void)
{
	return g_quark_from_static_string ("pomodoro-accelerator-error-quark");
}

static GType
pomodoro_accelerator_error_get_type_once (void)
{
	static const GEnumValue values[] = {{POMODORO_ACCELERATOR_ERROR_INVALID, "POMODORO_ACCELERATOR_ERROR_INVALID", "invalid"}, {POMODORO_ACCELERATOR_ERROR_FORBIDDEN, "POMODORO_ACCELERATOR_ERROR_FORBIDDEN", "forbidden"}, {POMODORO_ACCELERATOR_ERROR_TYPING_COLLISION, "POMODORO_ACCELERATOR_ERROR_TYPING_COLLISION", "typing-collision"}, {0, NULL, NULL}};
	GType pomodoro_accelerator_error_type_id;
	pomodoro_accelerator_error_type_id = g_enum_register_static ("PomodoroAcceleratorError", values);
	return pomodoro_accelerator_error_type_id;
}

GType
pomodoro_accelerator_error_get_type (void)
{
	static volatile gsize pomodoro_accelerator_error_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_accelerator_error_type_id__once)) {
		GType pomodoro_accelerator_error_type_id;
		pomodoro_accelerator_error_type_id = pomodoro_accelerator_error_get_type_once ();
		g_once_init_leave (&pomodoro_accelerator_error_type_id__once, pomodoro_accelerator_error_type_id);
	}
	return pomodoro_accelerator_error_type_id__once;
}

static inline gpointer
pomodoro_accelerator_get_instance_private (PomodoroAccelerator* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroAccelerator_private_offset);
}

PomodoroAccelerator*
pomodoro_accelerator_construct_from_name (GType object_type,
                                          const gchar* name)
{
	PomodoroAccelerator * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (PomodoroAccelerator*) g_object_new (object_type, NULL);
	pomodoro_accelerator_set_name (self, name);
	return self;
}

PomodoroAccelerator*
pomodoro_accelerator_new_from_name (const gchar* name)
{
	return pomodoro_accelerator_construct_from_name (POMODORO_TYPE_ACCELERATOR, name);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
pomodoro_accelerator_parse (const gchar* name,
                            guint* keyval,
                            GdkModifierType* modifiers)
{
	guint _vala_keyval = 0U;
	GdkModifierType _vala_modifiers = 0U;
	gint pos = 0;
	gint start = 0;
	gchar chr = '\0';
	gboolean is_modifier = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp10_;
	gchar* _tmp11_;
	pos = 0;
	start = 0;
	chr = '\0';
	is_modifier = FALSE;
	_vala_keyval = (guint) 0;
	_vala_modifiers = 0;
	if (name == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (name, "") == 0;
	}
	if (_tmp0_) {
		if (keyval) {
			*keyval = _vala_keyval;
		}
		if (modifiers) {
			*modifiers = _vala_modifiers;
		}
		return;
	}
	while (TRUE) {
		gint _tmp9_;
		chr = string_get (name, (glong) pos);
		if (!(chr != '\0')) {
			break;
		}
		if (chr == '<') {
			start = pos + 1;
			is_modifier = TRUE;
		} else {
			gboolean _tmp1_ = FALSE;
			if (chr == '>') {
				_tmp1_ = is_modifier;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				gchar* modifier = NULL;
				gchar* _tmp2_;
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp2_ = string_slice (name, (glong) start, (glong) pos);
				modifier = _tmp2_;
				_tmp4_ = modifier;
				if (g_strcmp0 (_tmp4_, "Ctrl") == 0) {
					_tmp3_ = TRUE;
				} else {
					const gchar* _tmp5_;
					_tmp5_ = modifier;
					_tmp3_ = g_strcmp0 (_tmp5_, "Control") == 0;
				}
				if (_tmp3_) {
					_vala_modifiers = _vala_modifiers | GDK_CONTROL_MASK;
				}
				_tmp6_ = modifier;
				if (g_strcmp0 (_tmp6_, "Alt") == 0) {
					_vala_modifiers = _vala_modifiers | GDK_MOD1_MASK;
				}
				_tmp7_ = modifier;
				if (g_strcmp0 (_tmp7_, "Shift") == 0) {
					_vala_modifiers = _vala_modifiers | GDK_SHIFT_MASK;
				}
				_tmp8_ = modifier;
				if (g_strcmp0 (_tmp8_, "Super") == 0) {
					_vala_modifiers = _vala_modifiers | GDK_SUPER_MASK;
				}
				is_modifier = FALSE;
				start = pos + 1;
				_g_free0 (modifier);
			}
		}
		_tmp9_ = pos;
		pos = _tmp9_ + 1;
	}
	_tmp10_ = string_slice (name, (glong) start, (glong) pos);
	_tmp11_ = _tmp10_;
	_vala_keyval = gdk_keyval_from_name (_tmp11_);
	_g_free0 (_tmp11_);
	if (keyval) {
		*keyval = _vala_keyval;
	}
	if (modifiers) {
		*modifiers = _vala_modifiers;
	}
}

void
pomodoro_accelerator_unset (PomodoroAccelerator* self)
{
	g_return_if_fail (self != NULL);
	pomodoro_accelerator_set_key (self, (guint) 0);
	pomodoro_accelerator_set_modifiers (self, 0);
	g_signal_emit (self, pomodoro_accelerator_signals[POMODORO_ACCELERATOR_CHANGED_SIGNAL], 0);
}

static void
pomodoro_accelerator_normalize (guint* keyval,
                                GdkModifierType* modifiers)
{
	GdkModifierType keyval_modifier = 0U;
	keyval_modifier = 0;
	switch (*keyval) {
		case GDK_KEY_Control_L:
		case GDK_KEY_Control_R:
		{
			keyval_modifier = GDK_CONTROL_MASK;
			break;
		}
		case GDK_KEY_Shift_L:
		case GDK_KEY_Shift_R:
		{
			keyval_modifier = GDK_SHIFT_MASK;
			break;
		}
		case GDK_KEY_Super_L:
		case GDK_KEY_Super_R:
		{
			keyval_modifier = GDK_SUPER_MASK;
			break;
		}
		case GDK_KEY_Alt_L:
		case GDK_KEY_Alt_R:
		{
			keyval_modifier = GDK_MOD1_MASK;
			break;
		}
		default:
		break;
	}
	if (keyval_modifier != 0) {
		*keyval = (guint) 0;
		*modifiers = (*modifiers) | keyval_modifier;
	}
	*modifiers = (*modifiers) & (((GDK_CONTROL_MASK | GDK_SHIFT_MASK) | GDK_SUPER_MASK) | GDK_MOD1_MASK);
}

void
pomodoro_accelerator_set_keyval (PomodoroAccelerator* self,
                                 guint keyval,
                                 GdkModifierType modifiers)
{
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	pomodoro_accelerator_normalize (&keyval, &modifiers);
	_tmp1_ = self->priv->_key;
	if (_tmp1_ != keyval) {
		_tmp0_ = TRUE;
	} else {
		GdkModifierType _tmp2_;
		_tmp2_ = self->priv->_modifiers;
		_tmp0_ = _tmp2_ != modifiers;
	}
	if (_tmp0_) {
		pomodoro_accelerator_set_key (self, keyval);
		pomodoro_accelerator_set_modifiers (self, modifiers);
		g_signal_emit (self, pomodoro_accelerator_signals[POMODORO_ACCELERATOR_CHANGED_SIGNAL], 0);
	}
}

void
pomodoro_accelerator_validate (PomodoroAccelerator* self,
                               GError** error)
{
	guint key = 0U;
	guint _tmp0_;
	GdkModifierType modifiers = 0U;
	GdkModifierType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_key;
	key = _tmp0_;
	_tmp1_ = self->priv->_modifiers;
	modifiers = _tmp1_;
	if (key == ((guint) 0)) {
		_tmp2_ = modifiers == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		return;
	}
	if (!gtk_accelerator_valid (key, modifiers)) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (POMODORO_ACCELERATOR_ERROR, POMODORO_ACCELERATOR_ERROR_INVALID, "Invalid");
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == POMODORO_ACCELERATOR_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (key != ((guint) 0)) {
		_tmp4_ = modifiers == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (key == GDK_KEY_Escape) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = key == GDK_KEY_BackSpace;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = key == GDK_KEY_Return;
		}
		if (_tmp5_) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (POMODORO_ACCELERATOR_ERROR, POMODORO_ACCELERATOR_ERROR_FORBIDDEN, "Forbidden");
			_inner_error0_ = _tmp7_;
			if (_inner_error0_->domain == POMODORO_ACCELERATOR_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	if (key != ((guint) 0)) {
		gboolean _tmp9_ = FALSE;
		if (modifiers == 0) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = modifiers == GDK_SHIFT_MASK;
		}
		_tmp8_ = _tmp9_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		if (key >= GDK_KEY_a) {
			_tmp20_ = key <= GDK_KEY_z;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp21_ = FALSE;
			if (key >= GDK_KEY_A) {
				_tmp21_ = key <= GDK_KEY_Z;
			} else {
				_tmp21_ = FALSE;
			}
			_tmp19_ = _tmp21_;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp22_ = FALSE;
			if (key >= GDK_KEY_0) {
				_tmp22_ = key <= GDK_KEY_9;
			} else {
				_tmp22_ = FALSE;
			}
			_tmp18_ = _tmp22_;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			gboolean _tmp23_ = FALSE;
			if (key >= GDK_KEY_kana_fullstop) {
				_tmp23_ = key <= GDK_KEY_semivoicedsound;
			} else {
				_tmp23_ = FALSE;
			}
			_tmp17_ = _tmp23_;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			gboolean _tmp24_ = FALSE;
			if (key >= GDK_KEY_Arabic_comma) {
				_tmp24_ = key <= GDK_KEY_Arabic_sukun;
			} else {
				_tmp24_ = FALSE;
			}
			_tmp16_ = _tmp24_;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			if (key >= GDK_KEY_Serbian_dje) {
				_tmp25_ = key <= GDK_KEY_Cyrillic_HARDSIGN;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp15_ = _tmp25_;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp26_ = FALSE;
			if (key >= GDK_KEY_Greek_ALPHAaccent) {
				_tmp26_ = key <= GDK_KEY_Greek_omega;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp14_ = _tmp26_;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			gboolean _tmp27_ = FALSE;
			if (key >= GDK_KEY_hebrew_doublelowline) {
				_tmp27_ = key <= GDK_KEY_hebrew_taf;
			} else {
				_tmp27_ = FALSE;
			}
			_tmp13_ = _tmp27_;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp28_ = FALSE;
			if (key >= GDK_KEY_Thai_kokai) {
				_tmp28_ = key <= GDK_KEY_Thai_lekkao;
			} else {
				_tmp28_ = FALSE;
			}
			_tmp12_ = _tmp28_;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gboolean _tmp29_ = FALSE;
			if (key >= GDK_KEY_Hangul) {
				_tmp29_ = key <= GDK_KEY_Hangul_Special;
			} else {
				_tmp29_ = FALSE;
			}
			_tmp11_ = _tmp29_;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp30_ = FALSE;
			if (key >= GDK_KEY_Hangul_Kiyeog) {
				_tmp30_ = key <= GDK_KEY_Hangul_J_YeorinHieuh;
			} else {
				_tmp30_ = FALSE;
			}
			_tmp10_ = _tmp30_;
		}
		if (_tmp10_) {
			GError* _tmp31_;
			_tmp31_ = g_error_new_literal (POMODORO_ACCELERATOR_ERROR, POMODORO_ACCELERATOR_ERROR_TYPING_COLLISION, "Typing collision");
			_inner_error0_ = _tmp31_;
			if (_inner_error0_->domain == POMODORO_ACCELERATOR_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
pomodoro_accelerator_get_keys_internal (PomodoroAccelerator* self,
                                        gboolean escape,
                                        gint* result_length1)
{
	gchar** elements = NULL;
	gchar** _tmp0_;
	gint elements_length1;
	gint _elements_size_;
	GdkModifierType _tmp1_;
	GdkModifierType _tmp4_;
	GdkModifierType _tmp7_;
	GdkModifierType _tmp10_;
	guint _tmp13_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	elements = _tmp0_;
	elements_length1 = 0;
	_elements_size_ = elements_length1;
	_tmp1_ = self->priv->_modifiers;
	if ((_tmp1_ & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		if (escape) {
			_tmp2_ = "<Shift>";
		} else {
			_tmp2_ = "Shift";
		}
		_tmp3_ = g_strdup (_tmp2_);
		_vala_array_add1 (&elements, &elements_length1, &_elements_size_, _tmp3_);
	}
	_tmp4_ = self->priv->_modifiers;
	if ((_tmp4_ & GDK_SUPER_MASK) == GDK_SUPER_MASK) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		if (escape) {
			_tmp5_ = "<Super>";
		} else {
			_tmp5_ = "Super";
		}
		_tmp6_ = g_strdup (_tmp5_);
		_vala_array_add2 (&elements, &elements_length1, &_elements_size_, _tmp6_);
	}
	_tmp7_ = self->priv->_modifiers;
	if ((_tmp7_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		if (escape) {
			_tmp8_ = "<Ctrl>";
		} else {
			_tmp8_ = "Ctrl";
		}
		_tmp9_ = g_strdup (_tmp8_);
		_vala_array_add3 (&elements, &elements_length1, &_elements_size_, _tmp9_);
	}
	_tmp10_ = self->priv->_modifiers;
	if ((_tmp10_ & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		if (escape) {
			_tmp11_ = "<Alt>";
		} else {
			_tmp11_ = "Alt";
		}
		_tmp12_ = g_strdup (_tmp11_);
		_vala_array_add4 (&elements, &elements_length1, &_elements_size_, _tmp12_);
	}
	_tmp13_ = self->priv->_key;
	if (_tmp13_ != ((guint) 0)) {
		guint keyval = 0U;
		guint _tmp14_;
		gchar* name = NULL;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = self->priv->_key;
		keyval = gdk_keyval_to_upper (_tmp14_);
		_tmp15_ = gdk_keyval_name (keyval);
		_tmp16_ = g_strdup (_tmp15_);
		name = _tmp16_;
		if (escape) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = name;
			_tmp18_ = g_strdup (_tmp17_);
			_vala_array_add5 (&elements, &elements_length1, &_elements_size_, _tmp18_);
		} else {
			gunichar key = 0U;
			gchar* _tmp19_ = NULL;
			gchar* _tmp23_;
			key = (gunichar) gdk_keyval_to_unicode (keyval);
			if (key > ((gunichar) 0)) {
				gchar* _tmp20_;
				_tmp20_ = g_unichar_to_string (key);
				_g_free0 (_tmp19_);
				_tmp19_ = _tmp20_;
			} else {
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp21_ = name;
				_tmp22_ = string_replace (_tmp21_, "_", " ");
				_g_free0 (_tmp19_);
				_tmp19_ = _tmp22_;
			}
			_tmp23_ = g_strdup (_tmp19_);
			_vala_array_add6 (&elements, &elements_length1, &_elements_size_, _tmp23_);
			_g_free0 (_tmp19_);
		}
		_g_free0 (name);
	}
	_tmp24_ = elements;
	_tmp24__length1 = elements_length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	return result;
}

gchar**
pomodoro_accelerator_get_keys (PomodoroAccelerator* self,
                               gint* result_length1)
{
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = pomodoro_accelerator_get_keys_internal (self, FALSE, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PomodoroAccelerator*
pomodoro_accelerator_construct (GType object_type)
{
	PomodoroAccelerator * self = NULL;
	self = (PomodoroAccelerator*) g_object_new (object_type, NULL);
	return self;
}

PomodoroAccelerator*
pomodoro_accelerator_new (void)
{
	return pomodoro_accelerator_construct (POMODORO_TYPE_ACCELERATOR);
}

static guint
pomodoro_accelerator_get_key (PomodoroAccelerator* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_key;
	return result;
}

static void
pomodoro_accelerator_set_key (PomodoroAccelerator* self,
                              guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_key = value;
}

static GdkModifierType
pomodoro_accelerator_get_modifiers (PomodoroAccelerator* self)
{
	GdkModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_modifiers;
	return result;
}

static void
pomodoro_accelerator_set_modifiers (PomodoroAccelerator* self,
                                    GdkModifierType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_modifiers = value;
}

gchar*
pomodoro_accelerator_get_name (PomodoroAccelerator* self)
{
	gchar* result;
	GString* name = NULL;
	GString* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	name = _tmp0_;
	_tmp2_ = pomodoro_accelerator_get_keys_internal (self, TRUE, &_tmp1_);
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp2_;
		element_collection_length1 = _tmp1_;
		for (element_it = 0; element_it < element_collection_length1; element_it = element_it + 1) {
			gchar* _tmp3_;
			gchar* element = NULL;
			_tmp3_ = g_strdup (element_collection[element_it]);
			element = _tmp3_;
			{
				GString* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = name;
				_tmp5_ = element;
				g_string_append (_tmp4_, _tmp5_);
				_g_free0 (element);
			}
		}
		element_collection = (_vala_array_free (element_collection, element_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp6_ = name;
	_tmp7_ = _tmp6_->str;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_g_string_free0 (name);
	return result;
}

void
pomodoro_accelerator_set_name (PomodoroAccelerator* self,
                               const gchar* value)
{
	guint keyval = 0U;
	GdkModifierType modifiers = 0U;
	guint _tmp0_ = 0U;
	GdkModifierType _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	keyval = (guint) 0;
	modifiers = 0;
	pomodoro_accelerator_parse (value, &_tmp0_, &_tmp1_);
	keyval = _tmp0_;
	modifiers = _tmp1_;
	pomodoro_accelerator_set_keyval (self, keyval, modifiers);
	g_object_notify_by_pspec ((GObject *) self, pomodoro_accelerator_properties[POMODORO_ACCELERATOR_NAME_PROPERTY]);
}

gchar*
pomodoro_accelerator_get_display_name (PomodoroAccelerator* self)
{
	gchar* result;
	GString* name = NULL;
	GString* _tmp0_;
	gboolean is_first = FALSE;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	name = _tmp0_;
	is_first = TRUE;
	_tmp2_ = pomodoro_accelerator_get_keys_internal (self, FALSE, &_tmp1_);
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp2_;
		element_collection_length1 = _tmp1_;
		for (element_it = 0; element_it < element_collection_length1; element_it = element_it + 1) {
			gchar* _tmp3_;
			gchar* element = NULL;
			_tmp3_ = g_strdup (element_collection[element_it]);
			element = _tmp3_;
			{
				GString* _tmp5_;
				const gchar* _tmp6_;
				if (is_first) {
					is_first = FALSE;
				} else {
					GString* _tmp4_;
					_tmp4_ = name;
					g_string_append (_tmp4_, " + ");
				}
				_tmp5_ = name;
				_tmp6_ = element;
				g_string_append (_tmp5_, _tmp6_);
				_g_free0 (element);
			}
		}
		element_collection = (_vala_array_free (element_collection, element_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = name;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (name);
	return result;
}

static void
pomodoro_accelerator_real_changed (PomodoroAccelerator* self)
{
	g_object_notify ((GObject*) self, "name");
	g_object_notify ((GObject*) self, "display-name");
}

static void
pomodoro_accelerator_class_init (PomodoroAcceleratorClass * klass,
                                 gpointer klass_data)
{
	pomodoro_accelerator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroAccelerator_private_offset);
	((PomodoroAcceleratorClass *) klass)->changed = pomodoro_accelerator_real_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_accelerator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_accelerator_set_property;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_accelerator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ACCELERATOR_NAME_PROPERTY, pomodoro_accelerator_properties[POMODORO_ACCELERATOR_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ACCELERATOR_DISPLAY_NAME_PROPERTY, pomodoro_accelerator_properties[POMODORO_ACCELERATOR_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	pomodoro_accelerator_signals[POMODORO_ACCELERATOR_CHANGED_SIGNAL] = g_signal_new ("changed", POMODORO_TYPE_ACCELERATOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PomodoroAcceleratorClass, changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pomodoro_accelerator_instance_init (PomodoroAccelerator * self,
                                    gpointer klass)
{
	self->priv = pomodoro_accelerator_get_instance_private (self);
}

static void
pomodoro_accelerator_finalize (GObject * obj)
{
	PomodoroAccelerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_ACCELERATOR, PomodoroAccelerator);
	G_OBJECT_CLASS (pomodoro_accelerator_parent_class)->finalize (obj);
}

static GType
pomodoro_accelerator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroAcceleratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_accelerator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroAccelerator), 0, (GInstanceInitFunc) pomodoro_accelerator_instance_init, NULL };
	GType pomodoro_accelerator_type_id;
	pomodoro_accelerator_type_id = g_type_register_static (G_TYPE_OBJECT, "PomodoroAccelerator", &g_define_type_info, 0);
	PomodoroAccelerator_private_offset = g_type_add_instance_private (pomodoro_accelerator_type_id, sizeof (PomodoroAcceleratorPrivate));
	return pomodoro_accelerator_type_id;
}

GType
pomodoro_accelerator_get_type (void)
{
	static volatile gsize pomodoro_accelerator_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_accelerator_type_id__once)) {
		GType pomodoro_accelerator_type_id;
		pomodoro_accelerator_type_id = pomodoro_accelerator_get_type_once ();
		g_once_init_leave (&pomodoro_accelerator_type_id__once, pomodoro_accelerator_type_id);
	}
	return pomodoro_accelerator_type_id__once;
}

static void
_vala_pomodoro_accelerator_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	PomodoroAccelerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_ACCELERATOR, PomodoroAccelerator);
	switch (property_id) {
		case POMODORO_ACCELERATOR_NAME_PROPERTY:
		g_value_take_string (value, pomodoro_accelerator_get_name (self));
		break;
		case POMODORO_ACCELERATOR_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, pomodoro_accelerator_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_accelerator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	PomodoroAccelerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_ACCELERATOR, PomodoroAccelerator);
	switch (property_id) {
		case POMODORO_ACCELERATOR_NAME_PROPERTY:
		pomodoro_accelerator_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

