/* aggregated-entry.c generated by valac 0.56.17, the Vala compiler
 * generated from aggregated-entry.vala, do not modify */

/*
 * Copyright (c) 2017 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include <gom/gom.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "gnome-pomodoro.h"

#define POMODORO_AGGREGATED_ENTRY_DATE_FORMAT "%Y-%m-%d"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define POMODORO_TYPE_AGGREGATED_ENTRY (pomodoro_aggregated_entry_get_type ())
#define POMODORO_AGGREGATED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntry))
#define POMODORO_AGGREGATED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntryClass))
#define POMODORO_IS_AGGREGATED_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_AGGREGATED_ENTRY))
#define POMODORO_IS_AGGREGATED_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_AGGREGATED_ENTRY))
#define POMODORO_AGGREGATED_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntryClass))

typedef struct _PomodoroAggregatedEntry PomodoroAggregatedEntry;
typedef struct _PomodoroAggregatedEntryClass PomodoroAggregatedEntryClass;
typedef struct _PomodoroAggregatedEntryPrivate PomodoroAggregatedEntryPrivate;
enum  {
	POMODORO_AGGREGATED_ENTRY_0_PROPERTY,
	POMODORO_AGGREGATED_ENTRY_ID_PROPERTY,
	POMODORO_AGGREGATED_ENTRY_DATE_STRING_PROPERTY,
	POMODORO_AGGREGATED_ENTRY_STATE_NAME_PROPERTY,
	POMODORO_AGGREGATED_ENTRY_STATE_DURATION_PROPERTY,
	POMODORO_AGGREGATED_ENTRY_ELAPSED_PROPERTY,
	POMODORO_AGGREGATED_ENTRY_NUM_PROPERTIES
};
static GParamSpec* pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PomodoroAggregatedEntryGetMaxElapsedSumData PomodoroAggregatedEntryGetMaxElapsedSumData;
typedef struct _PomodoroAggregatedEntryGetBaselineDailyElapsedData PomodoroAggregatedEntryGetBaselineDailyElapsedData;
typedef struct _PomodoroAggregatedEntryGetBaselineWeeklyElapsedData PomodoroAggregatedEntryGetBaselineWeeklyElapsedData;
typedef struct _PomodoroAggregatedEntryGetBaselineMonthlyElapsedData PomodoroAggregatedEntryGetBaselineMonthlyElapsedData;

struct _PomodoroAggregatedEntry {
	GomResource parent_instance;
	PomodoroAggregatedEntryPrivate * priv;
};

struct _PomodoroAggregatedEntryClass {
	GomResourceClass parent_class;
};

struct _PomodoroAggregatedEntryPrivate {
	gint64 _id;
	gchar* _date_string;
	gchar* _state_name;
	gint64 _state_duration;
	gint64 _elapsed;
};

struct _Block1Data {
	int _ref_count_;
	GomAdapter* adapter;
	gint64 elapsed;
	gchar* group_by_sql;
	gpointer _async_data_;
};

struct _PomodoroAggregatedEntryGetMaxElapsedSumData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* group_by_sql;
	gint64 result;
	Block1Data* _data1_;
	GomRepository* _tmp0_;
	GomRepository* _tmp1_;
	GomAdapter* _tmp2_;
	GomAdapter* _tmp3_;
	GomAdapter* _tmp4_;
};

struct _PomodoroAggregatedEntryGetBaselineDailyElapsedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gint64 result;
};

struct _PomodoroAggregatedEntryGetBaselineWeeklyElapsedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gint64 result;
};

struct _PomodoroAggregatedEntryGetBaselineMonthlyElapsedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gint64 result;
};

static gint PomodoroAggregatedEntry_private_offset;
static gpointer pomodoro_aggregated_entry_parent_class = NULL;

VALA_EXTERN GType pomodoro_aggregated_entry_get_type (void) G_GNUC_CONST ;
static void pomodoro_aggregated_entry_get_max_elapsed_sum_data_free (gpointer _data);
static void pomodoro_aggregated_entry_get_max_elapsed_sum (const gchar* group_by_sql,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gint64 pomodoro_aggregated_entry_get_max_elapsed_sum_finish (GAsyncResult* _res_);
static gboolean pomodoro_aggregated_entry_get_max_elapsed_sum_co (PomodoroAggregatedEntryGetMaxElapsedSumData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GomRepository* pomodoro_get_repository (void);
static void __lambda42_ (Block1Data* _data1_);
static gboolean _pomodoro_aggregated_entry_get_max_elapsed_sum_co_gsource_func (gpointer self);
static void ___lambda42__gom_adapter_callback (GomAdapter* adapter,
                                        gpointer self);
static void pomodoro_aggregated_entry_get_baseline_daily_elapsed_data_free (gpointer _data);
VALA_EXTERN void pomodoro_aggregated_entry_get_baseline_daily_elapsed (GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_baseline_daily_elapsed_finish (GAsyncResult* _res_);
static gboolean pomodoro_aggregated_entry_get_baseline_daily_elapsed_co (PomodoroAggregatedEntryGetBaselineDailyElapsedData* _data_);
static void pomodoro_aggregated_entry_get_baseline_daily_elapsed_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void pomodoro_aggregated_entry_get_baseline_weekly_elapsed_data_free (gpointer _data);
VALA_EXTERN void pomodoro_aggregated_entry_get_baseline_weekly_elapsed (GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_baseline_weekly_elapsed_finish (GAsyncResult* _res_);
static gboolean pomodoro_aggregated_entry_get_baseline_weekly_elapsed_co (PomodoroAggregatedEntryGetBaselineWeeklyElapsedData* _data_);
static void pomodoro_aggregated_entry_get_baseline_weekly_elapsed_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static void pomodoro_aggregated_entry_get_baseline_monthly_elapsed_data_free (gpointer _data);
VALA_EXTERN void pomodoro_aggregated_entry_get_baseline_monthly_elapsed (GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_baseline_monthly_elapsed_finish (GAsyncResult* _res_);
static gboolean pomodoro_aggregated_entry_get_baseline_monthly_elapsed_co (PomodoroAggregatedEntryGetBaselineMonthlyElapsedData* _data_);
static void pomodoro_aggregated_entry_get_baseline_monthly_elapsed_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
VALA_EXTERN PomodoroAggregatedEntry* pomodoro_aggregated_entry_new (void);
VALA_EXTERN PomodoroAggregatedEntry* pomodoro_aggregated_entry_construct (GType object_type);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_id (PomodoroAggregatedEntry* self);
VALA_EXTERN void pomodoro_aggregated_entry_set_id (PomodoroAggregatedEntry* self,
                                       gint64 value);
VALA_EXTERN const gchar* pomodoro_aggregated_entry_get_date_string (PomodoroAggregatedEntry* self);
VALA_EXTERN void pomodoro_aggregated_entry_set_date_string (PomodoroAggregatedEntry* self,
                                                const gchar* value);
VALA_EXTERN const gchar* pomodoro_aggregated_entry_get_state_name (PomodoroAggregatedEntry* self);
VALA_EXTERN void pomodoro_aggregated_entry_set_state_name (PomodoroAggregatedEntry* self,
                                               const gchar* value);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_state_duration (PomodoroAggregatedEntry* self);
VALA_EXTERN void pomodoro_aggregated_entry_set_state_duration (PomodoroAggregatedEntry* self,
                                                   gint64 value);
VALA_EXTERN gint64 pomodoro_aggregated_entry_get_elapsed (PomodoroAggregatedEntry* self);
VALA_EXTERN void pomodoro_aggregated_entry_set_elapsed (PomodoroAggregatedEntry* self,
                                            gint64 value);
static void pomodoro_aggregated_entry_finalize (GObject * obj);
static GType pomodoro_aggregated_entry_get_type_once (void);
static void _vala_pomodoro_aggregated_entry_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_pomodoro_aggregated_entry_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
pomodoro_aggregated_entry_get_instance_private (PomodoroAggregatedEntry* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroAggregatedEntry_private_offset);
}

static void
pomodoro_aggregated_entry_get_max_elapsed_sum_data_free (gpointer _data)
{
	PomodoroAggregatedEntryGetMaxElapsedSumData* _data_;
	_data_ = _data;
	g_slice_free (PomodoroAggregatedEntryGetMaxElapsedSumData, _data_);
}

static void
pomodoro_aggregated_entry_get_max_elapsed_sum (const gchar* group_by_sql,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	PomodoroAggregatedEntryGetMaxElapsedSumData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (group_by_sql != NULL);
	_data_ = g_slice_new0 (PomodoroAggregatedEntryGetMaxElapsedSumData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_aggregated_entry_get_max_elapsed_sum_data_free);
	_tmp0_ = g_strdup (group_by_sql);
	_g_free0 (_data_->group_by_sql);
	_data_->group_by_sql = _tmp0_;
	pomodoro_aggregated_entry_get_max_elapsed_sum_co (_data_);
}

static gint64
pomodoro_aggregated_entry_get_max_elapsed_sum_finish (GAsyncResult* _res_)
{
	gint64 result;
	PomodoroAggregatedEntryGetMaxElapsedSumData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->adapter);
		_g_free0 (_data1_->group_by_sql);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_pomodoro_aggregated_entry_get_max_elapsed_sum_co_gsource_func (gpointer self)
{
	gboolean result;
	result = pomodoro_aggregated_entry_get_max_elapsed_sum_co (self);
	return result;
}

static void
__lambda42_ (Block1Data* _data1_)
{
	GomCursor* cursor = NULL;
	GomCommand* command = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GomCommand* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_object_new (gom_command_get_type (), "adapter", _data1_->adapter, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	command = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gom_command_get_type (), GomCommand);
	_tmp2_ = command;
	_tmp3_ = g_strconcat ("\nSELECT ", _data1_->group_by_sql, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, " AS \"group\", SUM(\"elapsed\") AS \"elapsed-sum\"\n" \
"    FROM \"aggregated-entries\"\n" \
"    GROUP BY \"group\"\n" \
"    ORDER BY \"elapsed-sum\" DESC\n" \
"    LIMIT 1;\n", NULL);
	_tmp6_ = _tmp5_;
	gom_command_set_sql (_tmp2_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	{
		GomCommand* _tmp7_;
		GomCursor* _tmp8_ = NULL;
		GomCursor* _tmp9_;
		gboolean _tmp10_ = FALSE;
		GomCursor* _tmp11_;
		_tmp7_ = command;
		gom_command_execute (_tmp7_, &_tmp8_, &_inner_error0_);
		_g_object_unref0 (cursor);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		cursor = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = cursor;
		if (_tmp11_ != NULL) {
			GomCursor* _tmp12_;
			_tmp12_ = cursor;
			_tmp10_ = gom_cursor_next (_tmp12_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GomCursor* _tmp13_;
			_tmp13_ = cursor;
			_data1_->elapsed = gom_cursor_get_column_int64 (_tmp13_, (guint) 1);
		} else {
			g_assert_not_reached ();
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = _error_;
		_tmp15_ = _tmp14_->message;
		g_critical ("aggregated-entry.vala:77: %s", _tmp15_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (command);
		_g_object_unref0 (cursor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _pomodoro_aggregated_entry_get_max_elapsed_sum_co_gsource_func, _data1_->_async_data_, NULL);
	_g_object_unref0 (command);
	_g_object_unref0 (cursor);
}

static void
___lambda42__gom_adapter_callback (GomAdapter* adapter,
                                   gpointer self)
{
	__lambda42_ (self);
	block1_data_unref (self);
}

static gboolean
pomodoro_aggregated_entry_get_max_elapsed_sum_co (PomodoroAggregatedEntryGetMaxElapsedSumData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_g_free0 (_data_->_data1_->group_by_sql);
	_data_->_data1_->group_by_sql = _data_->group_by_sql;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = pomodoro_get_repository ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = gom_repository_get_adapter (_data_->_tmp1_);
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->_data1_->adapter = _data_->_tmp4_;
	_data_->_data1_->elapsed = (gint64) 0;
	gom_adapter_queue_read (_data_->_data1_->adapter, ___lambda42__gom_adapter_callback, block1_data_ref (_data_->_data1_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->result = _data_->_data1_->elapsed;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pomodoro_aggregated_entry_get_baseline_daily_elapsed_data_free (gpointer _data)
{
	PomodoroAggregatedEntryGetBaselineDailyElapsedData* _data_;
	_data_ = _data;
	g_slice_free (PomodoroAggregatedEntryGetBaselineDailyElapsedData, _data_);
}

void
pomodoro_aggregated_entry_get_baseline_daily_elapsed (GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	PomodoroAggregatedEntryGetBaselineDailyElapsedData* _data_;
	_data_ = g_slice_new0 (PomodoroAggregatedEntryGetBaselineDailyElapsedData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_aggregated_entry_get_baseline_daily_elapsed_data_free);
	pomodoro_aggregated_entry_get_baseline_daily_elapsed_co (_data_);
}

gint64
pomodoro_aggregated_entry_get_baseline_daily_elapsed_finish (GAsyncResult* _res_)
{
	gint64 result;
	PomodoroAggregatedEntryGetBaselineDailyElapsedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
pomodoro_aggregated_entry_get_baseline_daily_elapsed_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	PomodoroAggregatedEntryGetBaselineDailyElapsedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pomodoro_aggregated_entry_get_baseline_daily_elapsed_co (_data_);
}

static gboolean
pomodoro_aggregated_entry_get_baseline_daily_elapsed_co (PomodoroAggregatedEntryGetBaselineDailyElapsedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	pomodoro_aggregated_entry_get_max_elapsed_sum ("\"date-string\"", pomodoro_aggregated_entry_get_baseline_daily_elapsed_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result = pomodoro_aggregated_entry_get_max_elapsed_sum_finish (_data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pomodoro_aggregated_entry_get_baseline_weekly_elapsed_data_free (gpointer _data)
{
	PomodoroAggregatedEntryGetBaselineWeeklyElapsedData* _data_;
	_data_ = _data;
	g_slice_free (PomodoroAggregatedEntryGetBaselineWeeklyElapsedData, _data_);
}

void
pomodoro_aggregated_entry_get_baseline_weekly_elapsed (GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	PomodoroAggregatedEntryGetBaselineWeeklyElapsedData* _data_;
	_data_ = g_slice_new0 (PomodoroAggregatedEntryGetBaselineWeeklyElapsedData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_aggregated_entry_get_baseline_weekly_elapsed_data_free);
	pomodoro_aggregated_entry_get_baseline_weekly_elapsed_co (_data_);
}

gint64
pomodoro_aggregated_entry_get_baseline_weekly_elapsed_finish (GAsyncResult* _res_)
{
	gint64 result;
	PomodoroAggregatedEntryGetBaselineWeeklyElapsedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
pomodoro_aggregated_entry_get_baseline_weekly_elapsed_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	PomodoroAggregatedEntryGetBaselineWeeklyElapsedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pomodoro_aggregated_entry_get_baseline_weekly_elapsed_co (_data_);
}

static gboolean
pomodoro_aggregated_entry_get_baseline_weekly_elapsed_co (PomodoroAggregatedEntryGetBaselineWeeklyElapsedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	pomodoro_aggregated_entry_get_max_elapsed_sum ("strftime('%Y-%W', \"date-string\")", pomodoro_aggregated_entry_get_baseline_weekly_elapsed_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result = pomodoro_aggregated_entry_get_max_elapsed_sum_finish (_data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pomodoro_aggregated_entry_get_baseline_monthly_elapsed_data_free (gpointer _data)
{
	PomodoroAggregatedEntryGetBaselineMonthlyElapsedData* _data_;
	_data_ = _data;
	g_slice_free (PomodoroAggregatedEntryGetBaselineMonthlyElapsedData, _data_);
}

void
pomodoro_aggregated_entry_get_baseline_monthly_elapsed (GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	PomodoroAggregatedEntryGetBaselineMonthlyElapsedData* _data_;
	_data_ = g_slice_new0 (PomodoroAggregatedEntryGetBaselineMonthlyElapsedData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_aggregated_entry_get_baseline_monthly_elapsed_data_free);
	pomodoro_aggregated_entry_get_baseline_monthly_elapsed_co (_data_);
}

gint64
pomodoro_aggregated_entry_get_baseline_monthly_elapsed_finish (GAsyncResult* _res_)
{
	gint64 result;
	PomodoroAggregatedEntryGetBaselineMonthlyElapsedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
pomodoro_aggregated_entry_get_baseline_monthly_elapsed_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	PomodoroAggregatedEntryGetBaselineMonthlyElapsedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pomodoro_aggregated_entry_get_baseline_monthly_elapsed_co (_data_);
}

static gboolean
pomodoro_aggregated_entry_get_baseline_monthly_elapsed_co (PomodoroAggregatedEntryGetBaselineMonthlyElapsedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	pomodoro_aggregated_entry_get_max_elapsed_sum ("strftime('%Y-%m', \"date-string\")", pomodoro_aggregated_entry_get_baseline_monthly_elapsed_ready, _data_);
	return FALSE;
	_state_1:
	_data_->result = pomodoro_aggregated_entry_get_max_elapsed_sum_finish (_data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

PomodoroAggregatedEntry*
pomodoro_aggregated_entry_construct (GType object_type)
{
	PomodoroAggregatedEntry * self = NULL;
	self = (PomodoroAggregatedEntry*) g_object_new (object_type, NULL);
	return self;
}

PomodoroAggregatedEntry*
pomodoro_aggregated_entry_new (void)
{
	return pomodoro_aggregated_entry_construct (POMODORO_TYPE_AGGREGATED_ENTRY);
}

gint64
pomodoro_aggregated_entry_get_id (PomodoroAggregatedEntry* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_id;
	return result;
}

void
pomodoro_aggregated_entry_set_id (PomodoroAggregatedEntry* self,
                                  gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_aggregated_entry_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_ID_PROPERTY]);
	}
}

const gchar*
pomodoro_aggregated_entry_get_date_string (PomodoroAggregatedEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_string;
	result = _tmp0_;
	return result;
}

void
pomodoro_aggregated_entry_set_date_string (PomodoroAggregatedEntry* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_aggregated_entry_get_date_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_date_string);
		self->priv->_date_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_DATE_STRING_PROPERTY]);
	}
}

const gchar*
pomodoro_aggregated_entry_get_state_name (PomodoroAggregatedEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state_name;
	result = _tmp0_;
	return result;
}

void
pomodoro_aggregated_entry_set_state_name (PomodoroAggregatedEntry* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_aggregated_entry_get_state_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_state_name);
		self->priv->_state_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_STATE_NAME_PROPERTY]);
	}
}

gint64
pomodoro_aggregated_entry_get_state_duration (PomodoroAggregatedEntry* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_state_duration;
	return result;
}

void
pomodoro_aggregated_entry_set_state_duration (PomodoroAggregatedEntry* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_aggregated_entry_get_state_duration (self);
	if (old_value != value) {
		self->priv->_state_duration = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_STATE_DURATION_PROPERTY]);
	}
}

gint64
pomodoro_aggregated_entry_get_elapsed (PomodoroAggregatedEntry* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_elapsed;
	return result;
}

void
pomodoro_aggregated_entry_set_elapsed (PomodoroAggregatedEntry* self,
                                       gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_aggregated_entry_get_elapsed (self);
	if (old_value != value) {
		self->priv->_elapsed = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_ELAPSED_PROPERTY]);
	}
}

static void
pomodoro_aggregated_entry_class_init (PomodoroAggregatedEntryClass * klass,
                                      gpointer klass_data)
{
	pomodoro_aggregated_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroAggregatedEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_aggregated_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_aggregated_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_aggregated_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_AGGREGATED_ENTRY_ID_PROPERTY, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_ID_PROPERTY] = g_param_spec_int64 ("id", "id", "id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_AGGREGATED_ENTRY_DATE_STRING_PROPERTY, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_DATE_STRING_PROPERTY] = g_param_spec_string ("date-string", "date-string", "date-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_AGGREGATED_ENTRY_STATE_NAME_PROPERTY, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_STATE_NAME_PROPERTY] = g_param_spec_string ("state-name", "state-name", "state-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_AGGREGATED_ENTRY_STATE_DURATION_PROPERTY, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_STATE_DURATION_PROPERTY] = g_param_spec_int64 ("state-duration", "state-duration", "state-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_AGGREGATED_ENTRY_ELAPSED_PROPERTY, pomodoro_aggregated_entry_properties[POMODORO_AGGREGATED_ENTRY_ELAPSED_PROPERTY] = g_param_spec_int64 ("elapsed", "elapsed", "elapsed", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gom_resource_class_set_table (GOM_RESOURCE_CLASS (klass), "aggregated-entries");
	gom_resource_class_set_primary_key (GOM_RESOURCE_CLASS (klass), "id");
	gom_resource_class_set_notnull (GOM_RESOURCE_CLASS (klass), "state-name");
	gom_resource_class_set_notnull (GOM_RESOURCE_CLASS (klass), "date-string");
}

static void
pomodoro_aggregated_entry_instance_init (PomodoroAggregatedEntry * self,
                                         gpointer klass)
{
	self->priv = pomodoro_aggregated_entry_get_instance_private (self);
}

static void
pomodoro_aggregated_entry_finalize (GObject * obj)
{
	PomodoroAggregatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntry);
	_g_free0 (self->priv->_date_string);
	_g_free0 (self->priv->_state_name);
	G_OBJECT_CLASS (pomodoro_aggregated_entry_parent_class)->finalize (obj);
}

/**
     * Aggregate daily entries so that it's easier to display / analyse data.
     */
static GType
pomodoro_aggregated_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroAggregatedEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_aggregated_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroAggregatedEntry), 0, (GInstanceInitFunc) pomodoro_aggregated_entry_instance_init, NULL };
	GType pomodoro_aggregated_entry_type_id;
	pomodoro_aggregated_entry_type_id = g_type_register_static (gom_resource_get_type (), "PomodoroAggregatedEntry", &g_define_type_info, 0);
	PomodoroAggregatedEntry_private_offset = g_type_add_instance_private (pomodoro_aggregated_entry_type_id, sizeof (PomodoroAggregatedEntryPrivate));
	return pomodoro_aggregated_entry_type_id;
}

GType
pomodoro_aggregated_entry_get_type (void)
{
	static volatile gsize pomodoro_aggregated_entry_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_aggregated_entry_type_id__once)) {
		GType pomodoro_aggregated_entry_type_id;
		pomodoro_aggregated_entry_type_id = pomodoro_aggregated_entry_get_type_once ();
		g_once_init_leave (&pomodoro_aggregated_entry_type_id__once, pomodoro_aggregated_entry_type_id);
	}
	return pomodoro_aggregated_entry_type_id__once;
}

static void
_vala_pomodoro_aggregated_entry_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	PomodoroAggregatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntry);
	switch (property_id) {
		case POMODORO_AGGREGATED_ENTRY_ID_PROPERTY:
		g_value_set_int64 (value, pomodoro_aggregated_entry_get_id (self));
		break;
		case POMODORO_AGGREGATED_ENTRY_DATE_STRING_PROPERTY:
		g_value_set_string (value, pomodoro_aggregated_entry_get_date_string (self));
		break;
		case POMODORO_AGGREGATED_ENTRY_STATE_NAME_PROPERTY:
		g_value_set_string (value, pomodoro_aggregated_entry_get_state_name (self));
		break;
		case POMODORO_AGGREGATED_ENTRY_STATE_DURATION_PROPERTY:
		g_value_set_int64 (value, pomodoro_aggregated_entry_get_state_duration (self));
		break;
		case POMODORO_AGGREGATED_ENTRY_ELAPSED_PROPERTY:
		g_value_set_int64 (value, pomodoro_aggregated_entry_get_elapsed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_aggregated_entry_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	PomodoroAggregatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_AGGREGATED_ENTRY, PomodoroAggregatedEntry);
	switch (property_id) {
		case POMODORO_AGGREGATED_ENTRY_ID_PROPERTY:
		pomodoro_aggregated_entry_set_id (self, g_value_get_int64 (value));
		break;
		case POMODORO_AGGREGATED_ENTRY_DATE_STRING_PROPERTY:
		pomodoro_aggregated_entry_set_date_string (self, g_value_get_string (value));
		break;
		case POMODORO_AGGREGATED_ENTRY_STATE_NAME_PROPERTY:
		pomodoro_aggregated_entry_set_state_name (self, g_value_get_string (value));
		break;
		case POMODORO_AGGREGATED_ENTRY_STATE_DURATION_PROPERTY:
		pomodoro_aggregated_entry_set_state_duration (self, g_value_get_int64 (value));
		break;
		case POMODORO_AGGREGATED_ENTRY_ELAPSED_PROPERTY:
		pomodoro_aggregated_entry_set_elapsed (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

