/* animation.c generated by valac 0.56.17, the Vala compiler
 * generated from animation.vala, do not modify */

/*
 * Copyright (c) 2013 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 */

#include "gnome-pomodoro.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef gdouble (*PomodoroAnimationFunc) (gdouble progress, gpointer user_data);
enum  {
	POMODORO_ANIMATION_0_PROPERTY,
	POMODORO_ANIMATION_TARGET_PROPERTY,
	POMODORO_ANIMATION_PROPERTY_NAME_PROPERTY,
	POMODORO_ANIMATION_MODE_PROPERTY,
	POMODORO_ANIMATION_DURATION_PROPERTY,
	POMODORO_ANIMATION_FRAMES_PER_SECOND_PROPERTY,
	POMODORO_ANIMATION_PROGRESS_PROPERTY,
	POMODORO_ANIMATION_NUM_PROPERTIES
};
static GParamSpec* pomodoro_animation_properties[POMODORO_ANIMATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	POMODORO_ANIMATION_COMPLETE_SIGNAL,
	POMODORO_ANIMATION_NUM_SIGNALS
};
static guint pomodoro_animation_signals[POMODORO_ANIMATION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PomodoroAnimationPrivate {
	GObject* _target;
	gchar* _property_name;
	PomodoroAnimationMode _mode;
	guint _duration;
	guint _frames_per_second;
	gdouble _progress;
	gdouble value_from;
	gdouble value_to;
	gint64 timestamp;
	guint timeout_id;
	PomodoroAnimationFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

static gint PomodoroAnimation_private_offset;
static gpointer pomodoro_animation_parent_class = NULL;

static void __lambda8_ (PomodoroAnimation* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static PomodoroAnimationFunc pomodoro_animation_get_func (PomodoroAnimationMode mode,
                                                   gpointer* result_target,
                                                   GDestroyNotify* result_target_destroy_notify);
static gboolean pomodoro_animation_on_timeout (PomodoroAnimation* self);
static void pomodoro_animation_set_progress (PomodoroAnimation* self,
                                      gdouble value);
static gdouble pomodoro_animation_compute_value (PomodoroAnimation* self,
                                          gdouble progress);
static gdouble pomodoro_animation_calculate_linear (gdouble t);
static gdouble _pomodoro_animation_calculate_linear_pomodoro_animation_func (gdouble progress,
                                                                      gpointer self);
static gdouble pomodoro_animation_calculate_ease_in (gdouble t);
static gdouble _pomodoro_animation_calculate_ease_in_pomodoro_animation_func (gdouble progress,
                                                                       gpointer self);
static gdouble pomodoro_animation_calculate_ease_in_out (gdouble t);
static gdouble _pomodoro_animation_calculate_ease_in_out_pomodoro_animation_func (gdouble progress,
                                                                           gpointer self);
static gdouble pomodoro_animation_calculate_ease_out (gdouble t);
static gdouble _pomodoro_animation_calculate_ease_out_pomodoro_animation_func (gdouble progress,
                                                                        gpointer self);
static gdouble pomodoro_animation_calculate_ease_in_cubic (gdouble t);
static gdouble _pomodoro_animation_calculate_ease_in_cubic_pomodoro_animation_func (gdouble progress,
                                                                             gpointer self);
static gdouble pomodoro_animation_calculate_ease_in_out_cubic (gdouble t);
static gdouble _pomodoro_animation_calculate_ease_in_out_cubic_pomodoro_animation_func (gdouble progress,
                                                                                 gpointer self);
static gdouble pomodoro_animation_calculate_ease_out_cubic (gdouble t);
static gdouble _pomodoro_animation_calculate_ease_out_cubic_pomodoro_animation_func (gdouble progress,
                                                                              gpointer self);
static gdouble pomodoro_animation_calculate_blink (gdouble t);
static gdouble _pomodoro_animation_calculate_blink_pomodoro_animation_func (gdouble progress,
                                                                     gpointer self);
static void pomodoro_animation_finalize (GObject * obj);
static GType pomodoro_animation_get_type_once (void);
static void _vala_pomodoro_animation_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_pomodoro_animation_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static GType
pomodoro_animation_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{POMODORO_ANIMATION_MODE_LINEAR, "POMODORO_ANIMATION_MODE_LINEAR", "linear"}, {POMODORO_ANIMATION_MODE_EASE_IN, "POMODORO_ANIMATION_MODE_EASE_IN", "ease-in"}, {POMODORO_ANIMATION_MODE_EASE_IN_OUT, "POMODORO_ANIMATION_MODE_EASE_IN_OUT", "ease-in-out"}, {POMODORO_ANIMATION_MODE_EASE_OUT, "POMODORO_ANIMATION_MODE_EASE_OUT", "ease-out"}, {POMODORO_ANIMATION_MODE_EASE_IN_CUBIC, "POMODORO_ANIMATION_MODE_EASE_IN_CUBIC", "ease-in-cubic"}, {POMODORO_ANIMATION_MODE_EASE_IN_OUT_CUBIC, "POMODORO_ANIMATION_MODE_EASE_IN_OUT_CUBIC", "ease-in-out-cubic"}, {POMODORO_ANIMATION_MODE_EASE_OUT_CUBIC, "POMODORO_ANIMATION_MODE_EASE_OUT_CUBIC", "ease-out-cubic"}, {POMODORO_ANIMATION_MODE_BLINK, "POMODORO_ANIMATION_MODE_BLINK", "blink"}, {0, NULL, NULL}};
	GType pomodoro_animation_mode_type_id;
	pomodoro_animation_mode_type_id = g_enum_register_static ("PomodoroAnimationMode", values);
	return pomodoro_animation_mode_type_id;
}

GType
pomodoro_animation_mode_get_type (void)
{
	static volatile gsize pomodoro_animation_mode_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_animation_mode_type_id__once)) {
		GType pomodoro_animation_mode_type_id;
		pomodoro_animation_mode_type_id = pomodoro_animation_mode_get_type_once ();
		g_once_init_leave (&pomodoro_animation_mode_type_id__once, pomodoro_animation_mode_type_id);
	}
	return pomodoro_animation_mode_type_id__once;
}

static inline gpointer
pomodoro_animation_get_instance_private (PomodoroAnimation* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroAnimation_private_offset);
}

static void
__lambda8_ (PomodoroAnimation* self)
{
	gdouble _tmp0_;
	_tmp0_ = self->priv->_progress;
	if (_tmp0_ == 1.0) {
		g_signal_emit (self, pomodoro_animation_signals[POMODORO_ANIMATION_COMPLETE_SIGNAL], 0);
	}
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((PomodoroAnimation*) self);
}

PomodoroAnimation*
pomodoro_animation_construct (GType object_type,
                              PomodoroAnimationMode mode,
                              guint duration,
                              guint frames_per_second)
{
	PomodoroAnimation * self = NULL;
	_vala_return_val_if_fail (frames_per_second > ((guint) 0), "frames_per_second > 0", NULL);
	self = (PomodoroAnimation*) g_object_new (object_type, "mode", mode, "duration", duration, "frames-per-second", frames_per_second, NULL);
	g_signal_connect_object ((GObject*) self, "notify::progress", (GCallback) ___lambda8__g_object_notify, self, 0);
	return self;
}

PomodoroAnimation*
pomodoro_animation_new (PomodoroAnimationMode mode,
                        guint duration,
                        guint frames_per_second)
{
	return pomodoro_animation_construct (POMODORO_TYPE_ANIMATION, mode, duration, frames_per_second);
}

void
pomodoro_animation_add_property (PomodoroAnimation* self,
                                 GObject* target,
                                 const gchar* property_name,
                                 GValue* property_value)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (property_name != NULL);
	g_return_if_fail (property_value != NULL);
	pomodoro_animation_set_target (self, target);
	pomodoro_animation_set_property_name (self, property_name);
	self->priv->value_to = g_value_get_double (property_value);
}

void
pomodoro_animation_start (PomodoroAnimation* self)
{
	GValue begin_value = {0};
	GValue _tmp0_ = {0};
	GObject* _tmp1_;
	const gchar* _tmp2_;
	PomodoroAnimationMode _tmp3_;
	gpointer _tmp4_ = NULL;
	GDestroyNotify _tmp5_ = NULL;
	PomodoroAnimationFunc _tmp6_;
	gboolean _tmp7_ = FALSE;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	g_value_init (&_tmp0_, G_TYPE_DOUBLE);
	begin_value = _tmp0_;
	_tmp1_ = self->priv->_target;
	_tmp2_ = self->priv->_property_name;
	g_object_get_property (_tmp1_, _tmp2_, &begin_value);
	self->priv->value_from = g_value_get_double (&begin_value);
	_tmp3_ = self->priv->_mode;
	_tmp6_ = pomodoro_animation_get_func (_tmp3_, &_tmp4_, &_tmp5_);
	(self->priv->func_target_destroy_notify == NULL) ? NULL : (self->priv->func_target_destroy_notify (self->priv->func_target), NULL);
	self->priv->func = NULL;
	self->priv->func_target = NULL;
	self->priv->func_target_destroy_notify = NULL;
	self->priv->func = _tmp6_;
	self->priv->func_target = _tmp4_;
	self->priv->func_target_destroy_notify = _tmp5_;
	self->priv->timestamp = g_get_real_time () / 1000;
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp8_ = self->priv->_duration;
	if (_tmp8_ > ((guint) 0)) {
		_tmp7_ = self->priv->value_from != self->priv->value_to;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		guint _tmp9_;
		guint _tmp10_;
		_tmp9_ = self->priv->_frames_per_second;
		_tmp10_ = self->priv->_duration;
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, MIN (1000 / _tmp9_, _tmp10_), (GSourceFunc) pomodoro_animation_on_timeout, g_object_ref (self), g_object_unref);
		pomodoro_animation_set_progress (self, 0.0);
	} else {
		pomodoro_animation_set_progress (self, 1.0);
	}
	G_IS_VALUE (&begin_value) ? (g_value_unset (&begin_value), NULL) : NULL;
}

void
pomodoro_animation_start_with_value (PomodoroAnimation* self,
                                     gdouble value_from)
{
	PomodoroAnimationMode _tmp0_;
	gpointer _tmp1_ = NULL;
	GDestroyNotify _tmp2_ = NULL;
	PomodoroAnimationFunc _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	self->priv->value_from = value_from;
	_tmp0_ = self->priv->_mode;
	_tmp3_ = pomodoro_animation_get_func (_tmp0_, &_tmp1_, &_tmp2_);
	(self->priv->func_target_destroy_notify == NULL) ? NULL : (self->priv->func_target_destroy_notify (self->priv->func_target), NULL);
	self->priv->func = NULL;
	self->priv->func_target = NULL;
	self->priv->func_target_destroy_notify = NULL;
	self->priv->func = _tmp3_;
	self->priv->func_target = _tmp1_;
	self->priv->func_target_destroy_notify = _tmp2_;
	self->priv->timestamp = g_get_real_time () / 1000;
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp4_ = self->priv->_duration;
	if (_tmp4_ > ((guint) 0)) {
		guint _tmp5_;
		guint _tmp6_;
		_tmp5_ = self->priv->_frames_per_second;
		_tmp6_ = self->priv->_duration;
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, MIN (1000 / _tmp5_, _tmp6_), (GSourceFunc) pomodoro_animation_on_timeout, g_object_ref (self), g_object_unref);
		pomodoro_animation_set_progress (self, 0.0);
	} else {
		pomodoro_animation_set_progress (self, 1.0);
	}
}

void
pomodoro_animation_stop (PomodoroAnimation* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
}

static gdouble
pomodoro_animation_compute_value (PomodoroAnimation* self,
                                  gdouble progress)
{
	gdouble factor = 0.0;
	PomodoroAnimationFunc _tmp0_;
	gpointer _tmp0__target;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->func;
	_tmp0__target = self->priv->func_target;
	factor = _tmp0_ (CLAMP (progress, 0.0, 1.0), _tmp0__target);
	result = self->priv->value_from + (factor * (self->priv->value_to - self->priv->value_from));
	return result;
}

static gboolean
pomodoro_animation_on_timeout (PomodoroAnimation* self)
{
	gint64 current_timestamp = 0LL;
	gdouble _tmp0_ = 0.0;
	guint _tmp1_;
	GObject* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_;
	GValue _tmp6_ = {0};
	gdouble _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	current_timestamp = g_get_real_time () / 1000;
	_tmp1_ = self->priv->_duration;
	if (_tmp1_ > ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->_duration;
		_tmp0_ = CLAMP (((gdouble) (current_timestamp - self->priv->timestamp)) / _tmp2_, 0.0, 1.0);
	} else {
		_tmp0_ = 1.0;
	}
	pomodoro_animation_set_progress (self, _tmp0_);
	_tmp3_ = self->priv->_target;
	_tmp4_ = self->priv->_property_name;
	_tmp5_ = self->priv->_progress;
	g_value_init (&_tmp6_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp6_, pomodoro_animation_compute_value (self, _tmp5_));
	g_object_set_property (_tmp3_, _tmp4_, &_tmp6_);
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
	_tmp7_ = self->priv->_progress;
	if (_tmp7_ == 1.0) {
		self->priv->timeout_id = (guint) 0;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gdouble
_pomodoro_animation_calculate_linear_pomodoro_animation_func (gdouble progress,
                                                              gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_linear (progress);
	return result;
}

static gdouble
_pomodoro_animation_calculate_ease_in_pomodoro_animation_func (gdouble progress,
                                                               gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_ease_in (progress);
	return result;
}

static gdouble
_pomodoro_animation_calculate_ease_in_out_pomodoro_animation_func (gdouble progress,
                                                                   gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_ease_in_out (progress);
	return result;
}

static gdouble
_pomodoro_animation_calculate_ease_out_pomodoro_animation_func (gdouble progress,
                                                                gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_ease_out (progress);
	return result;
}

static gdouble
_pomodoro_animation_calculate_ease_in_cubic_pomodoro_animation_func (gdouble progress,
                                                                     gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_ease_in_cubic (progress);
	return result;
}

static gdouble
_pomodoro_animation_calculate_ease_in_out_cubic_pomodoro_animation_func (gdouble progress,
                                                                         gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_ease_in_out_cubic (progress);
	return result;
}

static gdouble
_pomodoro_animation_calculate_ease_out_cubic_pomodoro_animation_func (gdouble progress,
                                                                      gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_ease_out_cubic (progress);
	return result;
}

static gdouble
_pomodoro_animation_calculate_blink_pomodoro_animation_func (gdouble progress,
                                                             gpointer self)
{
	gdouble result;
	result = pomodoro_animation_calculate_blink (progress);
	return result;
}

static PomodoroAnimationFunc
pomodoro_animation_get_func (PomodoroAnimationMode mode,
                             gpointer* result_target,
                             GDestroyNotify* result_target_destroy_notify)
{
	PomodoroAnimationFunc _tmp8_;
	gpointer _tmp8__target;
	GDestroyNotify _tmp8__target_destroy_notify;
	PomodoroAnimationFunc result;
	switch (mode) {
		case POMODORO_ANIMATION_MODE_LINEAR:
		{
			PomodoroAnimationFunc _tmp0_;
			gpointer _tmp0__target;
			GDestroyNotify _tmp0__target_destroy_notify;
			_tmp0_ = _pomodoro_animation_calculate_linear_pomodoro_animation_func;
			_tmp0__target = NULL;
			_tmp0__target_destroy_notify = NULL;
			*result_target = _tmp0__target;
			*result_target_destroy_notify = _tmp0__target_destroy_notify;
			result = _tmp0_;
			return result;
		}
		case POMODORO_ANIMATION_MODE_EASE_IN:
		{
			PomodoroAnimationFunc _tmp1_;
			gpointer _tmp1__target;
			GDestroyNotify _tmp1__target_destroy_notify;
			_tmp1_ = _pomodoro_animation_calculate_ease_in_pomodoro_animation_func;
			_tmp1__target = NULL;
			_tmp1__target_destroy_notify = NULL;
			*result_target = _tmp1__target;
			*result_target_destroy_notify = _tmp1__target_destroy_notify;
			result = _tmp1_;
			return result;
		}
		case POMODORO_ANIMATION_MODE_EASE_IN_OUT:
		{
			PomodoroAnimationFunc _tmp2_;
			gpointer _tmp2__target;
			GDestroyNotify _tmp2__target_destroy_notify;
			_tmp2_ = _pomodoro_animation_calculate_ease_in_out_pomodoro_animation_func;
			_tmp2__target = NULL;
			_tmp2__target_destroy_notify = NULL;
			*result_target = _tmp2__target;
			*result_target_destroy_notify = _tmp2__target_destroy_notify;
			result = _tmp2_;
			return result;
		}
		case POMODORO_ANIMATION_MODE_EASE_OUT:
		{
			PomodoroAnimationFunc _tmp3_;
			gpointer _tmp3__target;
			GDestroyNotify _tmp3__target_destroy_notify;
			_tmp3_ = _pomodoro_animation_calculate_ease_out_pomodoro_animation_func;
			_tmp3__target = NULL;
			_tmp3__target_destroy_notify = NULL;
			*result_target = _tmp3__target;
			*result_target_destroy_notify = _tmp3__target_destroy_notify;
			result = _tmp3_;
			return result;
		}
		case POMODORO_ANIMATION_MODE_EASE_IN_CUBIC:
		{
			PomodoroAnimationFunc _tmp4_;
			gpointer _tmp4__target;
			GDestroyNotify _tmp4__target_destroy_notify;
			_tmp4_ = _pomodoro_animation_calculate_ease_in_cubic_pomodoro_animation_func;
			_tmp4__target = NULL;
			_tmp4__target_destroy_notify = NULL;
			*result_target = _tmp4__target;
			*result_target_destroy_notify = _tmp4__target_destroy_notify;
			result = _tmp4_;
			return result;
		}
		case POMODORO_ANIMATION_MODE_EASE_IN_OUT_CUBIC:
		{
			PomodoroAnimationFunc _tmp5_;
			gpointer _tmp5__target;
			GDestroyNotify _tmp5__target_destroy_notify;
			_tmp5_ = _pomodoro_animation_calculate_ease_in_out_cubic_pomodoro_animation_func;
			_tmp5__target = NULL;
			_tmp5__target_destroy_notify = NULL;
			*result_target = _tmp5__target;
			*result_target_destroy_notify = _tmp5__target_destroy_notify;
			result = _tmp5_;
			return result;
		}
		case POMODORO_ANIMATION_MODE_EASE_OUT_CUBIC:
		{
			PomodoroAnimationFunc _tmp6_;
			gpointer _tmp6__target;
			GDestroyNotify _tmp6__target_destroy_notify;
			_tmp6_ = _pomodoro_animation_calculate_ease_out_cubic_pomodoro_animation_func;
			_tmp6__target = NULL;
			_tmp6__target_destroy_notify = NULL;
			*result_target = _tmp6__target;
			*result_target_destroy_notify = _tmp6__target_destroy_notify;
			result = _tmp6_;
			return result;
		}
		case POMODORO_ANIMATION_MODE_BLINK:
		{
			PomodoroAnimationFunc _tmp7_;
			gpointer _tmp7__target;
			GDestroyNotify _tmp7__target_destroy_notify;
			_tmp7_ = _pomodoro_animation_calculate_blink_pomodoro_animation_func;
			_tmp7__target = NULL;
			_tmp7__target_destroy_notify = NULL;
			*result_target = _tmp7__target;
			*result_target_destroy_notify = _tmp7__target_destroy_notify;
			result = _tmp7_;
			return result;
		}
		default:
		break;
	}
	_tmp8_ = _pomodoro_animation_calculate_linear_pomodoro_animation_func;
	_tmp8__target = NULL;
	_tmp8__target_destroy_notify = NULL;
	*result_target = _tmp8__target;
	*result_target_destroy_notify = _tmp8__target_destroy_notify;
	result = _tmp8_;
	return result;
}

static gdouble
pomodoro_animation_calculate_linear (gdouble t)
{
	gdouble result;
	result = t;
	return result;
}

static gdouble
pomodoro_animation_calculate_ease_in (gdouble t)
{
	gdouble result;
	result = t * t;
	return result;
}

static gdouble
pomodoro_animation_calculate_ease_in_out (gdouble t)
{
	gdouble result;
	t = t * 2.0;
	if (t < 1.0) {
		result = (0.5 * t) * t;
		return result;
	} else {
		t = t - 1.0;
		result = (-0.5) * ((t * (t - 2.0)) - 1.0);
		return result;
	}
}

static gdouble
pomodoro_animation_calculate_ease_in_out_cubic (gdouble t)
{
	gdouble result;
	result = ((1.0 - t) + (2.0 - t)) * (t * t);
	return result;
}

static gdouble
pomodoro_animation_calculate_ease_out (gdouble t)
{
	gdouble result;
	result = (2.0 - t) * t;
	return result;
}

static gdouble
pomodoro_animation_calculate_ease_in_cubic (gdouble t)
{
	gdouble result;
	result = (t * t) * t;
	return result;
}

static gdouble
pomodoro_animation_calculate_ease_out_cubic (gdouble t)
{
	gdouble result;
	result = (((t - 3.0) * t) + 3.0) * t;
	return result;
}

static gdouble
pomodoro_animation_calculate_blink (gdouble t)
{
	gdouble _tmp0_ = 0.0;
	gdouble result;
	if (t < 0.5) {
		_tmp0_ = pomodoro_animation_calculate_ease_in_out (2.0 * t);
	} else {
		_tmp0_ = 1.0 - pomodoro_animation_calculate_ease_in_out ((2.0 * t) - 1.0);
	}
	result = _tmp0_;
	return result;
}

GObject*
pomodoro_animation_get_target (PomodoroAnimation* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
pomodoro_animation_set_target (PomodoroAnimation* self,
                               GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_animation_get_target (self);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_target);
		self->priv->_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_animation_properties[POMODORO_ANIMATION_TARGET_PROPERTY]);
	}
}

const gchar*
pomodoro_animation_get_property_name (PomodoroAnimation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_property_name;
	result = _tmp0_;
	return result;
}

void
pomodoro_animation_set_property_name (PomodoroAnimation* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_animation_get_property_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_property_name);
		self->priv->_property_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_animation_properties[POMODORO_ANIMATION_PROPERTY_NAME_PROPERTY]);
	}
}

PomodoroAnimationMode
pomodoro_animation_get_mode (PomodoroAnimation* self)
{
	PomodoroAnimationMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
pomodoro_animation_set_mode (PomodoroAnimation* self,
                             PomodoroAnimationMode value)
{
	PomodoroAnimationMode old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_animation_get_mode (self);
	if (old_value != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_animation_properties[POMODORO_ANIMATION_MODE_PROPERTY]);
	}
}

guint
pomodoro_animation_get_duration (PomodoroAnimation* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_duration;
	return result;
}

void
pomodoro_animation_set_duration (PomodoroAnimation* self,
                                 guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_animation_get_duration (self);
	if (old_value != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_animation_properties[POMODORO_ANIMATION_DURATION_PROPERTY]);
	}
}

guint
pomodoro_animation_get_frames_per_second (PomodoroAnimation* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_frames_per_second;
	return result;
}

void
pomodoro_animation_set_frames_per_second (PomodoroAnimation* self,
                                          guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_animation_get_frames_per_second (self);
	if (old_value != value) {
		self->priv->_frames_per_second = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_animation_properties[POMODORO_ANIMATION_FRAMES_PER_SECOND_PROPERTY]);
	}
}

gdouble
pomodoro_animation_get_progress (PomodoroAnimation* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}

static void
pomodoro_animation_set_progress (PomodoroAnimation* self,
                                 gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_animation_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_animation_properties[POMODORO_ANIMATION_PROGRESS_PROPERTY]);
	}
}

static void
pomodoro_animation_class_init (PomodoroAnimationClass * klass,
                               gpointer klass_data)
{
	pomodoro_animation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroAnimation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_animation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_animation_set_property;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_animation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ANIMATION_TARGET_PROPERTY, pomodoro_animation_properties[POMODORO_ANIMATION_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ANIMATION_PROPERTY_NAME_PROPERTY, pomodoro_animation_properties[POMODORO_ANIMATION_PROPERTY_NAME_PROPERTY] = g_param_spec_string ("property-name", "property-name", "property-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ANIMATION_MODE_PROPERTY, pomodoro_animation_properties[POMODORO_ANIMATION_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", POMODORO_TYPE_ANIMATION_MODE, POMODORO_ANIMATION_MODE_LINEAR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ANIMATION_DURATION_PROPERTY, pomodoro_animation_properties[POMODORO_ANIMATION_DURATION_PROPERTY] = g_param_spec_uint ("duration", "duration", "duration", 0, G_MAXUINT, (guint) 200, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ANIMATION_FRAMES_PER_SECOND_PROPERTY, pomodoro_animation_properties[POMODORO_ANIMATION_FRAMES_PER_SECOND_PROPERTY] = g_param_spec_uint ("frames-per-second", "frames-per-second", "frames-per-second", 0, G_MAXUINT, (guint) 60, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_ANIMATION_PROGRESS_PROPERTY, pomodoro_animation_properties[POMODORO_ANIMATION_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	pomodoro_animation_signals[POMODORO_ANIMATION_COMPLETE_SIGNAL] = g_signal_new ("complete", POMODORO_TYPE_ANIMATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pomodoro_animation_instance_init (PomodoroAnimation * self,
                                  gpointer klass)
{
	self->priv = pomodoro_animation_get_instance_private (self);
	self->priv->_mode = POMODORO_ANIMATION_MODE_LINEAR;
	self->priv->_duration = (guint) 200;
	self->priv->_frames_per_second = (guint) 60;
	self->priv->_progress = 0.0;
	self->priv->timestamp = (gint64) 0;
	self->priv->timeout_id = (guint) 0;
	self->priv->func = NULL;
	self->priv->func_target = NULL;
	self->priv->func_target_destroy_notify = NULL;
}

static void
pomodoro_animation_finalize (GObject * obj)
{
	PomodoroAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_ANIMATION, PomodoroAnimation);
	pomodoro_animation_stop (self);
	_g_object_unref0 (self->priv->_target);
	_g_free0 (self->priv->_property_name);
	(self->priv->func_target_destroy_notify == NULL) ? NULL : (self->priv->func_target_destroy_notify (self->priv->func_target), NULL);
	self->priv->func = NULL;
	self->priv->func_target = NULL;
	self->priv->func_target_destroy_notify = NULL;
	G_OBJECT_CLASS (pomodoro_animation_parent_class)->finalize (obj);
}

static GType
pomodoro_animation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroAnimationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_animation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroAnimation), 0, (GInstanceInitFunc) pomodoro_animation_instance_init, NULL };
	GType pomodoro_animation_type_id;
	pomodoro_animation_type_id = g_type_register_static (G_TYPE_INITIALLY_UNOWNED, "PomodoroAnimation", &g_define_type_info, 0);
	PomodoroAnimation_private_offset = g_type_add_instance_private (pomodoro_animation_type_id, sizeof (PomodoroAnimationPrivate));
	return pomodoro_animation_type_id;
}

GType
pomodoro_animation_get_type (void)
{
	static volatile gsize pomodoro_animation_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_animation_type_id__once)) {
		GType pomodoro_animation_type_id;
		pomodoro_animation_type_id = pomodoro_animation_get_type_once ();
		g_once_init_leave (&pomodoro_animation_type_id__once, pomodoro_animation_type_id);
	}
	return pomodoro_animation_type_id__once;
}

static void
_vala_pomodoro_animation_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PomodoroAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_ANIMATION, PomodoroAnimation);
	switch (property_id) {
		case POMODORO_ANIMATION_TARGET_PROPERTY:
		g_value_set_object (value, pomodoro_animation_get_target (self));
		break;
		case POMODORO_ANIMATION_PROPERTY_NAME_PROPERTY:
		g_value_set_string (value, pomodoro_animation_get_property_name (self));
		break;
		case POMODORO_ANIMATION_MODE_PROPERTY:
		g_value_set_enum (value, pomodoro_animation_get_mode (self));
		break;
		case POMODORO_ANIMATION_DURATION_PROPERTY:
		g_value_set_uint (value, pomodoro_animation_get_duration (self));
		break;
		case POMODORO_ANIMATION_FRAMES_PER_SECOND_PROPERTY:
		g_value_set_uint (value, pomodoro_animation_get_frames_per_second (self));
		break;
		case POMODORO_ANIMATION_PROGRESS_PROPERTY:
		g_value_set_double (value, pomodoro_animation_get_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_animation_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PomodoroAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_ANIMATION, PomodoroAnimation);
	switch (property_id) {
		case POMODORO_ANIMATION_TARGET_PROPERTY:
		pomodoro_animation_set_target (self, g_value_get_object (value));
		break;
		case POMODORO_ANIMATION_PROPERTY_NAME_PROPERTY:
		pomodoro_animation_set_property_name (self, g_value_get_string (value));
		break;
		case POMODORO_ANIMATION_MODE_PROPERTY:
		pomodoro_animation_set_mode (self, g_value_get_enum (value));
		break;
		case POMODORO_ANIMATION_DURATION_PROPERTY:
		pomodoro_animation_set_duration (self, g_value_get_uint (value));
		break;
		case POMODORO_ANIMATION_FRAMES_PER_SECOND_PROPERTY:
		pomodoro_animation_set_frames_per_second (self, g_value_get_uint (value));
		break;
		case POMODORO_ANIMATION_PROGRESS_PROPERTY:
		pomodoro_animation_set_progress (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

