/* capability-manager.c generated by valac 0.56.17, the Vala compiler
 * generated from capability-manager.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_CAPABILITY_MANAGER_0_PROPERTY,
	POMODORO_CAPABILITY_MANAGER_NUM_PROPERTIES
};
static GParamSpec* pomodoro_capability_manager_properties[POMODORO_CAPABILITY_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
enum  {
	POMODORO_CAPABILITY_MANAGER_GROUP_ADDED_SIGNAL,
	POMODORO_CAPABILITY_MANAGER_GROUP_REMOVED_SIGNAL,
	POMODORO_CAPABILITY_MANAGER_CAPABILITY_ENABLED_SIGNAL,
	POMODORO_CAPABILITY_MANAGER_CAPABILITY_DISABLED_SIGNAL,
	POMODORO_CAPABILITY_MANAGER_NUM_SIGNALS
};
static guint pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_NUM_SIGNALS] = {0};

struct _PomodoroCapabilityManagerPrivate {
	GHashTable* capabilities;
	GHashTable* enabled_capabilities;
	GSList* groups;
};

struct _Block6Data {
	int _ref_count_;
	GHashTable* self;
	GFunc func;
	gpointer func_target;
};

static gint PomodoroCapabilityManager_private_offset;
static gpointer pomodoro_capability_manager_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void pomodoro_capability_manager_set_group_priority (PomodoroCapabilityGroup* group,
                                                     PomodoroPriority priority);
static gint pomodoro_capability_manager_group_priority_compare (PomodoroCapabilityGroup* a,
                                                         PomodoroCapabilityGroup* b);
static gint _pomodoro_capability_manager_group_priority_compare_gcompare_func (gconstpointer a,
                                                                        gconstpointer b);
static void pomodoro_capability_manager_on_group_capability_added (PomodoroCapabilityManager* self,
                                                            PomodoroCapabilityGroup* group,
                                                            PomodoroCapability* capability);
static void _pomodoro_capability_manager_on_group_capability_added_pomodoro_capability_group_capability_added (PomodoroCapabilityGroup* _sender,
                                                                                                        PomodoroCapability* capability,
                                                                                                        gpointer self);
static void pomodoro_capability_manager_on_group_capability_removed (PomodoroCapabilityManager* self,
                                                              PomodoroCapabilityGroup* group,
                                                              PomodoroCapability* capability);
static void _pomodoro_capability_manager_on_group_capability_removed_pomodoro_capability_group_capability_removed (PomodoroCapabilityGroup* _sender,
                                                                                                            PomodoroCapability* capability,
                                                                                                            gpointer self);
static void ___lambda18_ (PomodoroCapabilityManager* self,
                   const gchar* capability_name,
                   PomodoroCapability* capability);
static void pomodoro_capability_manager_add_capability_internal (PomodoroCapabilityManager* self,
                                                          PomodoroCapability* capability);
static void ____lambda18__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static void ___lambda19_ (PomodoroCapabilityManager* self,
                   const gchar* capability_name,
                   PomodoroCapability* capability);
static void pomodoro_capability_manager_remove_capability_internal (PomodoroCapabilityManager* self,
                                                             PomodoroCapability* capability);
static void ____lambda19__gh_func (gconstpointer key,
                            gconstpointer value,
                            gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda2__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void __lambda20_ (PomodoroCapabilityManager* self,
                  const gchar* capability_name);
static void ___lambda20__gfunc (gconstpointer data,
                         gpointer self);
static PomodoroPriority pomodoro_capability_manager_get_group_priority (PomodoroCapabilityGroup* group);
static void pomodoro_capability_manager_real_dispose (GObject* base);
static GObject * pomodoro_capability_manager_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void pomodoro_capability_manager_finalize (GObject * obj);
static GType pomodoro_capability_manager_get_type_once (void);

static GType
pomodoro_priority_get_type_once (void)
{
	static const GEnumValue values[] = {{POMODORO_PRIORITY_LOW, "POMODORO_PRIORITY_LOW", "low"}, {POMODORO_PRIORITY_DEFAULT, "POMODORO_PRIORITY_DEFAULT", "default"}, {POMODORO_PRIORITY_HIGH, "POMODORO_PRIORITY_HIGH", "high"}, {0, NULL, NULL}};
	GType pomodoro_priority_type_id;
	pomodoro_priority_type_id = g_enum_register_static ("PomodoroPriority", values);
	return pomodoro_priority_type_id;
}

GType
pomodoro_priority_get_type (void)
{
	static volatile gsize pomodoro_priority_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_priority_type_id__once)) {
		GType pomodoro_priority_type_id;
		pomodoro_priority_type_id = pomodoro_priority_get_type_once ();
		g_once_init_leave (&pomodoro_priority_type_id__once, pomodoro_priority_type_id);
	}
	return pomodoro_priority_type_id__once;
}

static inline gpointer
pomodoro_capability_manager_get_instance_private (PomodoroCapabilityManager* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroCapabilityManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

PomodoroCapability*
pomodoro_capability_manager_get_preferred_capability (PomodoroCapabilityManager* self,
                                                      const gchar* capability_name)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	PomodoroCapability* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (capability_name != NULL, NULL);
	_tmp0_ = self->priv->capabilities;
	_tmp1_ = g_hash_table_lookup (_tmp0_, capability_name);
	result = (PomodoroCapability*) _tmp1_;
	return result;
}

gboolean
pomodoro_capability_manager_has_capability (PomodoroCapabilityManager* self,
                                            const gchar* capability_name)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (capability_name != NULL, FALSE);
	_tmp0_ = self->priv->capabilities;
	result = g_hash_table_contains (_tmp0_, capability_name);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
pomodoro_capability_manager_has_enabled (PomodoroCapabilityManager* self,
                                         const gchar* capability_name)
{
	PomodoroCapability* capability = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	PomodoroCapability* _tmp2_;
	gboolean _tmp3_ = FALSE;
	PomodoroCapability* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (capability_name != NULL, FALSE);
	_tmp0_ = self->priv->capabilities;
	_tmp1_ = g_hash_table_lookup (_tmp0_, capability_name);
	_tmp2_ = _g_object_ref0 ((PomodoroCapability*) _tmp1_);
	capability = _tmp2_;
	_tmp4_ = capability;
	if (_tmp4_ != NULL) {
		PomodoroCapability* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = capability;
		_tmp6_ = pomodoro_capability_get_enabled (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	_g_object_unref0 (capability);
	return result;
}

gboolean
pomodoro_capability_manager_has_group (PomodoroCapabilityManager* self,
                                       PomodoroCapabilityGroup* group)
{
	GSList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	_tmp0_ = self->priv->groups;
	result = g_slist_index (_tmp0_, group) >= 0;
	return result;
}

static gint
_pomodoro_capability_manager_group_priority_compare_gcompare_func (gconstpointer a,
                                                                   gconstpointer b)
{
	gint result;
	result = pomodoro_capability_manager_group_priority_compare ((PomodoroCapabilityGroup*) a, (PomodoroCapabilityGroup*) b);
	return result;
}

static void
_pomodoro_capability_manager_on_group_capability_added_pomodoro_capability_group_capability_added (PomodoroCapabilityGroup* _sender,
                                                                                                   PomodoroCapability* capability,
                                                                                                   gpointer self)
{
	pomodoro_capability_manager_on_group_capability_added ((PomodoroCapabilityManager*) self, _sender, capability);
}

static void
_pomodoro_capability_manager_on_group_capability_removed_pomodoro_capability_group_capability_removed (PomodoroCapabilityGroup* _sender,
                                                                                                       PomodoroCapability* capability,
                                                                                                       gpointer self)
{
	pomodoro_capability_manager_on_group_capability_removed ((PomodoroCapabilityManager*) self, _sender, capability);
}

static void
___lambda18_ (PomodoroCapabilityManager* self,
              const gchar* capability_name,
              PomodoroCapability* capability)
{
	g_return_if_fail (capability_name != NULL);
	g_return_if_fail (capability != NULL);
	pomodoro_capability_manager_add_capability_internal (self, capability);
}

static void
____lambda18__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda18_ ((PomodoroCapabilityManager*) self, (const gchar*) key, (PomodoroCapability*) value);
}

void
pomodoro_capability_manager_add_group (PomodoroCapabilityManager* self,
                                       PomodoroCapabilityGroup* group,
                                       PomodoroPriority priority)
{
	GSList* group_link = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = self->priv->groups;
	_tmp1_ = g_slist_find (_tmp0_, group);
	group_link = _tmp1_;
	_tmp2_ = group_link;
	if (_tmp2_ == NULL) {
		PomodoroCapabilityGroup* _tmp3_;
		pomodoro_capability_manager_set_group_priority (group, priority);
		_tmp3_ = _g_object_ref0 (group);
		self->priv->groups = g_slist_insert_sorted (self->priv->groups, _tmp3_, _pomodoro_capability_manager_group_priority_compare_gcompare_func);
		g_signal_connect_object (group, "capability-added", (GCallback) _pomodoro_capability_manager_on_group_capability_added_pomodoro_capability_group_capability_added, self, 0);
		g_signal_connect_object (group, "capability-removed", (GCallback) _pomodoro_capability_manager_on_group_capability_removed_pomodoro_capability_group_capability_removed, self, 0);
		pomodoro_capability_group_foreach (group, ____lambda18__gh_func, self);
		g_signal_emit (self, pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_GROUP_ADDED_SIGNAL], 0, group);
	} else {
	}
}

static void
___lambda19_ (PomodoroCapabilityManager* self,
              const gchar* capability_name,
              PomodoroCapability* capability)
{
	g_return_if_fail (capability_name != NULL);
	g_return_if_fail (capability != NULL);
	pomodoro_capability_manager_remove_capability_internal (self, capability);
}

static void
____lambda19__gh_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	___lambda19_ ((PomodoroCapabilityManager*) self, (const gchar*) key, (PomodoroCapability*) value);
}

void
pomodoro_capability_manager_remove_group (PomodoroCapabilityManager* self,
                                          PomodoroCapabilityGroup* group)
{
	GSList* group_link = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = self->priv->groups;
	_tmp1_ = g_slist_find (_tmp0_, group);
	group_link = _tmp1_;
	_tmp2_ = group_link;
	if (_tmp2_ != NULL) {
		GSList* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp3_ = group_link;
		self->priv->groups = g_slist_remove_link (self->priv->groups, _tmp3_);
		g_signal_parse_name ("capability-added", POMODORO_TYPE_CAPABILITY_GROUP, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (group, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _pomodoro_capability_manager_on_group_capability_added_pomodoro_capability_group_capability_added, self);
		g_signal_parse_name ("capability-removed", POMODORO_TYPE_CAPABILITY_GROUP, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (group, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _pomodoro_capability_manager_on_group_capability_removed_pomodoro_capability_group_capability_removed, self);
		pomodoro_capability_group_foreach (group, ____lambda19__gh_func, self);
		g_signal_emit (self, pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_GROUP_REMOVED_SIGNAL], 0, group);
	}
}

void
pomodoro_capability_manager_enable (PomodoroCapabilityManager* self,
                                    const gchar* capability_name)
{
	PomodoroCapability* capability = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	PomodoroCapability* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	PomodoroCapability* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (capability_name != NULL);
	_tmp0_ = self->priv->capabilities;
	_tmp1_ = g_hash_table_lookup (_tmp0_, capability_name);
	_tmp2_ = _g_object_ref0 ((PomodoroCapability*) _tmp1_);
	capability = _tmp2_;
	_tmp3_ = self->priv->enabled_capabilities;
	_tmp4_ = g_strdup (capability_name);
	g_hash_table_add (_tmp3_, _tmp4_);
	_tmp6_ = capability;
	if (_tmp6_ != NULL) {
		PomodoroCapability* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = capability;
		_tmp8_ = pomodoro_capability_get_enabled (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = !_tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		PomodoroCapability* _tmp10_;
		_tmp10_ = capability;
		g_signal_emit_by_name (_tmp10_, "enable");
	}
	_g_object_unref0 (capability);
}

void
pomodoro_capability_manager_disable (PomodoroCapabilityManager* self,
                                     const gchar* capability_name)
{
	PomodoroCapability* capability = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	PomodoroCapability* _tmp2_;
	GHashTable* _tmp3_;
	gboolean _tmp4_ = FALSE;
	PomodoroCapability* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (capability_name != NULL);
	_tmp0_ = self->priv->capabilities;
	_tmp1_ = g_hash_table_lookup (_tmp0_, capability_name);
	_tmp2_ = _g_object_ref0 ((PomodoroCapability*) _tmp1_);
	capability = _tmp2_;
	_tmp3_ = self->priv->enabled_capabilities;
	g_hash_table_remove (_tmp3_, capability_name);
	_tmp5_ = capability;
	if (_tmp5_ != NULL) {
		PomodoroCapability* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = capability;
		_tmp7_ = pomodoro_capability_get_enabled (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		PomodoroCapability* _tmp9_;
		_tmp9_ = capability;
		g_signal_emit_by_name (_tmp9_, "disable");
	}
	_g_object_unref0 (capability);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GHashTable* self;
		self = _data6_->self;
		_g_hash_table_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda2_ (Block6Data* _data6_,
            gconstpointer k,
            gconstpointer v)
{
	GHashTable* self;
	self = _data6_->self;
	_data6_->func (v, _data6_->func_target);
}

static void
___lambda2__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda2_ (self, key, value);
}

static void
_vala_g_hash_set_foreach (GHashTable* self,
                          GFunc func,
                          gpointer func_target)
{
	Block6Data* _data6_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_hash_table_ref (self);
	_data6_->func = func;
	_data6_->func_target = func_target;
	g_hash_table_foreach ((GHashTable*) self, ___lambda2__gh_func, _data6_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
__lambda20_ (PomodoroCapabilityManager* self,
             const gchar* capability_name)
{
	PomodoroCapability* capability = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	PomodoroCapability* _tmp2_;
	gboolean _tmp3_ = FALSE;
	PomodoroCapability* _tmp4_;
	g_return_if_fail (capability_name != NULL);
	_tmp0_ = self->priv->capabilities;
	_tmp1_ = g_hash_table_lookup (_tmp0_, capability_name);
	_tmp2_ = _g_object_ref0 ((PomodoroCapability*) _tmp1_);
	capability = _tmp2_;
	_tmp4_ = capability;
	if (_tmp4_ != NULL) {
		PomodoroCapability* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = capability;
		_tmp6_ = pomodoro_capability_get_enabled (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		PomodoroCapability* _tmp8_;
		_tmp8_ = capability;
		g_signal_emit_by_name (_tmp8_, "disable");
	}
	_g_object_unref0 (capability);
}

static void
___lambda20__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda20_ ((PomodoroCapabilityManager*) self, (const gchar*) data);
}

void
pomodoro_capability_manager_disable_all (PomodoroCapabilityManager* self)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->enabled_capabilities;
	_vala_g_hash_set_foreach (_tmp0_, ___lambda20__gfunc, self);
	_tmp1_ = self->priv->enabled_capabilities;
	g_hash_table_remove_all (_tmp1_);
}

static PomodoroPriority
pomodoro_capability_manager_get_group_priority (PomodoroCapabilityGroup* group)
{
	gconstpointer _tmp0_;
	PomodoroPriority result;
	g_return_val_if_fail (group != NULL, 0);
	_tmp0_ = g_object_get_data ((GObject*) group, "priority");
	result = (PomodoroPriority) ((gintptr) _tmp0_);
	return result;
}

static void
pomodoro_capability_manager_set_group_priority (PomodoroCapabilityGroup* group,
                                                PomodoroPriority priority)
{
	g_return_if_fail (group != NULL);
	g_object_set_data_full ((GObject*) group, "priority", (gpointer) ((gintptr) priority), NULL);
}

static gint
pomodoro_capability_manager_group_priority_compare (PomodoroCapabilityGroup* a,
                                                    PomodoroCapabilityGroup* b)
{
	PomodoroPriority a_priority = 0;
	PomodoroPriority b_priority = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	a_priority = pomodoro_capability_manager_get_group_priority (a);
	b_priority = pomodoro_capability_manager_get_group_priority (b);
	if (a_priority > b_priority) {
		result = -1;
		return result;
	}
	if (a_priority < b_priority) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static void
pomodoro_capability_manager_add_capability_internal (PomodoroCapabilityManager* self,
                                                     PomodoroCapability* capability)
{
	PomodoroCapability* preferred_capability = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	PomodoroCapability* _tmp4_;
	PomodoroCapability* _tmp5_;
	GHashTable* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (capability != NULL);
	_tmp0_ = self->priv->capabilities;
	_tmp1_ = pomodoro_capability_get_name (capability);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((PomodoroCapability*) _tmp3_);
	preferred_capability = _tmp4_;
	_tmp5_ = preferred_capability;
	if (_tmp5_ != NULL) {
		PomodoroCapability* _tmp6_;
		PomodoroCapability* _tmp7_;
		PomodoroCapabilityGroup* _tmp8_;
		PomodoroCapabilityGroup* _tmp9_;
		PomodoroCapabilityGroup* _tmp10_;
		PomodoroCapabilityGroup* _tmp11_;
		_tmp6_ = preferred_capability;
		g_signal_emit_by_name (_tmp6_, "disable");
		_tmp7_ = preferred_capability;
		_tmp8_ = pomodoro_capability_get_group (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = pomodoro_capability_get_group (capability);
		_tmp11_ = _tmp10_;
		if (pomodoro_capability_manager_get_group_priority (_tmp9_) < pomodoro_capability_manager_get_group_priority (_tmp11_)) {
			GHashTable* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			PomodoroCapability* _tmp16_;
			_tmp12_ = self->priv->capabilities;
			_tmp13_ = pomodoro_capability_get_name (capability);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup (_tmp14_);
			_tmp16_ = _g_object_ref0 (capability);
			g_hash_table_replace (_tmp12_, _tmp15_, _tmp16_);
		}
	} else {
		GHashTable* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		PomodoroCapability* _tmp21_;
		_tmp17_ = self->priv->capabilities;
		_tmp18_ = pomodoro_capability_get_name (capability);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = _g_object_ref0 (capability);
		g_hash_table_insert (_tmp17_, _tmp20_, _tmp21_);
	}
	_tmp22_ = self->priv->enabled_capabilities;
	_tmp23_ = pomodoro_capability_get_name (capability);
	_tmp24_ = _tmp23_;
	if (g_hash_table_contains (_tmp22_, _tmp24_)) {
		gboolean _tmp25_;
		gboolean _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp25_ = pomodoro_capability_get_enabled (capability);
		_tmp26_ = _tmp25_;
		if (!_tmp26_) {
			g_signal_emit_by_name (capability, "enable");
		}
		_tmp27_ = pomodoro_capability_get_name (capability);
		_tmp28_ = _tmp27_;
		g_signal_emit (self, pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_CAPABILITY_ENABLED_SIGNAL], 0, _tmp28_);
	} else {
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp29_ = pomodoro_capability_get_enabled (capability);
		_tmp30_ = _tmp29_;
		if (_tmp30_) {
			g_signal_emit_by_name (capability, "disable");
		}
	}
	_g_object_unref0 (preferred_capability);
}

static void
pomodoro_capability_manager_remove_capability_internal (PomodoroCapabilityManager* self,
                                                        PomodoroCapability* capability)
{
	PomodoroCapability* preferred_capability = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	PomodoroCapability* _tmp4_;
	PomodoroCapability* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (capability != NULL);
	_tmp0_ = self->priv->capabilities;
	_tmp1_ = pomodoro_capability_get_name (capability);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((PomodoroCapability*) _tmp3_);
	preferred_capability = _tmp4_;
	_tmp5_ = preferred_capability;
	if (_tmp5_ == capability) {
		GHashTable* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GSList* iter = NULL;
		GSList* _tmp9_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp6_ = self->priv->capabilities;
		_tmp7_ = pomodoro_capability_get_name (capability);
		_tmp8_ = _tmp7_;
		g_hash_table_remove (_tmp6_, _tmp8_);
		g_signal_emit_by_name (capability, "disable");
		_tmp9_ = self->priv->groups;
		iter = _tmp9_;
		while (TRUE) {
			GSList* _tmp10_;
			GSList* _tmp11_;
			gconstpointer _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			PomodoroCapability* _tmp15_;
			PomodoroCapability* _tmp16_;
			PomodoroCapability* _tmp17_;
			GSList* _tmp19_;
			GSList* _tmp20_;
			_tmp10_ = iter;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = iter;
			_tmp12_ = _tmp11_->data;
			_tmp13_ = pomodoro_capability_get_name (capability);
			_tmp14_ = _tmp13_;
			_tmp15_ = pomodoro_capability_group_lookup ((PomodoroCapabilityGroup*) _tmp12_, _tmp14_);
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_g_object_unref0 (preferred_capability);
			preferred_capability = _tmp16_;
			_tmp17_ = preferred_capability;
			if (_tmp17_ != NULL) {
				PomodoroCapability* _tmp18_;
				_tmp18_ = preferred_capability;
				pomodoro_capability_manager_add_capability_internal (self, _tmp18_);
				break;
			}
			_tmp19_ = iter;
			_tmp20_ = _tmp19_->next;
			iter = _tmp20_;
		}
		_tmp21_ = pomodoro_capability_get_name (capability);
		_tmp22_ = _tmp21_;
		g_signal_emit (self, pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_CAPABILITY_DISABLED_SIGNAL], 0, _tmp22_);
	}
	_g_object_unref0 (preferred_capability);
}

static void
pomodoro_capability_manager_on_group_capability_added (PomodoroCapabilityManager* self,
                                                       PomodoroCapabilityGroup* group,
                                                       PomodoroCapability* capability)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (capability != NULL);
	pomodoro_capability_manager_add_capability_internal (self, capability);
}

static void
pomodoro_capability_manager_on_group_capability_removed (PomodoroCapabilityManager* self,
                                                         PomodoroCapabilityGroup* group,
                                                         PomodoroCapability* capability)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (capability != NULL);
	pomodoro_capability_manager_remove_capability_internal (self, capability);
}

static void
pomodoro_capability_manager_real_dispose (GObject* base)
{
	PomodoroCapabilityManager * self;
	self = (PomodoroCapabilityManager*) base;
	pomodoro_capability_manager_disable_all (self);
	G_OBJECT_CLASS (pomodoro_capability_manager_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

PomodoroCapabilityManager*
pomodoro_capability_manager_construct (GType object_type)
{
	PomodoroCapabilityManager * self = NULL;
	self = (PomodoroCapabilityManager*) g_object_new (object_type, NULL);
	return self;
}

PomodoroCapabilityManager*
pomodoro_capability_manager_new (void)
{
	return pomodoro_capability_manager_construct (POMODORO_TYPE_CAPABILITY_MANAGER);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
pomodoro_capability_manager_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroCapabilityManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	parent_class = G_OBJECT_CLASS (pomodoro_capability_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_CAPABILITY_MANAGER, PomodoroCapabilityManager);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->capabilities);
	self->priv->capabilities = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->enabled_capabilities);
	self->priv->enabled_capabilities = _tmp5_;
	(self->priv->groups == NULL) ? NULL : (self->priv->groups = (_g_slist_free__g_object_unref0_ (self->priv->groups), NULL));
	self->priv->groups = NULL;
	return obj;
}

static void
pomodoro_capability_manager_class_init (PomodoroCapabilityManagerClass * klass,
                                        gpointer klass_data)
{
	pomodoro_capability_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroCapabilityManager_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) pomodoro_capability_manager_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_capability_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_capability_manager_finalize;
	pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_GROUP_ADDED_SIGNAL] = g_signal_new ("group-added", POMODORO_TYPE_CAPABILITY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, POMODORO_TYPE_CAPABILITY_GROUP);
	pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_GROUP_REMOVED_SIGNAL] = g_signal_new ("group-removed", POMODORO_TYPE_CAPABILITY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, POMODORO_TYPE_CAPABILITY_GROUP);
	pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_CAPABILITY_ENABLED_SIGNAL] = g_signal_new ("capability-enabled", POMODORO_TYPE_CAPABILITY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pomodoro_capability_manager_signals[POMODORO_CAPABILITY_MANAGER_CAPABILITY_DISABLED_SIGNAL] = g_signal_new ("capability-disabled", POMODORO_TYPE_CAPABILITY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
pomodoro_capability_manager_instance_init (PomodoroCapabilityManager * self,
                                           gpointer klass)
{
	self->priv = pomodoro_capability_manager_get_instance_private (self);
}

static void
pomodoro_capability_manager_finalize (GObject * obj)
{
	PomodoroCapabilityManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_CAPABILITY_MANAGER, PomodoroCapabilityManager);
	_g_hash_table_unref0 (self->priv->capabilities);
	_g_hash_table_unref0 (self->priv->enabled_capabilities);
	(self->priv->groups == NULL) ? NULL : (self->priv->groups = (_g_slist_free__g_object_unref0_ (self->priv->groups), NULL));
	G_OBJECT_CLASS (pomodoro_capability_manager_parent_class)->finalize (obj);
}

static GType
pomodoro_capability_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroCapabilityManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_capability_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroCapabilityManager), 0, (GInstanceInitFunc) pomodoro_capability_manager_instance_init, NULL };
	GType pomodoro_capability_manager_type_id;
	pomodoro_capability_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PomodoroCapabilityManager", &g_define_type_info, 0);
	PomodoroCapabilityManager_private_offset = g_type_add_instance_private (pomodoro_capability_manager_type_id, sizeof (PomodoroCapabilityManagerPrivate));
	return pomodoro_capability_manager_type_id;
}

GType
pomodoro_capability_manager_get_type (void)
{
	static volatile gsize pomodoro_capability_manager_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_capability_manager_type_id__once)) {
		GType pomodoro_capability_manager_type_id;
		pomodoro_capability_manager_type_id = pomodoro_capability_manager_get_type_once ();
		g_once_init_leave (&pomodoro_capability_manager_type_id__once, pomodoro_capability_manager_type_id);
	}
	return pomodoro_capability_manager_type_id__once;
}

