/* log-scale.c generated by valac 0.56.17, the Vala compiler
 * generated from log-scale.vala, do not modify */

/*
 * Copyright (c) 2013 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_WIDGETS_LOG_SCALE_0_PROPERTY,
	POMODORO_WIDGETS_LOG_SCALE_EXPONENT_PROPERTY,
	POMODORO_WIDGETS_LOG_SCALE_BASE_ADJUSTMENT_PROPERTY,
	POMODORO_WIDGETS_LOG_SCALE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_widgets_log_scale_properties[POMODORO_WIDGETS_LOG_SCALE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PomodoroWidgetsLogScalePrivate {
	gdouble _exponent;
	GtkAdjustment* _base_adjustment;
};

static gint PomodoroWidgetsLogScale_private_offset;
static gpointer pomodoro_widgets_log_scale_parent_class = NULL;

static void pomodoro_widgets_log_scale_do_set_adjustment (PomodoroWidgetsLogScale* self,
                                                   GtkAdjustment* base_adjustment);
static void pomodoro_widgets_log_scale_set_base_adjustment (PomodoroWidgetsLogScale* self,
                                                     GtkAdjustment* value);
static gboolean pomodoro_widgets_log_scale_transform_to (PomodoroWidgetsLogScale* self,
                                                  GBinding* binding,
                                                  GValue* source_value,
                                                  GValue* target_value);
static gboolean _pomodoro_widgets_log_scale_transform_to_gbinding_transform_func (GBinding* binding,
                                                                           GValue* from_value,
                                                                           GValue* to_value,
                                                                           gpointer self);
static gboolean pomodoro_widgets_log_scale_transform_from (PomodoroWidgetsLogScale* self,
                                                    GBinding* binding,
                                                    GValue* source_value,
                                                    GValue* target_value);
static gboolean _pomodoro_widgets_log_scale_transform_from_gbinding_transform_func (GBinding* binding,
                                                                             GValue* from_value,
                                                                             GValue* to_value,
                                                                             gpointer self);
static gboolean pomodoro_widgets_log_scale_real_scroll_event (GtkWidget* base,
                                                       GdkEventScroll* event);
static void pomodoro_widgets_log_scale_finalize (GObject * obj);
static GType pomodoro_widgets_log_scale_get_type_once (void);
static void _vala_pomodoro_widgets_log_scale_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_pomodoro_widgets_log_scale_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
pomodoro_widgets_log_scale_get_instance_private (PomodoroWidgetsLogScale* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroWidgetsLogScale_private_offset);
}

PomodoroWidgetsLogScale*
pomodoro_widgets_log_scale_construct (GType object_type,
                                      GtkAdjustment* adjustment,
                                      gdouble exponent)
{
	PomodoroWidgetsLogScale * self = NULL;
	g_return_val_if_fail (adjustment != NULL, NULL);
	self = (PomodoroWidgetsLogScale*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "digits", -1, "draw-value", FALSE, "margin-top", 4, "halign", GTK_ALIGN_FILL, NULL);
	pomodoro_widgets_log_scale_set_exponent (self, exponent);
	pomodoro_widgets_log_scale_do_set_adjustment (self, adjustment);
	return self;
}

PomodoroWidgetsLogScale*
pomodoro_widgets_log_scale_new (GtkAdjustment* adjustment,
                                gdouble exponent)
{
	return pomodoro_widgets_log_scale_construct (POMODORO_WIDGETS_TYPE_LOG_SCALE, adjustment, exponent);
}

static gboolean
_pomodoro_widgets_log_scale_transform_to_gbinding_transform_func (GBinding* binding,
                                                                  GValue* from_value,
                                                                  GValue* to_value,
                                                                  gpointer self)
{
	gboolean result;
	result = pomodoro_widgets_log_scale_transform_to ((PomodoroWidgetsLogScale*) self, binding, from_value, to_value);
	return result;
}

static gboolean
_pomodoro_widgets_log_scale_transform_from_gbinding_transform_func (GBinding* binding,
                                                                    GValue* from_value,
                                                                    GValue* to_value,
                                                                    gpointer self)
{
	gboolean result;
	result = pomodoro_widgets_log_scale_transform_from ((PomodoroWidgetsLogScale*) self, binding, from_value, to_value);
	return result;
}

static void
pomodoro_widgets_log_scale_do_set_adjustment (PomodoroWidgetsLogScale* self,
                                              GtkAdjustment* base_adjustment)
{
	GBindingFlags binding_flags = 0U;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	GtkAdjustment* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_adjustment != NULL);
	binding_flags = (G_BINDING_DEFAULT | G_BINDING_BIDIRECTIONAL) | G_BINDING_SYNC_CREATE;
	_tmp0_ = gtk_adjustment_new (0.0, 0.0, 1.0, 0.0001, 0.001, 0.0);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_range_set_adjustment ((GtkRange*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	pomodoro_widgets_log_scale_set_base_adjustment (self, base_adjustment);
	_tmp2_ = self->priv->_base_adjustment;
	_tmp3_ = gtk_range_get_adjustment ((GtkRange*) self);
	_tmp4_ = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) _tmp2_, "value", (GObject*) _tmp4_, "value", binding_flags, (GClosure*) ((_pomodoro_widgets_log_scale_transform_to_gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) _pomodoro_widgets_log_scale_transform_to_gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_pomodoro_widgets_log_scale_transform_from_gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) _pomodoro_widgets_log_scale_transform_from_gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)));
}

static gboolean
pomodoro_widgets_log_scale_transform_from (PomodoroWidgetsLogScale* self,
                                           GBinding* binding,
                                           GValue* source_value,
                                           GValue* target_value)
{
	gdouble lower = 0.0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble step_increment = 0.0;
	GtkAdjustment* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble value = 0.0;
	gdouble _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (source_value != NULL, FALSE);
	g_return_val_if_fail (target_value != NULL, FALSE);
	_tmp0_ = self->priv->_base_adjustment;
	_tmp1_ = gtk_adjustment_get_lower (_tmp0_);
	_tmp2_ = _tmp1_;
	lower = _tmp2_;
	_tmp3_ = self->priv->_base_adjustment;
	_tmp4_ = gtk_adjustment_get_upper (_tmp3_);
	_tmp5_ = _tmp4_;
	upper = _tmp5_;
	_tmp6_ = self->priv->_base_adjustment;
	_tmp7_ = gtk_adjustment_get_step_increment (_tmp6_);
	_tmp8_ = _tmp7_;
	step_increment = _tmp8_;
	_tmp9_ = self->priv->_exponent;
	value = (pow (g_value_get_double (source_value), _tmp9_) * (upper - lower)) + lower;
	g_value_set_double (target_value, step_increment * floor (value / step_increment));
	result = TRUE;
	return result;
}

static gboolean
pomodoro_widgets_log_scale_transform_to (PomodoroWidgetsLogScale* self,
                                         GBinding* binding,
                                         GValue* source_value,
                                         GValue* target_value)
{
	gdouble lower = 0.0;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble upper = 0.0;
	GtkAdjustment* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (source_value != NULL, FALSE);
	g_return_val_if_fail (target_value != NULL, FALSE);
	_tmp0_ = self->priv->_base_adjustment;
	_tmp1_ = gtk_adjustment_get_lower (_tmp0_);
	_tmp2_ = _tmp1_;
	lower = _tmp2_;
	_tmp3_ = self->priv->_base_adjustment;
	_tmp4_ = gtk_adjustment_get_upper (_tmp3_);
	_tmp5_ = _tmp4_;
	upper = _tmp5_;
	_tmp6_ = self->priv->_exponent;
	g_value_set_double (target_value, pow ((g_value_get_double (source_value) - lower) / (upper - lower), 1.0 / _tmp6_));
	result = TRUE;
	return result;
}

static gboolean
pomodoro_widgets_log_scale_real_scroll_event (GtkWidget* base,
                                              GdkEventScroll* event)
{
	PomodoroWidgetsLogScale * self;
	gboolean result;
	self = (PomodoroWidgetsLogScale*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = FALSE;
	return result;
}

gdouble
pomodoro_widgets_log_scale_get_exponent (PomodoroWidgetsLogScale* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_exponent;
	return result;
}

void
pomodoro_widgets_log_scale_set_exponent (PomodoroWidgetsLogScale* self,
                                         gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_widgets_log_scale_get_exponent (self);
	if (old_value != value) {
		self->priv->_exponent = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_widgets_log_scale_properties[POMODORO_WIDGETS_LOG_SCALE_EXPONENT_PROPERTY]);
	}
}

GtkAdjustment*
pomodoro_widgets_log_scale_get_base_adjustment (PomodoroWidgetsLogScale* self)
{
	GtkAdjustment* result;
	GtkAdjustment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_adjustment;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pomodoro_widgets_log_scale_set_base_adjustment (PomodoroWidgetsLogScale* self,
                                                GtkAdjustment* value)
{
	GtkAdjustment* old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_widgets_log_scale_get_base_adjustment (self);
	if (old_value != value) {
		GtkAdjustment* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_base_adjustment);
		self->priv->_base_adjustment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_widgets_log_scale_properties[POMODORO_WIDGETS_LOG_SCALE_BASE_ADJUSTMENT_PROPERTY]);
	}
}

static void
pomodoro_widgets_log_scale_class_init (PomodoroWidgetsLogScaleClass * klass,
                                       gpointer klass_data)
{
	pomodoro_widgets_log_scale_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroWidgetsLogScale_private_offset);
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) pomodoro_widgets_log_scale_real_scroll_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_widgets_log_scale_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_widgets_log_scale_set_property;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_widgets_log_scale_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_WIDGETS_LOG_SCALE_EXPONENT_PROPERTY, pomodoro_widgets_log_scale_properties[POMODORO_WIDGETS_LOG_SCALE_EXPONENT_PROPERTY] = g_param_spec_double ("exponent", "exponent", "exponent", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_WIDGETS_LOG_SCALE_BASE_ADJUSTMENT_PROPERTY, pomodoro_widgets_log_scale_properties[POMODORO_WIDGETS_LOG_SCALE_BASE_ADJUSTMENT_PROPERTY] = g_param_spec_object ("base-adjustment", "base-adjustment", "base-adjustment", gtk_adjustment_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pomodoro_widgets_log_scale_instance_init (PomodoroWidgetsLogScale * self,
                                          gpointer klass)
{
	self->priv = pomodoro_widgets_log_scale_get_instance_private (self);
	self->priv->_exponent = 1.0;
}

static void
pomodoro_widgets_log_scale_finalize (GObject * obj)
{
	PomodoroWidgetsLogScale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_WIDGETS_TYPE_LOG_SCALE, PomodoroWidgetsLogScale);
	_g_object_unref0 (self->priv->_base_adjustment);
	G_OBJECT_CLASS (pomodoro_widgets_log_scale_parent_class)->finalize (obj);
}

static GType
pomodoro_widgets_log_scale_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroWidgetsLogScaleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_widgets_log_scale_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroWidgetsLogScale), 0, (GInstanceInitFunc) pomodoro_widgets_log_scale_instance_init, NULL };
	GType pomodoro_widgets_log_scale_type_id;
	pomodoro_widgets_log_scale_type_id = g_type_register_static (gtk_scale_get_type (), "PomodoroWidgetsLogScale", &g_define_type_info, 0);
	PomodoroWidgetsLogScale_private_offset = g_type_add_instance_private (pomodoro_widgets_log_scale_type_id, sizeof (PomodoroWidgetsLogScalePrivate));
	return pomodoro_widgets_log_scale_type_id;
}

GType
pomodoro_widgets_log_scale_get_type (void)
{
	static volatile gsize pomodoro_widgets_log_scale_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_widgets_log_scale_type_id__once)) {
		GType pomodoro_widgets_log_scale_type_id;
		pomodoro_widgets_log_scale_type_id = pomodoro_widgets_log_scale_get_type_once ();
		g_once_init_leave (&pomodoro_widgets_log_scale_type_id__once, pomodoro_widgets_log_scale_type_id);
	}
	return pomodoro_widgets_log_scale_type_id__once;
}

static void
_vala_pomodoro_widgets_log_scale_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	PomodoroWidgetsLogScale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_WIDGETS_TYPE_LOG_SCALE, PomodoroWidgetsLogScale);
	switch (property_id) {
		case POMODORO_WIDGETS_LOG_SCALE_EXPONENT_PROPERTY:
		g_value_set_double (value, pomodoro_widgets_log_scale_get_exponent (self));
		break;
		case POMODORO_WIDGETS_LOG_SCALE_BASE_ADJUSTMENT_PROPERTY:
		g_value_set_object (value, pomodoro_widgets_log_scale_get_base_adjustment (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_widgets_log_scale_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	PomodoroWidgetsLogScale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_WIDGETS_TYPE_LOG_SCALE, PomodoroWidgetsLogScale);
	switch (property_id) {
		case POMODORO_WIDGETS_LOG_SCALE_EXPONENT_PROPERTY:
		pomodoro_widgets_log_scale_set_exponent (self, g_value_get_double (value));
		break;
		case POMODORO_WIDGETS_LOG_SCALE_BASE_ADJUSTMENT_PROPERTY:
		pomodoro_widgets_log_scale_set_base_adjustment (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

