/* notifications-capability.c generated by valac 0.56.17, the Vala compiler
 * generated from notifications-capability.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <math.h>
#include <float.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy FreedesktopNotificationsProxy;
typedef GDBusProxyClass FreedesktopNotificationsProxyClass;
enum  {
	POMODORO_NOTIFICATIONS_CAPABILITY_0_PROPERTY,
	POMODORO_NOTIFICATIONS_CAPABILITY_NUM_PROPERTIES
};
static GParamSpec* pomodoro_notifications_capability_properties[POMODORO_NOTIFICATIONS_CAPABILITY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _PomodoroNotificationsCapabilityPrivate {
	GSettings* settings;
	PomodoroTimer* timer;
	PomodoroScreenNotification* screen_notification;
	guint watcher_id;
	gboolean have_actions;
	gboolean have_persistence;
};

static gint PomodoroNotificationsCapability_private_offset;
static gpointer pomodoro_notifications_capability_parent_class = NULL;

static GType freedesktop_notifications_get_type_once (void);
static void freedesktop_notifications_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters);
static void freedesktop_notifications_proxy_get_capabilities (FreedesktopNotifications* self,
                                                       gchar*** capabilities,
                                                       gint* capabilities_length1,
                                                       GError** error);
static void freedesktop_notifications_proxy_freedesktop_notifications_interface_init (FreedesktopNotificationsIface* iface);
static void _dbus_freedesktop_notifications_get_capabilities (FreedesktopNotifications* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void freedesktop_notifications_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* freedesktop_notifications_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean freedesktop_notifications_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _freedesktop_notifications_unregister_object (gpointer user_data);
static void pomodoro_notifications_capability_on_name_appeared (PomodoroNotificationsCapability* self,
                                                         GDBusConnection* connection,
                                                         const gchar* name,
                                                         const gchar* name_owner);
static void pomodoro_notifications_capability_on_name_vanished (PomodoroNotificationsCapability* self,
                                                         GDBusConnection* connection,
                                                         const gchar* name);
static void pomodoro_notifications_capability_notify_pomodoro_start (PomodoroNotificationsCapability* self);
static void pomodoro_notifications_capability_show_pomodoro_start_notification (PomodoroNotificationsCapability* self);
static void pomodoro_notifications_capability_notify_pomodoro_end (PomodoroNotificationsCapability* self);
static void pomodoro_notifications_capability_show_screen_notification (PomodoroNotificationsCapability* self);
static void pomodoro_notifications_capability_show_pomodoro_end_notification (PomodoroNotificationsCapability* self);
static void pomodoro_notifications_capability_withdraw_notifications (PomodoroNotificationsCapability* self);
static void ___lambda35_ (PomodoroNotificationsCapability* self);
static void ____lambda35__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void pomodoro_notifications_capability_on_settings_changed (PomodoroNotificationsCapability* self,
                                                            GSettings* settings,
                                                            const gchar* key);
static void pomodoro_notifications_capability_on_timer_state_changed (PomodoroNotificationsCapability* self,
                                                               PomodoroTimerState* state,
                                                               PomodoroTimerState* previous_state);
static void pomodoro_notifications_capability_on_timer_state_duration_notify (PomodoroNotificationsCapability* self);
static void pomodoro_notifications_capability_on_timer_is_paused_notify (PomodoroNotificationsCapability* self);
static gboolean ___lambda36_ (PomodoroNotificationsCapability* self);
static gboolean ____lambda36__gsource_func (gpointer self);
static void pomodoro_notifications_capability_on_show_screen_notification_activate (PomodoroNotificationsCapability* self,
                                                                             GSimpleAction* action,
                                                                             GVariant* parameter);
static void pomodoro_notifications_capability_real_enable (PomodoroCapability* base);
static void _pomodoro_notifications_capability_on_show_screen_notification_activate_g_simple_action_activate (GSimpleAction* _sender,
                                                                                                       GVariant* parameter,
                                                                                                       gpointer self);
static void _pomodoro_notifications_capability_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                             PomodoroTimerState* state,
                                                                                             PomodoroTimerState* previous_state,
                                                                                             gpointer self);
static void _pomodoro_notifications_capability_on_timer_state_duration_notify_g_object_notify (GObject* _sender,
                                                                                        GParamSpec* pspec,
                                                                                        gpointer self);
static void _pomodoro_notifications_capability_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self);
static void _pomodoro_notifications_capability_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                                const gchar* key,
                                                                                gpointer self);
static void pomodoro_notifications_capability_real_disable (PomodoroCapability* base);
static void pomodoro_notifications_capability_real_dispose (GObject* base);
static GObject * pomodoro_notifications_capability_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _pomodoro_notifications_capability_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                                      const gchar* name,
                                                                                      const gchar* name_owner,
                                                                                      gpointer self);
static void _pomodoro_notifications_capability_on_name_vanished_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                                      const gchar* name,
                                                                                      gpointer self);
static void pomodoro_notifications_capability_finalize (GObject * obj);
static GType pomodoro_notifications_capability_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _freedesktop_notifications_dbus_arg_info_get_capabilities_capabilities = {-1, "capabilities", "as", NULL};
static const GDBusArgInfo * const _freedesktop_notifications_dbus_arg_info_get_capabilities_in[] = {NULL};
static const GDBusArgInfo * const _freedesktop_notifications_dbus_arg_info_get_capabilities_out[] = {&_freedesktop_notifications_dbus_arg_info_get_capabilities_capabilities, NULL};
static const GDBusMethodInfo _freedesktop_notifications_dbus_method_info_get_capabilities = {-1, "GetCapabilities", (GDBusArgInfo **) (&_freedesktop_notifications_dbus_arg_info_get_capabilities_in), (GDBusArgInfo **) (&_freedesktop_notifications_dbus_arg_info_get_capabilities_out), NULL};
static const GDBusMethodInfo * const _freedesktop_notifications_dbus_method_info[] = {&_freedesktop_notifications_dbus_method_info_get_capabilities, NULL};
static const GDBusSignalInfo * const _freedesktop_notifications_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _freedesktop_notifications_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _freedesktop_notifications_dbus_interface_info = {-1, "org.freedesktop.Notifications", (GDBusMethodInfo **) (&_freedesktop_notifications_dbus_method_info), (GDBusSignalInfo **) (&_freedesktop_notifications_dbus_signal_info), (GDBusPropertyInfo **) (&_freedesktop_notifications_dbus_property_info), NULL};
static const GDBusInterfaceVTable _freedesktop_notifications_dbus_interface_vtable = {freedesktop_notifications_dbus_interface_method_call, freedesktop_notifications_dbus_interface_get_property, freedesktop_notifications_dbus_interface_set_property};

void
freedesktop_notifications_get_capabilities (FreedesktopNotifications* self,
                                            gchar*** capabilities,
                                            gint* capabilities_length1,
                                            GError** error)
{
	FreedesktopNotificationsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FREEDESKTOP_NOTIFICATIONS_GET_INTERFACE (self);
	if (_iface_->get_capabilities) {
		_iface_->get_capabilities (self, capabilities, capabilities_length1, error);
	}
}

static void
freedesktop_notifications_default_init (FreedesktopNotificationsIface * iface,
                                        gpointer iface_data)
{
}

static GType
freedesktop_notifications_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FreedesktopNotificationsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) freedesktop_notifications_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType freedesktop_notifications_type_id;
	freedesktop_notifications_type_id = g_type_register_static (G_TYPE_INTERFACE, "FreedesktopNotifications", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (freedesktop_notifications_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (freedesktop_notifications_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) freedesktop_notifications_proxy_get_type);
	g_type_set_qdata (freedesktop_notifications_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Notifications");
	g_type_set_qdata (freedesktop_notifications_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_freedesktop_notifications_dbus_interface_info));
	g_type_set_qdata (freedesktop_notifications_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) freedesktop_notifications_register_object);
	return freedesktop_notifications_type_id;
}

GType
freedesktop_notifications_get_type (void)
{
	static volatile gsize freedesktop_notifications_type_id__once = 0;
	if (g_once_init_enter (&freedesktop_notifications_type_id__once)) {
		GType freedesktop_notifications_type_id;
		freedesktop_notifications_type_id = freedesktop_notifications_get_type_once ();
		g_once_init_leave (&freedesktop_notifications_type_id__once, freedesktop_notifications_type_id);
	}
	return freedesktop_notifications_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (FreedesktopNotificationsProxy, freedesktop_notifications_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (FREEDESKTOP_TYPE_NOTIFICATIONS, freedesktop_notifications_proxy_freedesktop_notifications_interface_init) )
static void
freedesktop_notifications_proxy_class_init (FreedesktopNotificationsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = freedesktop_notifications_proxy_g_signal;
}

static void
freedesktop_notifications_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters)
{
}

static void
freedesktop_notifications_proxy_init (FreedesktopNotificationsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_freedesktop_notifications_dbus_interface_info));
}

static void
freedesktop_notifications_proxy_get_capabilities (FreedesktopNotifications* self,
                                                  gchar*** capabilities,
                                                  gint* capabilities_length1,
                                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _vala_capabilities = NULL;
	gint _vala_capabilities_length1;
	GVariant* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length;
	gint _tmp7__size;
	gint _tmp7__length1;
	GVariantIter _tmp8_;
	GVariant* _tmp9_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Notifications", "GetCapabilities");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_capabilities_length1 = 0;
	_tmp6_ = g_variant_iter_next_value (&_reply_iter);
	_tmp7_ = g_new (gchar*, 5);
	_tmp7__length = 0;
	_tmp7__size = 4;
	_tmp7__length1 = 0;
	g_variant_iter_init (&_tmp8_, _tmp6_);
	for (; (_tmp9_ = g_variant_iter_next_value (&_tmp8_)) != NULL; _tmp7__length1++) {
		if (_tmp7__size == _tmp7__length) {
			_tmp7__size = 2 * _tmp7__size;
			_tmp7_ = g_renew (gchar*, _tmp7_, _tmp7__size + 1);
		}
		_tmp7_[_tmp7__length++] = g_variant_dup_string (_tmp9_, NULL);
		g_variant_unref (_tmp9_);
	}
	_vala_capabilities_length1 = _tmp7__length1;
	_tmp7_[_tmp7__length] = NULL;
	_vala_capabilities = _tmp7_;
	g_variant_unref (_tmp6_);
	*capabilities = _vala_capabilities;
	*capabilities_length1 = _vala_capabilities_length1;
	g_object_unref (_reply_message);
}

static void
freedesktop_notifications_proxy_freedesktop_notifications_interface_init (FreedesktopNotificationsIface* iface)
{
	iface->get_capabilities = freedesktop_notifications_proxy_get_capabilities;
}

static void
_dbus_freedesktop_notifications_get_capabilities (FreedesktopNotifications* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** capabilities = NULL;
	gint capabilities_length1 = 0;
	gchar** _tmp10_;
	GVariantBuilder _tmp11_;
	gint _tmp12_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	freedesktop_notifications_get_capabilities (self, &capabilities, &capabilities_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp10_ = capabilities;
	g_variant_builder_init (&_tmp11_, G_VARIANT_TYPE ("as"));
	for (_tmp12_ = 0; _tmp12_ < capabilities_length1; _tmp12_++) {
		g_variant_builder_add_value (&_tmp11_, g_variant_new_string (*_tmp10_));
		_tmp10_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp11_));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	capabilities = (_vala_array_free (capabilities, capabilities_length1, (GDestroyNotify) g_free), NULL);
}

static void
freedesktop_notifications_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetCapabilities") == 0) {
		_dbus_freedesktop_notifications_get_capabilities (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
freedesktop_notifications_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
freedesktop_notifications_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
freedesktop_notifications_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_freedesktop_notifications_dbus_interface_info), &_freedesktop_notifications_dbus_interface_vtable, data, _freedesktop_notifications_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_freedesktop_notifications_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
pomodoro_notifications_capability_get_instance_private (PomodoroNotificationsCapability* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroNotificationsCapability_private_offset);
}

PomodoroNotificationsCapability*
pomodoro_notifications_capability_construct (GType object_type,
                                             const gchar* name)
{
	PomodoroNotificationsCapability * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (PomodoroNotificationsCapability*) pomodoro_capability_construct (object_type, name, NULL, NULL, NULL, NULL, NULL, NULL);
	return self;
}

PomodoroNotificationsCapability*
pomodoro_notifications_capability_new (const gchar* name)
{
	return pomodoro_notifications_capability_construct (POMODORO_TYPE_NOTIFICATIONS_CAPABILITY, name);
}

static void
pomodoro_notifications_capability_on_name_appeared (PomodoroNotificationsCapability* self,
                                                    GDBusConnection* connection,
                                                    const gchar* name,
                                                    const gchar* name_owner)
{
	gchar** capabilities = NULL;
	gint capabilities_length1 = 0;
	gint _capabilities_size_ = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	{
		FreedesktopNotifications* proxy = NULL;
		FreedesktopNotifications* _tmp0_;
		FreedesktopNotifications* _tmp1_;
		gchar** _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp0_ = (FreedesktopNotifications*) g_initable_new (FREEDESKTOP_TYPE_NOTIFICATIONS_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, "g-name", "org.freedesktop.Notifications", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/Notifications", "g-interface-name", "org.freedesktop.Notifications", NULL);
		proxy = (FreedesktopNotifications*) _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = proxy;
		freedesktop_notifications_get_capabilities (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
		capabilities = (_vala_array_free (capabilities, capabilities_length1, (GDestroyNotify) g_free), NULL);
		capabilities = _tmp2_;
		capabilities_length1 = _tmp3_;
		_capabilities_size_ = capabilities_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (proxy);
			goto __catch0_g_error;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gchar** _tmp6_;
					gint _tmp6__length1;
					gchar** _tmp7_;
					gint _tmp7__length1;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					GQuark _tmp11_ = 0U;
					static GQuark _tmp10_label0 = 0;
					static GQuark _tmp10_label1 = 0;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = capabilities;
					_tmp6__length1 = capabilities_length1;
					if (!(i < _tmp6__length1)) {
						break;
					}
					_tmp7_ = capabilities;
					_tmp7__length1 = capabilities_length1;
					_tmp8_ = _tmp7_[i];
					_tmp9_ = _tmp8_;
					_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
					if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("actions")))) {
						switch (0) {
							default:
							{
								self->priv->have_actions = TRUE;
								break;
							}
						}
					} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("persistence")))) {
						switch (0) {
							default:
							{
								self->priv->have_persistence = TRUE;
								break;
							}
						}
					}
				}
			}
		}
		_g_object_unref0 (proxy);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning ("notifications-capability.vala:88: Error getting notification capabilit" \
"ies: %s", _tmp13_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		capabilities = (_vala_array_free (capabilities, capabilities_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	capabilities = (_vala_array_free (capabilities, capabilities_length1, (GDestroyNotify) g_free), NULL);
}

static void
pomodoro_notifications_capability_on_name_vanished (PomodoroNotificationsCapability* self,
                                                    GDBusConnection* connection,
                                                    const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
}

static void
pomodoro_notifications_capability_notify_pomodoro_start (PomodoroNotificationsCapability* self)
{
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		pomodoro_notifications_capability_show_pomodoro_start_notification (self);
	}
}

static void
pomodoro_notifications_capability_notify_pomodoro_end (PomodoroNotificationsCapability* self)
{
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = self->priv->settings;
		if (g_settings_get_boolean (_tmp3_, "show-screen-notifications")) {
			pomodoro_notifications_capability_show_screen_notification (self);
		} else {
			pomodoro_notifications_capability_show_pomodoro_end_notification (self);
		}
	}
}

static void
pomodoro_notifications_capability_withdraw_notifications (PomodoroNotificationsCapability* self)
{
	PomodoroScreenNotification* _tmp0_;
	GApplication* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->screen_notification;
	if (_tmp0_ != NULL) {
		PomodoroScreenNotification* _tmp1_;
		_tmp1_ = self->priv->screen_notification;
		pomodoro_screen_notification_close (_tmp1_);
	}
	_tmp2_ = g_application_get_default ();
	g_application_withdraw_notification (_tmp2_, "timer");
}

static void
___lambda35_ (PomodoroNotificationsCapability* self)
{
	gboolean _tmp0_ = FALSE;
	PomodoroTimer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_g_object_unref0 (self->priv->screen_notification);
	self->priv->screen_notification = NULL;
	_tmp1_ = self->priv->timer;
	_tmp2_ = pomodoro_timer_get_is_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		PomodoroTimer* _tmp4_;
		PomodoroTimerState* _tmp5_;
		PomodoroTimerState* _tmp6_;
		_tmp4_ = self->priv->timer;
		_tmp5_ = pomodoro_timer_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = POMODORO_IS_BREAK_STATE (_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		pomodoro_notifications_capability_show_pomodoro_end_notification (self);
	}
}

static void
____lambda35__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda35_ ((PomodoroNotificationsCapability*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pomodoro_notifications_capability_show_screen_notification (PomodoroNotificationsCapability* self)
{
	PomodoroScreenNotification* _tmp0_;
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp3_;
	PomodoroApplication* _tmp4_;
	PomodoroScreenNotification* _tmp5_;
	PomodoroScreenNotification* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->screen_notification;
	if (_tmp0_ == NULL) {
		PomodoroScreenNotification* _tmp1_;
		PomodoroScreenNotification* _tmp2_;
		_tmp1_ = pomodoro_screen_notification_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->screen_notification);
		self->priv->screen_notification = _tmp1_;
		_tmp2_ = self->priv->screen_notification;
		g_signal_connect_object ((GtkWidget*) _tmp2_, "destroy", (GCallback) ____lambda35__gtk_widget_destroy, self, 0);
	}
	_tmp3_ = pomodoro_application_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	application = _tmp4_;
	_tmp5_ = self->priv->screen_notification;
	gtk_application_add_window ((GtkApplication*) application, (GtkWindow*) _tmp5_);
	_tmp6_ = self->priv->screen_notification;
	gtk_window_present ((GtkWindow*) _tmp6_);
	_g_object_unref0 (application);
}

static void
pomodoro_notifications_capability_show_pomodoro_start_notification (PomodoroNotificationsCapability* self)
{
	GNotification* notification = NULL;
	GNotification* _tmp0_;
	GApplication* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_notification_new (_ ("Pomodoro"));
	notification = _tmp0_;
	g_notification_set_body (notification, _ ("Focus on your task."));
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_HIGH);
	{
		GIcon* _tmp1_ = NULL;
		GIcon* _tmp2_;
		_tmp2_ = g_icon_new_for_string (PACKAGE_NAME, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_notification_set_icon (notification, _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("notifications-capability.vala:155: %s", _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (notification);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (self->priv->have_actions) {
		g_notification_add_button (notification, _ ("Take a break"), "app.timer-skip");
	}
	_tmp5_ = g_application_get_default ();
	g_application_send_notification (_tmp5_, "timer", notification);
	_g_object_unref0 (notification);
}

static void
pomodoro_notifications_capability_show_pomodoro_end_notification (PomodoroNotificationsCapability* self)
{
	gint remaining = 0;
	PomodoroTimer* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint minutes = 0;
	gint seconds = 0;
	gchar* _tmp3_ = NULL;
	gchar* body = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	PomodoroTimer* _tmp8_;
	PomodoroTimerState* _tmp9_;
	PomodoroTimerState* _tmp10_;
	GNotification* notification = NULL;
	GNotification* _tmp11_;
	const gchar* _tmp12_;
	GApplication* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_remaining (_tmp0_);
	_tmp2_ = _tmp1_;
	remaining = (gint) ceil (_tmp2_);
	minutes = (gint) round (((gdouble) remaining) / 60.0);
	seconds = (gint) floor ((gdouble) (remaining % 60));
	if (remaining > 45) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf (ngettext ("You have %d minute", "You have %d minutes", (gulong) minutes), minutes);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf (ngettext ("You have %d second", "You have %d seconds", (gulong) seconds), seconds);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp3_);
	body = _tmp6_;
	_tmp8_ = self->priv->timer;
	_tmp9_ = pomodoro_timer_get_state (_tmp8_);
	_tmp10_ = _tmp9_;
	if (POMODORO_IS_SHORT_BREAK_STATE (_tmp10_)) {
		_tmp7_ = _ ("Take a break");
	} else {
		_tmp7_ = _ ("Take a longer break");
	}
	_tmp11_ = g_notification_new (_tmp7_);
	notification = _tmp11_;
	_tmp12_ = body;
	g_notification_set_body (notification, _tmp12_);
	g_notification_set_priority (notification, G_NOTIFICATION_PRIORITY_HIGH);
	{
		GIcon* _tmp13_ = NULL;
		GIcon* _tmp14_;
		_tmp14_ = g_icon_new_for_string (PACKAGE_NAME, &_inner_error0_);
		_tmp13_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_notification_set_icon (notification, _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning ("notifications-capability.vala:189: %s", _tmp16_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (notification);
		_g_free0 (body);
		_g_free0 (_tmp3_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (self->priv->have_actions) {
		PomodoroTimer* _tmp17_;
		PomodoroTimerState* _tmp18_;
		PomodoroTimerState* _tmp19_;
		GVariant* _tmp24_;
		GVariant* _tmp25_;
		g_notification_set_default_action (notification, "app.show-screen-notification");
		_tmp17_ = self->priv->timer;
		_tmp18_ = pomodoro_timer_get_state (_tmp17_);
		_tmp19_ = _tmp18_;
		if (POMODORO_IS_SHORT_BREAK_STATE (_tmp19_)) {
			GVariant* _tmp20_;
			GVariant* _tmp21_;
			_tmp20_ = g_variant_new_string ("long-break");
			g_variant_ref_sink (_tmp20_);
			_tmp21_ = _tmp20_;
			g_notification_add_button_with_target_value (notification, _ ("Lengthen it"), "app.timer-switch-state", _tmp21_);
			_g_variant_unref0 (_tmp21_);
		} else {
			GVariant* _tmp22_;
			GVariant* _tmp23_;
			_tmp22_ = g_variant_new_string ("short-break");
			g_variant_ref_sink (_tmp22_);
			_tmp23_ = _tmp22_;
			g_notification_add_button_with_target_value (notification, _ ("Shorten it"), "app.timer-switch-state", _tmp23_);
			_g_variant_unref0 (_tmp23_);
		}
		_tmp24_ = g_variant_new_string ("pomodoro");
		g_variant_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		g_notification_add_button_with_target_value (notification, _ ("Start pomodoro"), "app.timer-set-state", _tmp25_);
		_g_variant_unref0 (_tmp25_);
	}
	_tmp26_ = g_application_get_default ();
	g_application_send_notification (_tmp26_, "timer", notification);
	_g_object_unref0 (notification);
	_g_free0 (body);
	_g_free0 (_tmp3_);
}

static void
pomodoro_notifications_capability_on_settings_changed (PomodoroNotificationsCapability* self,
                                                       GSettings* settings,
                                                       const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("show-screen-notifications")))) {
		switch (0) {
			default:
			{
				PomodoroTimer* _tmp3_;
				PomodoroTimerState* _tmp4_;
				PomodoroTimerState* _tmp5_;
				_tmp3_ = self->priv->timer;
				_tmp4_ = pomodoro_timer_get_state (_tmp3_);
				_tmp5_ = _tmp4_;
				if (POMODORO_IS_BREAK_STATE (_tmp5_)) {
					pomodoro_notifications_capability_notify_pomodoro_end (self);
				}
				break;
			}
		}
	}
}

static void
pomodoro_notifications_capability_on_timer_state_changed (PomodoroNotificationsCapability* self,
                                                          PomodoroTimerState* state,
                                                          PomodoroTimerState* previous_state)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (previous_state != NULL);
	pomodoro_notifications_capability_withdraw_notifications (self);
	if (POMODORO_IS_POMODORO_STATE (state)) {
		pomodoro_notifications_capability_notify_pomodoro_start (self);
	} else {
		if (POMODORO_IS_BREAK_STATE (state)) {
			pomodoro_notifications_capability_notify_pomodoro_end (self);
		}
	}
}

static void
pomodoro_notifications_capability_on_timer_state_duration_notify (PomodoroNotificationsCapability* self)
{
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		PomodoroTimer* _tmp3_;
		PomodoroTimerState* _tmp4_;
		PomodoroTimerState* _tmp5_;
		PomodoroTimer* _tmp6_;
		PomodoroTimerState* _tmp7_;
		PomodoroTimerState* _tmp8_;
		_tmp3_ = self->priv->timer;
		_tmp4_ = pomodoro_timer_get_state (_tmp3_);
		_tmp5_ = _tmp4_;
		if (POMODORO_IS_POMODORO_STATE (_tmp5_)) {
			pomodoro_notifications_capability_show_pomodoro_start_notification (self);
		}
		_tmp6_ = self->priv->timer;
		_tmp7_ = pomodoro_timer_get_state (_tmp6_);
		_tmp8_ = _tmp7_;
		if (POMODORO_IS_BREAK_STATE (_tmp8_)) {
			pomodoro_notifications_capability_show_pomodoro_end_notification (self);
		}
	}
}

static gboolean
___lambda36_ (PomodoroNotificationsCapability* self)
{
	PomodoroTimer* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	if (POMODORO_IS_POMODORO_STATE (_tmp2_)) {
		pomodoro_notifications_capability_notify_pomodoro_start (self);
	} else {
		PomodoroTimer* _tmp3_;
		PomodoroTimerState* _tmp4_;
		PomodoroTimerState* _tmp5_;
		_tmp3_ = self->priv->timer;
		_tmp4_ = pomodoro_timer_get_state (_tmp3_);
		_tmp5_ = _tmp4_;
		if (POMODORO_IS_BREAK_STATE (_tmp5_)) {
			pomodoro_notifications_capability_notify_pomodoro_end (self);
		}
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda36__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda36_ ((PomodoroNotificationsCapability*) self);
	return result;
}

static void
pomodoro_notifications_capability_on_timer_is_paused_notify (PomodoroNotificationsCapability* self)
{
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		pomodoro_notifications_capability_withdraw_notifications (self);
	} else {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda36__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
pomodoro_notifications_capability_on_show_screen_notification_activate (PomodoroNotificationsCapability* self,
                                                                        GSimpleAction* action,
                                                                        GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pomodoro_notifications_capability_show_screen_notification (self);
}

static void
_pomodoro_notifications_capability_on_show_screen_notification_activate_g_simple_action_activate (GSimpleAction* _sender,
                                                                                                  GVariant* parameter,
                                                                                                  gpointer self)
{
	pomodoro_notifications_capability_on_show_screen_notification_activate ((PomodoroNotificationsCapability*) self, _sender, parameter);
}

static void
_pomodoro_notifications_capability_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                        PomodoroTimerState* state,
                                                                                        PomodoroTimerState* previous_state,
                                                                                        gpointer self)
{
	pomodoro_notifications_capability_on_timer_state_changed ((PomodoroNotificationsCapability*) self, state, previous_state);
}

static void
_pomodoro_notifications_capability_on_timer_state_duration_notify_g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self)
{
	pomodoro_notifications_capability_on_timer_state_duration_notify ((PomodoroNotificationsCapability*) self);
}

static void
_pomodoro_notifications_capability_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self)
{
	pomodoro_notifications_capability_on_timer_is_paused_notify ((PomodoroNotificationsCapability*) self);
}

static void
_pomodoro_notifications_capability_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                           const gchar* key,
                                                                           gpointer self)
{
	pomodoro_notifications_capability_on_settings_changed ((PomodoroNotificationsCapability*) self, _sender, key);
}

static void
pomodoro_notifications_capability_real_enable (PomodoroCapability* base)
{
	PomodoroNotificationsCapability * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (PomodoroNotificationsCapability*) base;
	_tmp0_ = pomodoro_capability_get_enabled ((PomodoroCapability*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GSimpleAction* show_screen_notification_action = NULL;
		GSimpleAction* _tmp2_;
		GSimpleAction* _tmp3_;
		GApplication* application = NULL;
		GApplication* _tmp4_;
		GApplication* _tmp5_;
		GApplication* _tmp6_;
		GSimpleAction* _tmp7_;
		PomodoroTimer* _tmp8_;
		PomodoroTimer* _tmp9_;
		PomodoroTimer* _tmp10_;
		PomodoroTimer* _tmp11_;
		PomodoroTimer* _tmp12_;
		GSettings* _tmp13_;
		GSettings* _tmp14_;
		GSettings* _tmp15_;
		PomodoroTimer* _tmp16_;
		PomodoroTimerState* _tmp17_;
		PomodoroTimerState* _tmp18_;
		PomodoroTimer* _tmp19_;
		PomodoroTimerState* _tmp20_;
		PomodoroTimerState* _tmp21_;
		_tmp2_ = g_simple_action_new ("show-screen-notification", NULL);
		show_screen_notification_action = _tmp2_;
		_tmp3_ = show_screen_notification_action;
		g_signal_connect_object (_tmp3_, "activate", (GCallback) _pomodoro_notifications_capability_on_show_screen_notification_activate_g_simple_action_activate, self, 0);
		_tmp4_ = g_application_get_default ();
		_tmp5_ = _g_object_ref0 (_tmp4_);
		application = _tmp5_;
		_tmp6_ = application;
		_tmp7_ = show_screen_notification_action;
		g_action_map_add_action ((GActionMap*) _tmp6_, (GAction*) _tmp7_);
		_tmp8_ = pomodoro_timer_get_default ();
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (self->priv->timer);
		self->priv->timer = _tmp9_;
		_tmp10_ = self->priv->timer;
		g_signal_connect_object (_tmp10_, "state-changed", (GCallback) _pomodoro_notifications_capability_on_timer_state_changed_pomodoro_timer_state_changed, self, G_CONNECT_AFTER);
		_tmp11_ = self->priv->timer;
		g_signal_connect_object ((GObject*) _tmp11_, "notify::state-duration", (GCallback) _pomodoro_notifications_capability_on_timer_state_duration_notify_g_object_notify, self, 0);
		_tmp12_ = self->priv->timer;
		g_signal_connect_object ((GObject*) _tmp12_, "notify::is-paused", (GCallback) _pomodoro_notifications_capability_on_timer_is_paused_notify_g_object_notify, self, 0);
		_tmp13_ = pomodoro_get_settings ();
		_tmp14_ = g_settings_get_child (_tmp13_, "preferences");
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp14_;
		_tmp15_ = self->priv->settings;
		g_signal_connect_object (_tmp15_, "changed", (GCallback) _pomodoro_notifications_capability_on_settings_changed_g_settings_changed, self, 0);
		_tmp16_ = self->priv->timer;
		_tmp17_ = pomodoro_timer_get_state (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->timer;
		_tmp20_ = pomodoro_timer_get_state (_tmp19_);
		_tmp21_ = _tmp20_;
		pomodoro_notifications_capability_on_timer_state_changed (self, _tmp18_, _tmp21_);
		_g_object_unref0 (application);
		_g_object_unref0 (show_screen_notification_action);
	}
	POMODORO_CAPABILITY_CLASS (pomodoro_notifications_capability_parent_class)->enable (G_TYPE_CHECK_INSTANCE_CAST (self, POMODORO_TYPE_CAPABILITY, PomodoroCapability));
}

static void
pomodoro_notifications_capability_real_disable (PomodoroCapability* base)
{
	PomodoroNotificationsCapability * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (PomodoroNotificationsCapability*) base;
	_tmp0_ = pomodoro_capability_get_enabled ((PomodoroCapability*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		PomodoroTimer* _tmp2_;
		guint _tmp3_;
		PomodoroTimer* _tmp4_;
		guint _tmp5_;
		GQuark _tmp6_;
		PomodoroTimer* _tmp7_;
		guint _tmp8_;
		GQuark _tmp9_;
		GSettings* _tmp10_;
		guint _tmp11_;
		GApplication* application = NULL;
		GApplication* _tmp12_;
		GApplication* _tmp13_;
		GApplication* _tmp14_;
		pomodoro_notifications_capability_withdraw_notifications (self);
		_tmp2_ = self->priv->timer;
		g_signal_parse_name ("state-changed", POMODORO_TYPE_TIMER, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _pomodoro_notifications_capability_on_timer_state_changed_pomodoro_timer_state_changed, self);
		_tmp4_ = self->priv->timer;
		g_signal_parse_name ("notify::state-duration", G_TYPE_OBJECT, &_tmp5_, &_tmp6_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, _tmp6_, NULL, (GCallback) _pomodoro_notifications_capability_on_timer_state_duration_notify_g_object_notify, self);
		_tmp7_ = self->priv->timer;
		g_signal_parse_name ("notify::is-paused", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _pomodoro_notifications_capability_on_timer_is_paused_notify_g_object_notify, self);
		_g_object_unref0 (self->priv->timer);
		self->priv->timer = NULL;
		_tmp10_ = self->priv->settings;
		g_signal_parse_name ("changed", g_settings_get_type (), &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _pomodoro_notifications_capability_on_settings_changed_g_settings_changed, self);
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = NULL;
		_tmp12_ = g_application_get_default ();
		_tmp13_ = _g_object_ref0 (_tmp12_);
		application = _tmp13_;
		_tmp14_ = application;
		g_action_map_remove_action ((GActionMap*) _tmp14_, "show-screen-notification");
		_g_object_unref0 (application);
	}
	POMODORO_CAPABILITY_CLASS (pomodoro_notifications_capability_parent_class)->disable (G_TYPE_CHECK_INSTANCE_CAST (self, POMODORO_TYPE_CAPABILITY, PomodoroCapability));
}

static void
pomodoro_notifications_capability_real_dispose (GObject* base)
{
	PomodoroNotificationsCapability * self;
	self = (PomodoroNotificationsCapability*) base;
	if (self->priv->watcher_id != ((guint) 0)) {
		g_bus_unwatch_name (self->priv->watcher_id);
		self->priv->watcher_id = (guint) 0;
	}
	G_OBJECT_CLASS (pomodoro_notifications_capability_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, POMODORO_TYPE_CAPABILITY, PomodoroCapability));
}

static void
_pomodoro_notifications_capability_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                                 const gchar* name,
                                                                                 const gchar* name_owner,
                                                                                 gpointer self)
{
	pomodoro_notifications_capability_on_name_appeared ((PomodoroNotificationsCapability*) self, connection, name, name_owner);
}

static void
_pomodoro_notifications_capability_on_name_vanished_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                                 const gchar* name,
                                                                                 gpointer self)
{
	pomodoro_notifications_capability_on_name_vanished ((PomodoroNotificationsCapability*) self, connection, name);
}

static GObject *
pomodoro_notifications_capability_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroNotificationsCapability * self;
	parent_class = G_OBJECT_CLASS (pomodoro_notifications_capability_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_NOTIFICATIONS_CAPABILITY, PomodoroNotificationsCapability);
	self->priv->watcher_id = g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "org.freedesktop.Notifications", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_pomodoro_notifications_capability_on_name_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _pomodoro_notifications_capability_on_name_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_pomodoro_notifications_capability_on_name_vanished_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _pomodoro_notifications_capability_on_name_vanished_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	return obj;
}

static void
pomodoro_notifications_capability_class_init (PomodoroNotificationsCapabilityClass * klass,
                                              gpointer klass_data)
{
	pomodoro_notifications_capability_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroNotificationsCapability_private_offset);
	((PomodoroCapabilityClass *) klass)->enable = (void (*) (PomodoroCapability*)) pomodoro_notifications_capability_real_enable;
	((PomodoroCapabilityClass *) klass)->disable = (void (*) (PomodoroCapability*)) pomodoro_notifications_capability_real_disable;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) pomodoro_notifications_capability_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_notifications_capability_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_notifications_capability_finalize;
}

static void
pomodoro_notifications_capability_instance_init (PomodoroNotificationsCapability * self,
                                                 gpointer klass)
{
	self->priv = pomodoro_notifications_capability_get_instance_private (self);
	self->priv->watcher_id = (guint) 0;
	self->priv->have_actions = FALSE;
	self->priv->have_persistence = FALSE;
}

static void
pomodoro_notifications_capability_finalize (GObject * obj)
{
	PomodoroNotificationsCapability * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_NOTIFICATIONS_CAPABILITY, PomodoroNotificationsCapability);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->timer);
	_g_object_unref0 (self->priv->screen_notification);
	G_OBJECT_CLASS (pomodoro_notifications_capability_parent_class)->finalize (obj);
}

static GType
pomodoro_notifications_capability_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroNotificationsCapabilityClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_notifications_capability_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroNotificationsCapability), 0, (GInstanceInitFunc) pomodoro_notifications_capability_instance_init, NULL };
	GType pomodoro_notifications_capability_type_id;
	pomodoro_notifications_capability_type_id = g_type_register_static (POMODORO_TYPE_CAPABILITY, "PomodoroNotificationsCapability", &g_define_type_info, 0);
	PomodoroNotificationsCapability_private_offset = g_type_add_instance_private (pomodoro_notifications_capability_type_id, sizeof (PomodoroNotificationsCapabilityPrivate));
	return pomodoro_notifications_capability_type_id;
}

GType
pomodoro_notifications_capability_get_type (void)
{
	static volatile gsize pomodoro_notifications_capability_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_notifications_capability_type_id__once)) {
		GType pomodoro_notifications_capability_type_id;
		pomodoro_notifications_capability_type_id = pomodoro_notifications_capability_get_type_once ();
		g_once_init_leave (&pomodoro_notifications_capability_type_id__once, pomodoro_notifications_capability_type_id);
	}
	return pomodoro_notifications_capability_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

