/* stats-view.c generated by valac 0.56.17, the Vala compiler
 * generated from stats-view.vala, do not modify */

/*
 * Copyright (c) 2017 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <gtk/gtk.h>
#include <gom/gom.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_STATS_VIEW_0_PROPERTY,
	POMODORO_STATS_VIEW_MODE_PROPERTY,
	POMODORO_STATS_VIEW_NUM_PROPERTIES
};
static GParamSpec* pomodoro_stats_view_properties[POMODORO_STATS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define POMODORO_TYPE_STATS_PAGE (pomodoro_stats_page_get_type ())
#define POMODORO_STATS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_STATS_PAGE, PomodoroStatsPage))
#define POMODORO_STATS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_STATS_PAGE, PomodoroStatsPageClass))
#define POMODORO_IS_STATS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_STATS_PAGE))
#define POMODORO_IS_STATS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_STATS_PAGE))
#define POMODORO_STATS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_STATS_PAGE, PomodoroStatsPageClass))

typedef struct _PomodoroStatsPage PomodoroStatsPage;
typedef struct _PomodoroStatsPageClass PomodoroStatsPageClass;
typedef struct _Block19Data Block19Data;

#define POMODORO_TYPE_ENTRY (pomodoro_entry_get_type ())
#define POMODORO_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_ENTRY, PomodoroEntry))
#define POMODORO_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_ENTRY, PomodoroEntryClass))
#define POMODORO_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_ENTRY))
#define POMODORO_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_ENTRY))
#define POMODORO_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_ENTRY, PomodoroEntryClass))

typedef struct _PomodoroEntry PomodoroEntry;
typedef struct _PomodoroEntryClass PomodoroEntryClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PomodoroStatsViewUpdateData PomodoroStatsViewUpdateData;

#define POMODORO_TYPE_STATS_DAY_PAGE (pomodoro_stats_day_page_get_type ())
#define POMODORO_STATS_DAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_STATS_DAY_PAGE, PomodoroStatsDayPage))
#define POMODORO_STATS_DAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_STATS_DAY_PAGE, PomodoroStatsDayPageClass))
#define POMODORO_IS_STATS_DAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_STATS_DAY_PAGE))
#define POMODORO_IS_STATS_DAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_STATS_DAY_PAGE))
#define POMODORO_STATS_DAY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_STATS_DAY_PAGE, PomodoroStatsDayPageClass))

typedef struct _PomodoroStatsDayPage PomodoroStatsDayPage;
typedef struct _PomodoroStatsDayPageClass PomodoroStatsDayPageClass;

#define POMODORO_TYPE_STATS_WEEK_PAGE (pomodoro_stats_week_page_get_type ())
#define POMODORO_STATS_WEEK_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_STATS_WEEK_PAGE, PomodoroStatsWeekPage))
#define POMODORO_STATS_WEEK_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_STATS_WEEK_PAGE, PomodoroStatsWeekPageClass))
#define POMODORO_IS_STATS_WEEK_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_STATS_WEEK_PAGE))
#define POMODORO_IS_STATS_WEEK_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_STATS_WEEK_PAGE))
#define POMODORO_STATS_WEEK_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_STATS_WEEK_PAGE, PomodoroStatsWeekPageClass))

typedef struct _PomodoroStatsWeekPage PomodoroStatsWeekPage;
typedef struct _PomodoroStatsWeekPageClass PomodoroStatsWeekPageClass;

#define POMODORO_TYPE_STATS_MONTH_PAGE (pomodoro_stats_month_page_get_type ())
#define POMODORO_STATS_MONTH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_STATS_MONTH_PAGE, PomodoroStatsMonthPage))
#define POMODORO_STATS_MONTH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_STATS_MONTH_PAGE, PomodoroStatsMonthPageClass))
#define POMODORO_IS_STATS_MONTH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_STATS_MONTH_PAGE))
#define POMODORO_IS_STATS_MONTH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_STATS_MONTH_PAGE))
#define POMODORO_STATS_MONTH_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_STATS_MONTH_PAGE, PomodoroStatsMonthPageClass))

typedef struct _PomodoroStatsMonthPage PomodoroStatsMonthPage;
typedef struct _PomodoroStatsMonthPageClass PomodoroStatsMonthPageClass;

struct _PomodoroStatsViewPrivate {
	GtkNotebook* notebook;
	GtkLabel* title;
	GtkStack* stack;
	GtkStack* pages;
	GomRepository* repository;
	GDateTime* min_datetime;
	GDateTime* max_datetime;
	GQueue* history;
	GSimpleAction* previous_action;
	GSimpleAction* next_action;
	GBinding* title_binding;
	gchar* _mode;
};

struct _Block19Data {
	int _ref_count_;
	PomodoroStatsView* self;
	gpointer _async_data_;
};

struct _PomodoroStatsViewUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PomodoroStatsView* self;
	Block19Data* _data19_;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GomSorting* sorting;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GomSorting* _tmp4_;
	GomRepository* _tmp5_;
	GomSorting* _tmp6_;
	GDateTime* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
};

static gint PomodoroStatsView_private_offset;
static gpointer pomodoro_stats_view_parent_class = NULL;
static GtkBuildableIface * pomodoro_stats_view_gtk_buildable_parent_iface = NULL;

static void pomodoro_stats_view_real_parser_finished (GtkBuildable* base,
                                               GtkBuilder* builder);
static void pomodoro_stats_view_activate_previous (PomodoroStatsView* self);
static void _pomodoro_stats_view_activate_previous_g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void pomodoro_stats_view_activate_next (PomodoroStatsView* self);
static void _pomodoro_stats_view_activate_next_g_simple_action_activate (GSimpleAction* _sender,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static gboolean pomodoro_stats_view_transform_mode_to_page (GBinding* binding,
                                                     GValue* source_value,
                                                     GValue* target_value);
static gboolean pomodoro_stats_view_transform_mode_from_page (GBinding* binding,
                                                       GValue* source_value,
                                                       GValue* target_value);
static gboolean pomodoro_stats_view_transform_mode_to_sensitive (GBinding* binding,
                                                          GValue* source_value,
                                                          GValue* target_value);
VALA_EXTERN GType pomodoro_stats_page_get_type (void) G_GNUC_CONST ;
static void pomodoro_stats_view_select_page (PomodoroStatsView* self,
                                      GDateTime* value);
VALA_EXTERN GDateTime* pomodoro_stats_page_get_previous_date (PomodoroStatsPage* self);
VALA_EXTERN GDateTime* pomodoro_stats_page_get_next_date (PomodoroStatsPage* self);
static void pomodoro_stats_view_on_map (PomodoroStatsView* self,
                                 GtkWidget* widget);
static void pomodoro_stats_view_update (PomodoroStatsView* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void pomodoro_stats_view_update_finish (PomodoroStatsView* self,
                                        GAsyncResult* _res_);
static void _pomodoro_stats_view_on_map_gtk_widget_map (GtkWidget* _sender,
                                                 gpointer self);
static void pomodoro_stats_view_update_data_free (gpointer _data);
static gboolean pomodoro_stats_view_update_co (PomodoroStatsViewUpdateData* _data_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
VALA_EXTERN GType pomodoro_entry_get_type (void) G_GNUC_CONST ;
static void ___lambda13_ (Block19Data* _data19_,
                   GObject* obj,
                   GAsyncResult* res);
VALA_EXTERN GDateTime* pomodoro_entry_get_datetime_local (PomodoroEntry* self);
static void ____lambda13__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static GDateTime* pomodoro_stats_view_normalize_datetime (PomodoroStatsView* self,
                                                   GDateTime* datetime,
                                                   const gchar* mode);
static gchar* pomodoro_stats_view_build_page_name (PomodoroStatsView* self,
                                            GDateTime* datetime,
                                            const gchar* mode);
static PomodoroStatsPage* pomodoro_stats_view_create_page (PomodoroStatsView* self,
                                                    GDateTime* datetime,
                                                    const gchar* mode);
VALA_EXTERN PomodoroStatsDayPage* pomodoro_stats_day_page_new (GomRepository* repository,
                                                   GDateTime* date);
VALA_EXTERN PomodoroStatsDayPage* pomodoro_stats_day_page_construct (GType object_type,
                                                         GomRepository* repository,
                                                         GDateTime* date);
VALA_EXTERN GType pomodoro_stats_day_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PomodoroStatsWeekPage* pomodoro_stats_week_page_new (GomRepository* repository,
                                                     GDateTime* date);
VALA_EXTERN PomodoroStatsWeekPage* pomodoro_stats_week_page_construct (GType object_type,
                                                           GomRepository* repository,
                                                           GDateTime* date);
VALA_EXTERN GType pomodoro_stats_week_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PomodoroStatsMonthPage* pomodoro_stats_month_page_new (GomRepository* repository,
                                                       GDateTime* date);
VALA_EXTERN PomodoroStatsMonthPage* pomodoro_stats_month_page_construct (GType object_type,
                                                             GomRepository* repository,
                                                             GDateTime* date);
VALA_EXTERN GType pomodoro_stats_month_page_get_type (void) G_GNUC_CONST ;
static PomodoroStatsPage* pomodoro_stats_view_get_page (PomodoroStatsView* self,
                                                 const gchar* name);
static PomodoroStatsPage* pomodoro_stats_view_get_or_create_page (PomodoroStatsView* self,
                                                           GDateTime* datetime,
                                                           const gchar* mode);
VALA_EXTERN GDateTime* pomodoro_stats_page_get_date (PomodoroStatsPage* self);
static GObject * pomodoro_stats_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
VALA_EXTERN GomRepository* pomodoro_get_repository (void);
static gboolean _pomodoro_stats_view_transform_mode_to_page_gbinding_transform_func (GBinding* binding,
                                                                              GValue* from_value,
                                                                              GValue* to_value,
                                                                              gpointer self);
static gboolean _pomodoro_stats_view_transform_mode_from_page_gbinding_transform_func (GBinding* binding,
                                                                                GValue* from_value,
                                                                                GValue* to_value,
                                                                                gpointer self);
static gboolean _pomodoro_stats_view_transform_mode_to_sensitive_gbinding_transform_func (GBinding* binding,
                                                                                   GValue* from_value,
                                                                                   GValue* to_value,
                                                                                   gpointer self);
static void pomodoro_stats_view_finalize (GObject * obj);
static GType pomodoro_stats_view_get_type_once (void);
static void _vala_pomodoro_stats_view_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_pomodoro_stats_view_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
pomodoro_stats_view_get_instance_private (PomodoroStatsView* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroStatsView_private_offset);
}

static void
_pomodoro_stats_view_activate_previous_g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	pomodoro_stats_view_activate_previous ((PomodoroStatsView*) self);
}

static void
_pomodoro_stats_view_activate_next_g_simple_action_activate (GSimpleAction* _sender,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	pomodoro_stats_view_activate_next ((PomodoroStatsView*) self);
}

static void
pomodoro_stats_view_real_parser_finished (GtkBuildable* base,
                                          GtkBuilder* builder)
{
	PomodoroStatsView * self;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	self = (PomodoroStatsView*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_simple_action_new ("previous", NULL);
	_g_object_unref0 (self->priv->previous_action);
	self->priv->previous_action = _tmp0_;
	_tmp1_ = self->priv->previous_action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) _pomodoro_stats_view_activate_previous_g_simple_action_activate, self, 0);
	_tmp2_ = g_simple_action_new ("next", NULL);
	_g_object_unref0 (self->priv->next_action);
	self->priv->next_action = _tmp2_;
	_tmp3_ = self->priv->next_action;
	g_signal_connect_object (_tmp3_, "activate", (GCallback) _pomodoro_stats_view_activate_next_g_simple_action_activate, self, 0);
	_tmp4_ = g_simple_action_group_new ();
	action_group = _tmp4_;
	_tmp5_ = self->priv->previous_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp5_);
	_tmp6_ = self->priv->next_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp6_);
	gtk_widget_insert_action_group ((GtkWidget*) self, "stats", (GActionGroup*) action_group);
	pomodoro_stats_view_gtk_buildable_parent_iface->parser_finished ((GtkBuildable*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), builder);
	_g_object_unref0 (action_group);
}

static gboolean
pomodoro_stats_view_transform_mode_to_page (GBinding* binding,
                                            GValue* source_value,
                                            GValue* target_value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (source_value != NULL, FALSE);
	g_return_val_if_fail (target_value != NULL, FALSE);
	_tmp0_ = g_value_get_string (source_value);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("day")))) {
		switch (0) {
			default:
			{
				g_value_set_int (target_value, 0);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("week")))) {
		switch (0) {
			default:
			{
				g_value_set_int (target_value, 1);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("month")))) {
		switch (0) {
			default:
			{
				g_value_set_int (target_value, 2);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("none")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pomodoro_stats_view_transform_mode_from_page (GBinding* binding,
                                              GValue* source_value,
                                              GValue* target_value)
{
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (source_value != NULL, FALSE);
	g_return_val_if_fail (target_value != NULL, FALSE);
	switch (g_value_get_int (source_value)) {
		case 0:
		{
			g_value_set_string (target_value, "day");
			break;
		}
		case 1:
		{
			g_value_set_string (target_value, "week");
			break;
		}
		case 2:
		{
			g_value_set_string (target_value, "month");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = TRUE;
	return result;
}

static gboolean
pomodoro_stats_view_transform_mode_to_sensitive (GBinding* binding,
                                                 GValue* source_value,
                                                 GValue* target_value)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (source_value != NULL, FALSE);
	g_return_val_if_fail (target_value != NULL, FALSE);
	_tmp0_ = g_value_get_string (source_value);
	g_value_set_boolean (target_value, g_strcmp0 (_tmp0_, "none") != 0);
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pomodoro_stats_view_activate_previous (PomodoroStatsView* self)
{
	PomodoroStatsPage* page = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	PomodoroStatsPage* _tmp3_;
	PomodoroStatsPage* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pages;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (POMODORO_IS_STATS_PAGE (_tmp2_) ? ((PomodoroStatsPage*) _tmp2_) : NULL);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		PomodoroStatsPage* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		_tmp5_ = page;
		_tmp6_ = pomodoro_stats_page_get_previous_date (_tmp5_);
		_tmp7_ = _tmp6_;
		pomodoro_stats_view_select_page (self, _tmp7_);
		_g_date_time_unref0 (_tmp7_);
	}
	_g_object_unref0 (page);
}

static void
pomodoro_stats_view_activate_next (PomodoroStatsView* self)
{
	PomodoroStatsPage* page = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	PomodoroStatsPage* _tmp3_;
	PomodoroStatsPage* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pages;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (POMODORO_IS_STATS_PAGE (_tmp2_) ? ((PomodoroStatsPage*) _tmp2_) : NULL);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		PomodoroStatsPage* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		_tmp5_ = page;
		_tmp6_ = pomodoro_stats_page_get_next_date (_tmp5_);
		_tmp7_ = _tmp6_;
		pomodoro_stats_view_select_page (self, _tmp7_);
		_g_date_time_unref0 (_tmp7_);
	}
	_g_object_unref0 (page);
}

static void
pomodoro_stats_view_on_map (PomodoroStatsView* self,
                            GtkWidget* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	pomodoro_stats_view_update (self, NULL, NULL);
}

static void
_pomodoro_stats_view_on_map_gtk_widget_map (GtkWidget* _sender,
                                            gpointer self)
{
	pomodoro_stats_view_on_map ((PomodoroStatsView*) self, _sender);
}

static void
pomodoro_stats_view_update_data_free (gpointer _data)
{
	PomodoroStatsViewUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PomodoroStatsViewUpdateData, _data_);
}

static void
pomodoro_stats_view_update (PomodoroStatsView* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	PomodoroStatsViewUpdateData* _data_;
	PomodoroStatsView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PomodoroStatsViewUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_stats_view_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pomodoro_stats_view_update_co (_data_);
}

static void
pomodoro_stats_view_update_finish (PomodoroStatsView* self,
                                   GAsyncResult* _res_)
{
	PomodoroStatsViewUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		PomodoroStatsView* self;
		self = _data19_->self;
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static void
___lambda13_ (Block19Data* _data19_,
              GObject* obj,
              GAsyncResult* res)
{
	PomodoroStatsView* self;
	GError* _inner_error0_ = NULL;
	self = _data19_->self;
	g_return_if_fail (res != NULL);
	{
		GomResourceGroup* group = NULL;
		GomRepository* _tmp0_;
		GomResourceGroup* _tmp1_;
		gboolean _tmp2_ = FALSE;
		GomResourceGroup* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp0_ = self->priv->repository;
		_tmp1_ = gom_repository_find_finish (_tmp0_, res, &_inner_error0_);
		group = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = group;
		_tmp4_ = gom_resource_group_get_count (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > ((guint) 0)) {
			gboolean _tmp6_ = FALSE;
			GomResourceGroup* _tmp7_;
			_tmp7_ = group;
			_tmp6_ = gom_resource_group_fetch_sync (_tmp7_, (guint) 0, (guint) 1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (group);
				goto __catch0_g_error;
			}
			_tmp2_ = _tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			PomodoroEntry* first_entry = NULL;
			GomResourceGroup* _tmp8_;
			GomResource* _tmp9_;
			PomodoroEntry* _tmp10_;
			PomodoroEntry* _tmp11_;
			GDateTime* _tmp12_;
			_tmp8_ = group;
			_tmp9_ = gom_resource_group_get_index (_tmp8_, (guint) 0);
			_tmp10_ = _g_object_ref0 (POMODORO_IS_ENTRY (_tmp9_) ? ((PomodoroEntry*) _tmp9_) : NULL);
			first_entry = _tmp10_;
			_tmp11_ = first_entry;
			_tmp12_ = pomodoro_entry_get_datetime_local (_tmp11_);
			_g_date_time_unref0 (self->priv->min_datetime);
			self->priv->min_datetime = _tmp12_;
			_g_object_unref0 (first_entry);
		} else {
			_g_date_time_unref0 (self->priv->min_datetime);
			self->priv->min_datetime = NULL;
		}
		_g_object_unref0 (group);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_date_time_unref0 (self->priv->min_datetime);
		self->priv->min_datetime = NULL;
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		g_critical ("stats-view.vala:220: %s", _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	pomodoro_stats_view_update_co (_data19_->_async_data_);
}

static void
____lambda13__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda13_ (self, source_object, res);
	block19_data_unref (self);
}

static gboolean
pomodoro_stats_view_update_co (PomodoroStatsViewUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data19_ = g_slice_new0 (Block19Data);
	_data_->_data19_->_ref_count_ = 1;
	_data_->_data19_->self = g_object_ref (_data_->self);
	_data_->_data19_->_async_data_ = _data_;
	_data_->_tmp0_ = g_date_time_new_now_local ();
	_g_date_time_unref0 (_data_->self->priv->max_datetime);
	_data_->self->priv->max_datetime = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->min_datetime;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = g_object_new (gom_sorting_get_type (), NULL);
		_data_->_tmp3_ = G_IS_INITIALLY_UNOWNED (_data_->_tmp2_) ? g_object_ref_sink (_data_->_tmp2_) : _data_->_tmp2_;
		_data_->sorting = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, gom_sorting_get_type (), GomSorting);
		_data_->_tmp4_ = _data_->sorting;
		gom_sorting_add (_data_->_tmp4_, POMODORO_TYPE_ENTRY, "datetime-local-string", GOM_SORTING_ASCENDING);
		_data_->_tmp5_ = _data_->self->priv->repository;
		_data_->_tmp6_ = _data_->sorting;
		gom_repository_find_sorted_async (_data_->_tmp5_, POMODORO_TYPE_ENTRY, NULL, _data_->_tmp6_, ____lambda13__gasync_ready_callback, block19_data_ref (_data_->_data19_));
		_g_object_unref0 (_data_->sorting);
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp7_ = _data_->self->priv->min_datetime;
	if (_data_->_tmp7_ == NULL) {
		pomodoro_stats_view_set_mode (_data_->self, "none");
	} else {
		_data_->_tmp8_ = pomodoro_stats_view_get_mode (_data_->self);
		_data_->_tmp9_ = _data_->_tmp8_;
		if (g_strcmp0 (_data_->_tmp9_, "none") == 0) {
			pomodoro_stats_view_set_mode (_data_->self, "day");
		}
	}
	block19_data_unref (_data_->_data19_);
	_data_->_data19_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
         * Normalizes datetime according to mode. Returns null if there are no entries.
         */
static GDateTime*
pomodoro_stats_view_normalize_datetime (PomodoroStatsView* self,
                                        GDateTime* datetime,
                                        const gchar* mode)
{
	GDateTime* _tmp0_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mode != NULL, NULL);
	_tmp0_ = self->priv->min_datetime;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	if (datetime == NULL) {
		GDateTime* _tmp1_;
		_tmp1_ = self->priv->max_datetime;
		datetime = _tmp1_;
	}
	_tmp2_ = mode;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("none")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("day")))) {
		switch (0) {
			default:
			{
				GDateTime* _tmp5_;
				_tmp5_ = g_date_time_new_local (g_date_time_get_year (datetime), g_date_time_get_month (datetime), g_date_time_get_day_of_month (datetime), 0, 0, 0.0);
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("week")))) {
		switch (0) {
			default:
			{
				GDateTime* tmp = NULL;
				GDateTime* _tmp6_;
				GDateTime* _tmp7_;
				GDateTime* _tmp8_;
				_tmp6_ = g_date_time_new_local (g_date_time_get_year (datetime), g_date_time_get_month (datetime), g_date_time_get_day_of_month (datetime), 0, 0, 0.0);
				tmp = _tmp6_;
				_tmp7_ = tmp;
				_tmp8_ = g_date_time_add_days (_tmp7_, 1 - g_date_time_get_day_of_week (datetime));
				result = _tmp8_;
				_g_date_time_unref0 (tmp);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("month")))) {
		switch (0) {
			default:
			{
				GDateTime* _tmp9_;
				_tmp9_ = g_date_time_new_local (g_date_time_get_year (datetime), g_date_time_get_month (datetime), 1, 0, 0, 0.0);
				result = _tmp9_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
pomodoro_stats_view_build_page_name (PomodoroStatsView* self,
                                     GDateTime* datetime,
                                     const gchar* mode)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (datetime != NULL, NULL);
	g_return_val_if_fail (mode != NULL, NULL);
	_tmp0_ = g_date_time_format (datetime, "%s");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:%s", mode, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static PomodoroStatsPage*
pomodoro_stats_view_create_page (PomodoroStatsView* self,
                                 GDateTime* datetime,
                                 const gchar* mode)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	PomodoroStatsPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (datetime != NULL, NULL);
	g_return_val_if_fail (mode != NULL, NULL);
	_tmp0_ = mode;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("day")))) {
		switch (0) {
			default:
			{
				GomRepository* _tmp3_;
				PomodoroStatsDayPage* _tmp4_;
				_tmp3_ = self->priv->repository;
				_tmp4_ = pomodoro_stats_day_page_new (_tmp3_, datetime);
				g_object_ref_sink (_tmp4_);
				result = (PomodoroStatsPage*) _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("week")))) {
		switch (0) {
			default:
			{
				GomRepository* _tmp5_;
				PomodoroStatsWeekPage* _tmp6_;
				_tmp5_ = self->priv->repository;
				_tmp6_ = pomodoro_stats_week_page_new (_tmp5_, datetime);
				g_object_ref_sink (_tmp6_);
				result = (PomodoroStatsPage*) _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("month")))) {
		switch (0) {
			default:
			{
				GomRepository* _tmp7_;
				PomodoroStatsMonthPage* _tmp8_;
				_tmp7_ = self->priv->repository;
				_tmp8_ = pomodoro_stats_month_page_new (_tmp7_, datetime);
				g_object_ref_sink (_tmp8_);
				result = (PomodoroStatsPage*) _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

static PomodoroStatsPage*
pomodoro_stats_view_get_page (PomodoroStatsView* self,
                              const gchar* name)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	PomodoroStatsPage* _tmp2_;
	PomodoroStatsPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->pages;
	_tmp1_ = gtk_stack_get_child_by_name (_tmp0_, name);
	_tmp2_ = _g_object_ref0 (POMODORO_IS_STATS_PAGE (_tmp1_) ? ((PomodoroStatsPage*) _tmp1_) : NULL);
	result = _tmp2_;
	return result;
}

static PomodoroStatsPage*
pomodoro_stats_view_get_or_create_page (PomodoroStatsView* self,
                                        GDateTime* datetime,
                                        const gchar* mode)
{
	gchar* page_name = NULL;
	gchar* _tmp0_;
	PomodoroStatsPage* page = NULL;
	const gchar* _tmp1_;
	PomodoroStatsPage* _tmp2_;
	PomodoroStatsPage* _tmp3_;
	PomodoroStatsPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (datetime != NULL, NULL);
	g_return_val_if_fail (mode != NULL, NULL);
	_tmp0_ = pomodoro_stats_view_build_page_name (self, datetime, mode);
	page_name = _tmp0_;
	_tmp1_ = page_name;
	_tmp2_ = pomodoro_stats_view_get_page (self, _tmp1_);
	page = _tmp2_;
	_tmp3_ = page;
	if (_tmp3_ == NULL) {
		PomodoroStatsPage* _tmp4_;
		GtkStack* _tmp5_;
		PomodoroStatsPage* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = pomodoro_stats_view_create_page (self, datetime, mode);
		_g_object_unref0 (page);
		page = _tmp4_;
		_tmp5_ = self->priv->pages;
		_tmp6_ = page;
		_tmp7_ = page_name;
		gtk_stack_add_named (_tmp5_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp6_) : NULL, _tmp7_);
	}
	result = page;
	_g_free0 (page_name);
	return result;
}

/**
         * Switch to appropriate page specified by datetime, according to current mode
         */
static void
pomodoro_stats_view_select_page (PomodoroStatsView* self,
                                 GDateTime* value)
{
	gchar* mode = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GDateTime* datetime = NULL;
	const gchar* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* min_datetime = NULL;
	GDateTime* _tmp5_;
	const gchar* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* max_datetime = NULL;
	GDateTime* _tmp8_;
	const gchar* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_stats_view_get_mode (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	mode = _tmp2_;
	_tmp3_ = mode;
	_tmp4_ = pomodoro_stats_view_normalize_datetime (self, value, _tmp3_);
	datetime = _tmp4_;
	_tmp5_ = self->priv->min_datetime;
	_tmp6_ = mode;
	_tmp7_ = pomodoro_stats_view_normalize_datetime (self, _tmp5_, _tmp6_);
	min_datetime = _tmp7_;
	_tmp8_ = self->priv->max_datetime;
	_tmp9_ = mode;
	_tmp10_ = pomodoro_stats_view_normalize_datetime (self, _tmp8_, _tmp9_);
	max_datetime = _tmp10_;
	_tmp11_ = datetime;
	if (_tmp11_ != NULL) {
		PomodoroStatsPage* page = NULL;
		GDateTime* _tmp12_;
		const gchar* _tmp13_;
		PomodoroStatsPage* _tmp14_;
		GtkStackTransitionType page_transition = 0;
		PomodoroStatsPage* current_page = NULL;
		GtkStack* _tmp15_;
		GtkWidget* _tmp16_;
		GtkWidget* _tmp17_;
		PomodoroStatsPage* _tmp18_;
		PomodoroStatsPage* _tmp19_;
		GtkStack* _tmp29_;
		GtkStack* _tmp30_;
		PomodoroStatsPage* _tmp31_;
		GQueue* _tmp32_;
		PomodoroStatsPage* _tmp33_;
		GQueue* _tmp34_;
		PomodoroStatsPage* _tmp35_;
		GBinding* _tmp39_;
		PomodoroStatsPage* _tmp42_;
		GtkLabel* _tmp43_;
		GBinding* _tmp44_;
		GBinding* _tmp45_;
		gboolean _tmp46_ = FALSE;
		GDateTime* _tmp47_;
		GSimpleAction* _tmp52_;
		gboolean _tmp53_ = FALSE;
		GDateTime* _tmp54_;
		GSimpleAction* _tmp59_;
		_tmp12_ = datetime;
		_tmp13_ = mode;
		_tmp14_ = pomodoro_stats_view_get_or_create_page (self, _tmp12_, _tmp13_);
		page = _tmp14_;
		page_transition = GTK_STACK_TRANSITION_TYPE_NONE;
		_tmp15_ = self->priv->pages;
		_tmp16_ = gtk_stack_get_visible_child (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _g_object_ref0 (POMODORO_IS_STATS_PAGE (_tmp17_) ? ((PomodoroStatsPage*) _tmp17_) : NULL);
		current_page = _tmp18_;
		_tmp19_ = current_page;
		if (_tmp19_ != NULL) {
			PomodoroStatsPage* _tmp20_;
			PomodoroStatsPage* _tmp21_;
			_tmp20_ = page;
			_tmp21_ = current_page;
			if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp20_) != G_TYPE_FROM_INSTANCE ((GObject*) _tmp21_)) {
				page_transition = GTK_STACK_TRANSITION_TYPE_CROSSFADE;
			} else {
				GtkStackTransitionType _tmp22_ = 0;
				PomodoroStatsPage* _tmp23_;
				GDateTime* _tmp24_;
				GDateTime* _tmp25_;
				PomodoroStatsPage* _tmp26_;
				GDateTime* _tmp27_;
				GDateTime* _tmp28_;
				_tmp23_ = current_page;
				_tmp24_ = pomodoro_stats_page_get_date (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = page;
				_tmp27_ = pomodoro_stats_page_get_date (_tmp26_);
				_tmp28_ = _tmp27_;
				if (g_date_time_compare (_tmp25_, _tmp28_) < 0) {
					_tmp22_ = GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT;
				} else {
					_tmp22_ = GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT;
				}
				page_transition = _tmp22_;
			}
		}
		_tmp29_ = self->priv->pages;
		gtk_stack_set_transition_type (_tmp29_, page_transition);
		_tmp30_ = self->priv->pages;
		_tmp31_ = page;
		gtk_stack_set_visible_child (_tmp30_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp31_) : NULL);
		_tmp32_ = self->priv->history;
		_tmp33_ = page;
		g_queue_remove (_tmp32_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp33_) : NULL);
		_tmp34_ = self->priv->history;
		_tmp35_ = page;
		g_queue_push_tail (_tmp34_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp35_) : NULL);
		while (TRUE) {
			GQueue* _tmp36_;
			GQueue* _tmp37_;
			gpointer _tmp38_;
			_tmp36_ = self->priv->history;
			if (!(_tmp36_->length > ((guint) 3))) {
				break;
			}
			_tmp37_ = self->priv->history;
			_tmp38_ = g_queue_pop_head (_tmp37_);
			gtk_widget_destroy ((GtkWidget*) _tmp38_);
		}
		_tmp39_ = self->priv->title_binding;
		if (_tmp39_ != NULL) {
			GBinding* _tmp40_;
			GBinding* _tmp41_;
			_tmp40_ = self->priv->title_binding;
			_tmp41_ = _g_object_ref0 (_tmp40_);
			g_binding_unbind (_tmp41_);
		}
		_tmp42_ = page;
		_tmp43_ = self->priv->title;
		_tmp44_ = g_object_bind_property_with_closures ((GObject*) _tmp42_, "title", (GObject*) _tmp43_, "label", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp45_ = _g_object_ref0 (_tmp44_);
		_g_object_unref0 (self->priv->title_binding);
		self->priv->title_binding = _tmp45_;
		_tmp47_ = min_datetime;
		if (_tmp47_ != NULL) {
			GDateTime* _tmp48_;
			PomodoroStatsPage* _tmp49_;
			GDateTime* _tmp50_;
			GDateTime* _tmp51_;
			_tmp48_ = min_datetime;
			_tmp49_ = page;
			_tmp50_ = pomodoro_stats_page_get_previous_date (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp46_ = g_date_time_compare (_tmp48_, _tmp51_) <= 0;
			_g_date_time_unref0 (_tmp51_);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp52_ = self->priv->previous_action;
		g_simple_action_set_enabled (_tmp52_, _tmp46_);
		_tmp54_ = max_datetime;
		if (_tmp54_ != NULL) {
			GDateTime* _tmp55_;
			PomodoroStatsPage* _tmp56_;
			GDateTime* _tmp57_;
			GDateTime* _tmp58_;
			_tmp55_ = max_datetime;
			_tmp56_ = page;
			_tmp57_ = pomodoro_stats_page_get_next_date (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp53_ = g_date_time_compare (_tmp55_, _tmp58_) >= 0;
			_g_date_time_unref0 (_tmp58_);
		} else {
			_tmp53_ = FALSE;
		}
		_tmp59_ = self->priv->next_action;
		g_simple_action_set_enabled (_tmp59_, _tmp53_);
		_g_object_unref0 (current_page);
		_g_object_unref0 (page);
	} else {
		GSimpleAction* _tmp60_;
		GSimpleAction* _tmp61_;
		_tmp60_ = self->priv->previous_action;
		g_simple_action_set_enabled (_tmp60_, FALSE);
		_tmp61_ = self->priv->next_action;
		g_simple_action_set_enabled (_tmp61_, FALSE);
	}
	_g_date_time_unref0 (max_datetime);
	_g_date_time_unref0 (min_datetime);
	_g_date_time_unref0 (datetime);
	_g_free0 (mode);
}

PomodoroStatsView*
pomodoro_stats_view_construct (GType object_type)
{
	PomodoroStatsView * self = NULL;
	self = (PomodoroStatsView*) g_object_new (object_type, NULL);
	return self;
}

PomodoroStatsView*
pomodoro_stats_view_new (void)
{
	return pomodoro_stats_view_construct (POMODORO_TYPE_STATS_VIEW);
}

const gchar*
pomodoro_stats_view_get_mode (PomodoroStatsView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}

void
pomodoro_stats_view_set_mode (PomodoroStatsView* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mode);
	self->priv->_mode = _tmp0_;
	if (g_strcmp0 (value, "none") == 0) {
		GtkStack* _tmp1_;
		_tmp1_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp1_, "none");
	} else {
		GtkStack* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GDateTime* _tmp6_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = gtk_stack_get_visible_child_name (_tmp2_);
		_tmp4_ = _tmp3_;
		if (g_strcmp0 (_tmp4_, "none") == 0) {
			GtkStack* _tmp5_;
			_tmp5_ = self->priv->stack;
			gtk_stack_set_visible_child_name (_tmp5_, "content");
		}
		_tmp6_ = self->priv->max_datetime;
		pomodoro_stats_view_select_page (self, _tmp6_);
	}
	g_object_notify_by_pspec ((GObject *) self, pomodoro_stats_view_properties[POMODORO_STATS_VIEW_MODE_PROPERTY]);
}

static gboolean
_pomodoro_stats_view_transform_mode_to_page_gbinding_transform_func (GBinding* binding,
                                                                     GValue* from_value,
                                                                     GValue* to_value,
                                                                     gpointer self)
{
	gboolean result;
	result = pomodoro_stats_view_transform_mode_to_page (binding, from_value, to_value);
	return result;
}

static gboolean
_pomodoro_stats_view_transform_mode_from_page_gbinding_transform_func (GBinding* binding,
                                                                       GValue* from_value,
                                                                       GValue* to_value,
                                                                       gpointer self)
{
	gboolean result;
	result = pomodoro_stats_view_transform_mode_from_page (binding, from_value, to_value);
	return result;
}

static gboolean
_pomodoro_stats_view_transform_mode_to_sensitive_gbinding_transform_func (GBinding* binding,
                                                                          GValue* from_value,
                                                                          GValue* to_value,
                                                                          gpointer self)
{
	gboolean result;
	result = pomodoro_stats_view_transform_mode_to_sensitive (binding, from_value, to_value);
	return result;
}

static GObject *
pomodoro_stats_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroStatsView * self;
	GomRepository* _tmp0_;
	GQueue* _tmp1_;
	GtkNotebook* _tmp2_;
	GtkNotebook* _tmp3_;
	parent_class = G_OBJECT_CLASS (pomodoro_stats_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_STATS_VIEW, PomodoroStatsView);
	_tmp0_ = pomodoro_get_repository ();
	_g_object_unref0 (self->priv->repository);
	self->priv->repository = _tmp0_;
	_tmp1_ = g_queue_new ();
	(self->priv->history == NULL) ? NULL : (self->priv->history = (g_queue_free (self->priv->history), NULL));
	self->priv->history = _tmp1_;
	pomodoro_stats_view_set_mode (self, "none");
	_tmp2_ = self->priv->notebook;
	g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp2_, "page", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) g_cclosure_new ((GCallback) _pomodoro_stats_view_transform_mode_to_page_gbinding_transform_func, NULL, (GClosureNotify) NULL), (GClosure*) g_cclosure_new ((GCallback) _pomodoro_stats_view_transform_mode_from_page_gbinding_transform_func, NULL, (GClosureNotify) NULL));
	_tmp3_ = self->priv->notebook;
	g_object_bind_property_with_closures ((GObject*) self, "mode", (GObject*) _tmp3_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) g_cclosure_new ((GCallback) _pomodoro_stats_view_transform_mode_to_sensitive_gbinding_transform_func, NULL, (GClosureNotify) NULL), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return obj;
}

static void
pomodoro_stats_view_class_init (PomodoroStatsViewClass * klass,
                                gpointer klass_data)
{
	pomodoro_stats_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroStatsView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_stats_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_stats_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_stats_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_stats_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_STATS_VIEW_MODE_PROPERTY, pomodoro_stats_view_properties[POMODORO_STATS_VIEW_MODE_PROPERTY] = g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/stats-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notebook", FALSE, PomodoroStatsView_private_offset + G_STRUCT_OFFSET (PomodoroStatsViewPrivate, notebook));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title", FALSE, PomodoroStatsView_private_offset + G_STRUCT_OFFSET (PomodoroStatsViewPrivate, title));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, PomodoroStatsView_private_offset + G_STRUCT_OFFSET (PomodoroStatsViewPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pages", FALSE, PomodoroStatsView_private_offset + G_STRUCT_OFFSET (PomodoroStatsViewPrivate, pages));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_map", G_CALLBACK(_pomodoro_stats_view_on_map_gtk_widget_map));
}

static void
pomodoro_stats_view_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                  gpointer iface_data)
{
	pomodoro_stats_view_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->parser_finished = (void (*) (GtkBuildable*, GtkBuilder*)) pomodoro_stats_view_real_parser_finished;
}

static void
pomodoro_stats_view_instance_init (PomodoroStatsView * self,
                                   gpointer klass)
{
	self->priv = pomodoro_stats_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_stats_view_finalize (GObject * obj)
{
	PomodoroStatsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_STATS_VIEW, PomodoroStatsView);
	_g_object_unref0 (self->priv->repository);
	_g_date_time_unref0 (self->priv->min_datetime);
	_g_date_time_unref0 (self->priv->max_datetime);
	(self->priv->history == NULL) ? NULL : (self->priv->history = (g_queue_free (self->priv->history), NULL));
	_g_object_unref0 (self->priv->previous_action);
	_g_object_unref0 (self->priv->next_action);
	_g_object_unref0 (self->priv->title_binding);
	_g_free0 (self->priv->_mode);
	G_OBJECT_CLASS (pomodoro_stats_view_parent_class)->finalize (obj);
}

static GType
pomodoro_stats_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroStatsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_stats_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroStatsView), 0, (GInstanceInitFunc) pomodoro_stats_view_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_stats_view_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_stats_view_type_id;
	pomodoro_stats_view_type_id = g_type_register_static (gtk_box_get_type (), "PomodoroStatsView", &g_define_type_info, 0);
	g_type_add_interface_static (pomodoro_stats_view_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	PomodoroStatsView_private_offset = g_type_add_instance_private (pomodoro_stats_view_type_id, sizeof (PomodoroStatsViewPrivate));
	return pomodoro_stats_view_type_id;
}

GType
pomodoro_stats_view_get_type (void)
{
	static volatile gsize pomodoro_stats_view_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_stats_view_type_id__once)) {
		GType pomodoro_stats_view_type_id;
		pomodoro_stats_view_type_id = pomodoro_stats_view_get_type_once ();
		g_once_init_leave (&pomodoro_stats_view_type_id__once, pomodoro_stats_view_type_id);
	}
	return pomodoro_stats_view_type_id__once;
}

static void
_vala_pomodoro_stats_view_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PomodoroStatsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_STATS_VIEW, PomodoroStatsView);
	switch (property_id) {
		case POMODORO_STATS_VIEW_MODE_PROPERTY:
		g_value_set_string (value, pomodoro_stats_view_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_stats_view_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PomodoroStatsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_STATS_VIEW, PomodoroStatsView);
	switch (property_id) {
		case POMODORO_STATS_VIEW_MODE_PROPERTY:
		pomodoro_stats_view_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

