/* timer.c generated by valac 0.56.17, the Vala compiler
 * generated from timer.vala, do not modify */

/*
 * Copyright (c) 2011-2015 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Arun Mahapatra <pratikarun@gmail.com>
 *          Kamil Prusko <kamilprusko@gmail.com>
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include "gnome-pomodoro.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define POMODORO_TIME_TO_RESET_SCORE 3600.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_TIMER_0_PROPERTY,
	POMODORO_TIMER_STATE_PROPERTY,
	POMODORO_TIMER_STATE_DURATION_PROPERTY,
	POMODORO_TIMER_ELAPSED_PROPERTY,
	POMODORO_TIMER_REMAINING_PROPERTY,
	POMODORO_TIMER_OFFSET_PROPERTY,
	POMODORO_TIMER_IS_PAUSED_PROPERTY,
	POMODORO_TIMER_TIMESTAMP_PROPERTY,
	POMODORO_TIMER_SCORE_PROPERTY,
	POMODORO_TIMER_NUM_PROPERTIES
};
static GParamSpec* pomodoro_timer_properties[POMODORO_TIMER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block20Data Block20Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
enum  {
	POMODORO_TIMER_UPDATE_SIGNAL,
	POMODORO_TIMER_STATE_ENTER_SIGNAL,
	POMODORO_TIMER_STATE_LEAVE_SIGNAL,
	POMODORO_TIMER_STATE_CHANGED_SIGNAL,
	POMODORO_TIMER_DESTROY_SIGNAL,
	POMODORO_TIMER_NUM_SIGNALS
};
static guint pomodoro_timer_signals[POMODORO_TIMER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PomodoroTimerPrivate {
	gdouble _offset;
	gdouble _timestamp;
	gdouble _score;
	guint timeout_source;
	PomodoroTimerState* _state;
	gboolean _is_paused;
};

struct _Block20Data {
	int _ref_count_;
	PomodoroTimer* timer;
};

static gint PomodoroTimer_private_offset;
static gpointer pomodoro_timer_parent_class = NULL;
static PomodoroTimer* pomodoro_timer_instance;
static PomodoroTimer* pomodoro_timer_instance = NULL;

static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void ___lambda5_ (Block20Data* _data20_);
static void ____lambda5__pomodoro_timer_destroy (PomodoroTimer* _sender,
                                          gpointer self);
static void pomodoro_timer_set_is_paused_full (PomodoroTimer* self,
                                        gboolean value,
                                        gdouble timestamp);
static void pomodoro_timer_set_state_full (PomodoroTimer* self,
                                    PomodoroTimerState* state,
                                    gdouble timestamp);
static void pomodoro_timer_update_offset (PomodoroTimer* self);
static gboolean pomodoro_timer_resolve_state (PomodoroTimer* self);
static void pomodoro_timer_update_timeout (PomodoroTimer* self);
static gboolean pomodoro_timer_on_timeout (PomodoroTimer* self);
static void pomodoro_timer_stop_timeout (PomodoroTimer* self);
static void pomodoro_timer_start_timeout (PomodoroTimer* self);
static gboolean _pomodoro_timer_on_timeout_gsource_func (gpointer self);
static void pomodoro_timer_update_elapsed (PomodoroTimer* self);
static void pomodoro_timer_on_state_duration_notify (PomodoroTimer* self);
static void pomodoro_timer_real_dispose (GObject* base);
static void pomodoro_timer_set_offset (PomodoroTimer* self,
                                gdouble value);
static void pomodoro_timer_real_update (PomodoroTimer* self,
                                 gdouble timestamp);
static void pomodoro_timer_real_state_enter (PomodoroTimer* self,
                                      PomodoroTimerState* state);
static void _pomodoro_timer_on_state_duration_notify_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void pomodoro_timer_real_state_leave (PomodoroTimer* self,
                                      PomodoroTimerState* state);
static void pomodoro_timer_real_state_changed (PomodoroTimer* self,
                                        PomodoroTimerState* state,
                                        PomodoroTimerState* previous_state);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void pomodoro_timer_real_destroy (PomodoroTimer* self);
static GObject * pomodoro_timer_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void pomodoro_timer_finalize (GObject * obj);
static GType pomodoro_timer_get_type_once (void);
static void _vala_pomodoro_timer_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_pomodoro_timer_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
pomodoro_timer_get_instance_private (PomodoroTimer* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroTimer_private_offset);
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_g_object_unref0 (_data20_->timer);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
___lambda5_ (Block20Data* _data20_)
{
	PomodoroTimer* _tmp0_;
	PomodoroTimer* _tmp1_;
	_tmp0_ = pomodoro_timer_instance;
	_tmp1_ = _data20_->timer;
	if (_tmp0_ == _tmp1_) {
		_g_object_unref0 (pomodoro_timer_instance);
		pomodoro_timer_instance = NULL;
	}
}

static void
____lambda5__pomodoro_timer_destroy (PomodoroTimer* _sender,
                                     gpointer self)
{
	___lambda5_ (self);
}

PomodoroTimer*
pomodoro_timer_get_default (void)
{
	PomodoroTimer* _tmp0_;
	PomodoroTimer* _tmp4_;
	PomodoroTimer* result;
	_tmp0_ = pomodoro_timer_instance;
	if (_tmp0_ == NULL) {
		Block20Data* _data20_;
		PomodoroTimer* _tmp1_;
		PomodoroTimer* _tmp2_;
		PomodoroTimer* _tmp3_;
		_data20_ = g_slice_new0 (Block20Data);
		_data20_->_ref_count_ = 1;
		_tmp1_ = pomodoro_timer_new ();
		_data20_->timer = _tmp1_;
		_tmp2_ = _data20_->timer;
		pomodoro_timer_set_default (_tmp2_);
		_tmp3_ = _data20_->timer;
		g_signal_connect_data (_tmp3_, "destroy", (GCallback) ____lambda5__pomodoro_timer_destroy, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, G_CONNECT_AFTER);
		block20_data_unref (_data20_);
		_data20_ = NULL;
	}
	_tmp4_ = pomodoro_timer_instance;
	result = _tmp4_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
pomodoro_timer_set_default (PomodoroTimer* self)
{
	PomodoroTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (pomodoro_timer_instance);
	pomodoro_timer_instance = _tmp0_;
}

/**
         * Check whether timer is ticking.
         */
gboolean
pomodoro_timer_is_running (PomodoroTimer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->timeout_source != ((guint) 0);
	return result;
}

void
pomodoro_timer_start (PomodoroTimer* self,
                      gdouble timestamp)
{
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	g_return_if_fail (self != NULL);
	pomodoro_timer_resume (self, timestamp);
	_tmp0_ = pomodoro_timer_get_state (self);
	_tmp1_ = _tmp0_;
	if (POMODORO_IS_DISABLED_STATE (_tmp1_)) {
		PomodoroPomodoroState* _tmp2_;
		PomodoroPomodoroState* _tmp3_;
		_tmp2_ = pomodoro_pomodoro_state_new_with_timestamp (timestamp);
		_tmp3_ = _tmp2_;
		pomodoro_timer_set_state (self, (PomodoroTimerState*) _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
}

void
pomodoro_timer_stop (PomodoroTimer* self,
                     gdouble timestamp)
{
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	g_return_if_fail (self != NULL);
	pomodoro_timer_resume (self, timestamp);
	_tmp0_ = pomodoro_timer_get_state (self);
	_tmp1_ = _tmp0_;
	if (!POMODORO_IS_DISABLED_STATE (_tmp1_)) {
		PomodoroDisabledState* _tmp2_;
		PomodoroDisabledState* _tmp3_;
		_tmp2_ = pomodoro_disabled_state_new_with_timestamp (timestamp);
		_tmp3_ = _tmp2_;
		pomodoro_timer_set_state (self, (PomodoroTimerState*) _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
}

void
pomodoro_timer_toggle (PomodoroTimer* self,
                       gdouble timestamp)
{
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_timer_get_state (self);
	_tmp1_ = _tmp0_;
	if (POMODORO_IS_DISABLED_STATE (_tmp1_)) {
		pomodoro_timer_start (self, timestamp);
	} else {
		pomodoro_timer_stop (self, timestamp);
	}
}

void
pomodoro_timer_pause (PomodoroTimer* self,
                      gdouble timestamp)
{
	g_return_if_fail (self != NULL);
	pomodoro_timer_set_is_paused_full (self, TRUE, timestamp);
}

void
pomodoro_timer_resume (PomodoroTimer* self,
                       gdouble timestamp)
{
	g_return_if_fail (self != NULL);
	pomodoro_timer_set_is_paused_full (self, FALSE, timestamp);
}

void
pomodoro_timer_reset (PomodoroTimer* self,
                      gdouble timestamp)
{
	PomodoroDisabledState* _tmp0_;
	PomodoroDisabledState* _tmp1_;
	g_return_if_fail (self != NULL);
	pomodoro_timer_resume (self, timestamp);
	pomodoro_timer_set_score (self, 0.0);
	_tmp0_ = pomodoro_disabled_state_new_with_timestamp (timestamp);
	_tmp1_ = _tmp0_;
	pomodoro_timer_set_state (self, (PomodoroTimerState*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

void
pomodoro_timer_skip (PomodoroTimer* self,
                     gdouble timestamp)
{
	PomodoroTimerState* _tmp0_;
	gdouble _tmp1_;
	PomodoroTimerState* _tmp2_;
	PomodoroTimerState* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	_tmp1_ = self->priv->_score;
	_tmp2_ = pomodoro_timer_state_create_next_state (_tmp0_, _tmp1_, timestamp);
	_tmp3_ = _tmp2_;
	pomodoro_timer_set_state (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}

/**
         * set_state_full
         *
         * Changes the state and sets new timestamp
         */
static void
pomodoro_timer_set_state_full (PomodoroTimer* self,
                               PomodoroTimerState* state,
                               gdouble timestamp)
{
	PomodoroTimerState* previous_state = NULL;
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	PomodoroTimerState* _tmp3_;
	PomodoroTimerState* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = self->priv->_state;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	previous_state = _tmp1_;
	pomodoro_timer_set_timestamp (self, timestamp);
	_tmp2_ = self->priv->_state;
	g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_LEAVE_SIGNAL], 0, _tmp2_);
	_tmp3_ = _g_object_ref0 (state);
	_g_object_unref0 (self->priv->_state);
	self->priv->_state = _tmp3_;
	pomodoro_timer_update_offset (self);
	_tmp4_ = self->priv->_state;
	g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_ENTER_SIGNAL], 0, _tmp4_);
	if (!pomodoro_timer_resolve_state (self)) {
		PomodoroTimerState* _tmp5_;
		PomodoroTimerState* _tmp6_;
		_tmp5_ = self->priv->_state;
		_tmp6_ = previous_state;
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_CHANGED_SIGNAL], 0, _tmp5_, _tmp6_);
	}
	_g_object_unref0 (previous_state);
}

static void
pomodoro_timer_set_is_paused_full (PomodoroTimer* self,
                                   gboolean value,
                                   gdouble timestamp)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value) {
		_tmp0_ = self->priv->timeout_source == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (value != self->priv->_is_paused) {
		self->priv->_is_paused = value;
		pomodoro_timer_set_timestamp (self, timestamp);
		pomodoro_timer_update_offset (self);
		pomodoro_timer_update_timeout (self);
		g_object_notify ((GObject*) self, "is-paused");
	}
}

static gboolean
pomodoro_timer_on_timeout (PomodoroTimer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_UPDATE_SIGNAL], 0, pomodoro_get_current_time ());
	result = TRUE;
	return result;
}

static void
pomodoro_timer_stop_timeout (PomodoroTimer* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_source != ((guint) 0)) {
		g_source_remove (self->priv->timeout_source);
		self->priv->timeout_source = (guint) 0;
	}
}

static gboolean
_pomodoro_timer_on_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = pomodoro_timer_on_timeout ((PomodoroTimer*) self);
	return result;
}

static void
pomodoro_timer_start_timeout (PomodoroTimer* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_source == ((guint) 0)) {
		self->priv->timeout_source = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _pomodoro_timer_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
pomodoro_timer_update_timeout (PomodoroTimer* self)
{
	gboolean _tmp0_ = FALSE;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = pomodoro_timer_get_state (self);
	_tmp2_ = _tmp1_;
	if (POMODORO_IS_DISABLED_STATE (_tmp2_)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_is_paused;
	}
	if (_tmp0_) {
		pomodoro_timer_stop_timeout (self);
	} else {
		pomodoro_timer_start_timeout (self);
	}
}

static void
pomodoro_timer_update_offset (PomodoroTimer* self)
{
	gdouble _tmp0_;
	PomodoroTimerState* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	PomodoroTimerState* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_timestamp;
	_tmp1_ = self->priv->_state;
	_tmp2_ = pomodoro_timer_state_get_timestamp (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_state;
	_tmp5_ = pomodoro_timer_state_get_elapsed (_tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->_offset = (_tmp0_ - _tmp3_) - _tmp6_;
}

static void
pomodoro_timer_update_elapsed (PomodoroTimer* self)
{
	PomodoroTimerState* _tmp0_;
	gdouble _tmp1_;
	PomodoroTimerState* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	_tmp1_ = self->priv->_timestamp;
	_tmp2_ = self->priv->_state;
	_tmp3_ = pomodoro_timer_state_get_timestamp (_tmp2_);
	_tmp4_ = _tmp3_;
	pomodoro_timer_state_set_elapsed (_tmp0_, (_tmp1_ - _tmp4_) - self->priv->_offset);
}

/**
         * Resolve next states after timer elapse or state change.
         *
         * Return true if state has been changed.
         */
static gboolean
pomodoro_timer_resolve_state (PomodoroTimer* self)
{
	PomodoroTimerState* original_state = NULL;
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	gboolean state_changed = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	_tmp1_ = _g_object_ref0 (POMODORO_IS_TIMER_STATE (_tmp0_) ? ((PomodoroTimerState*) _tmp0_) : NULL);
	original_state = _tmp1_;
	state_changed = FALSE;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		PomodoroTimerState* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		PomodoroTimerState* _tmp7_;
		PomodoroTimerState* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		PomodoroTimerState* _tmp11_;
		PomodoroTimerState* _tmp12_;
		_tmp3_ = self->priv->_state;
		_tmp4_ = pomodoro_timer_state_get_duration (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > 0.0) {
			PomodoroTimerState* _tmp6_;
			_tmp6_ = self->priv->_state;
			_tmp2_ = pomodoro_timer_state_is_completed (_tmp6_);
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp7_ = self->priv->_state;
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_LEAVE_SIGNAL], 0, _tmp7_);
		_tmp8_ = self->priv->_state;
		_tmp9_ = self->priv->_score;
		_tmp10_ = self->priv->_timestamp;
		_tmp11_ = pomodoro_timer_state_create_next_state (_tmp8_, _tmp9_, _tmp10_);
		_g_object_unref0 (self->priv->_state);
		self->priv->_state = _tmp11_;
		pomodoro_timer_update_offset (self);
		state_changed = TRUE;
		_tmp12_ = self->priv->_state;
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_ENTER_SIGNAL], 0, _tmp12_);
	}
	if (state_changed) {
		PomodoroTimerState* _tmp13_;
		PomodoroTimerState* _tmp14_;
		_tmp13_ = self->priv->_state;
		_tmp14_ = original_state;
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_CHANGED_SIGNAL], 0, _tmp13_, _tmp14_);
	}
	result = state_changed;
	_g_object_unref0 (original_state);
	return result;
}

static void
pomodoro_timer_on_state_duration_notify (PomodoroTimer* self)
{
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_timestamp;
	g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_UPDATE_SIGNAL], 0, _tmp0_);
	g_object_notify ((GObject*) self, "state-duration");
}

GActionGroup*
pomodoro_timer_get_action_group (PomodoroTimer* self)
{
	GActionGroup* _tmp0_;
	GActionGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pomodoro_timer_action_group_for_timer (self);
	result = _tmp0_;
	return result;
}

/**
         * Saves timer state to settings.
         */
static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

void
pomodoro_timer_save (PomodoroTimer* self,
                     GSettings* settings)
{
	GSettingsSchema* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	const gchar* _tmp3_;
	GDateTime* timer_datetime = NULL;
	gdouble _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* state_datetime = NULL;
	PomodoroTimerState* _tmp7_;
	PomodoroTimerState* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	GDateTime* _tmp11_;
	PomodoroTimerState* _tmp12_;
	PomodoroTimerState* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	PomodoroTimerState* _tmp16_;
	PomodoroTimerState* _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	PomodoroTimerState* _tmp22_;
	PomodoroTimerState* _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_object_get (settings, "settings-schema", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_settings_schema_get_id (_tmp2_);
	_vala_return_if_fail (g_strcmp0 (_tmp3_, "org.gnome.pomodoro.state") == 0, "settings.settings_schema.get_id () == \"org.gnome.pomodoro.state\"");
	_tmp4_ = self->priv->_timestamp;
	_tmp5_ = g_date_time_new_from_unix_utc ((gint64) floor (_tmp4_));
	_tmp6_ = _tmp5_;
	_g_settings_schema_unref0 (_tmp2_);
	timer_datetime = _tmp6_;
	_tmp7_ = pomodoro_timer_get_state (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = pomodoro_timer_state_get_timestamp (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_date_time_new_from_unix_utc ((gint64) floor (_tmp10_));
	state_datetime = _tmp11_;
	_tmp12_ = pomodoro_timer_get_state (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = pomodoro_timer_state_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	g_settings_set_string (settings, "timer-state", _tmp15_);
	_tmp16_ = pomodoro_timer_get_state (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = pomodoro_timer_state_get_duration (_tmp17_);
	_tmp19_ = _tmp18_;
	g_settings_set_double (settings, "timer-state-duration", _tmp19_);
	_tmp20_ = g_date_time_to_string (state_datetime);
	_tmp21_ = _tmp20_;
	g_settings_set_string (settings, "timer-state-date", _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = pomodoro_timer_get_state (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = pomodoro_timer_state_get_elapsed (_tmp23_);
	_tmp25_ = _tmp24_;
	g_settings_set_double (settings, "timer-elapsed", _tmp25_);
	_tmp26_ = self->priv->_score;
	g_settings_set_double (settings, "timer-score", _tmp26_);
	_tmp27_ = g_date_time_to_string (timer_datetime);
	_tmp28_ = _tmp27_;
	g_settings_set_string (settings, "timer-date", _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = pomodoro_timer_get_is_paused (self);
	_tmp30_ = _tmp29_;
	g_settings_set_boolean (settings, "timer-paused", _tmp30_);
	_g_date_time_unref0 (state_datetime);
	_g_date_time_unref0 (timer_datetime);
}

/**
         * Restores timer state from settings.
         *
         * When restoring, lost time is considered as interruption.
         * If exceeded time of a long break, timer would reset.
         */
void
pomodoro_timer_restore (PomodoroTimer* self,
                        GSettings* settings,
                        gdouble timestamp)
{
	GSettingsSchema* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	const gchar* _tmp3_;
	PomodoroTimerState* state = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PomodoroTimerState* _tmp6_;
	PomodoroTimerState* _tmp7_;
	gboolean is_paused = FALSE;
	gdouble score = 0.0;
	gdouble last_timestamp = 0.0;
	PomodoroTimerState* _tmp8_;
	gboolean _tmp29_ = FALSE;
	PomodoroTimerState* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_object_get (settings, "settings-schema", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_settings_schema_get_id (_tmp2_);
	_vala_return_if_fail (g_strcmp0 (_tmp3_, "org.gnome.pomodoro.state") == 0, "settings.settings_schema.get_id () == \"org.gnome.pomodoro.state\"");
	_tmp4_ = g_settings_get_string (settings, "timer-state");
	_tmp5_ = _tmp4_;
	_tmp6_ = pomodoro_timer_state_lookup (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_settings_schema_unref0 (_tmp2_);
	state = _tmp7_;
	is_paused = g_settings_get_boolean (settings, "timer-paused");
	score = g_settings_get_double (settings, "timer-score");
	last_timestamp = 0.0;
	_tmp8_ = state;
	if (_tmp8_ != NULL) {
		PomodoroTimerState* _tmp9_;
		PomodoroTimerState* _tmp10_;
		GDateTime* state_datetime = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GTimeZone* _tmp13_;
		GTimeZone* _tmp14_;
		GDateTime* _tmp15_;
		GDateTime* _tmp16_;
		GDateTime* last_datetime = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GTimeZone* _tmp19_;
		GTimeZone* _tmp20_;
		GDateTime* _tmp21_;
		GDateTime* _tmp22_;
		gboolean _tmp23_ = FALSE;
		GDateTime* _tmp24_;
		_tmp9_ = state;
		pomodoro_timer_state_set_duration (_tmp9_, g_settings_get_double (settings, "timer-state-duration"));
		_tmp10_ = state;
		pomodoro_timer_state_set_elapsed (_tmp10_, g_settings_get_double (settings, "timer-elapsed"));
		_tmp11_ = g_settings_get_string (settings, "timer-state-date");
		_tmp12_ = _tmp11_;
		_tmp13_ = g_time_zone_new_local ();
		_tmp14_ = _tmp13_;
		_tmp15_ = g_date_time_new_from_iso8601 (_tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_time_zone_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		state_datetime = _tmp16_;
		_tmp17_ = g_settings_get_string (settings, "timer-date");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_time_zone_new_local ();
		_tmp20_ = _tmp19_;
		_tmp21_ = g_date_time_new_from_iso8601 (_tmp18_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_time_zone_unref0 (_tmp20_);
		_g_free0 (_tmp18_);
		last_datetime = _tmp22_;
		_tmp24_ = state_datetime;
		if (_tmp24_ != NULL) {
			GDateTime* _tmp25_;
			_tmp25_ = last_datetime;
			_tmp23_ = _tmp25_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			PomodoroTimerState* _tmp26_;
			GDateTime* _tmp27_;
			GDateTime* _tmp28_;
			_tmp26_ = state;
			_tmp27_ = state_datetime;
			pomodoro_timer_state_set_timestamp (_tmp26_, (gdouble) g_date_time_to_unix (_tmp27_));
			_tmp28_ = last_datetime;
			last_timestamp = (gdouble) g_date_time_to_unix (_tmp28_);
		} else {
			_g_object_unref0 (state);
			state = NULL;
		}
		_g_date_time_unref0 (last_datetime);
		_g_date_time_unref0 (state_datetime);
	}
	_tmp30_ = state;
	if (_tmp30_ != NULL) {
		_tmp29_ = (timestamp - last_timestamp) < POMODORO_TIME_TO_RESET_SCORE;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		PomodoroTimerState* _tmp31_;
		g_object_freeze_notify ((GObject*) self);
		pomodoro_timer_set_score (self, score);
		_tmp31_ = state;
		pomodoro_timer_set_state_full (self, _tmp31_, last_timestamp);
		pomodoro_timer_pause (self, last_timestamp);
		g_object_thaw_notify ((GObject*) self);
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_UPDATE_SIGNAL], 0, timestamp);
		if (is_paused) {
			g_object_notify ((GObject*) self, "is-paused");
		} else {
			pomodoro_timer_resume (self, timestamp);
		}
	} else {
		pomodoro_timer_reset (self, timestamp);
	}
	_g_object_unref0 (state);
}

static void
pomodoro_timer_real_dispose (GObject* base)
{
	PomodoroTimer * self;
	self = (PomodoroTimer*) base;
	if (self->priv->timeout_source != ((guint) 0)) {
		g_source_remove (self->priv->timeout_source);
		self->priv->timeout_source = (guint) 0;
	}
	G_OBJECT_CLASS (pomodoro_timer_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

PomodoroTimer*
pomodoro_timer_construct (GType object_type)
{
	PomodoroTimer * self = NULL;
	self = (PomodoroTimer*) g_object_new (object_type, NULL);
	return self;
}

PomodoroTimer*
pomodoro_timer_new (void)
{
	return pomodoro_timer_construct (POMODORO_TYPE_TIMER);
}

PomodoroTimerState*
pomodoro_timer_get_state (PomodoroTimer* self)
{
	PomodoroTimerState* result;
	PomodoroTimerState* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}

void
pomodoro_timer_set_state (PomodoroTimer* self,
                          PomodoroTimerState* value)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_timer_state_get_timestamp (value);
	_tmp1_ = _tmp0_;
	pomodoro_timer_set_state_full (self, value, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, pomodoro_timer_properties[POMODORO_TIMER_STATE_PROPERTY]);
}

gdouble
pomodoro_timer_get_state_duration (PomodoroTimer* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	PomodoroTimerState* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != NULL) {
		PomodoroTimerState* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		_tmp2_ = self->priv->_state;
		_tmp3_ = pomodoro_timer_state_get_duration (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0.0;
	}
	result = _tmp0_;
	return result;
}

void
pomodoro_timer_set_state_duration (PomodoroTimer* self,
                                   gdouble value)
{
	PomodoroTimerState* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != NULL) {
		PomodoroTimerState* _tmp1_;
		_tmp1_ = self->priv->_state;
		pomodoro_timer_state_set_duration (_tmp1_, value);
	}
}

gdouble
pomodoro_timer_get_elapsed (PomodoroTimer* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	PomodoroTimerState* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != NULL) {
		PomodoroTimerState* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		_tmp2_ = self->priv->_state;
		_tmp3_ = pomodoro_timer_state_get_elapsed (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0.0;
	}
	result = _tmp0_;
	return result;
}

void
pomodoro_timer_set_elapsed (PomodoroTimer* self,
                            gdouble value)
{
	PomodoroTimerState* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	pomodoro_timer_state_set_elapsed (_tmp0_, value);
	pomodoro_timer_update_offset (self);
}

gdouble
pomodoro_timer_get_remaining (PomodoroTimer* self)
{
	gdouble result;
	gdouble _tmp0_ = 0.0;
	PomodoroTimerState* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != NULL) {
		PomodoroTimerState* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		PomodoroTimerState* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp2_ = self->priv->_state;
		_tmp3_ = pomodoro_timer_state_get_duration (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->_state;
		_tmp6_ = pomodoro_timer_state_get_elapsed (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp4_ - _tmp7_;
	} else {
		_tmp0_ = 0.0;
	}
	result = _tmp0_;
	return result;
}

void
pomodoro_timer_set_remaining (PomodoroTimer* self,
                              gdouble value)
{
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	_tmp1_ = self->priv->_state;
	_tmp2_ = pomodoro_timer_state_get_duration (_tmp1_);
	_tmp3_ = _tmp2_;
	pomodoro_timer_state_set_elapsed (_tmp0_, _tmp3_ - value);
	pomodoro_timer_update_offset (self);
}

gdouble
pomodoro_timer_get_offset (PomodoroTimer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_offset;
	return result;
}

static void
pomodoro_timer_set_offset (PomodoroTimer* self,
                           gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_offset = value;
}

gboolean
pomodoro_timer_get_is_paused (PomodoroTimer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_paused;
	return result;
}

void
pomodoro_timer_set_is_paused (PomodoroTimer* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	pomodoro_timer_set_is_paused_full (self, value, pomodoro_get_current_time ());
}

gdouble
pomodoro_timer_get_timestamp (PomodoroTimer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_timestamp;
	return result;
}

void
pomodoro_timer_set_timestamp (PomodoroTimer* self,
                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_timer_get_timestamp (self);
	if (old_value != value) {
		self->priv->_timestamp = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_timer_properties[POMODORO_TIMER_TIMESTAMP_PROPERTY]);
	}
}

gdouble
pomodoro_timer_get_score (PomodoroTimer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_score;
	return result;
}

void
pomodoro_timer_set_score (PomodoroTimer* self,
                          gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = pomodoro_timer_get_score (self);
	if (old_value != value) {
		self->priv->_score = value;
		g_object_notify_by_pspec ((GObject *) self, pomodoro_timer_properties[POMODORO_TIMER_SCORE_PROPERTY]);
	}
}

static void
pomodoro_timer_real_update (PomodoroTimer* self,
                            gdouble timestamp)
{
	PomodoroTimerState* last_state = NULL;
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	gdouble last_timestamp = 0.0;
	gdouble _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	PomodoroTimerState* _tmp5_;
	_tmp0_ = self->priv->_state;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	last_state = _tmp1_;
	_tmp2_ = self->priv->_timestamp;
	last_timestamp = _tmp2_;
	_tmp5_ = last_state;
	if (_tmp5_ != NULL) {
		PomodoroTimerState* _tmp6_;
		_tmp6_ = last_state;
		_tmp4_ = !POMODORO_IS_DISABLED_STATE (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = (timestamp - last_timestamp) >= POMODORO_TIME_TO_RESET_SCORE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		PomodoroTimerState* _tmp7_;
		PomodoroDisabledState* _tmp8_;
		PomodoroTimerState* _tmp9_;
		PomodoroTimerState* _tmp10_;
		PomodoroTimerState* _tmp11_;
		_tmp7_ = last_state;
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_LEAVE_SIGNAL], 0, _tmp7_);
		_tmp8_ = pomodoro_disabled_state_new_with_timestamp (timestamp);
		_g_object_unref0 (self->priv->_state);
		self->priv->_state = (PomodoroTimerState*) _tmp8_;
		pomodoro_timer_set_timestamp (self, timestamp);
		pomodoro_timer_update_offset (self);
		_tmp9_ = self->priv->_state;
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_ENTER_SIGNAL], 0, _tmp9_);
		_tmp10_ = self->priv->_state;
		_tmp11_ = last_state;
		g_signal_emit (self, pomodoro_timer_signals[POMODORO_TIMER_STATE_CHANGED_SIGNAL], 0, _tmp10_, _tmp11_);
		_g_object_unref0 (last_state);
		return;
	}
	pomodoro_timer_set_timestamp (self, timestamp);
	if (!self->priv->_is_paused) {
		pomodoro_timer_update_elapsed (self);
		if (!pomodoro_timer_resolve_state (self)) {
			g_object_notify ((GObject*) self, "elapsed");
		}
	} else {
		pomodoro_timer_update_offset (self);
	}
	_g_object_unref0 (last_state);
}

static void
_pomodoro_timer_on_state_duration_notify_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	pomodoro_timer_on_state_duration_notify ((PomodoroTimer*) self);
}

static void
pomodoro_timer_real_state_enter (PomodoroTimer* self,
                                 PomodoroTimerState* state)
{
	g_return_if_fail (state != NULL);
	g_signal_connect_object ((GObject*) state, "notify::duration", (GCallback) _pomodoro_timer_on_state_duration_notify_g_object_notify, self, 0);
}

static void
pomodoro_timer_real_state_leave (PomodoroTimer* self,
                                 PomodoroTimerState* state)
{
	guint _tmp0_;
	GQuark _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (state != NULL);
	g_signal_parse_name ("notify::duration", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) state, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _pomodoro_timer_on_state_duration_notify_g_object_notify, self);
	_tmp2_ = self->priv->_score;
	_tmp3_ = self->priv->_timestamp;
	pomodoro_timer_set_score (self, pomodoro_timer_state_calculate_score (state, _tmp2_, _tmp3_));
}

static void
pomodoro_timer_real_state_changed (PomodoroTimer* self,
                                   PomodoroTimerState* state,
                                   PomodoroTimerState* previous_state)
{
	g_return_if_fail (state != NULL);
	g_return_if_fail (previous_state != NULL);
	pomodoro_timer_update_timeout (self);
	g_object_notify ((GObject*) self, "state");
	g_object_notify ((GObject*) self, "elapsed");
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
pomodoro_timer_real_destroy (PomodoroTimer* self)
{
	g_object_run_dispose ((GObject*) self);
}

static GObject *
pomodoro_timer_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroTimer * self;
	PomodoroDisabledState* _tmp0_;
	PomodoroTimerState* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	parent_class = G_OBJECT_CLASS (pomodoro_timer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_TIMER, PomodoroTimer);
	_tmp0_ = pomodoro_disabled_state_new ();
	_g_object_unref0 (self->priv->_state);
	self->priv->_state = (PomodoroTimerState*) _tmp0_;
	_tmp1_ = self->priv->_state;
	_tmp2_ = pomodoro_timer_state_get_timestamp (_tmp1_);
	_tmp3_ = _tmp2_;
	pomodoro_timer_set_timestamp (self, _tmp3_);
	return obj;
}

static void
pomodoro_timer_class_init (PomodoroTimerClass * klass,
                           gpointer klass_data)
{
	pomodoro_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroTimer_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) pomodoro_timer_real_dispose;
	((PomodoroTimerClass *) klass)->update = pomodoro_timer_real_update;
	((PomodoroTimerClass *) klass)->state_enter = pomodoro_timer_real_state_enter;
	((PomodoroTimerClass *) klass)->state_leave = pomodoro_timer_real_state_leave;
	((PomodoroTimerClass *) klass)->state_changed = pomodoro_timer_real_state_changed;
	((PomodoroTimerClass *) klass)->destroy = pomodoro_timer_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_timer_set_property;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_timer_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_STATE_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_STATE_PROPERTY] = g_param_spec_object ("state", "state", "state", POMODORO_TYPE_TIMER_STATE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_STATE_DURATION_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_STATE_DURATION_PROPERTY] = g_param_spec_double ("state-duration", "state-duration", "state-duration", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_ELAPSED_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_ELAPSED_PROPERTY] = g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_REMAINING_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_REMAINING_PROPERTY] = g_param_spec_double ("remaining", "remaining", "remaining", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_OFFSET_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_OFFSET_PROPERTY] = g_param_spec_double ("offset", "offset", "offset", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_IS_PAUSED_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_IS_PAUSED_PROPERTY] = g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_TIMESTAMP_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_TIMESTAMP_PROPERTY] = g_param_spec_double ("timestamp", "timestamp", "timestamp", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * Achieved score or number of completed sessions.
	         *
	         * It's updated on state change.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_TIMER_SCORE_PROPERTY, pomodoro_timer_properties[POMODORO_TIMER_SCORE_PROPERTY] = g_param_spec_double ("score", "score", "score", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	pomodoro_timer_signals[POMODORO_TIMER_UPDATE_SIGNAL] = g_signal_new ("update", POMODORO_TYPE_TIMER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PomodoroTimerClass, update), NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	pomodoro_timer_signals[POMODORO_TIMER_STATE_ENTER_SIGNAL] = g_signal_new ("state-enter", POMODORO_TYPE_TIMER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PomodoroTimerClass, state_enter), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, POMODORO_TYPE_TIMER_STATE);
	pomodoro_timer_signals[POMODORO_TIMER_STATE_LEAVE_SIGNAL] = g_signal_new ("state-leave", POMODORO_TYPE_TIMER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PomodoroTimerClass, state_leave), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, POMODORO_TYPE_TIMER_STATE);
	pomodoro_timer_signals[POMODORO_TIMER_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", POMODORO_TYPE_TIMER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PomodoroTimerClass, state_changed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, POMODORO_TYPE_TIMER_STATE, POMODORO_TYPE_TIMER_STATE);
	pomodoro_timer_signals[POMODORO_TIMER_DESTROY_SIGNAL] = g_signal_new ("destroy", POMODORO_TYPE_TIMER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PomodoroTimerClass, destroy), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pomodoro_timer_instance_init (PomodoroTimer * self,
                              gpointer klass)
{
	self->priv = pomodoro_timer_get_instance_private (self);
	self->priv->_score = 0.0;
	self->priv->timeout_source = (guint) 0;
}

static void
pomodoro_timer_finalize (GObject * obj)
{
	PomodoroTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_TIMER, PomodoroTimer);
	_g_object_unref0 (self->priv->_state);
	G_OBJECT_CLASS (pomodoro_timer_parent_class)->finalize (obj);
}

/**
     * Pomodoro.Timer class.
     *
     * A class for a countdown timer. Timer works in an atomic manner, it acknowlegdes passage
     * of time after calling update() method.
     */
static GType
pomodoro_timer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroTimer), 0, (GInstanceInitFunc) pomodoro_timer_instance_init, NULL };
	GType pomodoro_timer_type_id;
	pomodoro_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "PomodoroTimer", &g_define_type_info, 0);
	PomodoroTimer_private_offset = g_type_add_instance_private (pomodoro_timer_type_id, sizeof (PomodoroTimerPrivate));
	return pomodoro_timer_type_id;
}

GType
pomodoro_timer_get_type (void)
{
	static volatile gsize pomodoro_timer_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_timer_type_id__once)) {
		GType pomodoro_timer_type_id;
		pomodoro_timer_type_id = pomodoro_timer_get_type_once ();
		g_once_init_leave (&pomodoro_timer_type_id__once, pomodoro_timer_type_id);
	}
	return pomodoro_timer_type_id__once;
}

static void
_vala_pomodoro_timer_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	PomodoroTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_TIMER, PomodoroTimer);
	switch (property_id) {
		case POMODORO_TIMER_STATE_PROPERTY:
		g_value_set_object (value, pomodoro_timer_get_state (self));
		break;
		case POMODORO_TIMER_STATE_DURATION_PROPERTY:
		g_value_set_double (value, pomodoro_timer_get_state_duration (self));
		break;
		case POMODORO_TIMER_ELAPSED_PROPERTY:
		g_value_set_double (value, pomodoro_timer_get_elapsed (self));
		break;
		case POMODORO_TIMER_REMAINING_PROPERTY:
		g_value_set_double (value, pomodoro_timer_get_remaining (self));
		break;
		case POMODORO_TIMER_OFFSET_PROPERTY:
		g_value_set_double (value, pomodoro_timer_get_offset (self));
		break;
		case POMODORO_TIMER_IS_PAUSED_PROPERTY:
		g_value_set_boolean (value, pomodoro_timer_get_is_paused (self));
		break;
		case POMODORO_TIMER_TIMESTAMP_PROPERTY:
		g_value_set_double (value, pomodoro_timer_get_timestamp (self));
		break;
		case POMODORO_TIMER_SCORE_PROPERTY:
		g_value_set_double (value, pomodoro_timer_get_score (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_timer_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	PomodoroTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_TIMER, PomodoroTimer);
	switch (property_id) {
		case POMODORO_TIMER_STATE_PROPERTY:
		pomodoro_timer_set_state (self, g_value_get_object (value));
		break;
		case POMODORO_TIMER_STATE_DURATION_PROPERTY:
		pomodoro_timer_set_state_duration (self, g_value_get_double (value));
		break;
		case POMODORO_TIMER_ELAPSED_PROPERTY:
		pomodoro_timer_set_elapsed (self, g_value_get_double (value));
		break;
		case POMODORO_TIMER_REMAINING_PROPERTY:
		pomodoro_timer_set_remaining (self, g_value_get_double (value));
		break;
		case POMODORO_TIMER_OFFSET_PROPERTY:
		pomodoro_timer_set_offset (self, g_value_get_double (value));
		break;
		case POMODORO_TIMER_IS_PAUSED_PROPERTY:
		pomodoro_timer_set_is_paused (self, g_value_get_boolean (value));
		break;
		case POMODORO_TIMER_TIMESTAMP_PROPERTY:
		pomodoro_timer_set_timestamp (self, g_value_get_double (value));
		break;
		case POMODORO_TIMER_SCORE_PROPERTY:
		pomodoro_timer_set_score (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

